/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.ImmutableIterator;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Try;
import com.landawn.abacus.util.function.BooleanSupplier;
import com.landawn.abacus.util.function.Supplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class ObjIterator<T>
extends ImmutableIterator<T> {
    private static final ObjIterator EMPTY = new ObjIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }
    };

    public static <T> ObjIterator<T> empty() {
        return EMPTY;
    }

    public static <T> ObjIterator<T> just(final T val) {
        return new ObjIterator<T>(){
            private boolean done = false;

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public T next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                this.done = true;
                return val;
            }
        };
    }

    @SafeVarargs
    public static <T> ObjIterator<T> of(T ... a) {
        return N.isNullOrEmpty(a) ? EMPTY : ObjIterator.of(a, 0, a.length);
    }

    public static <T> ObjIterator<T> of(final T[] a, final int fromIndex, final int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        if (fromIndex == toIndex) {
            return EMPTY;
        }
        return new ObjIterator<T>(){
            private int cursor;
            {
                this.cursor = fromIndex;
            }

            @Override
            public boolean hasNext() {
                return this.cursor < toIndex;
            }

            @Override
            public T next() {
                if (this.cursor >= toIndex) {
                    throw new NoSuchElementException();
                }
                return a[this.cursor++];
            }

            @Override
            public <A> A[] toArray(A[] output) {
                if (output.length < toIndex - this.cursor) {
                    output = N.copyOf(output, toIndex - this.cursor);
                }
                N.copy(a, this.cursor, output, 0, toIndex - this.cursor);
                return output;
            }

            @Override
            public List<T> toList() {
                return N.asList(this.toArray());
            }
        };
    }

    public static <T> ObjIterator<T> of(final Iterator<T> iter) {
        if (iter == null) {
            return ObjIterator.empty();
        }
        if (iter instanceof ObjIterator) {
            return (ObjIterator)iter;
        }
        return new ObjIterator<T>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public T next() {
                return iter.next();
            }
        };
    }

    public static <T> ObjIterator<T> of(Collection<T> iterable) {
        return iterable == null ? ObjIterator.empty() : ObjIterator.of(iterable.iterator());
    }

    public static <T> ObjIterator<T> of(Iterable<T> iterable) {
        return iterable == null ? ObjIterator.empty() : ObjIterator.of(iterable.iterator());
    }

    public static <T> ObjIterator<T> generate(final Supplier<T> supplier) {
        N.checkArgNotNull(supplier);
        return new ObjIterator<T>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                return supplier.get();
            }
        };
    }

    public static <T> ObjIterator<T> generate(final BooleanSupplier hasNext, final Supplier<T> supplier) {
        N.checkArgNotNull(hasNext);
        N.checkArgNotNull(supplier);
        return new ObjIterator<T>(){

            @Override
            public boolean hasNext() {
                return hasNext.getAsBoolean();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return supplier.get();
            }
        };
    }

    public Object[] toArray() {
        return this.toArray(N.EMPTY_OBJECT_ARRAY);
    }

    public <A> A[] toArray(A[] a) {
        return this.toList().toArray(a);
    }

    public List<T> toList() {
        ArrayList list = new ArrayList();
        while (this.hasNext()) {
            list.add(this.next());
        }
        return list;
    }

    public <E extends Exception> void foreachRemaining(Try.Consumer<? super T, E> action) throws E {
        N.checkArgNotNull(action);
        while (this.hasNext()) {
            action.accept(this.next());
        }
    }
}

