/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.annotation.Internal;
import com.landawn.abacus.util.N;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

@Internal
public final class ObjectPool<K, V>
extends AbstractMap<K, V> {
    final int capacity;
    private final Entry<K, V>[] table;
    private final int indexMask;
    private int size = 0;
    private Set<K> keySet = null;
    private Collection<V> values = null;
    private Set<Map.Entry<K, V>> entrySet;

    public ObjectPool(int capacity) {
        this.capacity = capacity;
        this.table = new Entry[capacity];
        this.indexMask = this.table.length - 1;
    }

    @Override
    public V get(Object key) {
        int hash = ObjectPool.hash(key);
        int i = hash & this.indexMask;
        Entry<K, V> entry = this.table[i];
        while (entry != null) {
            if (hash == entry.hash && key.equals(entry.key)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        int hash = ObjectPool.hash(key);
        int i = hash & this.indexMask;
        Entry<K, V>[] entryArray = this.table;
        synchronized (this.table) {
            Entry<K, V> entry = this.table[i];
            while (entry != null) {
                if (hash == entry.hash && key.equals(entry.key)) {
                    Object previousValue = entry.value;
                    entry.value = value;
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return previousValue;
                }
                entry = entry.next;
            }
            this.table[i] = entry = new Entry<K, V>(hash, key, value, this.table[i]);
            this.keySet = null;
            this.values = null;
            this.entrySet = null;
            ++this.size;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return null;
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        V value = null;
        for (K key : m.keySet()) {
            value = m.get(key);
            if (value == null) continue;
            this.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        if (this.size == 0) {
            return null;
        }
        int hash = ObjectPool.hash(key);
        int i = hash & this.indexMask;
        Entry<K, V>[] entryArray = this.table;
        synchronized (this.table) {
            Entry<K, V> prev;
            Entry<K, V> e = prev = this.table[i];
            while (e != null) {
                Entry next = e.next;
                if (hash == e.hash && key.equals(e.key)) {
                    if (prev == e) {
                        this.table[i] = next;
                    } else {
                        prev.next = next;
                    }
                    this.keySet = null;
                    this.values = null;
                    this.entrySet = null;
                    --this.size;
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return e.value;
                }
                prev = e;
                e = next;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return null;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        int hash = ObjectPool.hash(key);
        int i = hash & this.indexMask;
        Entry<K, V> entry = this.table[i];
        while (entry != null) {
            if (hash == entry.hash && entry.value != null && key.equals(entry.key)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        for (Entry<K, V> entry : this.table) {
            while (entry != null) {
                if (entry.value != null && value.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        Set<Object> tmp = this.keySet;
        if (tmp == null) {
            tmp = N.newHashSet(N.initHashCapacity(this.size));
            for (Entry<K, V> entry : this.table) {
                while (entry != null) {
                    if (entry.value != null) {
                        tmp.add(entry.key);
                    }
                    entry = entry.next;
                }
            }
            tmp = Collections.unmodifiableSet(tmp);
            this.keySet = tmp;
        }
        return tmp;
    }

    @Override
    public Collection<V> values() {
        Collection<V> tmp = this.values;
        if (tmp == null) {
            tmp = N.newHashSet(this.size < 0x66666664 ? (int)((double)this.size * 1.25) + 1 : Integer.MAX_VALUE);
            Object value = null;
            for (Entry<K, V> entry : this.table) {
                while (entry != null) {
                    value = entry.value;
                    if (value != null) {
                        tmp.add(value);
                    }
                    entry = entry.next;
                }
            }
            tmp = Collections.unmodifiableCollection(tmp);
            this.values = tmp;
        }
        return tmp;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> tmp = this.entrySet;
        if (tmp == null) {
            tmp = N.newHashSet(N.initHashCapacity(this.size));
            for (Entry<K, V> entry : this.table) {
                while (entry != null) {
                    if (entry.value != null) {
                        tmp.add(entry);
                    }
                    entry = entry.next;
                }
            }
            tmp = Collections.unmodifiableSet(tmp);
            this.entrySet = tmp;
        }
        return tmp;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Entry<K, V>[] entryArray = this.table;
        synchronized (this.table) {
            Arrays.fill(this.table, null);
            this.keySet = null;
            this.values = null;
            this.entrySet = null;
            this.size = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static final int hash(Object key) {
        int n;
        if (key == null) {
            n = 0;
        } else {
            int h = key.hashCode();
            n = h ^ h >>> 16;
        }
        return n;
    }

    static class Entry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V value;
        Entry<K, V> next;
        int hash;

        Entry(int h, K k, V v, Entry<K, V> n) {
            this.value = v;
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Map.Entry) {
                Map.Entry other = (Map.Entry)obj;
                return N.equals(this.getKey(), other.getKey()) && N.equals(this.getValue(), other.getValue());
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return N.hashCode(this.getKey()) ^ N.hashCode(this.getValue());
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

