/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.annotation.Internal;
import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.util.BufferedJSONWriter;
import com.landawn.abacus.util.BufferedReader;
import com.landawn.abacus.util.BufferedWriter;
import com.landawn.abacus.util.BufferedXMLWriter;
import com.landawn.abacus.util.ByteArrayOutputStream;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

@Internal
public final class Objectory {
    private static final Logger logger = LoggerFactory.getLogger(Objectory.class);
    private static AtomicInteger created = new AtomicInteger();
    static final int POOL_SIZE = 1024;
    static final int POOLABLE_SIZE = 8192;
    static final int BUFFER_SIZE = Math.max(IOUtil.MAX_MEMORY_IN_MB * 1024, 8192);
    private static final int POOLABLE_ARRAY_LENGTH = 128;
    private static final int MAX_ARRAY_POOL_SIZE = IOUtil.IS_PLATFORM_ANDROID ? 8 : 64;
    private static final int MAX_ARRAY_LENGTH = IOUtil.IS_PLATFORM_ANDROID ? 128 : 1024;
    private static final Queue<List<?>> listPool = new ArrayBlockingQueue(1024);
    private static final Queue<Set<?>> setPool = new ArrayBlockingQueue(1024);
    private static final Queue<Set<?>> linkedHashSetPool = new ArrayBlockingQueue(1024);
    private static final Queue<Map<?, ?>> mapPool = new ArrayBlockingQueue(1024);
    private static final Queue<Map<?, ?>> linkedHashMapPool = new ArrayBlockingQueue(1024);
    private static final Queue<Object[]>[] objectArrayPool = new Queue[8193];
    private static final Queue<char[]> charArrayBufferPool = new ArrayBlockingQueue<char[]>(1024);
    private static final Queue<byte[]> byteArrayBufferPool = new ArrayBlockingQueue<byte[]>(1024);
    private static final Queue<StringBuilder> stringBuilderPool = new ArrayBlockingQueue<StringBuilder>(1024);
    private static final Queue<ByteArrayOutputStream> byteArrayOutputStreamPool = new ArrayBlockingQueue<ByteArrayOutputStream>(1024);
    private static final Queue<BufferedWriter> bufferedWriterPool = new ArrayBlockingQueue<BufferedWriter>(1024);
    private static final Queue<BufferedXMLWriter> bufferedXMLWriterPool = new ArrayBlockingQueue<BufferedXMLWriter>(1024);
    private static final Queue<BufferedJSONWriter> bufferedJSONWriterPool = new ArrayBlockingQueue<BufferedJSONWriter>(1024);
    private static final Queue<BufferedReader> bufferedReaderPool = new ArrayBlockingQueue<BufferedReader>(1024);

    public static <T> List<T> createList() {
        ArrayList list = listPool.poll();
        return list == null ? new ArrayList() : list;
    }

    public static <T> Set<T> createSet() {
        Set<?> set = setPool.poll();
        return set == null ? N.newHashSet() : set;
    }

    public static <T> Set<T> createLinkedHashSet() {
        Set<?> set = linkedHashSetPool.poll();
        return set == null ? N.newLinkedHashSet() : set;
    }

    public static <K, V> Map<K, V> createMap() {
        Map<?, ?> map = mapPool.poll();
        return map == null ? N.newHashMap() : map;
    }

    public static <K, V> Map<K, V> createLinkedHashMap() {
        Map<?, ?> linkedHashMap = linkedHashMapPool.poll();
        return linkedHashMap == null ? N.newLinkedHashMap() : linkedHashMap;
    }

    public static Object[] createObjectArray() {
        return Objectory.createObjectArray(128);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] createObjectArray(int size) {
        if (size > 128) {
            return new Object[size];
        }
        Object[] objArray = null;
        Queue<Object[]>[] queueArray = objectArrayPool;
        synchronized (objectArrayPool) {
            Queue<Object[]> arrayQueue = objectArrayPool[size];
            if (N.notNullOrEmpty(arrayQueue)) {
                objArray = arrayQueue.poll();
            }
            if (objArray == null) {
                objArray = new Object[size];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return objArray;
        }
    }

    public static char[] createCharArrayBuffer() {
        return Objectory.createCharArrayBuffer(BUFFER_SIZE);
    }

    public static char[] createCharArrayBuffer(int capacity) {
        if (capacity > BUFFER_SIZE) {
            return new char[capacity];
        }
        char[] cbuf = charArrayBufferPool.poll();
        if (cbuf == null) {
            Objectory.logCreated("createCharArrayBuffer");
            cbuf = new char[BUFFER_SIZE];
        }
        return cbuf;
    }

    public static byte[] createByteArrayBuffer() {
        return Objectory.createByteArrayBuffer(BUFFER_SIZE);
    }

    public static byte[] createByteArrayBuffer(int capacity) {
        if (capacity > BUFFER_SIZE) {
            return new byte[capacity];
        }
        byte[] bbuf = byteArrayBufferPool.poll();
        if (bbuf == null) {
            Objectory.logCreated("createByteArrayBuffer");
            bbuf = new byte[BUFFER_SIZE];
        }
        return bbuf;
    }

    public static StringBuilder createStringBuilder() {
        return Objectory.createStringBuilder(BUFFER_SIZE);
    }

    public static StringBuilder createStringBuilder(int initCapacity) {
        if (initCapacity > BUFFER_SIZE) {
            return new StringBuilder(initCapacity);
        }
        StringBuilder sb = stringBuilderPool.poll();
        if (sb == null) {
            Objectory.logCreated("createStringBuilder");
            sb = new StringBuilder(BUFFER_SIZE);
        }
        return sb;
    }

    public static ByteArrayOutputStream createByteArrayOutputStream() {
        return Objectory.createByteArrayOutputStream(BUFFER_SIZE);
    }

    public static ByteArrayOutputStream createByteArrayOutputStream(int initCapacity) {
        if (initCapacity > BUFFER_SIZE) {
            return new ByteArrayOutputStream(initCapacity);
        }
        ByteArrayOutputStream os = byteArrayOutputStreamPool.poll();
        if (os == null) {
            Objectory.logCreated("createByteArrayOutputStream");
            os = new ByteArrayOutputStream(BUFFER_SIZE);
        }
        return os;
    }

    public static BufferedWriter createBufferedWriter() {
        BufferedWriter bw = bufferedWriterPool.poll();
        if (bw == null) {
            Objectory.logCreated("createBufferedWriter");
            bw = new BufferedWriter();
        } else {
            bw.reinit();
        }
        return bw;
    }

    public static BufferedWriter createBufferedWriter(OutputStream os) {
        BufferedWriter bw = bufferedWriterPool.poll();
        if (bw == null) {
            Objectory.logCreated("createBufferedWriter");
            bw = new BufferedWriter(os);
        } else {
            bw.reinit(os);
        }
        return bw;
    }

    public static BufferedWriter createBufferedWriter(Writer writer) {
        BufferedWriter bw = bufferedWriterPool.poll();
        if (bw == null) {
            Objectory.logCreated("createBufferedWriter");
            bw = new BufferedWriter(writer);
        } else {
            bw.reinit(writer);
        }
        return bw;
    }

    public static BufferedXMLWriter createBufferedXMLWriter() {
        BufferedXMLWriter bw = bufferedXMLWriterPool.poll();
        if (bw == null) {
            Objectory.logCreated("createBufferedXMLWriter");
            bw = new BufferedXMLWriter();
        } else {
            bw.reinit();
        }
        return bw;
    }

    public static BufferedXMLWriter createBufferedXMLWriter(OutputStream os) {
        BufferedXMLWriter bw = bufferedXMLWriterPool.poll();
        if (bw == null) {
            Objectory.logCreated("createBufferedXMLWriter");
            bw = new BufferedXMLWriter(os);
        } else {
            bw.reinit(os);
        }
        return bw;
    }

    public static BufferedXMLWriter createBufferedXMLWriter(Writer writer) {
        BufferedXMLWriter bw = bufferedXMLWriterPool.poll();
        if (bw == null) {
            Objectory.logCreated("createBufferedXMLWriter");
            bw = new BufferedXMLWriter(writer);
        } else {
            bw.reinit(writer);
        }
        return bw;
    }

    public static BufferedJSONWriter createBufferedJSONWriter() {
        BufferedJSONWriter bw = bufferedJSONWriterPool.poll();
        if (bw == null) {
            Objectory.logCreated("createBufferedJSONWriter");
            bw = new BufferedJSONWriter();
        } else {
            bw.reinit();
        }
        return bw;
    }

    public static BufferedJSONWriter createBufferedJSONWriter(OutputStream os) {
        BufferedJSONWriter bw = bufferedJSONWriterPool.poll();
        if (bw == null) {
            Objectory.logCreated("createBufferedJSONWriter");
            bw = new BufferedJSONWriter(os);
        } else {
            bw.reinit(os);
        }
        return bw;
    }

    public static BufferedJSONWriter createBufferedJSONWriter(Writer writer) {
        BufferedJSONWriter bw = bufferedJSONWriterPool.poll();
        if (bw == null) {
            Objectory.logCreated("createBufferedJSONWriter");
            bw = new BufferedJSONWriter(writer);
        } else {
            bw.reinit(writer);
        }
        return bw;
    }

    public static BufferedReader createBufferedReader(String st) {
        BufferedReader br = bufferedReaderPool.poll();
        if (br == null) {
            Objectory.logCreated("createBufferedReader");
            return new BufferedReader(st);
        }
        br.reinit(st);
        return br;
    }

    public static BufferedReader createBufferedReader(InputStream is) {
        BufferedReader br = bufferedReaderPool.poll();
        if (br == null) {
            Objectory.logCreated("createBufferedReader");
            return new BufferedReader(is);
        }
        br.reinit(is);
        return br;
    }

    public static BufferedReader createBufferedReader(Reader reader) {
        BufferedReader br = bufferedReaderPool.poll();
        if (br == null) {
            Objectory.logCreated("createBufferedReader");
            return new BufferedReader(reader);
        }
        br.reinit(reader);
        return br;
    }

    private static void logCreated(String methodName) {
        if (logger.isWarnEnabled() && created.incrementAndGet() % 100 == 0) {
            logger.warn("The " + created.get() + "th cachable object is created by " + methodName, (Throwable)new RuntimeException("No error. Only to print stack trace"));
        }
    }

    public static void recycle(List<?> list) {
        if (list == null || list.size() > 8192) {
            return;
        }
        if (listPool.size() < 1024) {
            list.clear();
            listPool.add(list);
        }
    }

    public static void recycle(Set<?> set) {
        if (set == null || set.size() > 8192) {
            return;
        }
        if (set instanceof LinkedHashSet) {
            if (linkedHashSetPool.size() < 1024) {
                set.clear();
                linkedHashSetPool.add(set);
            }
        } else if (setPool.size() < 1024) {
            set.clear();
            setPool.add(set);
        }
    }

    public static void recycle(Map<?, ?> map) {
        if (map == null || map.size() > 8192) {
            return;
        }
        if (map instanceof LinkedHashMap) {
            if (linkedHashMapPool.size() < 1024) {
                map.clear();
                linkedHashMapPool.add(map);
            }
        } else if (mapPool.size() < 1024) {
            map.clear();
            mapPool.add(map);
        }
    }

    public static void recycle(Object[] objArray) {
        if (objArray == null || objArray.length > 128) {
            return;
        }
        int poolSize = N.min(MAX_ARRAY_POOL_SIZE, MAX_ARRAY_LENGTH / objArray.length);
        Queue<Object[]> arrayQueue = objectArrayPool[objArray.length];
        if (arrayQueue == null) {
            Objectory.objectArrayPool[objArray.length] = arrayQueue = new ArrayBlockingQueue<Object[]>(poolSize);
        }
        if (arrayQueue.size() < poolSize) {
            Arrays.fill(objArray, null);
            arrayQueue.add(objArray);
        }
    }

    public static void recycle(char[] cbuf) {
        if (cbuf == null || cbuf.length > BUFFER_SIZE) {
            return;
        }
        charArrayBufferPool.add(cbuf);
    }

    public static void recycle(byte[] bbuf) {
        if (bbuf == null || bbuf.length > BUFFER_SIZE) {
            return;
        }
        byteArrayBufferPool.add(bbuf);
    }

    public static void recycle(StringBuilder sb) {
        if (sb == null || sb.capacity() > BUFFER_SIZE) {
            return;
        }
        if (stringBuilderPool.size() < 1024) {
            sb.setLength(0);
            stringBuilderPool.add(sb);
        }
    }

    public static void recycle(ByteArrayOutputStream os) {
        if (os == null || os.capacity() > BUFFER_SIZE) {
            return;
        }
        if (byteArrayOutputStreamPool.size() < 1024) {
            os.reset();
            byteArrayOutputStreamPool.add(os);
        }
    }

    public static void recycle(BufferedWriter bw) {
        if (bw == null) {
            return;
        }
        try {
            bw.flushBuffer();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        bw._reset();
        bufferedWriterPool.add(bw);
    }

    public static void recycle(BufferedXMLWriter bw) {
        if (bw == null) {
            return;
        }
        try {
            bw.flushBuffer();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        bw._reset();
        bufferedXMLWriterPool.add(bw);
    }

    public static void recycle(BufferedJSONWriter bw) {
        if (bw == null) {
            return;
        }
        try {
            bw.flushBuffer();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        bw._reset();
        bufferedJSONWriterPool.add(bw);
    }

    public static void recycle(BufferedReader br) {
        if (br == null) {
            return;
        }
        br._reset();
        bufferedReaderPool.add(br);
    }
}

