/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.N;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class Password {
    private final String algorithm;
    private final MessageDigest MD;

    public Password(String algorithm) {
        this.algorithm = algorithm;
        try {
            this.MD = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw N.toRuntimeException(e);
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public synchronized String encrypt(String x) {
        if (x == null) {
            return null;
        }
        try {
            String string = N.base64Encode(this.MD.digest(x.getBytes()));
            return string;
        }
        finally {
            this.MD.reset();
        }
    }

    public boolean isEqual(String plainPassword, String encryptedPassword) {
        return plainPassword == null ? encryptedPassword == null : encryptedPassword != null && encryptedPassword.equals(this.encrypt(plainPassword));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.algorithm == null ? 0 : this.algorithm.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Password && ((Password)obj).algorithm.equals(this.algorithm);
    }

    public String toString() {
        return "{algorithm=" + this.algorithm + "}";
    }
}

