/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.BiMap;
import com.landawn.abacus.util.N;

public final class Primitives {
    static final BiMap<Class<?>, Class<?>> PRIMITIVE_2_WRAPPER = new BiMap();

    private Primitives() {
    }

    public static boolean isPrimitiveType(Class<?> cls) {
        N.checkArgNotNull(cls, "cls");
        return N.typeOf(cls).isPrimitiveType();
    }

    public static boolean isWrapperType(Class<?> cls) {
        N.checkArgNotNull(cls, "cls");
        return N.typeOf(cls).isPrimitiveWrapper();
    }

    public static boolean isPrimitiveArrayType(Class<?> cls) {
        N.checkArgNotNull(cls, "cls");
        return N.typeOf(cls).isPrimitiveArray();
    }

    public static Class<?> wrap(Class<?> cls) {
        N.checkArgNotNull(cls, "cls");
        Class<?> wrapped = PRIMITIVE_2_WRAPPER.get(cls);
        return wrapped == null ? cls : wrapped;
    }

    public static Class<?> unwrap(Class<?> cls) {
        N.checkArgNotNull(cls, "cls");
        Class<?> unwrapped = PRIMITIVE_2_WRAPPER.getByValue(cls);
        return unwrapped == null ? cls : unwrapped;
    }

    @SafeVarargs
    public static Boolean[] box(boolean ... a) {
        if (a == null) {
            return null;
        }
        return Primitives.box(a, 0, a.length);
    }

    public static Boolean[] box(boolean[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        Boolean[] result = new Boolean[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j];
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static Character[] box(char ... a) {
        if (a == null) {
            return null;
        }
        return Primitives.box(a, 0, a.length);
    }

    public static Character[] box(char[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        Character[] result = new Character[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = Character.valueOf(a[j]);
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static Byte[] box(byte ... a) {
        if (a == null) {
            return null;
        }
        return Primitives.box(a, 0, a.length);
    }

    public static Byte[] box(byte[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_BYTE_OBJECT_ARRAY;
        }
        Byte[] result = new Byte[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j];
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static Short[] box(short ... a) {
        if (a == null) {
            return null;
        }
        return Primitives.box(a, 0, a.length);
    }

    public static Short[] box(short[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_SHORT_OBJECT_ARRAY;
        }
        Short[] result = new Short[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j];
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static Integer[] box(int ... a) {
        if (a == null) {
            return null;
        }
        return Primitives.box(a, 0, a.length);
    }

    public static Integer[] box(int[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_INTEGER_OBJECT_ARRAY;
        }
        Integer[] result = new Integer[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j];
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static Long[] box(long ... a) {
        if (a == null) {
            return null;
        }
        return Primitives.box(a, 0, a.length);
    }

    public static Long[] box(long[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_LONG_OBJECT_ARRAY;
        }
        Long[] result = new Long[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j];
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static Float[] box(float ... a) {
        if (a == null) {
            return null;
        }
        return Primitives.box(a, 0, a.length);
    }

    public static Float[] box(float[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_FLOAT_OBJECT_ARRAY;
        }
        Float[] result = new Float[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = Float.valueOf(a[j]);
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static Double[] box(double ... a) {
        if (a == null) {
            return null;
        }
        return Primitives.box(a, 0, a.length);
    }

    public static Double[] box(double[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        Double[] result = new Double[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j];
            ++i;
        }
        return result;
    }

    public static Boolean[][] box(boolean[][] a) {
        if (a == null) {
            return null;
        }
        Boolean[][] result = new Boolean[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.box(a[i]);
        }
        return result;
    }

    public static Character[][] box(char[][] a) {
        if (a == null) {
            return null;
        }
        Character[][] result = new Character[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.box(a[i]);
        }
        return result;
    }

    public static Byte[][] box(byte[][] a) {
        if (a == null) {
            return null;
        }
        Byte[][] result = new Byte[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.box(a[i]);
        }
        return result;
    }

    public static Short[][] box(short[][] a) {
        if (a == null) {
            return null;
        }
        Short[][] result = new Short[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.box(a[i]);
        }
        return result;
    }

    public static Integer[][] box(int[][] a) {
        if (a == null) {
            return null;
        }
        Integer[][] result = new Integer[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.box(a[i]);
        }
        return result;
    }

    public static Long[][] box(long[][] a) {
        if (a == null) {
            return null;
        }
        Long[][] result = new Long[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.box(a[i]);
        }
        return result;
    }

    public static Float[][] box(float[][] a) {
        if (a == null) {
            return null;
        }
        Float[][] result = new Float[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.box(a[i]);
        }
        return result;
    }

    public static Double[][] box(double[][] a) {
        if (a == null) {
            return null;
        }
        Double[][] result = new Double[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.box(a[i]);
        }
        return result;
    }

    public static Boolean[][][] box(boolean[][][] a) {
        if (a == null) {
            return null;
        }
        Boolean[][][] result = new Boolean[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.box(a[i]);
        }
        return result;
    }

    public static Character[][][] box(char[][][] a) {
        if (a == null) {
            return null;
        }
        Character[][][] result = new Character[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.box(a[i]);
        }
        return result;
    }

    public static Byte[][][] box(byte[][][] a) {
        if (a == null) {
            return null;
        }
        Byte[][][] result = new Byte[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.box(a[i]);
        }
        return result;
    }

    public static Short[][][] box(short[][][] a) {
        if (a == null) {
            return null;
        }
        Short[][][] result = new Short[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.box(a[i]);
        }
        return result;
    }

    public static Integer[][][] box(int[][][] a) {
        if (a == null) {
            return null;
        }
        Integer[][][] result = new Integer[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.box(a[i]);
        }
        return result;
    }

    public static Long[][][] box(long[][][] a) {
        if (a == null) {
            return null;
        }
        Long[][][] result = new Long[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.box(a[i]);
        }
        return result;
    }

    public static Float[][][] box(float[][][] a) {
        if (a == null) {
            return null;
        }
        Float[][][] result = new Float[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.box(a[i]);
        }
        return result;
    }

    public static Double[][][] box(double[][][] a) {
        if (a == null) {
            return null;
        }
        Double[][][] result = new Double[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.box(a[i]);
        }
        return result;
    }

    @SafeVarargs
    public static boolean[] unbox(Boolean ... a) {
        return Primitives.unbox(a, false);
    }

    public static boolean[] unbox(Boolean[] a, boolean valueForNull) {
        if (a == null) {
            return null;
        }
        return Primitives.unbox(a, 0, a.length, valueForNull);
    }

    public static boolean[] unbox(Boolean[] a, int fromIndex, int toIndex, boolean valueForNull) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] result = new boolean[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j] == null ? valueForNull : a[j];
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static char[] unbox(Character ... a) {
        return Primitives.unbox(a, '\u0000');
    }

    public static char[] unbox(Character[] a, char valueForNull) {
        if (a == null) {
            return null;
        }
        return Primitives.unbox(a, 0, a.length, valueForNull);
    }

    public static char[] unbox(Character[] a, int fromIndex, int toIndex, char valueForNull) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j] == null ? valueForNull : a[j].charValue();
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static byte[] unbox(Byte ... a) {
        return Primitives.unbox(a, (byte)0);
    }

    public static byte[] unbox(Byte[] a, byte valueForNull) {
        if (a == null) {
            return null;
        }
        return Primitives.unbox(a, 0, a.length, valueForNull);
    }

    public static byte[] unbox(Byte[] a, int fromIndex, int toIndex, byte valueForNull) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j] == null ? valueForNull : a[j];
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static short[] unbox(Short ... a) {
        return Primitives.unbox(a, (short)0);
    }

    public static short[] unbox(Short[] a, short valueForNull) {
        if (a == null) {
            return null;
        }
        return Primitives.unbox(a, 0, a.length, valueForNull);
    }

    public static short[] unbox(Short[] a, int fromIndex, int toIndex, short valueForNull) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_SHORT_ARRAY;
        }
        short[] result = new short[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j] == null ? valueForNull : a[j];
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static int[] unbox(Integer ... a) {
        return Primitives.unbox(a, 0);
    }

    public static int[] unbox(Integer[] a, int valueForNull) {
        if (a == null) {
            return null;
        }
        return Primitives.unbox(a, 0, a.length, valueForNull);
    }

    public static int[] unbox(Integer[] a, int fromIndex, int toIndex, int valueForNull) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_INT_ARRAY;
        }
        int[] result = new int[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j] == null ? valueForNull : a[j];
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static long[] unbox(Long ... a) {
        return Primitives.unbox(a, 0L);
    }

    public static long[] unbox(Long[] a, long valueForNull) {
        if (a == null) {
            return null;
        }
        return Primitives.unbox(a, 0, a.length, valueForNull);
    }

    public static long[] unbox(Long[] a, int fromIndex, int toIndex, long valueForNull) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_LONG_ARRAY;
        }
        long[] result = new long[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j] == null ? valueForNull : a[j];
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static float[] unbox(Float ... a) {
        return Primitives.unbox(a, 0.0f);
    }

    public static float[] unbox(Float[] a, float valueForNull) {
        if (a == null) {
            return null;
        }
        return Primitives.unbox(a, 0, a.length, valueForNull);
    }

    public static float[] unbox(Float[] a, int fromIndex, int toIndex, float valueForNull) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_FLOAT_ARRAY;
        }
        float[] result = new float[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j] == null ? valueForNull : a[j].floatValue();
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static double[] unbox(Double ... a) {
        return Primitives.unbox(a, 0.0);
    }

    public static double[] unbox(Double[] a, double valueForNull) {
        if (a == null) {
            return null;
        }
        return Primitives.unbox(a, 0, a.length, valueForNull);
    }

    public static double[] unbox(Double[] a, int fromIndex, int toIndex, double valueForNull) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j] == null ? valueForNull : a[j];
            ++i;
        }
        return result;
    }

    public static boolean[][] unbox(Boolean[][] a) {
        return Primitives.unbox(a, false);
    }

    public static boolean[][] unbox(Boolean[][] a, boolean valueForNull) {
        if (a == null) {
            return null;
        }
        boolean[][] result = new boolean[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static char[][] unbox(Character[][] a) {
        return Primitives.unbox(a, '\u0000');
    }

    public static char[][] unbox(Character[][] a, char valueForNull) {
        if (a == null) {
            return null;
        }
        char[][] result = new char[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static byte[][] unbox(Byte[][] a) {
        return Primitives.unbox(a, (byte)0);
    }

    public static byte[][] unbox(Byte[][] a, byte valueForNull) {
        if (a == null) {
            return null;
        }
        byte[][] result = new byte[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static short[][] unbox(Short[][] a) {
        return Primitives.unbox(a, (short)0);
    }

    public static short[][] unbox(Short[][] a, short valueForNull) {
        if (a == null) {
            return null;
        }
        short[][] result = new short[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static int[][] unbox(Integer[][] a) {
        return Primitives.unbox(a, 0);
    }

    public static int[][] unbox(Integer[][] a, int valueForNull) {
        if (a == null) {
            return null;
        }
        int[][] result = new int[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static long[][] unbox(Long[][] a) {
        return Primitives.unbox(a, 0L);
    }

    public static long[][] unbox(Long[][] a, long valueForNull) {
        if (a == null) {
            return null;
        }
        long[][] result = new long[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static float[][] unbox(Float[][] a) {
        return Primitives.unbox(a, 0.0f);
    }

    public static float[][] unbox(Float[][] a, float valueForNull) {
        if (a == null) {
            return null;
        }
        float[][] result = new float[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static double[][] unbox(Double[][] a) {
        return Primitives.unbox(a, 0.0);
    }

    public static double[][] unbox(Double[][] a, double valueForNull) {
        if (a == null) {
            return null;
        }
        double[][] result = new double[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static boolean[][][] unbox(Boolean[][][] a) {
        return Primitives.unbox(a, false);
    }

    public static boolean[][][] unbox(Boolean[][][] a, boolean valueForNull) {
        if (a == null) {
            return null;
        }
        boolean[][][] result = new boolean[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static char[][][] unbox(Character[][][] a) {
        return Primitives.unbox(a, '\u0000');
    }

    public static char[][][] unbox(Character[][][] a, char valueForNull) {
        if (a == null) {
            return null;
        }
        char[][][] result = new char[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static byte[][][] unbox(Byte[][][] a) {
        return Primitives.unbox(a, (byte)0);
    }

    public static byte[][][] unbox(Byte[][][] a, byte valueForNull) {
        if (a == null) {
            return null;
        }
        byte[][][] result = new byte[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static short[][][] unbox(Short[][][] a) {
        return Primitives.unbox(a, (short)0);
    }

    public static short[][][] unbox(Short[][][] a, short valueForNull) {
        if (a == null) {
            return null;
        }
        short[][][] result = new short[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static int[][][] unbox(Integer[][][] a) {
        return Primitives.unbox(a, 0);
    }

    public static int[][][] unbox(Integer[][][] a, int valueForNull) {
        if (a == null) {
            return null;
        }
        int[][][] result = new int[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static long[][][] unbox(Long[][][] a) {
        return Primitives.unbox(a, 0L);
    }

    public static long[][][] unbox(Long[][][] a, long valueForNull) {
        if (a == null) {
            return null;
        }
        long[][][] result = new long[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static float[][][] unbox(Float[][][] a) {
        return Primitives.unbox(a, 0.0f);
    }

    public static float[][][] unbox(Float[][][] a, float valueForNull) {
        if (a == null) {
            return null;
        }
        float[][][] result = new float[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static double[][][] unbox(Double[][][] a) {
        return Primitives.unbox(a, 0.0);
    }

    public static double[][][] unbox(Double[][][] a, double valueForNull) {
        if (a == null) {
            return null;
        }
        double[][][] result = new double[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Primitives.unbox(a[i], valueForNull);
        }
        return result;
    }

    static {
        PRIMITIVE_2_WRAPPER.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_2_WRAPPER.put(Character.TYPE, Character.class);
        PRIMITIVE_2_WRAPPER.put(Byte.TYPE, Byte.class);
        PRIMITIVE_2_WRAPPER.put(Short.TYPE, Short.class);
        PRIMITIVE_2_WRAPPER.put(Integer.TYPE, Integer.class);
        PRIMITIVE_2_WRAPPER.put(Long.TYPE, Long.class);
        PRIMITIVE_2_WRAPPER.put(Float.TYPE, Float.class);
        PRIMITIVE_2_WRAPPER.put(Double.TYPE, Double.class);
        PRIMITIVE_2_WRAPPER.put(boolean[].class, Boolean[].class);
        PRIMITIVE_2_WRAPPER.put(char[].class, Character[].class);
        PRIMITIVE_2_WRAPPER.put(byte[].class, Byte[].class);
        PRIMITIVE_2_WRAPPER.put(short[].class, Short[].class);
        PRIMITIVE_2_WRAPPER.put(int[].class, Integer[].class);
        PRIMITIVE_2_WRAPPER.put(long[].class, Long[].class);
        PRIMITIVE_2_WRAPPER.put(float[].class, Float[].class);
        PRIMITIVE_2_WRAPPER.put(double[].class, Double[].class);
    }

    public static final class Doubles {
        private Doubles() {
        }
    }

    public static final class Floats {
        private Floats() {
        }
    }

    public static final class Longs {
        private Longs() {
        }
    }

    public static final class Ints {
        private Ints() {
        }
    }

    public static final class Shorts {
        private Shorts() {
        }
    }

    public static final class Bytes {
        private Bytes() {
        }
    }

    public static final class Chars {
        private Chars() {
        }
    }

    public static final class Booleans {
        private Booleans() {
        }

        public static void invert(boolean[] a) {
            if (N.isNullOrEmpty(a)) {
                return;
            }
            Booleans.invert(a, 0, a.length);
        }

        public static void invert(boolean[] a, int fromIndex, int toIndex) {
            N.checkFromToIndex(fromIndex, toIndex, N.len(a));
            if (fromIndex == toIndex) {
                return;
            }
            for (int i = fromIndex; i < toIndex; ++i) {
                a[i] = !a[i];
            }
        }
    }
}

