/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.N;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Properties<K, V>
implements Map<K, V> {
    protected final Map<K, V> values;

    public Properties() {
        this(new ConcurrentHashMap());
    }

    Properties(ConcurrentHashMap<? extends K, ? extends V> valueMap) {
        this.values = valueMap;
    }

    public static <K, V> Properties<K, V> from(Map<? extends K, ? extends V> map) {
        return new Properties<K, V>(new ConcurrentHashMap<K, V>(map));
    }

    @Override
    public V get(Object propName) {
        return this.values.get(propName);
    }

    public <T> T get(Class<T> targetClass, Object propName) {
        return N.convert(this.values.get(propName), targetClass);
    }

    @Override
    public V getOrDefault(Object propName, V defaultValue) {
        V result = this.values.get(propName);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public <T> T getOrDefault(Class<T> targetClass, Object propName, T defaultValue) {
        V result = this.values.get(propName);
        if (result == null) {
            return defaultValue;
        }
        return N.convert(result, targetClass);
    }

    public Properties<K, V> set(K propName, V propValue) {
        this.put(propName, propValue);
        return this;
    }

    @Override
    public V put(K key, V value) {
        return this.values.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.values.putAll(m);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V v = this.get(key);
        if (v == null) {
            v = this.put(key, value);
        }
        return v;
    }

    @Override
    public V remove(Object key) {
        return this.values.remove(key);
    }

    @Override
    public boolean remove(Object key, Object value) {
        V curValue = this.get(key);
        if (!Objects.equals(curValue, value) || curValue == null && !this.containsKey(key)) {
            return false;
        }
        this.remove(key);
        return true;
    }

    @Override
    public V replace(K key, V value) {
        V curValue = this.get(key);
        if (curValue != null || this.containsKey(key)) {
            curValue = this.put(key, value);
        }
        return curValue;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        V curValue = this.get(key);
        if (!Objects.equals(curValue, oldValue) || curValue == null && !this.containsKey(key)) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.values.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsValue(value);
    }

    @Override
    public Set<K> keySet() {
        return this.values.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.values.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.values.entrySet();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    public Properties<K, V> copy() {
        Properties<K, V> copy = new Properties<K, V>();
        copy.values.putAll(this.values);
        return copy;
    }

    @Override
    public int hashCode() {
        return 31 + (this.values == null ? 0 : this.values.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Properties && N.equals(((Properties)obj).values, this.values);
    }

    public String toString() {
        return this.values.toString();
    }
}

