/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.N;
import java.util.regex.Pattern;

public final class RegExUtil {
    private RegExUtil() {
    }

    public static String removeAll(String text, Pattern regex) {
        return RegExUtil.replaceAll(text, regex, N.EMPTY_STRING);
    }

    public static String removeAll(String text, String regex) {
        return RegExUtil.replaceAll(text, regex, N.EMPTY_STRING);
    }

    public static String removeFirst(String text, Pattern regex) {
        return RegExUtil.replaceFirst(text, regex, N.EMPTY_STRING);
    }

    public static String removeFirst(String text, String regex) {
        return RegExUtil.replaceFirst(text, regex, N.EMPTY_STRING);
    }

    public static String removePattern(String text, String regex) {
        return RegExUtil.replacePattern(text, regex, N.EMPTY_STRING);
    }

    public static String replaceFirst(String text, Pattern regex, String replacement) {
        if (text == null || regex == null || replacement == null) {
            return text;
        }
        return regex.matcher(text).replaceFirst(replacement);
    }

    public static String replaceFirst(String text, String regex, String replacement) {
        if (text == null || regex == null || replacement == null) {
            return text;
        }
        return text.replaceFirst(regex, replacement);
    }

    public static String replaceAll(String text, Pattern regex, String replacement) {
        if (text == null || regex == null || replacement == null) {
            return text;
        }
        return regex.matcher(text).replaceAll(replacement);
    }

    public static String replaceAll(String text, String regex, String replacement) {
        if (text == null || regex == null || replacement == null) {
            return text;
        }
        return text.replaceAll(regex, replacement);
    }

    public static String replacePattern(String text, String regex, String replacement) {
        if (text == null || regex == null || replacement == null) {
            return text;
        }
        return Pattern.compile(regex, 32).matcher(text).replaceAll(replacement);
    }
}

