/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.Fn;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Try;
import com.landawn.abacus.util.Tuple;
import com.landawn.abacus.util.function.Function;
import com.landawn.abacus.util.function.Supplier;

public final class Result<T, E extends Throwable> {
    private final T value;
    private final E exception;

    Result(T value, E exception) {
        this.value = value;
        this.exception = exception;
    }

    public static <T, E extends Throwable> Result<T, E> of(T value, E exception) {
        return new Result<T, E>(value, exception);
    }

    public boolean isFailure() {
        return this.exception != null;
    }

    public boolean isSuccess() {
        return this.exception == null;
    }

    public <E2 extends Exception> void ifFailure(Try.Consumer<? super E, E2> actionOnFailure) throws E2 {
        this.ifFailureOrElse(actionOnFailure, Fn.doNothing());
    }

    public <E2 extends Exception, E3 extends Exception> void ifFailureOrElse(Try.Consumer<? super E, E2> actionOnFailure, Try.Consumer<? super T, E3> actionOnSuccess) throws E2, E3 {
        N.checkArgNotNull(actionOnFailure, "actionOnFailure");
        N.checkArgNotNull(actionOnSuccess, "actionOnSuccess");
        if (this.exception != null) {
            actionOnFailure.accept(this.exception);
        } else {
            actionOnSuccess.accept(this.value);
        }
    }

    public <E2 extends Exception> void ifSuccess(Try.Consumer<? super T, E2> actionOnSuccess) throws E2 {
        this.ifSuccessOrElse(actionOnSuccess, Fn.doNothing());
    }

    public <E2 extends Exception, E3 extends Exception> void ifSuccessOrElse(Try.Consumer<? super T, E2> actionOnSuccess, Try.Consumer<? super E, E3> actionOnFailure) throws E2, E3 {
        N.checkArgNotNull(actionOnSuccess, "actionOnSuccess");
        N.checkArgNotNull(actionOnFailure, "actionOnFailure");
        if (this.exception == null) {
            actionOnSuccess.accept(this.value);
        } else {
            actionOnFailure.accept(this.exception);
        }
    }

    public T orElse(T defaultValueIfErrorOccurred) {
        if (this.exception == null) {
            return this.value;
        }
        return defaultValueIfErrorOccurred;
    }

    public T orElseGet(Supplier<T> valueSupplierIfErrorOccurred) {
        N.checkArgNotNull(valueSupplierIfErrorOccurred, "valueSupplierIfErrorOccurred");
        if (this.exception == null) {
            return this.value;
        }
        return valueSupplierIfErrorOccurred.get();
    }

    public T orElseThrow() throws E {
        if (this.exception == null) {
            return this.value;
        }
        throw this.exception;
    }

    public <E2 extends Throwable> T orElseThrow(Function<? super E, E2> exceptionSupplierIfErrorOccurred) throws E2 {
        N.checkArgNotNull(exceptionSupplierIfErrorOccurred, "exceptionSupplierIfErrorOccurred");
        if (this.exception == null) {
            return this.value;
        }
        throw (Throwable)exceptionSupplierIfErrorOccurred.apply(this.exception);
    }

    public E getExceptionIfPresent() {
        return this.exception;
    }

    public Tuple.Tuple2<T, E> toTuple() {
        return Tuple.of(this.value, this.exception);
    }

    public int hashCode() {
        return this.exception == null ? N.hashCode(this.value) : this.exception.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Result && N.equals(((Result)obj).value, this.value) && N.equals(((Result)obj).exception, this.exception);
    }

    public String toString() {
        return "{value=" + N.toString(this.value) + ", exception=" + N.toString(this.exception) + "}";
    }
}

