/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Try;
import com.landawn.abacus.util.function.BiPredicate;
import com.landawn.abacus.util.function.Predicate;
import java.util.Iterator;
import java.util.concurrent.Callable;

public final class Retry<T> {
    private static final Logger logger = LoggerFactory.getLogger(Retry.class);
    private final int retryTimes;
    private final long retryInterval;
    private final Predicate<? super Exception> retryCondition;
    private final BiPredicate<? super T, ? super Exception> retryCondition2;

    Retry(int retryTimes, long retryInterval, Predicate<? super Exception> retryCondition, BiPredicate<? super T, ? super Exception> retryCondition2) {
        this.retryTimes = retryTimes;
        this.retryInterval = retryInterval;
        this.retryCondition = retryCondition;
        this.retryCondition2 = retryCondition2;
    }

    public static Retry<Void> of(int retryTimes, long retryInterval, Predicate<? super Exception> retryCondition) {
        if (retryTimes < 0 || retryInterval < 0L) {
            throw new IllegalArgumentException("'retryTimes' and 'retryInterval' can't be negative");
        }
        N.checkArgNotNull(retryCondition);
        return new Retry<Void>(retryTimes, retryInterval, retryCondition, null);
    }

    public static <R> Retry<R> of(int retryTimes, long retryInterval, BiPredicate<? super R, ? super Exception> retryCondition) {
        if (retryTimes < 0 || retryInterval < 0L) {
            throw new IllegalArgumentException("'retryTimes' and 'retryInterval' can't be negative");
        }
        N.checkArgNotNull(retryCondition);
        return new Retry<R>(retryTimes, retryInterval, null, retryCondition);
    }

    public void run(Try.Runnable<? extends Exception> cmd) throws Exception {
        try {
            cmd.run();
        }
        catch (Exception e) {
            logger.error("AutoRetry", (Throwable)e);
            int retriedTimes = 0;
            Exception throwable = e;
            while (retriedTimes++ < this.retryTimes && (this.retryCondition != null && this.retryCondition.test(throwable) || this.retryCondition2 != null && this.retryCondition2.test(null, throwable))) {
                try {
                    if (this.retryInterval > 0L) {
                        N.sleep(this.retryInterval);
                    }
                    cmd.run();
                    return;
                }
                catch (Exception e2) {
                    logger.error("AutoRetry", (Throwable)e2);
                    throwable = e2;
                }
            }
            throw throwable;
        }
    }

    public T call(Callable<T> callable) throws Exception {
        Object result = null;
        int retriedTimes = 0;
        try {
            result = callable.call();
            while (retriedTimes++ < this.retryTimes && this.retryCondition2 != null && this.retryCondition2.test(result, null)) {
                if (this.retryInterval > 0L) {
                    N.sleep(this.retryInterval);
                }
                result = callable.call();
                if (this.retryCondition2 != null && this.retryCondition2.test(result, null)) continue;
                return result;
            }
        }
        catch (Exception e) {
            logger.error("AutoRetry", (Throwable)e);
            Exception throwable = e;
            while (retriedTimes++ < this.retryTimes && (this.retryCondition != null && this.retryCondition.test(throwable) || this.retryCondition2 != null && this.retryCondition2.test(null, throwable))) {
                try {
                    if (this.retryInterval > 0L) {
                        N.sleep(this.retryInterval);
                    }
                    result = callable.call();
                    if (this.retryCondition2 != null && this.retryCondition2.test(result, null)) continue;
                    return result;
                }
                catch (Exception e2) {
                    logger.error("AutoRetry", (Throwable)e2);
                    throwable = e2;
                }
            }
            throw throwable;
        }
        if (this.retryTimes > 0 && this.retryCondition2 != null && this.retryCondition2.test(result, null)) {
            throw new RuntimeException("Still failed after retried " + this.retryTimes + " times for result: " + N.toString(result));
        }
        return result;
    }

    @Deprecated
    public <E> Iterator<E> iterate(Iterator<E> iter) {
        return this.iterate(iter, Integer.MAX_VALUE);
    }

    public <E> Iterator<E> iterate(final Iterator<E> iter, final int totalRetryTimes) {
        N.checkArgPositive(totalRetryTimes, "totalRetryTimes");
        return new Iterator<E>(){
            private int totalRetriedTimes = 0;

            @Override
            public boolean hasNext() {
                try {
                    return iter.hasNext();
                }
                catch (RuntimeException e) {
                    logger.error("hasNext", (Throwable)e);
                    int retriedTimes = 0;
                    RuntimeException throwable = e;
                    while (this.totalRetriedTimes < totalRetryTimes && retriedTimes++ < Retry.this.retryTimes && (Retry.this.retryCondition != null && Retry.this.retryCondition.test(throwable) || Retry.this.retryCondition2 != null && Retry.this.retryCondition2.test(null, throwable))) {
                        ++this.totalRetriedTimes;
                        try {
                            if (Retry.this.retryInterval > 0L) {
                                N.sleep(Retry.this.retryInterval);
                            }
                            return iter.hasNext();
                        }
                        catch (RuntimeException e2) {
                            logger.error("hasNext", (Throwable)e2);
                            throwable = e2;
                        }
                    }
                    throw throwable;
                }
            }

            @Override
            public E next() {
                try {
                    return iter.next();
                }
                catch (RuntimeException e) {
                    logger.error("next", (Throwable)e);
                    int retriedTimes = 0;
                    RuntimeException throwable = e;
                    while (this.totalRetriedTimes < totalRetryTimes && retriedTimes++ < Retry.this.retryTimes && (Retry.this.retryCondition != null && Retry.this.retryCondition.test(throwable) || Retry.this.retryCondition2 != null && Retry.this.retryCondition2.test(null, throwable))) {
                        ++this.totalRetriedTimes;
                        try {
                            if (Retry.this.retryInterval > 0L) {
                                N.sleep(Retry.this.retryInterval);
                            }
                            return iter.next();
                        }
                        catch (RuntimeException e2) {
                            logger.error("next", (Throwable)e2);
                            throwable = e2;
                        }
                    }
                    throw throwable;
                }
            }

            @Override
            public void remove() {
                try {
                    iter.remove();
                }
                catch (RuntimeException e) {
                    logger.error("remove", (Throwable)e);
                    int retriedTimes = 0;
                    RuntimeException throwable = e;
                    while (this.totalRetriedTimes < totalRetryTimes && retriedTimes++ < Retry.this.retryTimes && (Retry.this.retryCondition != null && Retry.this.retryCondition.test(throwable) || Retry.this.retryCondition2 != null && Retry.this.retryCondition2.test(null, throwable))) {
                        ++this.totalRetriedTimes;
                        try {
                            if (Retry.this.retryInterval > 0L) {
                                N.sleep(Retry.this.retryInterval);
                            }
                            iter.remove();
                        }
                        catch (RuntimeException e2) {
                            logger.error("remove", (Throwable)e2);
                            throwable = e2;
                        }
                    }
                    throw throwable;
                }
            }
        };
    }
}

