/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.DirtyMarker;
import com.landawn.abacus.annotation.Beta;
import com.landawn.abacus.annotation.Column;
import com.landawn.abacus.annotation.NonUpdatable;
import com.landawn.abacus.annotation.ReadOnly;
import com.landawn.abacus.annotation.ReadOnlyId;
import com.landawn.abacus.annotation.Transient;
import com.landawn.abacus.condition.Between;
import com.landawn.abacus.condition.Binary;
import com.landawn.abacus.condition.Cell;
import com.landawn.abacus.condition.Condition;
import com.landawn.abacus.condition.ConditionFactory;
import com.landawn.abacus.condition.Expression;
import com.landawn.abacus.condition.In;
import com.landawn.abacus.condition.Junction;
import com.landawn.abacus.condition.SubQuery;
import com.landawn.abacus.core.DirtyMarkerUtil;
import com.landawn.abacus.exception.AbacusException;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.util.Array;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.ImmutableList;
import com.landawn.abacus.util.ImmutableSet;
import com.landawn.abacus.util.Maps;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.NamingPolicy;
import com.landawn.abacus.util.ObjectPool;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.OperationType;
import com.landawn.abacus.util.Pair;
import com.landawn.abacus.util.SQLParser;
import com.landawn.abacus.util.SortDirection;
import com.landawn.abacus.util.StringUtil;
import com.landawn.abacus.util.Try;
import com.landawn.abacus.util.u;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.Table;

public abstract class SQLBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SQLBuilder.class);
    public static final String ALL = "ALL";
    public static final String TOP = "TOP";
    public static final String UNIQUE = "UNIQUE";
    public static final String DISTINCT = "DISTINCT";
    public static final String DISTINCTROW = "DISTINCTROW";
    public static final String ASTERISK = "*";
    public static final String COUNT_ALL = "count(*)";
    public static final String _1 = "1";
    public static final List<String> _1_list = ImmutableList.of("1");
    static final char[] _INSERT = "INSERT".toCharArray();
    static final char[] _SPACE_INSERT_SPACE = " INSERT ".toCharArray();
    static final char[] _INTO = "INTO".toCharArray();
    static final char[] _SPACE_INTO_SPACE = " INTO ".toCharArray();
    static final char[] _VALUES = "VALUES".toCharArray();
    static final char[] _SPACE_VALUES_SPACE = " VALUES ".toCharArray();
    static final char[] _SELECT = "SELECT".toCharArray();
    static final char[] _SPACE_SELECT_SPACE = " SELECT ".toCharArray();
    static final char[] _FROM = "FROM".toCharArray();
    static final char[] _SPACE_FROM_SPACE = " FROM ".toCharArray();
    static final char[] _UPDATE = "UPDATE".toCharArray();
    static final char[] _SPACE_UPDATE_SPACE = " UPDATE ".toCharArray();
    static final char[] _SET = "SET".toCharArray();
    static final char[] _SPACE_SET_SPACE = " SET ".toCharArray();
    static final char[] _DELETE = "DELETE".toCharArray();
    static final char[] _SPACE_DELETE_SPACE = " DELETE ".toCharArray();
    static final char[] _JOIN = "JOIN".toCharArray();
    static final char[] _SPACE_JOIN_SPACE = " JOIN ".toCharArray();
    static final char[] _LEFT_JOIN = "LEFT JOIN".toCharArray();
    static final char[] _SPACE_LEFT_JOIN_SPACE = " LEFT JOIN ".toCharArray();
    static final char[] _RIGHT_JOIN = "RIGHT JOIN".toCharArray();
    static final char[] _SPACE_RIGHT_JOIN_SPACE = " RIGHT JOIN ".toCharArray();
    static final char[] _FULL_JOIN = "FULL JOIN".toCharArray();
    static final char[] _SPACE_FULL_JOIN_SPACE = " FULL JOIN ".toCharArray();
    static final char[] _CROSS_JOIN = "CROSS JOIN".toCharArray();
    static final char[] _SPACE_CROSS_JOIN_SPACE = " CROSS JOIN ".toCharArray();
    static final char[] _INNER_JOIN = "INNER JOIN".toCharArray();
    static final char[] _SPACE_INNER_JOIN_SPACE = " INNER JOIN ".toCharArray();
    static final char[] _NATURAL_JOIN = "NATURAL JOIN".toCharArray();
    static final char[] _SPACE_NATURAL_JOIN_SPACE = " NATURAL JOIN ".toCharArray();
    static final char[] _ON = "ON".toCharArray();
    static final char[] _SPACE_ON_SPACE = " ON ".toCharArray();
    static final char[] _USING = "USING".toCharArray();
    static final char[] _SPACE_USING_SPACE = " USING ".toCharArray();
    static final char[] _WHERE = "WHERE".toCharArray();
    static final char[] _SPACE_WHERE_SPACE = " WHERE ".toCharArray();
    static final char[] _GROUP_BY = "GROUP BY".toCharArray();
    static final char[] _SPACE_GROUP_BY_SPACE = " GROUP BY ".toCharArray();
    static final char[] _HAVING = "HAVING".toCharArray();
    static final char[] _SPACE_HAVING_SPACE = " HAVING ".toCharArray();
    static final char[] _ORDER_BY = "ORDER BY".toCharArray();
    static final char[] _SPACE_ORDER_BY_SPACE = " ORDER BY ".toCharArray();
    static final char[] _LIMIT = " LIMIT ".toCharArray();
    static final char[] _SPACE_LIMIT_SPACE = " LIMIT ".toCharArray();
    static final char[] _OFFSET = "OFFSET".toCharArray();
    static final char[] _SPACE_OFFSET_SPACE = " OFFSET ".toCharArray();
    static final char[] _AND = "AND".toCharArray();
    static final char[] _SPACE_AND_SPACE = " AND ".toCharArray();
    static final char[] _OR = "OR".toCharArray();
    static final char[] _SPACE_OR_SPACE = " OR ".toCharArray();
    static final char[] _UNION = "UNION".toCharArray();
    static final char[] _SPACE_UNION_SPACE = " UNION ".toCharArray();
    static final char[] _UNION_ALL = "UNION ALL".toCharArray();
    static final char[] _SPACE_UNION_ALL_SPACE = " UNION ALL ".toCharArray();
    static final char[] _INTERSECT = "INTERSECT".toCharArray();
    static final char[] _SPACE_INTERSECT_SPACE = " INTERSECT ".toCharArray();
    static final char[] _EXCEPT = "EXCEPT".toCharArray();
    static final char[] _SPACE_EXCEPT_SPACE = " EXCEPT ".toCharArray();
    static final char[] _EXCEPT2 = "MINUS".toCharArray();
    static final char[] _SPACE_EXCEPT2_SPACE = " MINUS ".toCharArray();
    static final char[] _AS = "AS".toCharArray();
    static final char[] _SPACE_AS_SPACE = " AS ".toCharArray();
    static final char[] _SPACE_EQUAL_SPACE = " = ".toCharArray();
    static final char[] _SPACE_FOR_UPDATE = " FOR UPDATE".toCharArray();
    static final char[] _COMMA_SPACE = ", ".toCharArray();
    static final String SPACE_AS_SPACE = " AS ";
    private static final Map<Class<?>, Map<String, String>> entityTablePropColumnNameMap = new ObjectPool(1024);
    private static final Map<Class<?>, Set<String>> subEntityPropNamesPool = new ObjectPool(1024);
    private static final Map<Class<?>, Set<String>> nonSubEntityPropNamesPool = new ObjectPool(1024);
    private static final Map<Class<?>, Set<String>[]> defaultPropNamesPool = new ObjectPool(1024);
    private static final Map<String, char[]> tableDeleteFrom = new ConcurrentHashMap<String, char[]>();
    private static final AtomicInteger activeStringBuilderCounter = new AtomicInteger();
    private final NamingPolicy namingPolicy;
    private final SQLPolicy sqlPolicy;
    private final List<Object> parameters = new ArrayList<Object>();
    private StringBuilder sb;
    private Class<?> entityClass;
    private OperationType op;
    private String tableName;
    private String predicates;
    private String[] columnNames;
    private Collection<String> columnNameList;
    private Map<String, String> columnAliases;
    private Map<String, Object> props;
    private Collection<Map<String, Object>> propsList;
    private static final Map<Class<?>, String[]> classTableNameMap = new ConcurrentHashMap();
    private static final Map<Integer, String> QM_CACHE = new HashMap<Integer, String>();

    SQLBuilder(NamingPolicy namingPolicy, SQLPolicy sqlPolicy) {
        if (activeStringBuilderCounter.incrementAndGet() > 1024) {
            logger.error("Too many(" + activeStringBuilderCounter.get() + ") StringBuilder instances are created in SQLBuilder. The method sql()/pair() must be called to release resources and close SQLBuilder");
        }
        this.sb = Objectory.createStringBuilder();
        this.namingPolicy = namingPolicy == null ? NamingPolicy.LOWER_CASE_WITH_UNDERSCORE : namingPolicy;
        this.sqlPolicy = sqlPolicy == null ? SQLPolicy.SQL : sqlPolicy;
    }

    static void registerEntityPropColumnNameMap(Class<?> entityClass) {
        N.checkArgNotNull(entityClass);
        Set<Field> allFields = N.newHashSet();
        for (Class<?> superClass : ClassUtil.getAllSuperclasses(entityClass)) {
            allFields.addAll(Array.asList(superClass.getDeclaredFields()));
        }
        allFields.addAll(Array.asList(entityClass.getDeclaredFields()));
        HashMap<String, String> propColumnNameMap = new HashMap<String, String>();
        Method getterMethod = null;
        for (Field field : allFields) {
            getterMethod = ClassUtil.getPropGetMethod(entityClass, field.getName());
            if (getterMethod == null) continue;
            String columnName = null;
            if (field.isAnnotationPresent(Column.class)) {
                columnName = field.getAnnotation(Column.class).value();
            } else {
                try {
                    if (field.isAnnotationPresent(javax.persistence.Column.class)) {
                        columnName = field.getAnnotation(javax.persistence.Column.class).name();
                    }
                }
                catch (Throwable e) {
                    logger.warn("To support javax.persistence.Table/Column, please add dependence javax.persistence:persistence-api");
                }
            }
            if (!N.notNullOrEmpty(columnName)) continue;
            propColumnNameMap.put(ClassUtil.getPropNameByMethod(getterMethod), columnName);
        }
        Map<String, String> tmp = entityTablePropColumnNameMap.get(entityClass);
        if (N.notNullOrEmpty(tmp)) {
            propColumnNameMap.putAll(tmp);
        }
        if (N.isNullOrEmpty(propColumnNameMap)) {
            entityTablePropColumnNameMap.put(entityClass, N.emptyMap());
        } else {
            entityTablePropColumnNameMap.put(entityClass, propColumnNameMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerNonSubEntityPropNames(Class<?> entityClass, Collection<String> nonSubEntityPropNames) {
        ImmutableSet<String> set = ImmutableSet.copyOf(nonSubEntityPropNames);
        Class<?> clazz = entityClass;
        synchronized (clazz) {
            nonSubEntityPropNamesPool.put(entityClass, set);
            subEntityPropNamesPool.remove(entityClass);
            defaultPropNamesPool.remove(entityClass);
        }
    }

    static String getTableName(Class<?> entityClass, NamingPolicy namingPolicy) {
        String[] entityTableNames = classTableNameMap.get(entityClass);
        if (entityTableNames == null) {
            if (entityClass.isAnnotationPresent(com.landawn.abacus.annotation.Table.class)) {
                entityTableNames = Array.repeat(entityClass.getAnnotation(com.landawn.abacus.annotation.Table.class).value(), 3);
            } else {
                try {
                    if (entityClass.isAnnotationPresent(Table.class)) {
                        entityTableNames = Array.repeat(entityClass.getAnnotation(Table.class).name(), 3);
                    }
                }
                catch (Throwable e) {
                    logger.warn("To support javax.persistence.Table/Column, please add dependence javax.persistence:persistence-api");
                }
            }
            if (entityTableNames == null) {
                String simpleClassName = ClassUtil.getSimpleClassName(entityClass);
                entityTableNames = new String[]{ClassUtil.toLowerCaseWithUnderscore(simpleClassName), ClassUtil.toUpperCaseWithUnderscore(simpleClassName), ClassUtil.toCamelCase(simpleClassName)};
            }
            classTableNameMap.put(entityClass, entityTableNames);
        }
        switch (namingPolicy) {
            case LOWER_CASE_WITH_UNDERSCORE: {
                return entityTableNames[0];
            }
            case UPPER_CASE_WITH_UNDERSCORE: {
                return entityTableNames[1];
            }
        }
        return entityTableNames[2];
    }

    static Collection<String> getSelectPropNamesByClass(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
        Collection<String> propNames;
        Collection<String>[] val = SQLBuilder.loadPropNamesByClass(entityClass);
        Collection<String> collection = propNames = includeSubEntityProperties ? val[0] : val[1];
        if (N.isNullOrEmpty(excludedPropNames)) {
            return propNames;
        }
        ArrayList<String> tmp = new ArrayList<String>(propNames);
        tmp.removeAll(excludedPropNames);
        return tmp;
    }

    static Collection<String> getInsertPropNamesByClass(Object entity, Set<String> excludedPropNames) {
        Class<?> entityClass = entity.getClass();
        Collection<String>[] val = SQLBuilder.loadPropNamesByClass(entityClass);
        if (N.isNullOrEmpty(excludedPropNames)) {
            List<String> idPropNames = ClassUtil.getIdFieldNames(entityClass);
            if (N.isNullOrEmpty(idPropNames)) {
                return val[2];
            }
            for (String idPropName : idPropNames) {
                if (!SQLBuilder.isDefaultIdPropValue(ClassUtil.getPropValue(entity, idPropName))) continue;
                return val[3];
            }
            return val[2];
        }
        ArrayList<String> tmp = new ArrayList<String>(val[2]);
        tmp.removeAll(excludedPropNames);
        return tmp;
    }

    private static boolean isDefaultIdPropValue(Object propValue) {
        return propValue == null || propValue instanceof Number && ((Number)propValue).longValue() == 0L;
    }

    static Collection<String> getInsertPropNamesByClass(Class<?> entityClass, Set<String> excludedPropNames) {
        Collection<String>[] val = SQLBuilder.loadPropNamesByClass(entityClass);
        Collection<String> propNames = val[2];
        if (N.isNullOrEmpty(excludedPropNames)) {
            return propNames;
        }
        ArrayList<String> tmp = new ArrayList<String>(propNames);
        tmp.removeAll(excludedPropNames);
        return tmp;
    }

    static Collection<String> getUpdatePropNamesByClass(Class<?> entityClass, Set<String> excludedPropNames) {
        Collection<String>[] val = SQLBuilder.loadPropNamesByClass(entityClass);
        Collection<String> propNames = val[4];
        if (N.isNullOrEmpty(excludedPropNames)) {
            return propNames;
        }
        ArrayList<String> tmp = new ArrayList<String>(propNames);
        tmp.removeAll(excludedPropNames);
        return tmp;
    }

    static Collection<String> getDeletePropNamesByClass(Class<?> entityClass, Set<String> excludedPropNames) {
        if (N.isNullOrEmpty(excludedPropNames)) {
            return N.emptyList();
        }
        Collection<String>[] val = SQLBuilder.loadPropNamesByClass(entityClass);
        Collection<String> propNames = val[0];
        if (N.isNullOrEmpty(excludedPropNames)) {
            return propNames;
        }
        ArrayList<String> tmp = new ArrayList<String>(propNames);
        tmp.removeAll(excludedPropNames);
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Collection<String>[] loadPropNamesByClass(Class<?> entityClass) {
        Set<String>[] val = defaultPropNamesPool.get(entityClass);
        if (val == null) {
            Class<?> clazz = entityClass;
            synchronized (clazz) {
                Set<String> entityPropNames = N.newLinkedHashSet(ClassUtil.getPropGetMethodList(entityClass).keySet());
                Set<String> subEntityPropNames = SQLBuilder.getSubEntityPropNames(entityClass);
                if (N.notNullOrEmpty(subEntityPropNames)) {
                    entityPropNames.removeAll(subEntityPropNames);
                }
                val = new Set[]{N.newLinkedHashSet(entityPropNames), N.newLinkedHashSet(entityPropNames), N.newLinkedHashSet(entityPropNames), N.newLinkedHashSet(entityPropNames), N.newLinkedHashSet(entityPropNames)};
                Method method = null;
                Class<?> subEntityClass = null;
                String subEntityClassName = null;
                Set<String> subEntityPropNameList = null;
                for (String subEntityPropName : subEntityPropNames) {
                    method = ClassUtil.getPropGetMethod(entityClass, subEntityPropName);
                    subEntityClass = ClassUtil.isEntity(method.getReturnType()) ? method.getReturnType() : ClassUtil.getTypeArgumentsByMethod(method)[0];
                    subEntityClassName = ClassUtil.getSimpleClassName(subEntityClass);
                    subEntityPropNameList = N.newLinkedHashSet(ClassUtil.getPropGetMethodList(subEntityClass).keySet());
                    subEntityPropNameList.removeAll(SQLBuilder.getSubEntityPropNames(subEntityClass));
                    for (String pn : subEntityPropNameList) {
                        val[0].add(StringUtil.concat(subEntityClassName, ".", pn));
                    }
                }
                Set readOnlyPropNames = N.newHashSet();
                Set nonUpdatablePropNames = N.newHashSet();
                Set transientPropNames = N.newHashSet();
                Set<Field> allFields = N.newHashSet();
                for (Class<?> superClass : ClassUtil.getAllSuperclasses(entityClass)) {
                    allFields.addAll(Array.asList(superClass.getDeclaredFields()));
                }
                allFields.addAll(Array.asList(entityClass.getDeclaredFields()));
                for (Field field : allFields) {
                    if (ClassUtil.getPropGetMethod(entityClass, field.getName()) == null && ClassUtil.getPropGetMethod(entityClass, ClassUtil.formalizePropName(field.getName())) == null) continue;
                    if (field.isAnnotationPresent(ReadOnly.class) || field.isAnnotationPresent(ReadOnlyId.class)) {
                        readOnlyPropNames.add(field.getName());
                    }
                    if (field.isAnnotationPresent(NonUpdatable.class)) {
                        nonUpdatablePropNames.add(field.getName());
                    }
                    if (!field.isAnnotationPresent(Transient.class) && !Modifier.isTransient(field.getModifiers())) continue;
                    readOnlyPropNames.add(field.getName());
                    transientPropNames.add(field.getName());
                    transientPropNames.add(ClassUtil.formalizePropName(field.getName()));
                }
                nonUpdatablePropNames.addAll(readOnlyPropNames);
                val[0].removeAll(transientPropNames);
                val[1].removeAll(transientPropNames);
                val[2].removeAll(readOnlyPropNames);
                val[3].removeAll(readOnlyPropNames);
                val[4].removeAll(nonUpdatablePropNames);
                for (String idPropName : ClassUtil.getIdFieldNames(entityClass)) {
                    val[3].remove(idPropName);
                    val[3].remove(ClassUtil.getPropNameByMethod(ClassUtil.getPropGetMethod(entityClass, idPropName)));
                }
                val[0] = ImmutableSet.of(val[0]);
                val[1] = ImmutableSet.of(val[1]);
                val[2] = ImmutableSet.of(val[2]);
                val[3] = ImmutableSet.of(val[3]);
                val[4] = ImmutableSet.of(val[4]);
                defaultPropNamesPool.put(entityClass, val);
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<String> getSubEntityPropNames(Class<?> entityClass) {
        Class<?> clazz = entityClass;
        synchronized (clazz) {
            Set<String> subEntityPropNames = subEntityPropNamesPool.get(entityClass);
            if (subEntityPropNames == null) {
                subEntityPropNames = N.newLinkedHashSet();
                Map<String, Method> propMethods = ClassUtil.getPropGetMethodList(entityClass);
                Set<String> nonSubEntityPropNames = nonSubEntityPropNamesPool.get(entityClass);
                Object[] typeParameterClasses = null;
                for (Map.Entry<String, Method> entry : propMethods.entrySet()) {
                    if (!ClassUtil.isEntity(entry.getValue().getReturnType()) && (!N.notNullOrEmpty(typeParameterClasses = ClassUtil.getTypeArgumentsByMethod(entry.getValue())) || !ClassUtil.isEntity(typeParameterClasses[0])) || nonSubEntityPropNames != null && nonSubEntityPropNames.contains(entry.getKey())) continue;
                    subEntityPropNames.add(entry.getKey());
                }
            }
            subEntityPropNamesPool.put(entityClass, subEntityPropNames);
            return subEntityPropNames;
        }
    }

    private static List<String> getSelectTableNames(Class<?> entityClass, NamingPolicy namingPolicy) {
        Set<String> subEntityPropNames = SQLBuilder.getSubEntityPropNames(entityClass);
        if (N.isNullOrEmpty(subEntityPropNames)) {
            return N.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>(subEntityPropNames.size() + 1);
        res.add(SQLBuilder.getTableName(entityClass, namingPolicy));
        Method method = null;
        Class<?> subEntityClass = null;
        for (String subEntityPropName : subEntityPropNames) {
            method = ClassUtil.getPropGetMethod(entityClass, subEntityPropName);
            subEntityClass = ClassUtil.isEntity(method.getReturnType()) ? method.getReturnType() : ClassUtil.getTypeArgumentsByMethod(method)[0];
            res.add(ClassUtil.getSimpleClassName(subEntityClass));
        }
        return res;
    }

    @Beta
    static Map<String, Expression> named(String ... propNames) {
        LinkedHashMap<String, Expression> m = new LinkedHashMap<String, Expression>(N.initHashCapacity(propNames.length));
        for (String propName : propNames) {
            m.put(propName, ConditionFactory.CF.QME);
        }
        return m;
    }

    @Beta
    static Map<String, Expression> named(Collection<String> propNames) {
        LinkedHashMap<String, Expression> m = new LinkedHashMap<String, Expression>(N.initHashCapacity(propNames.size()));
        for (String propName : propNames) {
            m.put(propName, ConditionFactory.CF.QME);
        }
        return m;
    }

    public static String repeatQM(int n) {
        N.checkArgNotNegative(n, "count");
        String result = QM_CACHE.get(n);
        if (result == null) {
            result = StringUtil.repeat("?", n, ", ");
        }
        return result;
    }

    public SQLBuilder into(String tableName) {
        block41: {
            block42: {
                block40: {
                    int len;
                    if (this.op != OperationType.ADD) {
                        throw new AbacusException("Invalid operation: " + (Object)((Object)this.op));
                    }
                    if (N.isNullOrEmpty(this.columnNames) && N.isNullOrEmpty(this.columnNameList) && N.isNullOrEmpty(this.props) && N.isNullOrEmpty(this.propsList)) {
                        throw new AbacusException("Column names or props must be set first by insert");
                    }
                    this.tableName = tableName;
                    this.sb.append(_INSERT);
                    this.sb.append(_SPACE_INTO_SPACE);
                    this.sb.append(tableName);
                    this.sb.append(' ');
                    this.sb.append('(');
                    Map<String, String> propColumnNameMap = this.getPropColumnNameMap();
                    if (N.notNullOrEmpty(this.columnNames)) {
                        if (this.columnNames.length == 1 && this.columnNames[0].indexOf(32) > 0) {
                            this.sb.append(this.columnNames[0]);
                        } else {
                            len = this.columnNames.length;
                            for (int i = 0; i < len; ++i) {
                                if (i > 0) {
                                    this.sb.append(_COMMA_SPACE);
                                }
                                this.sb.append(this.formalizeColumnName(propColumnNameMap, this.columnNames[i]));
                            }
                        }
                    } else if (N.notNullOrEmpty(this.columnNameList)) {
                        int i = 0;
                        for (String string : this.columnNameList) {
                            if (i++ > 0) {
                                this.sb.append(_COMMA_SPACE);
                            }
                            this.sb.append(this.formalizeColumnName(propColumnNameMap, string));
                        }
                    } else {
                        Map<String, Object> props = N.isNullOrEmpty(this.props) ? this.propsList.iterator().next() : this.props;
                        int i = 0;
                        for (String columnName : props.keySet()) {
                            if (i++ > 0) {
                                this.sb.append(_COMMA_SPACE);
                            }
                            this.sb.append(this.formalizeColumnName(propColumnNameMap, columnName));
                        }
                    }
                    this.sb.append(')');
                    this.sb.append(_SPACE_VALUES_SPACE);
                    this.sb.append('(');
                    if (!N.notNullOrEmpty(this.columnNames)) break block40;
                    switch (this.sqlPolicy) {
                        case SQL: 
                        case PARAMETERIZED_SQL: {
                            len = this.columnNames.length;
                            for (int i = 0; i < len; ++i) {
                                if (i > 0) {
                                    this.sb.append(_COMMA_SPACE);
                                }
                                this.sb.append('?');
                            }
                            break block41;
                        }
                        case NAMED_SQL: {
                            len = this.columnNames.length;
                            for (int i = 0; i < len; ++i) {
                                if (i > 0) {
                                    this.sb.append(_COMMA_SPACE);
                                }
                                this.sb.append(":");
                                this.sb.append(this.columnNames[i]);
                            }
                            break block41;
                        }
                        case IBATIS_SQL: {
                            len = this.columnNames.length;
                            for (int i = 0; i < len; ++i) {
                                if (i > 0) {
                                    this.sb.append(_COMMA_SPACE);
                                }
                                this.sb.append("#{");
                                this.sb.append(this.columnNames[i]);
                                this.sb.append('}');
                            }
                            break block41;
                        }
                        default: {
                            throw new AbacusException("Not supported SQL policy: " + (Object)((Object)this.sqlPolicy));
                        }
                    }
                }
                if (!N.notNullOrEmpty(this.columnNameList)) break block42;
                switch (this.sqlPolicy) {
                    case SQL: 
                    case PARAMETERIZED_SQL: {
                        int size = this.columnNameList.size();
                        for (int i = 0; i < size; ++i) {
                            if (i > 0) {
                                this.sb.append(_COMMA_SPACE);
                            }
                            this.sb.append('?');
                        }
                        break block41;
                    }
                    case NAMED_SQL: {
                        int i = 0;
                        for (String string : this.columnNameList) {
                            if (i++ > 0) {
                                this.sb.append(_COMMA_SPACE);
                            }
                            this.sb.append(":");
                            this.sb.append(string);
                        }
                        break block41;
                    }
                    case IBATIS_SQL: {
                        int i = 0;
                        for (String string : this.columnNameList) {
                            if (i++ > 0) {
                                this.sb.append(_COMMA_SPACE);
                            }
                            this.sb.append("#{");
                            this.sb.append(string);
                            this.sb.append('}');
                        }
                        break block41;
                    }
                    default: {
                        throw new AbacusException("Not supported SQL policy: " + (Object)((Object)this.sqlPolicy));
                    }
                }
            }
            if (N.notNullOrEmpty(this.props)) {
                this.appendInsertProps(this.props);
            } else {
                int i = 0;
                for (Map<String, Object> map : this.propsList) {
                    if (i++ > 0) {
                        this.sb.append(')');
                        this.sb.append(_COMMA_SPACE);
                        this.sb.append('(');
                    }
                    this.appendInsertProps(map);
                }
            }
        }
        this.sb.append(')');
        return this;
    }

    public SQLBuilder into(Class<?> entityClass) {
        if (this.entityClass != null) {
            this.entityClass = entityClass;
        }
        return this.into(SQLBuilder.getTableName(entityClass, this.namingPolicy));
    }

    public SQLBuilder from(String expr) {
        String tableName;
        String string = tableName = (expr = expr.trim()).indexOf(44) > 0 ? StringUtil.substring(expr, 0, ',').get() : expr;
        if (tableName.indexOf(32) > 0) {
            tableName = StringUtil.substring(tableName, 0, ' ').get();
        }
        return this.from(tableName.trim(), expr);
    }

    @SafeVarargs
    public final SQLBuilder from(String ... tableNames) {
        if (tableNames.length == 1) {
            return this.from(tableNames[0].trim());
        }
        String tableName = tableNames[0].trim();
        return this.from(tableName, StringUtil.join((Object[])tableNames, ", "));
    }

    public SQLBuilder from(Collection<String> tableNames) {
        if (tableNames.size() == 1) {
            return this.from(tableNames.iterator().next().trim());
        }
        String tableName = tableNames.iterator().next().trim();
        return this.from(tableName, StringUtil.join(tableNames, ", "));
    }

    public SQLBuilder from(Map<String, String> tableAliases) {
        String tableName = tableAliases.keySet().iterator().next().trim();
        return this.from(tableName, StringUtil.joinEntries(tableAliases, ", ", " "));
    }

    private SQLBuilder from(String tableName, String fromCause) {
        if (this.op != OperationType.QUERY) {
            throw new AbacusException("Invalid operation: " + (Object)((Object)this.op));
        }
        if (N.isNullOrEmpty(this.columnNames) && N.isNullOrEmpty(this.columnNameList) && N.isNullOrEmpty(this.columnAliases)) {
            throw new AbacusException("Column names or props must be set first by select");
        }
        this.tableName = tableName;
        this.sb.append(_SELECT);
        this.sb.append(' ');
        if (N.notNullOrEmpty(this.predicates)) {
            this.sb.append(this.predicates);
            this.sb.append(' ');
        }
        Map<String, String> propColumnNameMap = this.getPropColumnNameMap();
        if (N.notNullOrEmpty(this.columnNames)) {
            if (this.columnNames.length == 1) {
                String columnName = StringUtil.trim(this.columnNames[0]);
                int idx = columnName.indexOf(32);
                if (idx < 0) {
                    idx = columnName.indexOf(44);
                }
                if (idx > 0) {
                    this.sb.append(columnName);
                } else {
                    this.sb.append(this.formalizeColumnName(propColumnNameMap, columnName));
                    if (this.namingPolicy != NamingPolicy.LOWER_CAMEL_CASE && !ASTERISK.equals(columnName)) {
                        this.sb.append(_SPACE_AS_SPACE);
                        this.sb.append('\"');
                        this.sb.append(columnName);
                        this.sb.append('\"');
                    }
                }
            } else {
                String columnName = null;
                int len = this.columnNames.length;
                for (int i = 0; i < len; ++i) {
                    int idx;
                    columnName = StringUtil.trim(this.columnNames[i]);
                    if (i > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    if ((idx = columnName.indexOf(32)) > 0) {
                        int idx2 = columnName.indexOf(SPACE_AS_SPACE, idx);
                        if (idx2 < 0) {
                            idx2 = columnName.indexOf(" as ", idx);
                        }
                        this.sb.append(this.formalizeColumnName(propColumnNameMap, columnName.substring(0, idx).trim()));
                        this.sb.append(_SPACE_AS_SPACE);
                        this.sb.append('\"');
                        this.sb.append(columnName.substring(idx2 > 0 ? idx2 + 4 : idx + 1).trim());
                        this.sb.append('\"');
                        continue;
                    }
                    this.sb.append(this.formalizeColumnName(propColumnNameMap, columnName));
                    if (this.namingPolicy == NamingPolicy.LOWER_CAMEL_CASE || ASTERISK.equals(columnName)) continue;
                    this.sb.append(_SPACE_AS_SPACE);
                    this.sb.append('\"');
                    this.sb.append(columnName);
                    this.sb.append('\"');
                }
            }
        } else if (N.notNullOrEmpty(this.columnNameList)) {
            int i = 0;
            for (String columnName : this.columnNameList) {
                if (i++ > 0) {
                    this.sb.append(_COMMA_SPACE);
                }
                this.sb.append(this.formalizeColumnName(propColumnNameMap, columnName));
                if (this.namingPolicy == NamingPolicy.LOWER_CAMEL_CASE || ASTERISK.equals(columnName)) continue;
                this.sb.append(_SPACE_AS_SPACE);
                this.sb.append('\"');
                this.sb.append(columnName);
                this.sb.append('\"');
            }
        } else {
            int i = 0;
            for (Map.Entry<String, String> entry : this.columnAliases.entrySet()) {
                if (i++ > 0) {
                    this.sb.append(_COMMA_SPACE);
                }
                this.sb.append(this.formalizeColumnName(propColumnNameMap, entry.getKey()));
                if (!N.notNullOrEmpty(entry.getValue())) continue;
                this.sb.append(_SPACE_AS_SPACE);
                this.sb.append('\"');
                this.sb.append(entry.getValue());
                this.sb.append('\"');
            }
        }
        this.sb.append(_SPACE_FROM_SPACE);
        this.sb.append(fromCause);
        return this;
    }

    public SQLBuilder from(Class<?> entityClass) {
        if (this.entityClass != null) {
            this.entityClass = entityClass;
        }
        return this.from(SQLBuilder.getTableName(entityClass, this.namingPolicy));
    }

    public SQLBuilder join(String expr) {
        this.sb.append(_SPACE_JOIN_SPACE);
        this.sb.append(expr);
        return this;
    }

    public SQLBuilder join(Class<?> entityClass) {
        this.sb.append(_SPACE_JOIN_SPACE);
        this.sb.append(SQLBuilder.getTableName(entityClass, this.namingPolicy));
        return this;
    }

    public SQLBuilder innerJoin(String expr) {
        this.sb.append(_SPACE_INNER_JOIN_SPACE);
        this.sb.append(expr);
        return this;
    }

    public SQLBuilder innerJoin(Class<?> entityClass) {
        this.sb.append(_SPACE_INNER_JOIN_SPACE);
        this.sb.append(SQLBuilder.getTableName(entityClass, this.namingPolicy));
        return this;
    }

    public SQLBuilder leftJoin(String expr) {
        this.sb.append(_SPACE_LEFT_JOIN_SPACE);
        this.sb.append(expr);
        return this;
    }

    public SQLBuilder leftJoin(Class<?> entityClass) {
        this.sb.append(_SPACE_LEFT_JOIN_SPACE);
        this.sb.append(SQLBuilder.getTableName(entityClass, this.namingPolicy));
        return this;
    }

    public SQLBuilder rightJoin(String expr) {
        this.sb.append(_SPACE_RIGHT_JOIN_SPACE);
        this.sb.append(expr);
        return this;
    }

    public SQLBuilder rightJoin(Class<?> entityClass) {
        this.sb.append(_SPACE_RIGHT_JOIN_SPACE);
        this.sb.append(SQLBuilder.getTableName(entityClass, this.namingPolicy));
        return this;
    }

    public SQLBuilder fullJoin(String expr) {
        this.sb.append(_SPACE_FULL_JOIN_SPACE);
        this.sb.append(expr);
        return this;
    }

    public SQLBuilder fullJoin(Class<?> entityClass) {
        this.sb.append(_SPACE_FULL_JOIN_SPACE);
        this.sb.append(SQLBuilder.getTableName(entityClass, this.namingPolicy));
        return this;
    }

    public SQLBuilder crossJoin(String expr) {
        this.sb.append(_SPACE_CROSS_JOIN_SPACE);
        this.sb.append(expr);
        return this;
    }

    public SQLBuilder crossJoin(Class<?> entityClass) {
        this.sb.append(_SPACE_CROSS_JOIN_SPACE);
        this.sb.append(SQLBuilder.getTableName(entityClass, this.namingPolicy));
        return this;
    }

    public SQLBuilder naturalJoin(String expr) {
        this.sb.append(_SPACE_NATURAL_JOIN_SPACE);
        this.sb.append(expr);
        return this;
    }

    public SQLBuilder naturalJoin(Class<?> entityClass) {
        this.sb.append(_SPACE_NATURAL_JOIN_SPACE);
        this.sb.append(SQLBuilder.getTableName(entityClass, this.namingPolicy));
        return this;
    }

    public SQLBuilder on(String expr) {
        this.sb.append(_SPACE_ON_SPACE);
        this.appendStringExpr(expr);
        return this;
    }

    public SQLBuilder on(Condition cond) {
        this.sb.append(_SPACE_ON_SPACE);
        this.appendCondition(cond);
        return this;
    }

    public SQLBuilder using(String expr) {
        this.sb.append(_SPACE_USING_SPACE);
        this.sb.append(this.formalizeColumnName(expr));
        return this;
    }

    public SQLBuilder where(String expr) {
        this.init(true);
        this.sb.append(_SPACE_WHERE_SPACE);
        this.appendStringExpr(expr);
        return this;
    }

    private void appendStringExpr(String expr) {
        Map<String, String> propColumnNameMap = this.getPropColumnNameMap();
        List<String> words = SQLParser.parse(expr);
        String word = null;
        int len = words.size();
        for (int i = 0; i < len; ++i) {
            word = words.get(i);
            if (!StringUtil.isAsciiAlpha(word.charAt(0))) {
                this.sb.append(word);
                continue;
            }
            if (SQLParser.isFunctionName(words, len, i)) {
                this.sb.append(word);
                continue;
            }
            this.sb.append(this.formalizeColumnName(propColumnNameMap, word));
        }
    }

    public SQLBuilder where(Condition cond) {
        this.init(true);
        this.sb.append(_SPACE_WHERE_SPACE);
        this.appendCondition(cond);
        return this;
    }

    public SQLBuilder groupBy(String expr) {
        this.sb.append(_SPACE_GROUP_BY_SPACE);
        if (expr.indexOf(32) > 0) {
            this.appendStringExpr(expr);
        } else {
            this.sb.append(this.formalizeColumnName(expr));
        }
        return this;
    }

    @SafeVarargs
    public final SQLBuilder groupBy(String ... columnNames) {
        this.sb.append(_SPACE_GROUP_BY_SPACE);
        if (columnNames.length == 1) {
            if (columnNames[0].indexOf(32) > 0) {
                this.appendStringExpr(columnNames[0]);
            } else {
                this.sb.append(this.formalizeColumnName(columnNames[0]));
            }
        } else {
            Map<String, String> propColumnNameMap = this.getPropColumnNameMap();
            int len = columnNames.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    this.sb.append(_COMMA_SPACE);
                }
                this.sb.append(this.formalizeColumnName(propColumnNameMap, columnNames[i]));
            }
        }
        return this;
    }

    public SQLBuilder groupBy(String columnName, SortDirection direction) {
        this.groupBy(columnName);
        this.sb.append(' ');
        this.sb.append(direction.toString());
        return this;
    }

    public SQLBuilder groupBy(Collection<String> columnNames) {
        this.sb.append(_SPACE_GROUP_BY_SPACE);
        Map<String, String> propColumnNameMap = this.getPropColumnNameMap();
        int i = 0;
        for (String columnName : columnNames) {
            if (i++ > 0) {
                this.sb.append(_COMMA_SPACE);
            }
            this.sb.append(this.formalizeColumnName(propColumnNameMap, columnName));
        }
        return this;
    }

    public SQLBuilder groupBy(Collection<String> columnNames, SortDirection direction) {
        this.groupBy(columnNames);
        this.sb.append(' ');
        this.sb.append(direction.toString());
        return this;
    }

    public SQLBuilder groupBy(Map<String, SortDirection> orders) {
        this.sb.append(_SPACE_GROUP_BY_SPACE);
        Map<String, String> propColumnNameMap = this.getPropColumnNameMap();
        int i = 0;
        for (Map.Entry<String, SortDirection> entry : orders.entrySet()) {
            if (i++ > 0) {
                this.sb.append(_COMMA_SPACE);
            }
            this.sb.append(this.formalizeColumnName(propColumnNameMap, entry.getKey()));
            this.sb.append(' ');
            this.sb.append(entry.getValue().toString());
        }
        return this;
    }

    public SQLBuilder having(String expr) {
        this.sb.append(_SPACE_HAVING_SPACE);
        this.appendStringExpr(expr);
        return this;
    }

    public SQLBuilder having(Condition cond) {
        this.sb.append(_SPACE_HAVING_SPACE);
        this.appendCondition(cond);
        return this;
    }

    public SQLBuilder orderBy(String expr) {
        this.sb.append(_SPACE_ORDER_BY_SPACE);
        if (expr.indexOf(32) > 0) {
            this.appendStringExpr(expr);
        } else {
            this.sb.append(this.formalizeColumnName(expr));
        }
        return this;
    }

    @SafeVarargs
    public final SQLBuilder orderBy(String ... columnNames) {
        this.sb.append(_SPACE_ORDER_BY_SPACE);
        if (columnNames.length == 1) {
            if (columnNames[0].indexOf(32) > 0) {
                this.appendStringExpr(columnNames[0]);
            } else {
                this.sb.append(this.formalizeColumnName(columnNames[0]));
            }
        } else {
            Map<String, String> propColumnNameMap = this.getPropColumnNameMap();
            int len = columnNames.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    this.sb.append(_COMMA_SPACE);
                }
                this.sb.append(this.formalizeColumnName(propColumnNameMap, columnNames[i]));
            }
        }
        return this;
    }

    public SQLBuilder orderBy(String columnName, SortDirection direction) {
        this.orderBy(columnName);
        this.sb.append(' ');
        this.sb.append(direction.toString());
        return this;
    }

    public SQLBuilder orderBy(Collection<String> columnNames) {
        this.sb.append(_SPACE_ORDER_BY_SPACE);
        Map<String, String> propColumnNameMap = this.getPropColumnNameMap();
        int i = 0;
        for (String columnName : columnNames) {
            if (i++ > 0) {
                this.sb.append(_COMMA_SPACE);
            }
            this.sb.append(this.formalizeColumnName(propColumnNameMap, columnName));
        }
        return this;
    }

    public SQLBuilder orderBy(Collection<String> columnNames, SortDirection direction) {
        this.orderBy(columnNames);
        this.sb.append(' ');
        this.sb.append(direction.toString());
        return this;
    }

    public SQLBuilder orderBy(Map<String, SortDirection> orders) {
        this.sb.append(_SPACE_ORDER_BY_SPACE);
        Map<String, String> propColumnNameMap = this.getPropColumnNameMap();
        int i = 0;
        for (Map.Entry<String, SortDirection> entry : orders.entrySet()) {
            if (i++ > 0) {
                this.sb.append(_COMMA_SPACE);
            }
            this.sb.append(this.formalizeColumnName(propColumnNameMap, entry.getKey()));
            this.sb.append(' ');
            this.sb.append(entry.getValue().toString());
        }
        return this;
    }

    public SQLBuilder limit(int count) {
        this.sb.append(_SPACE_LIMIT_SPACE);
        this.sb.append(count);
        return this;
    }

    public SQLBuilder limit(int offset, int count) {
        this.sb.append(_SPACE_LIMIT_SPACE);
        this.sb.append(offset);
        this.sb.append(_COMMA_SPACE);
        this.sb.append(count);
        return this;
    }

    public SQLBuilder offset(int offset) {
        this.sb.append(_SPACE_OFFSET_SPACE);
        this.sb.append(offset);
        return this;
    }

    public SQLBuilder limitByRowNum(int count) {
        this.sb.append(" ROWNUM ");
        this.sb.append(count);
        return this;
    }

    public SQLBuilder union(SQLBuilder sqlBuilder) {
        String sql = sqlBuilder.sql();
        if (N.notNullOrEmpty(sqlBuilder.parameters())) {
            this.parameters.addAll(sqlBuilder.parameters());
        }
        return this.union(sql);
    }

    public SQLBuilder union(String query) {
        return this.union(N.asArray(query));
    }

    @SafeVarargs
    public final SQLBuilder union(String ... columnNames) {
        this.op = OperationType.QUERY;
        this.columnNames = columnNames;
        this.columnNameList = null;
        this.columnAliases = null;
        this.sb.append(_SPACE_UNION_SPACE);
        if (this.isSubQuery(columnNames)) {
            this.sb.append(columnNames[0]);
            this.columnNames = null;
        }
        return this;
    }

    public SQLBuilder union(Collection<String> columnNames) {
        this.op = OperationType.QUERY;
        this.columnNames = null;
        this.columnNameList = columnNames;
        this.columnAliases = null;
        this.sb.append(_SPACE_UNION_SPACE);
        return this;
    }

    public SQLBuilder unionAll(SQLBuilder sqlBuilder) {
        String sql = sqlBuilder.sql();
        if (N.notNullOrEmpty(sqlBuilder.parameters())) {
            this.parameters.addAll(sqlBuilder.parameters());
        }
        return this.unionAll(sql);
    }

    public SQLBuilder unionAll(String query) {
        return this.unionAll(N.asArray(query));
    }

    @SafeVarargs
    public final SQLBuilder unionAll(String ... columnNames) {
        this.op = OperationType.QUERY;
        this.columnNames = columnNames;
        this.columnNameList = null;
        this.columnAliases = null;
        this.sb.append(_SPACE_UNION_ALL_SPACE);
        if (this.isSubQuery(columnNames)) {
            this.sb.append(columnNames[0]);
            this.columnNames = null;
        }
        return this;
    }

    public SQLBuilder unionAll(Collection<String> columnNames) {
        this.op = OperationType.QUERY;
        this.columnNames = null;
        this.columnNameList = columnNames;
        this.columnAliases = null;
        this.sb.append(_SPACE_UNION_ALL_SPACE);
        return this;
    }

    public SQLBuilder intersect(SQLBuilder sqlBuilder) {
        String sql = sqlBuilder.sql();
        if (N.notNullOrEmpty(sqlBuilder.parameters())) {
            this.parameters.addAll(sqlBuilder.parameters());
        }
        return this.intersect(sql);
    }

    public SQLBuilder intersect(String query) {
        return this.intersect(N.asArray(query));
    }

    @SafeVarargs
    public final SQLBuilder intersect(String ... columnNames) {
        this.op = OperationType.QUERY;
        this.columnNames = columnNames;
        this.columnNameList = null;
        this.columnAliases = null;
        this.sb.append(_SPACE_INTERSECT_SPACE);
        if (this.isSubQuery(columnNames)) {
            this.sb.append(columnNames[0]);
            this.columnNames = null;
        }
        return this;
    }

    public SQLBuilder intersect(Collection<String> columnNames) {
        this.op = OperationType.QUERY;
        this.columnNames = null;
        this.columnNameList = columnNames;
        this.columnAliases = null;
        this.sb.append(_SPACE_INTERSECT_SPACE);
        return this;
    }

    public SQLBuilder except(SQLBuilder sqlBuilder) {
        String sql = sqlBuilder.sql();
        if (N.notNullOrEmpty(sqlBuilder.parameters())) {
            this.parameters.addAll(sqlBuilder.parameters());
        }
        return this.except(sql);
    }

    public SQLBuilder except(String query) {
        return this.except(N.asArray(query));
    }

    @SafeVarargs
    public final SQLBuilder except(String ... columnNames) {
        this.op = OperationType.QUERY;
        this.columnNames = columnNames;
        this.columnNameList = null;
        this.columnAliases = null;
        this.sb.append(_SPACE_EXCEPT_SPACE);
        if (this.isSubQuery(columnNames)) {
            this.sb.append(columnNames[0]);
            this.columnNames = null;
        }
        return this;
    }

    public SQLBuilder except(Collection<String> columnNames) {
        this.op = OperationType.QUERY;
        this.columnNames = null;
        this.columnNameList = columnNames;
        this.columnAliases = null;
        this.sb.append(_SPACE_EXCEPT_SPACE);
        return this;
    }

    public SQLBuilder minus(SQLBuilder sqlBuilder) {
        String sql = sqlBuilder.sql();
        if (N.notNullOrEmpty(sqlBuilder.parameters())) {
            this.parameters.addAll(sqlBuilder.parameters());
        }
        return this.minus(sql);
    }

    public SQLBuilder minus(String query) {
        return this.minus(N.asArray(query));
    }

    @SafeVarargs
    public final SQLBuilder minus(String ... columnNames) {
        this.op = OperationType.QUERY;
        this.columnNames = columnNames;
        this.columnNameList = null;
        this.columnAliases = null;
        this.sb.append(_SPACE_EXCEPT2_SPACE);
        if (this.isSubQuery(columnNames)) {
            this.sb.append(columnNames[0]);
            this.columnNames = null;
        }
        return this;
    }

    public SQLBuilder minus(Collection<String> columnNames) {
        this.op = OperationType.QUERY;
        this.columnNames = null;
        this.columnNameList = columnNames;
        this.columnAliases = null;
        this.sb.append(_SPACE_EXCEPT2_SPACE);
        return this;
    }

    public SQLBuilder forUpdate() {
        this.sb.append(_SPACE_FOR_UPDATE);
        return this;
    }

    public SQLBuilder set(String expr) {
        return this.set(N.asArray(expr));
    }

    @SafeVarargs
    public final SQLBuilder set(String ... columnNames) {
        this.init(false);
        if (columnNames.length == 1 && columnNames[0].contains("=")) {
            this.appendStringExpr(columnNames[0]);
        } else {
            Map<String, String> propColumnNameMap = this.getPropColumnNameMap();
            switch (this.sqlPolicy) {
                case SQL: 
                case PARAMETERIZED_SQL: {
                    int len = columnNames.length;
                    for (int i = 0; i < len; ++i) {
                        if (i > 0) {
                            this.sb.append(_COMMA_SPACE);
                        }
                        this.sb.append(this.formalizeColumnName(propColumnNameMap, columnNames[i]));
                        this.sb.append(_SPACE_EQUAL_SPACE);
                        this.sb.append('?');
                    }
                    break;
                }
                case NAMED_SQL: {
                    int len = columnNames.length;
                    for (int i = 0; i < len; ++i) {
                        if (i > 0) {
                            this.sb.append(_COMMA_SPACE);
                        }
                        this.sb.append(this.formalizeColumnName(propColumnNameMap, columnNames[i]));
                        this.sb.append(_SPACE_EQUAL_SPACE);
                        this.sb.append(":");
                        this.sb.append(columnNames[i]);
                    }
                    break;
                }
                case IBATIS_SQL: {
                    int len = columnNames.length;
                    for (int i = 0; i < len; ++i) {
                        if (i > 0) {
                            this.sb.append(_COMMA_SPACE);
                        }
                        this.sb.append(this.formalizeColumnName(propColumnNameMap, columnNames[i]));
                        this.sb.append(_SPACE_EQUAL_SPACE);
                        this.sb.append("#{");
                        this.sb.append(columnNames[i]);
                        this.sb.append('}');
                    }
                    break;
                }
                default: {
                    throw new AbacusException("Not supported SQL policy: " + (Object)((Object)this.sqlPolicy));
                }
            }
        }
        this.columnNameList = null;
        return this;
    }

    public SQLBuilder set(Collection<String> columnNames) {
        this.init(false);
        Map<String, String> propColumnNameMap = this.getPropColumnNameMap();
        switch (this.sqlPolicy) {
            case SQL: 
            case PARAMETERIZED_SQL: {
                int i = 0;
                for (String columnName : columnNames) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    this.sb.append(this.formalizeColumnName(propColumnNameMap, columnName));
                    this.sb.append(_SPACE_EQUAL_SPACE);
                    this.sb.append('?');
                }
                break;
            }
            case NAMED_SQL: {
                int i = 0;
                for (String columnName : columnNames) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    this.sb.append(this.formalizeColumnName(propColumnNameMap, columnName));
                    this.sb.append(_SPACE_EQUAL_SPACE);
                    this.sb.append(":");
                    this.sb.append(columnName);
                }
                break;
            }
            case IBATIS_SQL: {
                int i = 0;
                for (String columnName : columnNames) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    this.sb.append(this.formalizeColumnName(propColumnNameMap, columnName));
                    this.sb.append(_SPACE_EQUAL_SPACE);
                    this.sb.append("#{");
                    this.sb.append(columnName);
                    this.sb.append('}');
                }
                break;
            }
            default: {
                throw new AbacusException("Not supported SQL policy: " + (Object)((Object)this.sqlPolicy));
            }
        }
        this.columnNameList = null;
        return this;
    }

    public SQLBuilder set(Map<String, Object> props) {
        this.init(false);
        Map<String, String> propColumnNameMap = this.getPropColumnNameMap();
        switch (this.sqlPolicy) {
            case SQL: {
                int i = 0;
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    this.sb.append(this.formalizeColumnName(propColumnNameMap, entry.getKey()));
                    this.sb.append(_SPACE_EQUAL_SPACE);
                    this.setParameterForSQL(entry.getValue());
                }
                break;
            }
            case PARAMETERIZED_SQL: {
                int i = 0;
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    this.sb.append(this.formalizeColumnName(propColumnNameMap, entry.getKey()));
                    this.sb.append(_SPACE_EQUAL_SPACE);
                    this.setParameterForRawSQL(entry.getValue());
                }
                break;
            }
            case NAMED_SQL: {
                int i = 0;
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    this.sb.append(this.formalizeColumnName(propColumnNameMap, entry.getKey()));
                    this.sb.append(_SPACE_EQUAL_SPACE);
                    this.setParameterForNamedSQL(entry.getKey(), entry.getValue());
                }
                break;
            }
            case IBATIS_SQL: {
                int i = 0;
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    this.sb.append(this.formalizeColumnName(propColumnNameMap, entry.getKey()));
                    this.sb.append(_SPACE_EQUAL_SPACE);
                    this.setParameterForIbatisNamedSQL(entry.getKey(), entry.getValue());
                }
                break;
            }
            default: {
                throw new AbacusException("Not supported SQL policy: " + (Object)((Object)this.sqlPolicy));
            }
        }
        this.columnNameList = null;
        return this;
    }

    public SQLBuilder set(Object entity) {
        return this.set(entity, null);
    }

    public SQLBuilder set(Object entity, Set<String> excludedPropNames) {
        if (entity instanceof String) {
            return this.set(N.asArray((String)entity));
        }
        if (entity instanceof Map) {
            if (N.isNullOrEmpty(excludedPropNames)) {
                return this.set((Map)entity);
            }
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>((Map)entity);
            Maps.removeKeys(props, excludedPropNames);
            return this.set(props);
        }
        Class<?> entityClass = entity.getClass();
        this.entityClass = entityClass;
        Collection<String> propNames = SQLBuilder.getUpdatePropNamesByClass(entityClass, excludedPropNames);
        Set<String> dirtyPropNames = DirtyMarkerUtil.isDirtyMarker(entityClass) ? DirtyMarkerUtil.dirtyPropNames((DirtyMarker)entity) : null;
        Map<String, Object> props = N.newHashMap(N.initHashCapacity(N.isNullOrEmpty(dirtyPropNames) ? propNames.size() : dirtyPropNames.size()));
        for (String propName : propNames) {
            if (dirtyPropNames != null && !dirtyPropNames.contains(propName)) continue;
            props.put(propName, ClassUtil.getPropValue(entity, propName));
        }
        return this.set(props);
    }

    public SQLBuilder set(Class<?> entityClass) {
        this.entityClass = entityClass;
        return this.set(entityClass, null);
    }

    public SQLBuilder set(Class<?> entityClass, Set<String> excludedPropNames) {
        this.entityClass = entityClass;
        return this.set(SQLBuilder.getUpdatePropNamesByClass(entityClass, excludedPropNames));
    }

    public String sql() {
        if (this.sb == null) {
            throw new AbacusException("This SQLBuilder has been closed after sql() was called previously");
        }
        this.init(true);
        String sql = null;
        try {
            sql = this.sb.toString();
        }
        finally {
            Objectory.recycle(this.sb);
            this.sb = null;
            activeStringBuilderCounter.decrementAndGet();
        }
        if (logger.isDebugEnabled()) {
            logger.debug(sql);
        }
        return sql;
    }

    public List<Object> parameters() {
        return this.parameters;
    }

    public SP pair() {
        return new SP(this.sql(), this.parameters);
    }

    public <T, EX extends Exception> T apply(Try.Function<? super SP, T, EX> func) throws EX {
        return func.apply(this.pair());
    }

    public <EX extends Exception> void accept(Try.Consumer<? super SP, EX> consumer) throws EX {
        consumer.accept(this.pair());
    }

    void init(boolean setForUpdate) {
        if (this.sb.length() > 0) {
            return;
        }
        if (this.op == OperationType.UPDATE) {
            this.sb.append(_UPDATE);
            this.sb.append(' ');
            this.sb.append(this.tableName);
            this.sb.append(_SPACE_SET_SPACE);
            if (setForUpdate && N.notNullOrEmpty(this.columnNameList)) {
                this.set(this.columnNameList);
            }
        } else if (this.op == OperationType.DELETE) {
            String newTableName = this.tableName;
            char[] deleteFromTableChars = tableDeleteFrom.get(newTableName);
            if (deleteFromTableChars == null) {
                deleteFromTableChars = ("DELETE FROM " + newTableName).toCharArray();
                tableDeleteFrom.put(newTableName, deleteFromTableChars);
            }
            this.sb.append(deleteFromTableChars);
        }
    }

    private void setParameterForSQL(Object propValue) {
        if (ConditionFactory.CF.QME.equals(propValue)) {
            this.sb.append('?');
        } else if (propValue instanceof Condition) {
            this.appendCondition((Condition)propValue);
        } else {
            this.sb.append(Expression.formalize(propValue));
        }
    }

    private void setParameterForRawSQL(Object propValue) {
        if (ConditionFactory.CF.QME.equals(propValue)) {
            this.sb.append('?');
        } else if (propValue instanceof Condition) {
            this.appendCondition((Condition)propValue);
        } else {
            this.sb.append('?');
            this.parameters.add(propValue);
        }
    }

    private void setParameterForIbatisNamedSQL(String propName, Object propValue) {
        if (ConditionFactory.CF.QME.equals(propValue)) {
            this.sb.append("#{");
            this.sb.append(propName);
            this.sb.append('}');
        } else if (propValue instanceof Condition) {
            this.appendCondition((Condition)propValue);
        } else {
            this.sb.append("#{");
            this.sb.append(propName);
            this.sb.append('}');
            this.parameters.add(propValue);
        }
    }

    private void setParameterForNamedSQL(String propName, Object propValue) {
        if (ConditionFactory.CF.QME.equals(propValue)) {
            this.sb.append(":");
            this.sb.append(propName);
        } else if (propValue instanceof Condition) {
            this.appendCondition((Condition)propValue);
        } else {
            this.sb.append(":");
            this.sb.append(propName);
            this.parameters.add(propValue);
        }
    }

    private void setParameter(String propName, Object propValue) {
        switch (this.sqlPolicy) {
            case SQL: {
                this.setParameterForSQL(propValue);
                break;
            }
            case PARAMETERIZED_SQL: {
                this.setParameterForRawSQL(propValue);
                break;
            }
            case NAMED_SQL: {
                this.setParameterForNamedSQL(propName, propValue);
                break;
            }
            case IBATIS_SQL: {
                this.setParameterForIbatisNamedSQL(propName, propValue);
                break;
            }
            default: {
                throw new AbacusException("Not supported SQL policy: " + (Object)((Object)this.sqlPolicy));
            }
        }
    }

    private void appendInsertProps(Map<String, Object> props) {
        switch (this.sqlPolicy) {
            case SQL: {
                int i = 0;
                Object propValue = null;
                for (String propName : props.keySet()) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    propValue = props.get(propName);
                    this.setParameterForSQL(propValue);
                }
                break;
            }
            case PARAMETERIZED_SQL: {
                int i = 0;
                Object propValue = null;
                for (String propName : props.keySet()) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    propValue = props.get(propName);
                    this.setParameterForRawSQL(propValue);
                }
                break;
            }
            case NAMED_SQL: {
                int i = 0;
                Object propValue = null;
                for (String propName : props.keySet()) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    propValue = props.get(propName);
                    this.setParameterForNamedSQL(propName, propValue);
                }
                break;
            }
            case IBATIS_SQL: {
                int i = 0;
                Object propValue = null;
                for (String propName : props.keySet()) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    propValue = props.get(propName);
                    this.setParameterForIbatisNamedSQL(propName, propValue);
                }
                break;
            }
            default: {
                throw new AbacusException("Not supported SQL policy: " + (Object)((Object)this.sqlPolicy));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendCondition(Condition cond) {
        if (cond instanceof Binary) {
            Binary binary = (Binary)cond;
            String propName = binary.getPropName();
            this.sb.append(this.formalizeColumnName(propName));
            this.sb.append(' ');
            this.sb.append(binary.getOperator().toString());
            this.sb.append(' ');
            Object propValue = binary.getPropValue();
            this.setParameter(propName, propValue);
            return;
        } else if (cond instanceof Between) {
            Between bt = (Between)cond;
            String propName = bt.getPropName();
            this.sb.append(this.formalizeColumnName(propName));
            this.sb.append(' ');
            this.sb.append(bt.getOperator().toString());
            this.sb.append(' ');
            Object minValue = bt.getMinValue();
            if (this.sqlPolicy == SQLPolicy.NAMED_SQL || this.sqlPolicy == SQLPolicy.IBATIS_SQL) {
                this.setParameter("min" + StringUtil.capitalize(propName), minValue);
            } else {
                this.setParameter(propName, minValue);
            }
            this.sb.append(' ');
            this.sb.append("AND");
            this.sb.append(' ');
            Object maxValue = bt.getMaxValue();
            if (this.sqlPolicy == SQLPolicy.NAMED_SQL || this.sqlPolicy == SQLPolicy.IBATIS_SQL) {
                this.setParameter("max" + StringUtil.capitalize(propName), maxValue);
                return;
            } else {
                this.setParameter(propName, maxValue);
            }
            return;
        } else if (cond instanceof In) {
            In in = (In)cond;
            String propName = in.getPropName();
            List<Object> parameters = in.getParameters();
            this.sb.append(this.formalizeColumnName(propName));
            this.sb.append(' ');
            this.sb.append(in.getOperator().toString());
            this.sb.append(" (");
            int len = parameters.size();
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    this.sb.append(", ");
                }
                if (this.sqlPolicy == SQLPolicy.NAMED_SQL || this.sqlPolicy == SQLPolicy.IBATIS_SQL) {
                    this.setParameter(propName + (i + 1), parameters.get(i));
                    continue;
                }
                this.setParameter(propName, parameters.get(i));
            }
            this.sb.append(')');
            return;
        } else if (cond instanceof Cell) {
            Cell cell = (Cell)cond;
            this.sb.append(' ');
            this.sb.append(cell.getOperator().toString());
            this.sb.append(' ');
            this.sb.append('(');
            this.appendCondition((Condition)cell.getCondition());
            this.sb.append(')');
            return;
        } else if (cond instanceof Junction) {
            Junction junction = (Junction)cond;
            List<Condition> conditionList = junction.getConditions();
            if (N.isNullOrEmpty(conditionList)) {
                throw new IllegalArgumentException("The junction condition(" + junction.getOperator().toString() + ") doesn't include any element.");
            }
            if (conditionList.size() == 1) {
                this.appendCondition(conditionList.get(0));
                return;
            } else {
                int size = conditionList.size();
                for (int i = 0; i < size; ++i) {
                    if (i > 0) {
                        this.sb.append(' ');
                        this.sb.append(junction.getOperator().toString());
                        this.sb.append(' ');
                    }
                    this.sb.append('(');
                    this.appendCondition(conditionList.get(i));
                    this.sb.append(')');
                }
            }
            return;
        } else if (cond instanceof SubQuery) {
            SubQuery subQuery = (SubQuery)cond;
            if (N.notNullOrEmpty(subQuery.getSql())) {
                this.sb.append(subQuery.getSql());
                return;
            } else if (this instanceof SCSB) {
                this.sb.append(SCSB.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).where(subQuery.getCondition()).sql());
                return;
            } else if (this instanceof PSC) {
                this.sb.append(PSC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).where(subQuery.getCondition()).sql());
                return;
            } else if (this instanceof MSC) {
                this.sb.append(MSC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).where(subQuery.getCondition()).sql());
                return;
            } else if (this instanceof NSC) {
                this.sb.append(NSC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).where(subQuery.getCondition()).sql());
                return;
            } else if (this instanceof ACSB) {
                this.sb.append(ACSB.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).where(subQuery.getCondition()).sql());
                return;
            } else if (this instanceof PAC) {
                this.sb.append(PAC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).where(subQuery.getCondition()).sql());
                return;
            } else if (this instanceof MAC) {
                this.sb.append(MAC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).where(subQuery.getCondition()).sql());
                return;
            } else if (this instanceof NAC) {
                this.sb.append(NAC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).where(subQuery.getCondition()).sql());
                return;
            } else if (this instanceof LCSB) {
                this.sb.append(LCSB.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).where(subQuery.getCondition()).sql());
                return;
            } else if (this instanceof PLC) {
                this.sb.append(PLC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).where(subQuery.getCondition()).sql());
                return;
            } else if (this instanceof MLC) {
                this.sb.append(MLC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).where(subQuery.getCondition()).sql());
                return;
            } else {
                if (!(this instanceof NLC)) throw new AbacusException("Unsupproted subQuery condition: " + cond);
                this.sb.append(NLC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).where(subQuery.getCondition()).sql());
            }
            return;
        } else {
            if (!(cond instanceof Expression)) throw new IllegalArgumentException("Unsupported condtion: " + cond.toString());
            this.sb.append(cond.toString());
        }
    }

    private String formalizeColumnName(String propName) {
        return this.formalizeColumnName(this.getPropColumnNameMap(), propName);
    }

    private String formalizeColumnName(Map<String, String> propColumnNameMap, String propName) {
        String columnName;
        String string = columnName = propColumnNameMap == null ? null : propColumnNameMap.get(propName);
        if (columnName != null) {
            return columnName;
        }
        switch (this.namingPolicy) {
            case LOWER_CASE_WITH_UNDERSCORE: {
                return ClassUtil.toLowerCaseWithUnderscore(propName);
            }
            case UPPER_CASE_WITH_UNDERSCORE: {
                return ClassUtil.toUpperCaseWithUnderscore(propName);
            }
            case LOWER_CAMEL_CASE: {
                return ClassUtil.formalizePropName(propName);
            }
        }
        return propName;
    }

    private Map<String, String> getPropColumnNameMap() {
        if (this.entityClass == null || Map.class.isAssignableFrom(this.entityClass)) {
            return N.emptyMap();
        }
        Map<String, String> result = entityTablePropColumnNameMap.get(this.entityClass);
        if (result == null) {
            SQLBuilder.registerEntityPropColumnNameMap(this.entityClass);
        }
        return entityTablePropColumnNameMap.get(this.entityClass);
    }

    private boolean isSubQuery(String ... columnNames) {
        int index;
        if (columnNames.length == 1 && (index = SQLParser.indexWord(columnNames[0], "SELECT", 0, false)) >= 0) {
            return (index = SQLParser.indexWord(columnNames[0], "FROM", index, false)) >= 1;
        }
        return false;
    }

    public String toString() {
        return this.sql();
    }

    private static void parseInsertEntity(SQLBuilder instance, Object entity, Set<String> excludedPropNames) {
        if (entity instanceof String) {
            instance.columnNames = N.asArray((String)entity);
        } else if (entity instanceof Map) {
            if (N.isNullOrEmpty(excludedPropNames)) {
                instance.props = (Map)entity;
            } else {
                instance.props = new LinkedHashMap<String, Object>((Map)entity);
                Maps.removeKeys(instance.props, excludedPropNames);
            }
        } else {
            Collection<String> propNames = SQLBuilder.getInsertPropNamesByClass(entity, excludedPropNames);
            Map map = N.newHashMap(N.initHashCapacity(propNames.size()));
            for (String propName : propNames) {
                map.put(propName, ClassUtil.getPropValue(entity, propName));
            }
            instance.props = map;
        }
    }

    private static Collection<Map<String, Object>> toInsertPropsList(Collection<?> propsList) {
        u.Optional<?> first = N.firstNonNull(propsList);
        if (first.isPresent() && first.get() instanceof Map) {
            return (List)propsList;
        }
        Class<?> entityClass = first.get().getClass();
        Collection<String> propNames = SQLBuilder.getInsertPropNamesByClass(entityClass, null);
        ArrayList<Map<String, Object>> newPropsList = new ArrayList<Map<String, Object>>(propsList.size());
        for (Object entity : propsList) {
            Map props = N.newHashMap(N.initHashCapacity(propNames.size()));
            for (String propName : propNames) {
                props.put(propName, ClassUtil.getPropValue(entity, propName));
            }
            newPropsList.add(props);
        }
        return newPropsList;
    }

    static /* synthetic */ String[] access$102(SQLBuilder x0, String[] x1) {
        x0.columnNames = x1;
        return x1;
    }

    static {
        for (int i = 0; i <= 30; ++i) {
            QM_CACHE.put(i, StringUtil.repeat("?", i, ", "));
        }
        QM_CACHE.put(100, StringUtil.repeat("?", 100, ", "));
        QM_CACHE.put(200, StringUtil.repeat("?", 200, ", "));
        QM_CACHE.put(300, StringUtil.repeat("?", 300, ", "));
        QM_CACHE.put(500, StringUtil.repeat("?", 500, ", "));
        QM_CACHE.put(1000, StringUtil.repeat("?", 1000, ", "));
    }

    public static final class SP {
        public final String sql;
        public final List<Object> parameters;

        SP(String sql, List<Object> parameters) {
            this.sql = sql;
            this.parameters = ImmutableList.of(parameters);
        }

        public Pair<String, List<Object>> __() {
            return Pair.of(this.sql, this.parameters);
        }

        public int hashCode() {
            return N.hashCode(this.sql) * 31 + N.hashCode(this.parameters);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof SP) {
                SP other = (SP)obj;
                return N.equals(other.sql, this.sql) && N.equals(other.parameters, this.parameters);
            }
            return false;
        }

        public String toString() {
            return "{sql=" + this.sql + ", parameters=" + N.toString(this.parameters) + "}";
        }
    }

    @Deprecated
    public static class MLC
    extends SQLBuilder {
        MLC() {
            super(NamingPolicy.LOWER_CAMEL_CASE, SQLPolicy.IBATIS_SQL);
        }

        static MLC createInstance() {
            return new MLC();
        }

        public static SQLBuilder insert(String expr) {
            return MLC.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return MLC.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return MLC.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = MLC.getInsertPropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return MLC.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return MLC.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (N.firstNonNull(propsList).isPresent()) {
                ((SQLBuilder)instance).entityClass = first.getClass().getClass();
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(String expr, String[] columnNames) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(String expr, Collection<String> columnNames) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(String expr, Map<String, String> columnAliases) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return MLC.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return MLC.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return MLC.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = MLC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return MLC.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return MLC.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return MLC.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, NamingPolicy.LOWER_CAMEL_CASE);
                if (N.isNullOrEmpty(selectTableNames) || selectTableNames.size() == 1) {
                    return MLC.select(MLC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
                }
                return MLC.select(MLC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(selectTableNames);
            }
            return MLC.select(MLC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
        }

        public static SQLBuilder update(String tableName) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return MLC.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = MLC.getTableName(entityClass, NamingPolicy.LOWER_CAMEL_CASE);
            ((SQLBuilder)instance).columnNameList = MLC.getUpdatePropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = MLC.getTableName(entityClass, NamingPolicy.LOWER_CAMEL_CASE);
            return instance;
        }
    }

    @Deprecated
    public static class MAC
    extends SQLBuilder {
        MAC() {
            super(NamingPolicy.UPPER_CASE_WITH_UNDERSCORE, SQLPolicy.IBATIS_SQL);
        }

        static MAC createInstance() {
            return new MAC();
        }

        public static SQLBuilder insert(String expr) {
            return MAC.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return MAC.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return MAC.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = MAC.getInsertPropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return MAC.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return MAC.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (N.firstNonNull(propsList).isPresent()) {
                ((SQLBuilder)instance).entityClass = first.getClass().getClass();
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(String expr, String[] columnNames) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(String expr, Collection<String> columnNames) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(String expr, Map<String, String> columnAliases) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return MAC.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return MAC.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return MAC.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = MAC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return MAC.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return MAC.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return MAC.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
                if (N.isNullOrEmpty(selectTableNames) || selectTableNames.size() == 1) {
                    return MAC.select(MAC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
                }
                return MAC.select(MAC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(selectTableNames);
            }
            return MAC.select(MAC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
        }

        public static SQLBuilder update(String tableName) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return MAC.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = MAC.getTableName(entityClass, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
            ((SQLBuilder)instance).columnNameList = MAC.getUpdatePropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = MAC.getTableName(entityClass, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
            return instance;
        }
    }

    @Deprecated
    public static class MSC
    extends SQLBuilder {
        MSC() {
            super(NamingPolicy.LOWER_CASE_WITH_UNDERSCORE, SQLPolicy.IBATIS_SQL);
        }

        static MSC createInstance() {
            return new MSC();
        }

        public static SQLBuilder insert(String expr) {
            return MSC.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return MSC.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return MSC.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = MSC.getInsertPropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return MSC.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return MSC.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (N.firstNonNull(propsList).isPresent()) {
                ((SQLBuilder)instance).entityClass = first.getClass().getClass();
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(String expr, String[] columnNames) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(String expr, Collection<String> columnNames) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(String expr, Map<String, String> columnAliases) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return MSC.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return MSC.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return MSC.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = MSC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return MSC.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return MSC.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return MSC.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
                if (N.isNullOrEmpty(selectTableNames) || selectTableNames.size() == 1) {
                    return MSC.select(MSC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
                }
                return MSC.select(MSC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(selectTableNames);
            }
            return MSC.select(MSC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
        }

        public static SQLBuilder update(String tableName) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return MSC.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = MSC.getTableName(entityClass, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
            ((SQLBuilder)instance).columnNameList = MSC.getUpdatePropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = MSC.getTableName(entityClass, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
            return instance;
        }
    }

    public static class NLC
    extends SQLBuilder {
        NLC() {
            super(NamingPolicy.LOWER_CAMEL_CASE, SQLPolicy.NAMED_SQL);
        }

        static NLC createInstance() {
            return new NLC();
        }

        public static SQLBuilder insert(String expr) {
            return NLC.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return NLC.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return NLC.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = NLC.getInsertPropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return NLC.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return NLC.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (N.firstNonNull(propsList).isPresent()) {
                ((SQLBuilder)instance).entityClass = first.getClass().getClass();
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(String expr, String[] columnNames) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(String expr, Collection<String> columnNames) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(String expr, Map<String, String> columnAliases) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return NLC.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return NLC.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return NLC.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = NLC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return NLC.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return NLC.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return NLC.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, NamingPolicy.LOWER_CAMEL_CASE);
                if (N.isNullOrEmpty(selectTableNames) || selectTableNames.size() == 1) {
                    return NLC.select(NLC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
                }
                return NLC.select(NLC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(selectTableNames);
            }
            return NLC.select(NLC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
        }

        public static SQLBuilder update(String tableName) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return NLC.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = NLC.getTableName(entityClass, NamingPolicy.LOWER_CAMEL_CASE);
            ((SQLBuilder)instance).columnNameList = NLC.getUpdatePropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = NLC.getTableName(entityClass, NamingPolicy.LOWER_CAMEL_CASE);
            return instance;
        }
    }

    public static class NAC
    extends SQLBuilder {
        NAC() {
            super(NamingPolicy.UPPER_CASE_WITH_UNDERSCORE, SQLPolicy.NAMED_SQL);
        }

        static NAC createInstance() {
            return new NAC();
        }

        public static SQLBuilder insert(String expr) {
            return NAC.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return NAC.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return NAC.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = NAC.getInsertPropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return NAC.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return NAC.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (N.firstNonNull(propsList).isPresent()) {
                ((SQLBuilder)instance).entityClass = first.getClass().getClass();
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(String expr, String[] columnNames) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(String expr, Collection<String> columnNames) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(String expr, Map<String, String> columnAliases) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return NAC.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return NAC.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return NAC.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = NAC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return NAC.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return NAC.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return NAC.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
                if (N.isNullOrEmpty(selectTableNames) || selectTableNames.size() == 1) {
                    return NAC.select(NAC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
                }
                return NAC.select(NAC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(selectTableNames);
            }
            return NAC.select(NAC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
        }

        public static SQLBuilder update(String tableName) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return NAC.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = NAC.getTableName(entityClass, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
            ((SQLBuilder)instance).columnNameList = NAC.getUpdatePropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = NAC.getTableName(entityClass, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
            return instance;
        }
    }

    public static class NSC
    extends SQLBuilder {
        NSC() {
            super(NamingPolicy.LOWER_CASE_WITH_UNDERSCORE, SQLPolicy.NAMED_SQL);
        }

        static NSC createInstance() {
            return new NSC();
        }

        public static SQLBuilder insert(String expr) {
            return NSC.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return NSC.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return NSC.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = NSC.getInsertPropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return NSC.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return NSC.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (N.firstNonNull(propsList).isPresent()) {
                ((SQLBuilder)instance).entityClass = first.getClass().getClass();
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(String expr, String[] columnNames) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(String expr, Collection<String> columnNames) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(String expr, Map<String, String> columnAliases) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return NSC.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return NSC.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return NSC.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = NSC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return NSC.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return NSC.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return NSC.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
                if (N.isNullOrEmpty(selectTableNames) || selectTableNames.size() == 1) {
                    return NSC.select(NSC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
                }
                return NSC.select(NSC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(selectTableNames);
            }
            return NSC.select(NSC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
        }

        public static SQLBuilder update(String tableName) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return NSC.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = NSC.getTableName(entityClass, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
            ((SQLBuilder)instance).columnNameList = NSC.getUpdatePropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = NSC.getTableName(entityClass, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
            return instance;
        }
    }

    public static class PLC
    extends SQLBuilder {
        PLC() {
            super(NamingPolicy.LOWER_CAMEL_CASE, SQLPolicy.PARAMETERIZED_SQL);
        }

        static PLC createInstance() {
            return new PLC();
        }

        public static SQLBuilder insert(String expr) {
            return PLC.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return PLC.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return PLC.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = PLC.getInsertPropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return PLC.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return PLC.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (N.firstNonNull(propsList).isPresent()) {
                ((SQLBuilder)instance).entityClass = first.getClass().getClass();
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(String expr, String[] columnNames) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(String expr, Collection<String> columnNames) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(String expr, Map<String, String> columnAliases) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return PLC.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return PLC.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return PLC.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = PLC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return PLC.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return PLC.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return PLC.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, NamingPolicy.LOWER_CAMEL_CASE);
                if (N.isNullOrEmpty(selectTableNames) || selectTableNames.size() == 1) {
                    return PLC.select(PLC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
                }
                return PLC.select(PLC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(selectTableNames);
            }
            return PLC.select(PLC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
        }

        public static SQLBuilder update(String tableName) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return PLC.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = PLC.getTableName(entityClass, NamingPolicy.LOWER_CAMEL_CASE);
            ((SQLBuilder)instance).columnNameList = PLC.getUpdatePropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = PLC.getTableName(entityClass, NamingPolicy.LOWER_CAMEL_CASE);
            return instance;
        }
    }

    public static class PAC
    extends SQLBuilder {
        PAC() {
            super(NamingPolicy.UPPER_CASE_WITH_UNDERSCORE, SQLPolicy.PARAMETERIZED_SQL);
        }

        static PAC createInstance() {
            return new PAC();
        }

        public static SQLBuilder insert(String expr) {
            return PAC.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return PAC.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return PAC.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = PAC.getInsertPropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return PAC.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return PAC.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (N.firstNonNull(propsList).isPresent()) {
                ((SQLBuilder)instance).entityClass = first.getClass().getClass();
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(String expr, String[] columnNames) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(String expr, Collection<String> columnNames) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(String expr, Map<String, String> columnAliases) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return PAC.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return PAC.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return PAC.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = PAC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return PAC.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return PAC.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return PAC.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
                if (N.isNullOrEmpty(selectTableNames) || selectTableNames.size() == 1) {
                    return PAC.select(PAC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
                }
                return PAC.select(PAC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(selectTableNames);
            }
            return PAC.select(PAC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
        }

        public static SQLBuilder update(String tableName) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return PAC.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = PAC.getTableName(entityClass, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
            ((SQLBuilder)instance).columnNameList = PAC.getUpdatePropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = PAC.getTableName(entityClass, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
            return instance;
        }
    }

    public static class PSC
    extends SQLBuilder {
        PSC() {
            super(NamingPolicy.LOWER_CASE_WITH_UNDERSCORE, SQLPolicy.PARAMETERIZED_SQL);
        }

        static PSC createInstance() {
            return new PSC();
        }

        public static SQLBuilder insert(String expr) {
            return PSC.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return PSC.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return PSC.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = PSC.getInsertPropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return PSC.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return PSC.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (N.firstNonNull(propsList).isPresent()) {
                ((SQLBuilder)instance).entityClass = first.getClass().getClass();
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(String expr, String[] columnNames) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(String expr, Collection<String> columnNames) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(String expr, Map<String, String> columnAliases) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return PSC.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return PSC.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return PSC.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = PSC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return PSC.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return PSC.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return PSC.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
                if (N.isNullOrEmpty(selectTableNames) || selectTableNames.size() == 1) {
                    return PSC.select(PSC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
                }
                return PSC.select(PSC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(selectTableNames);
            }
            return PSC.select(PSC.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
        }

        public static SQLBuilder update(String tableName) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return PSC.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = PSC.getTableName(entityClass, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
            ((SQLBuilder)instance).columnNameList = PSC.getUpdatePropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = PSC.getTableName(entityClass, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
            return instance;
        }
    }

    @Deprecated
    public static class LCSB
    extends SQLBuilder {
        LCSB() {
            super(NamingPolicy.LOWER_CAMEL_CASE, SQLPolicy.SQL);
        }

        static LCSB createInstance() {
            return new LCSB();
        }

        public static SQLBuilder insert(String expr) {
            return LCSB.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return LCSB.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return LCSB.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = LCSB.getInsertPropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return LCSB.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return LCSB.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (N.firstNonNull(propsList).isPresent()) {
                ((SQLBuilder)instance).entityClass = first.getClass().getClass();
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(String expr, String[] columnNames) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(String expr, Collection<String> columnNames) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(String expr, Map<String, String> columnAliases) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return LCSB.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return LCSB.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return LCSB.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = LCSB.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return LCSB.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return LCSB.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return LCSB.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, NamingPolicy.LOWER_CAMEL_CASE);
                if (N.isNullOrEmpty(selectTableNames) || selectTableNames.size() == 1) {
                    return LCSB.select(LCSB.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
                }
                return LCSB.select(LCSB.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(selectTableNames);
            }
            return LCSB.select(LCSB.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
        }

        public static SQLBuilder update(String tableName) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return LCSB.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = LCSB.getTableName(entityClass, NamingPolicy.LOWER_CAMEL_CASE);
            ((SQLBuilder)instance).columnNameList = LCSB.getUpdatePropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = LCSB.getTableName(entityClass, NamingPolicy.LOWER_CAMEL_CASE);
            return instance;
        }
    }

    @Deprecated
    public static class ACSB
    extends SQLBuilder {
        ACSB() {
            super(NamingPolicy.UPPER_CASE_WITH_UNDERSCORE, SQLPolicy.SQL);
        }

        static ACSB createInstance() {
            return new ACSB();
        }

        public static SQLBuilder insert(String expr) {
            return ACSB.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return ACSB.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return ACSB.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = ACSB.getInsertPropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return ACSB.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return ACSB.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (N.firstNonNull(propsList).isPresent()) {
                ((SQLBuilder)instance).entityClass = first.getClass().getClass();
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(String expr, String[] columnNames) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(String expr, Collection<String> columnNames) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(String expr, Map<String, String> columnAliases) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return ACSB.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return ACSB.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return ACSB.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = ACSB.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return ACSB.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return ACSB.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return ACSB.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
                if (N.isNullOrEmpty(selectTableNames) || selectTableNames.size() == 1) {
                    return ACSB.select(ACSB.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
                }
                return ACSB.select(ACSB.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(selectTableNames);
            }
            return ACSB.select(ACSB.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
        }

        public static SQLBuilder update(String tableName) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return ACSB.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = ACSB.getTableName(entityClass, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
            ((SQLBuilder)instance).columnNameList = ACSB.getUpdatePropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = ACSB.getTableName(entityClass, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
            return instance;
        }
    }

    @Deprecated
    public static class SCSB
    extends SQLBuilder {
        SCSB() {
            super(NamingPolicy.LOWER_CASE_WITH_UNDERSCORE, SQLPolicy.SQL);
        }

        static SCSB createInstance() {
            return new SCSB();
        }

        public static SQLBuilder insert(String expr) {
            return SCSB.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return SCSB.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return SCSB.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = SCSB.getInsertPropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return SCSB.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return SCSB.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (N.firstNonNull(propsList).isPresent()) {
                ((SQLBuilder)instance).entityClass = first.getClass().getClass();
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(String expr, String[] columnNames) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            SQLBuilder.access$102(instance, columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(String expr, Collection<String> columnNames) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnNameList = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(String expr, Map<String, String> columnAliases) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).predicates = expr;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return SCSB.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return SCSB.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return SCSB.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).columnNameList = SCSB.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return SCSB.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return SCSB.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return SCSB.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
                if (N.isNullOrEmpty(selectTableNames) || selectTableNames.size() == 1) {
                    return SCSB.select(SCSB.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
                }
                return SCSB.select(SCSB.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(selectTableNames);
            }
            return SCSB.select(SCSB.getSelectPropNamesByClass(entityClass, includeSubEntityProperties, excludedPropNames)).from(entityClass);
        }

        public static SQLBuilder update(String tableName) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return SCSB.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = SCSB.getTableName(entityClass, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
            ((SQLBuilder)instance).columnNameList = SCSB.getUpdatePropNamesByClass(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).tableName = SCSB.getTableName(entityClass, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
            return instance;
        }
    }

    static enum SQLPolicy {
        SQL,
        PARAMETERIZED_SQL,
        NAMED_SQL,
        IBATIS_SQL;

    }
}

