/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.N;
import com.landawn.abacus.util.function.Supplier;
import java.util.concurrent.atomic.AtomicReference;

public final class SafeInitializer<T> {
    private final AtomicReference<SafeInitializer<T>> factory = new AtomicReference();
    private final AtomicReference<T> reference = new AtomicReference();
    private final Supplier<T> supplier;

    SafeInitializer(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public final T get() {
        T result = this.reference.get();
        if (result == null) {
            while ((result = this.reference.get()) == null) {
                if (!this.factory.compareAndSet(null, this)) continue;
                this.reference.set(this.supplier.get());
            }
        }
        return result;
    }

    public static <T> SafeInitializer<T> of(Supplier<T> supplier) {
        N.checkArgNotNull(supplier);
        return new SafeInitializer<T>(supplier);
    }
}

