/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.annotation.Beta;
import com.landawn.abacus.exception.DuplicatedResultException;
import com.landawn.abacus.util.Array;
import com.landawn.abacus.util.Fn;
import com.landawn.abacus.util.ImmutableCollection;
import com.landawn.abacus.util.Indexed;
import com.landawn.abacus.util.Iterables;
import com.landawn.abacus.util.Iterators;
import com.landawn.abacus.util.Joiner;
import com.landawn.abacus.util.ListMultimap;
import com.landawn.abacus.util.Maps;
import com.landawn.abacus.util.Multimap;
import com.landawn.abacus.util.Multiset;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Nth;
import com.landawn.abacus.util.ObjIterator;
import com.landawn.abacus.util.Pair;
import com.landawn.abacus.util.StringUtil;
import com.landawn.abacus.util.Try;
import com.landawn.abacus.util.function.BiConsumer;
import com.landawn.abacus.util.function.BiFunction;
import com.landawn.abacus.util.function.Function;
import com.landawn.abacus.util.function.IntFunction;
import com.landawn.abacus.util.function.Supplier;
import com.landawn.abacus.util.stream.Collector;
import com.landawn.abacus.util.u;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

@Beta
public final class Seq<T>
extends ImmutableCollection<T> {
    private static final Seq EMPTY = new Seq(Collections.EMPTY_LIST);

    Seq(Collection<T> c) {
        super(c == null ? Collections.EMPTY_LIST : c);
    }

    public static <T> Seq<T> empty() {
        return EMPTY;
    }

    public static <T> Seq<T> just(T t) {
        return Seq.of(t);
    }

    @SafeVarargs
    public static <T> Seq<T> of(T ... a) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY;
        }
        return Seq.of(Arrays.asList(a));
    }

    public static <T> Seq<T> of(Collection<T> c) {
        if (N.isNullOrEmpty(c)) {
            return EMPTY;
        }
        return new Seq<T>(c);
    }

    public static <K, V> Seq<Map.Entry<K, V>> of(Map<K, V> map) {
        if (N.isNullOrEmpty(map)) {
            return EMPTY;
        }
        return Seq.of(map.entrySet());
    }

    @Override
    public boolean contains(Object e) {
        if (N.isNullOrEmpty(this.coll)) {
            return false;
        }
        return this.coll.contains(e);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (N.isNullOrEmpty(c)) {
            return true;
        }
        if (N.isNullOrEmpty(this.coll)) {
            return false;
        }
        return this.coll.containsAll(c);
    }

    public boolean containsAll(Object[] a) {
        if (N.isNullOrEmpty(a)) {
            return true;
        }
        if (N.isNullOrEmpty(this.coll)) {
            return false;
        }
        return this.containsAll(Arrays.asList(a));
    }

    public boolean containsAny(Collection<?> c) {
        if (N.isNullOrEmpty(this.coll) || N.isNullOrEmpty(c)) {
            return false;
        }
        return !this.disjoint(c);
    }

    public boolean containsAny(Object[] a) {
        if (N.isNullOrEmpty(this.coll) || N.isNullOrEmpty(a)) {
            return false;
        }
        return !this.disjoint(a);
    }

    public boolean disjoint(Collection<?> c) {
        return N.disjoint(this.coll, c);
    }

    public boolean disjoint(Object[] a) {
        if (N.isNullOrEmpty(this.coll) || N.isNullOrEmpty(a)) {
            return true;
        }
        return this.disjoint(Arrays.asList(a));
    }

    public List<T> intersection(Collection<?> b) {
        return N.intersection(this.coll, b);
    }

    public List<T> intersection(Object[] a) {
        return N.intersection(this.coll, Array.asList(a));
    }

    public List<T> difference(Collection<?> b) {
        return N.difference(this.coll, b);
    }

    public List<T> difference(Object[] a) {
        return N.difference(this.coll, Array.asList(a));
    }

    public List<T> symmetricDifference(Collection<? extends T> b) {
        return N.symmetricDifference(this.coll, b);
    }

    public List<T> symmetricDifference(T[] a) {
        return N.symmetricDifference(this.coll, Array.asList(a));
    }

    public int occurrencesOf(Object objectToFind) {
        return N.isNullOrEmpty(this.coll) ? 0 : N.occurrencesOf(this.coll, objectToFind);
    }

    public u.Nullable<T> min() {
        return this.size() == 0 ? u.Nullable.empty() : u.Nullable.of(N.min(this.coll));
    }

    public u.Nullable<T> min(Comparator<? super T> cmp) {
        return this.size() == 0 ? u.Nullable.empty() : u.Nullable.of(N.min(this.coll, cmp));
    }

    public u.Nullable<T> minBy(Function<? super T, ? extends Comparable> keyMapper) {
        return this.min(Fn.comparingBy(keyMapper));
    }

    public u.Nullable<T> max() {
        return this.size() == 0 ? u.Nullable.empty() : u.Nullable.of(N.max(this.coll));
    }

    public u.Nullable<T> max(Comparator<? super T> cmp) {
        return this.size() == 0 ? u.Nullable.empty() : u.Nullable.of(N.max(this.coll, cmp));
    }

    public u.Nullable<T> maxBy(Function<? super T, ? extends Comparable> keyMapper) {
        return this.max(Fn.comparingBy(keyMapper));
    }

    public u.Nullable<T> median() {
        return this.size() == 0 ? u.Nullable.empty() : u.Nullable.of(N.median(this.coll));
    }

    public u.Nullable<T> median(Comparator<? super T> cmp) {
        return this.size() == 0 ? u.Nullable.empty() : u.Nullable.of(N.median(this.coll, cmp));
    }

    public u.Nullable<T> kthLargest(int k) {
        N.checkArgPositive(k, "k");
        return this.size() < k ? u.Nullable.empty() : u.Nullable.of(N.kthLargest(this.coll, k));
    }

    public u.Nullable<T> kthLargest(int k, Comparator<? super T> cmp) {
        N.checkArgPositive(k, "k");
        return this.size() < k ? u.Nullable.empty() : u.Nullable.of(N.kthLargest(this.coll, k, cmp));
    }

    public <E extends Exception> int sumInt(Try.ToIntFunction<? super T, E> mapper) throws E {
        if (N.isNullOrEmpty(this.coll)) {
            return 0;
        }
        return N.sumInt(this.coll, mapper);
    }

    public <E extends Exception> long sumLong(Try.ToLongFunction<? super T, E> mapper) throws E {
        if (N.isNullOrEmpty(this.coll)) {
            return 0L;
        }
        return N.sumLong(this.coll, mapper);
    }

    public <E extends Exception> double sumDouble(Try.ToDoubleFunction<? super T, E> mapper) throws E {
        if (N.isNullOrEmpty(this.coll)) {
            return 0.0;
        }
        return N.sumDouble(this.coll, mapper);
    }

    public <E extends Exception> u.OptionalDouble averageInt(Try.ToIntFunction<? super T, E> mapper) throws E {
        return N.averageInt(this.coll, mapper);
    }

    public <E extends Exception> u.OptionalDouble averageLong(Try.ToLongFunction<? super T, E> mapper) throws E {
        return N.averageLong(this.coll, mapper);
    }

    public <E extends Exception> u.OptionalDouble averageDouble(Try.ToDoubleFunction<? super T, E> mapper) throws E {
        return N.averageDouble(this.coll, mapper);
    }

    public <E extends Exception> void foreach(Try.Consumer<? super T, E> action) throws E {
        N.forEach(this.coll, action);
    }

    public <E extends Exception, E2 extends Exception> void forEach(Try.Consumer<? super T, E> action, Try.Runnable<E2> onComplete) throws E, E2 {
        N.forEach(this.coll, action);
        onComplete.run();
    }

    public <E extends Exception> void forEach(Try.IndexedConsumer<? super T, E> action) throws E {
        N.forEach(this.coll, action);
    }

    public <U, E extends Exception, E2 extends Exception> void forEach(Try.Function<? super T, ? extends Collection<U>, E> flatMapper, Try.BiConsumer<? super T, ? super U, E2> action) throws E, E2 {
        N.forEach(this.coll, flatMapper, action);
    }

    public <T2, T3, E extends Exception, E2 extends Exception, E3 extends Exception> void forEach(Try.Function<? super T, ? extends Collection<T2>, E> flatMapper, Try.Function<? super T2, ? extends Collection<T3>, E2> flatMapper2, Try.TriConsumer<? super T, ? super T2, ? super T3, E3> action) throws E, E2, E3 {
        N.forEach(this.coll, flatMapper, flatMapper2, action);
    }

    public <E extends Exception> void forEachNonNull(Try.Consumer<? super T, E> action) throws E {
        N.forEachNonNull(this.coll, action);
    }

    public <U, E extends Exception, E2 extends Exception> void forEachNonNull(Try.Function<? super T, ? extends Collection<U>, E> flatMapper, Try.BiConsumer<? super T, ? super U, E2> action) throws E, E2 {
        N.forEachNonNull(this.coll, flatMapper, action);
    }

    public <T2, T3, E extends Exception, E2 extends Exception, E3 extends Exception> void forEachNonNull(Try.Function<? super T, ? extends Collection<T2>, E> flatMapper, Try.Function<? super T2, ? extends Collection<T3>, E2> flatMapper2, Try.TriConsumer<? super T, ? super T2, ? super T3, E3> action) throws E, E2, E3 {
        N.forEachNonNull(this.coll, flatMapper, flatMapper2, action);
    }

    public <E extends Exception> void forEachPair(Try.BiConsumer<? super T, ? super T, E> action) throws E {
        this.forEachPair(action, 1);
    }

    public <E extends Exception> void forEachPair(Try.BiConsumer<? super T, ? super T, E> action, int increment) throws E {
        N.checkArgNotNull(action);
        int windowSize = 2;
        N.checkArgument(increment > 0, "windowSize=%s and increment=%s must be bigger than 0", 2, increment);
        if (N.isNullOrEmpty(this.coll)) {
            return;
        }
        Iterator iter = this.coll.iterator();
        Iterators.forEachPair(iter, action, increment);
    }

    public <E extends Exception> void forEachTriple(Try.TriConsumer<? super T, ? super T, ? super T, E> action) throws E {
        this.forEachTriple(action, 1);
    }

    public <E extends Exception> void forEachTriple(Try.TriConsumer<? super T, ? super T, ? super T, E> action, int increment) throws E {
        N.checkArgNotNull(action);
        int windowSize = 3;
        N.checkArgument(increment > 0, "windowSize=%s and increment=%s must be bigger than 0", 3, increment);
        if (N.isNullOrEmpty(this.coll)) {
            return;
        }
        Iterator iter = this.coll.iterator();
        Iterators.forEachTriple(iter, action, increment);
    }

    public u.Nullable<T> first() {
        return N.first(this.coll);
    }

    public u.Optional<T> firstNonNull() {
        return N.firstNonNull(this.coll);
    }

    public List<T> first(int n) {
        N.checkArgument(n >= 0, "'n' can't be negative: " + n);
        if (N.isNullOrEmpty(this.coll) || n == 0) {
            return new ArrayList();
        }
        if (this.coll.size() <= n) {
            return new ArrayList(this.coll);
        }
        if (this.coll instanceof List) {
            return new ArrayList(((List)this.coll).subList(0, n));
        }
        ArrayList result = new ArrayList(N.min(n, this.coll.size()));
        int cnt = 0;
        for (Object e : this.coll) {
            result.add(e);
            if (++cnt != n) continue;
            break;
        }
        return result;
    }

    public u.Nullable<T> last() {
        return N.last(this.coll);
    }

    public u.Optional<T> lastNonNull() {
        return N.lastNonNull(this.coll);
    }

    public List<T> last(int n) {
        N.checkArgument(n >= 0, "'n' can't be negative: " + n);
        if (N.isNullOrEmpty(this.coll) || n == 0) {
            return new ArrayList();
        }
        if (this.coll.size() <= n) {
            return new ArrayList(this.coll);
        }
        if (this.coll instanceof List) {
            return new ArrayList(((List)this.coll).subList(this.coll.size() - n, this.coll.size()));
        }
        ArrayList result = new ArrayList(N.min(n, this.coll.size()));
        Iterator iter = this.coll.iterator();
        int offset = this.coll.size() - n;
        while (offset-- > 0) {
            iter.next();
        }
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    public <E extends Exception> u.Nullable<T> findFirst(Try.Predicate<? super T, E> predicate) throws E {
        return Iterables.findFirst(this.coll, predicate);
    }

    public <E extends Exception> u.Nullable<T> findLast(Try.Predicate<? super T, E> predicate) throws E {
        return Iterables.findLast(this.coll, predicate);
    }

    public <E extends Exception> u.OptionalInt findFirstIndex(Try.Predicate<? super T, E> predicate) throws E {
        return Iterables.findFirstIndex(this.coll, predicate);
    }

    public <E extends Exception> u.OptionalInt findLastIndex(Try.Predicate<? super T, E> predicate) throws E {
        return Iterables.findLastIndex(this.coll, predicate);
    }

    public <E extends Exception, E2 extends Exception> u.Nullable<T> findFirstOrLast(Try.Predicate<? super T, E> predicateForFirst, Try.Predicate<? super T, E2> predicateForLast) throws E, E2 {
        if (N.isNullOrEmpty(this.coll)) {
            return u.Nullable.empty();
        }
        u.Nullable<T> res = this.findFirst(predicateForFirst);
        return res.isPresent() ? res : this.findLast(predicateForLast);
    }

    public <E extends Exception, E2 extends Exception> u.OptionalInt findFirstOrLastIndex(Try.Predicate<? super T, E> predicateForFirst, Try.Predicate<? super T, E2> predicateForLast) throws E, E2 {
        if (N.isNullOrEmpty(this.coll)) {
            return u.OptionalInt.empty();
        }
        u.OptionalInt res = this.findFirstIndex(predicateForFirst);
        return res.isPresent() ? res : this.findLastIndex(predicateForLast);
    }

    public <E extends Exception> Pair<u.Nullable<T>, u.Nullable<T>> findFirstAndLast(Try.Predicate<? super T, E> predicate) throws E {
        return this.findFirstAndLast(predicate, predicate);
    }

    public <E extends Exception, E2 extends Exception> Pair<u.Nullable<T>, u.Nullable<T>> findFirstAndLast(Try.Predicate<? super T, E> predicateForFirst, Try.Predicate<? super T, E2> predicateForLast) throws E, E2 {
        if (N.isNullOrEmpty(this.coll)) {
            return Pair.of(u.Nullable.empty(), u.Nullable.empty());
        }
        return Pair.of(this.findFirst(predicateForFirst), this.findLast(predicateForLast));
    }

    public <E extends Exception> Pair<u.OptionalInt, u.OptionalInt> findFirstAndLastIndex(Try.Predicate<? super T, E> predicate) throws E {
        return this.findFirstAndLastIndex(predicate, predicate);
    }

    public <E extends Exception, E2 extends Exception> Pair<u.OptionalInt, u.OptionalInt> findFirstAndLastIndex(Try.Predicate<? super T, E> predicateForFirst, Try.Predicate<? super T, E2> predicateForLast) throws E, E2 {
        if (N.isNullOrEmpty(this.coll)) {
            return Pair.of(u.OptionalInt.empty(), u.OptionalInt.empty());
        }
        return Pair.of(this.findFirstIndex(predicateForFirst), this.findLastIndex(predicateForLast));
    }

    public <E extends Exception> boolean allMatch(Try.Predicate<? super T, E> filter) throws E {
        if (N.isNullOrEmpty(this.coll)) {
            return true;
        }
        for (Object e : this.coll) {
            if (filter.test(e)) continue;
            return false;
        }
        return true;
    }

    public <E extends Exception> boolean anyMatch(Try.Predicate<? super T, E> filter) throws E {
        if (N.isNullOrEmpty(this.coll)) {
            return false;
        }
        for (Object e : this.coll) {
            if (!filter.test(e)) continue;
            return true;
        }
        return false;
    }

    public <E extends Exception> boolean noneMatch(Try.Predicate<? super T, E> filter) throws E {
        if (N.isNullOrEmpty(this.coll)) {
            return true;
        }
        for (Object e : this.coll) {
            if (!filter.test(e)) continue;
            return false;
        }
        return true;
    }

    public <E extends Exception> boolean nMatch(int atLeast, int atMost, Try.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNegative(atLeast, "atLeast");
        N.checkArgNotNegative(atMost, "atMost");
        N.checkArgument(atLeast <= atMost, "'atLeast' must be <= 'atMost'");
        long cnt = 0L;
        for (Object e : this.coll) {
            if (!filter.test(e) || ++cnt <= (long)atMost) continue;
            return false;
        }
        return cnt >= (long)atLeast && cnt <= (long)atMost;
    }

    public boolean hasDuplicates() {
        return N.hasDuplicates(this.coll, false);
    }

    public <E extends Exception> int count(Try.Predicate<? super T, E> filter) throws E {
        return N.count(this.coll, filter);
    }

    public <E extends Exception> List<T> filter(Try.Predicate<? super T, E> filter) throws E {
        return N.filter(this.coll, filter);
    }

    public <E extends Exception> List<T> filter(Try.Predicate<? super T, E> filter, int max) throws E {
        return N.filter(this.coll, filter, max);
    }

    public <C extends Collection<T>, E extends Exception> C filter(Try.Predicate<? super T, E> filter, IntFunction<? extends C> supplier) throws E {
        return N.filter(this.coll, filter, supplier);
    }

    public <C extends Collection<T>, E extends Exception> C filter(Try.Predicate<? super T, E> filter, int max, IntFunction<? extends C> supplier) throws E {
        return N.filter(this.coll, filter, max, supplier);
    }

    public <E extends Exception> List<T> takeWhile(Try.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter);
        ArrayList result = new ArrayList(N.min(9, this.size()));
        if (N.isNullOrEmpty(this.coll)) {
            return result;
        }
        for (Object e : this.coll) {
            if (!filter.test(e)) break;
            result.add(e);
        }
        return result;
    }

    public <E extends Exception> List<T> takeWhileInclusive(Try.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter);
        ArrayList result = new ArrayList(N.min(9, this.size()));
        if (N.isNullOrEmpty(this.coll)) {
            return result;
        }
        for (Object e : this.coll) {
            result.add(e);
            if (filter.test(e)) continue;
            break;
        }
        return result;
    }

    public <E extends Exception> List<T> dropWhile(Try.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter);
        ArrayList result = new ArrayList(N.min(9, this.size()));
        if (N.isNullOrEmpty(this.coll)) {
            return result;
        }
        Iterator iter = this.iterator();
        Object e = null;
        while (iter.hasNext()) {
            e = iter.next();
            if (filter.test(e)) continue;
            result.add(e);
            break;
        }
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    public <E extends Exception> List<T> skipUntil(Try.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter);
        ArrayList result = new ArrayList(N.min(9, this.size()));
        if (N.isNullOrEmpty(this.coll)) {
            return result;
        }
        Iterator iter = this.iterator();
        Object e = null;
        while (iter.hasNext()) {
            e = iter.next();
            if (!filter.test(e)) continue;
            result.add(e);
            break;
        }
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    public <R, E extends Exception> List<R> map(Try.Function<? super T, ? extends R, E> func) throws E {
        return N.map(this.coll, func);
    }

    public <R, E extends Exception> List<R> flatMap(Try.Function<? super T, ? extends Collection<? extends R>, E> func) throws E {
        N.checkArgNotNull(func);
        ArrayList<? extends R> result = new ArrayList<R>(this.size() > 0x3FFFFFFB ? 0x7FFFFFF7 : this.size() * 2);
        if (N.isNullOrEmpty(this.coll)) {
            return result;
        }
        for (Object e : this.coll) {
            result.addAll(func.apply(e));
        }
        return result;
    }

    public <R, E extends Exception> List<R> flattMap(Try.Function<? super T, ? extends R[], E> func) throws E {
        N.checkArgNotNull(func);
        ArrayList<Object> result = new ArrayList<Object>(this.size() > 0x3FFFFFFB ? 0x7FFFFFF7 : this.size() * 2);
        if (N.isNullOrEmpty(this.coll)) {
            return result;
        }
        Object[] a = null;
        for (Object e : this.coll) {
            a = func.apply(e);
            if (!N.notNullOrEmpty(a)) continue;
            if (a.length < 9) {
                for (Object r : a) {
                    result.add(r);
                }
                continue;
            }
            result.addAll(Arrays.asList(a));
        }
        return result;
    }

    public <U, R, E extends Exception, E2 extends Exception> List<R> flatMap(Try.Function<? super T, ? extends Collection<U>, E> mapper, Try.BiFunction<? super T, ? super U, ? extends R, E2> func) throws E, E2 {
        N.checkArgNotNull(mapper);
        N.checkArgNotNull(func);
        ArrayList<R> result = new ArrayList<R>(N.max(9, this.coll.size()));
        for (Object e : this.coll) {
            Collection<U> c = mapper.apply(e);
            if (!N.notNullOrEmpty(c)) continue;
            for (U u2 : c) {
                result.add(func.apply(e, u2));
            }
        }
        return result;
    }

    public <T2, T3, R, E extends Exception, E2 extends Exception, E3 extends Exception> List<R> flatMap(Try.Function<? super T, ? extends Collection<T2>, E> mapper2, Try.Function<? super T2, ? extends Collection<T3>, E2> mapper3, Try.TriFunction<? super T, ? super T2, ? super T3, R, E3> func) throws E, E2, E3 {
        N.checkArgNotNull(mapper2);
        N.checkArgNotNull(mapper3);
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(this.coll)) {
            return new ArrayList();
        }
        ArrayList<R> result = new ArrayList<R>(N.max(9, this.coll.size()));
        for (Object e : this.coll) {
            Collection<T2> c2 = mapper2.apply(e);
            if (!N.notNullOrEmpty(c2)) continue;
            for (T2 t2 : c2) {
                Collection<T3> c3 = mapper3.apply(t2);
                if (!N.notNullOrEmpty(c3)) continue;
                for (T3 t3 : c3) {
                    result.add(func.apply(e, t2, t3));
                }
            }
        }
        return result;
    }

    @Beta
    public <R, E extends Exception, E2 extends Exception> List<R> filterThenMap(Try.Predicate<? super T, E> filter, Try.Function<? super T, ? extends R, E2> mapper) throws E, E2 {
        N.checkArgNotNull(filter);
        N.checkArgNotNull(mapper);
        ArrayList<R> result = new ArrayList<R>();
        for (Object e : this.coll) {
            if (!filter.test(e)) continue;
            result.add(mapper.apply(e));
        }
        return result;
    }

    @Beta
    public <R, E extends Exception, E2 extends Exception> List<R> filterThenFlatMap(Try.Predicate<? super T, E> filter, Try.Function<? super T, ? extends Collection<? extends R>, E2> mapper) throws E, E2 {
        N.checkArgNotNull(filter);
        N.checkArgNotNull(mapper);
        ArrayList<? extends R> result = new ArrayList<R>();
        Collection<? extends R> c = null;
        for (Object e : this.coll) {
            if (!filter.test(e) || !N.notNullOrEmpty(c = mapper.apply(e))) continue;
            result.addAll(c);
        }
        return result;
    }

    @Beta
    public <R, E extends Exception, E2 extends Exception> List<R> mapThenFilter(Try.Function<? super T, ? extends R, E> mapper, Try.Predicate<? super R, E2> filter) throws E, E2 {
        N.checkArgNotNull(mapper);
        N.checkArgNotNull(filter);
        ArrayList<Object> result = new ArrayList<Object>();
        Object r = null;
        for (Object e : this.coll) {
            r = mapper.apply(e);
            if (!filter.test(r)) continue;
            result.add(r);
        }
        return result;
    }

    @Beta
    public <R, E extends Exception, E2 extends Exception> List<R> flatMapThenFilter(Try.Function<? super T, ? extends Collection<? extends R>, E> mapper, Try.Predicate<? super R, E2> filter) throws E, E2 {
        N.checkArgNotNull(mapper);
        N.checkArgNotNull(filter);
        ArrayList<R> result = new ArrayList<R>();
        Collection<R> c = null;
        for (Object e : this.coll) {
            c = mapper.apply(e);
            if (!N.notNullOrEmpty(c)) continue;
            for (R r : c) {
                if (!filter.test(r)) continue;
                result.add(r);
            }
        }
        return result;
    }

    @Beta
    public <R, E extends Exception, E2 extends Exception> void filterThenForEach(Try.Predicate<? super T, E> filter, Try.Consumer<? super T, E2> action) throws E, E2 {
        N.checkArgNotNull(filter);
        N.checkArgNotNull(action);
        for (Object e : this.coll) {
            if (!filter.test(e)) continue;
            action.accept(e);
        }
    }

    @Beta
    public <R, E extends Exception, E2 extends Exception> void mapThenForEach(Try.Function<? super T, ? extends R, E> mapper, Try.Consumer<? super R, E2> action) throws E, E2 {
        N.checkArgNotNull(mapper);
        N.checkArgNotNull(action);
        for (Object e : this.coll) {
            action.accept(mapper.apply(e));
        }
    }

    @Beta
    public <R, E extends Exception, E2 extends Exception> void flatMapThenForEach(Try.Function<? super T, ? extends Collection<? extends R>, E> mapper, Try.Consumer<? super R, E2> action) throws E, E2 {
        N.checkArgNotNull(mapper);
        N.checkArgNotNull(action);
        Collection<R> c = null;
        for (Object e : this.coll) {
            c = mapper.apply(e);
            if (!N.notNullOrEmpty(c)) continue;
            for (R r : c) {
                action.accept(r);
            }
        }
    }

    public <E extends Exception, E2 extends Exception> List<T> collapse(Try.BiPredicate<? super T, ? super T, E> collapsible, Try.BiFunction<? super T, ? super T, T, E2> mergeFunction) throws E, E2 {
        N.checkArgNotNull(collapsible);
        N.checkArgNotNull(mergeFunction);
        ArrayList result = new ArrayList();
        Iterator iter = this.iterator();
        boolean hasNext = false;
        Object next = null;
        while (hasNext || iter.hasNext()) {
            Object res;
            Object u2 = res = hasNext ? next : (next = (Object)iter.next());
            while (hasNext = iter.hasNext()) {
                Object u3 = next;
                Object e = iter.next();
                next = e;
                if (!collapsible.test(u3, e)) break;
                res = mergeFunction.apply(res, next);
            }
            result.add(res);
        }
        return result;
    }

    public <U, E extends Exception, E2 extends Exception> List<U> collapse(Try.BiPredicate<? super T, ? super T, E> collapsible, U init, Try.BiFunction<? super U, ? super T, U, E2> op) throws E, E2 {
        N.checkArgNotNull(collapsible);
        N.checkArgNotNull(op);
        ArrayList<U> result = new ArrayList<U>();
        Iterator iter = this.iterator();
        boolean hasNext = false;
        Object next = null;
        while (hasNext || iter.hasNext()) {
            U res = op.apply(init, hasNext ? next : (next = (Object)iter.next()));
            while (hasNext = iter.hasNext()) {
                Object u2 = next;
                Object e = iter.next();
                next = e;
                if (!collapsible.test(u2, e)) break;
                res = op.apply(res, next);
            }
            result.add(res);
        }
        return result;
    }

    public <E extends Exception> List<List<T>> collapse(Try.BiPredicate<? super T, ? super T, E> collapsible) throws E {
        return this.collapse(collapsible, Fn.Suppliers.ofList());
    }

    public <C extends Collection<T>, E extends Exception> List<C> collapse(Try.BiPredicate<? super T, ? super T, E> collapsible, Supplier<? extends C> collectionSupplier) throws E {
        N.checkArgNotNull(collapsible);
        N.checkArgNotNull(collectionSupplier);
        ArrayList<Collection> result = new ArrayList<Collection>();
        Iterator iter = this.iterator();
        boolean hasNext = false;
        Object next = null;
        while (hasNext || iter.hasNext()) {
            Collection c = (Collection)collectionSupplier.get();
            c.add(hasNext ? next : (next = (Object)iter.next()));
            while (hasNext = iter.hasNext()) {
                Object e = next;
                Object e2 = iter.next();
                next = e2;
                if (!collapsible.test(e, e2)) break;
                c.add(next);
            }
            result.add(c);
        }
        return result;
    }

    public <R, A, E extends Exception> List<R> collapse(Try.BiPredicate<? super T, ? super T, E> collapsible, Collector<? super T, A, R> collector) throws E {
        N.checkArgNotNull(collapsible);
        N.checkArgNotNull(collector);
        ArrayList<R> result = new ArrayList<R>();
        Supplier<A> supplier = collector.supplier();
        BiConsumer<A, A> accumulator = collector.accumulator();
        Function<A, R> finisher = collector.finisher();
        Iterator iter = this.iterator();
        boolean hasNext = false;
        Object next = null;
        while (hasNext || iter.hasNext()) {
            A c = supplier.get();
            accumulator.accept(c, hasNext ? next : (next = (Object)iter.next()));
            while (hasNext = iter.hasNext()) {
                Object u2 = next;
                Object e = iter.next();
                next = e;
                if (!collapsible.test(u2, e)) break;
                accumulator.accept(c, next);
            }
            result.add(finisher.apply(c));
        }
        return result;
    }

    public <E extends Exception> List<T> scan(Try.BiFunction<? super T, ? super T, T, E> accumulator) throws E {
        N.checkArgNotNull(accumulator);
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator iter = this.iterator();
        Object next = null;
        if (iter.hasNext()) {
            Object e = iter.next();
            next = e;
            result.add(e);
        }
        while (iter.hasNext()) {
            T t = accumulator.apply(next, iter.next());
            next = t;
            result.add(t);
        }
        return result;
    }

    public <U, E extends Exception> List<U> scan(U init, Try.BiFunction<? super U, ? super T, U, E> accumulator) throws E {
        return this.scan(init, accumulator, false);
    }

    public <U, E extends Exception> List<U> scan(U init, Try.BiFunction<? super U, ? super T, U, E> accumulator, boolean initIncluded) throws E {
        N.checkArgNotNull(accumulator);
        ArrayList<U> result = new ArrayList<U>();
        if (initIncluded) {
            result.add(init);
        }
        Iterator iter = this.iterator();
        U next = init;
        while (iter.hasNext()) {
            next = accumulator.apply(next, iter.next());
            result.add(next);
        }
        return result;
    }

    public <E extends Exception> u.Nullable<T> reduce(Try.BinaryOperator<T, E> accumulator) throws E {
        N.checkArgNotNull(accumulator);
        if (this.isEmpty()) {
            return u.Nullable.empty();
        }
        Iterator iter = this.iterator();
        Object result = iter.next();
        while (iter.hasNext()) {
            result = accumulator.apply(result, iter.next());
        }
        return u.Nullable.of(result);
    }

    public <U, E extends Exception> U reduce(U identity, Try.BiFunction<U, ? super T, U, E> accumulator) throws E {
        N.checkArgNotNull(accumulator);
        if (this.isEmpty()) {
            return identity;
        }
        Iterator iter = this.iterator();
        U result = identity;
        while (iter.hasNext()) {
            result = accumulator.apply(result, iter.next());
        }
        return result;
    }

    public <R, E extends Exception> R collect(Supplier<R> supplier, Try.BiConsumer<? super R, ? super T, E> accumulator) throws E {
        N.checkArgNotNull(supplier);
        N.checkArgNotNull(accumulator);
        R result = supplier.get();
        for (Object e : this.coll) {
            accumulator.accept(result, e);
        }
        return result;
    }

    public <A, R, E extends Exception, E2 extends Exception> R collect(Supplier<A> supplier, Try.BiConsumer<? super A, ? super T, E> accumulator, Try.Function<A, R, E2> finisher) throws E, E2 {
        N.checkArgNotNull(supplier);
        N.checkArgNotNull(accumulator);
        N.checkArgNotNull(finisher);
        A result = supplier.get();
        for (Object e : this.coll) {
            accumulator.accept(result, e);
        }
        return finisher.apply(result);
    }

    public <A, R> R collect(Collector<? super T, A, R> collector) {
        N.checkArgNotNull(collector);
        BiConsumer<A, A> accumulator = collector.accumulator();
        A result = collector.supplier().get();
        for (Object e : this.coll) {
            accumulator.accept(result, e);
        }
        return collector.finisher().apply(result);
    }

    public <A, R, RR, E extends Exception> RR collectThenApply(Collector<T, A, R> downstream, Try.Function<? super R, ? extends RR, E> mapper) throws E {
        return mapper.apply(this.collect(downstream));
    }

    public <A, R, E extends Exception> void collectThenAccept(Collector<T, A, R> downstream, Try.Consumer<? super R, E> consumer) throws E {
        consumer.accept(this.collect(downstream));
    }

    public List<T> append(T ... a) {
        if (N.isNullOrEmpty(a)) {
            return this.toList();
        }
        return this.append((Collection<? extends T>)Arrays.asList(a));
    }

    public List<T> append(Collection<? extends T> c) {
        return N.concat(this, c);
    }

    public List<T> prepend(T ... a) {
        if (N.isNullOrEmpty(a)) {
            return this.toList();
        }
        return this.prepend((Collection<? extends T>)Arrays.asList(a));
    }

    public List<T> prepend(Collection<? extends T> c) {
        return N.concat(c, this);
    }

    public <E extends Exception> List<T> merge(Collection<? extends T> b, Try.BiFunction<? super T, ? super T, Nth, E> nextSelector) throws E {
        return N.merge(this, b, nextSelector);
    }

    public <B, R, E extends Exception> List<R> zipWith(Collection<B> b, Try.BiFunction<? super T, ? super B, R, E> zipFunction) throws E {
        return N.zip(this, b, zipFunction);
    }

    public <B, R, E extends Exception> List<R> zipWith(Collection<B> b, T valueForNoneA, B valueForNoneB, Try.BiFunction<? super T, ? super B, R, E> zipFunction) throws E {
        return N.zip(this, b, valueForNoneA, valueForNoneB, zipFunction);
    }

    public <B, C, R, E extends Exception> List<R> zipWith(Collection<B> b, Collection<C> c, Try.TriFunction<? super T, ? super B, ? super C, R, E> zipFunction) throws E {
        return N.zip(this, b, c, zipFunction);
    }

    public <B, C, R, E extends Exception> List<R> zipWith(Collection<B> b, Collection<C> c, T valueForNoneA, B valueForNoneB, C valueForNoneC, Try.TriFunction<? super T, ? super B, ? super C, R, E> zipFunction) throws E {
        return N.zip(this, b, c, valueForNoneA, valueForNoneB, valueForNoneC, zipFunction);
    }

    public List<T> intersperse(T value) {
        if (this.isEmpty()) {
            return new ArrayList();
        }
        int size = this.size();
        ArrayList<Object> result = new ArrayList<Object>(size * 2 - 1);
        int idx = 0;
        for (Object e : this.coll) {
            result.add(e);
            if (++idx >= size) continue;
            result.add(value);
        }
        return result;
    }

    public List<Indexed<T>> indexed() {
        ArrayList<Indexed<T>> result = new ArrayList<Indexed<T>>(this.size());
        int idx = 0;
        for (Object e : this.coll) {
            result.add(Indexed.of(e, idx++));
        }
        return result;
    }

    public List<T> distinct() {
        return N.distinct(this.coll);
    }

    public <E extends Exception> List<T> distinctBy(Try.Function<? super T, ?, E> keyMapper) throws E {
        return N.distinctBy(this.coll, keyMapper);
    }

    public List<T> top(int n) {
        return N.top(this.coll, n);
    }

    public List<T> top(int n, Comparator<? super T> cmp) {
        return N.top(this.coll, n, cmp);
    }

    public List<List<T>> split(int chunkSize) {
        return N.split(this.coll, chunkSize);
    }

    public <U, E extends Exception> List<List<T>> split(Try.Predicate<? super T, E> predicate) throws E {
        return this.split(predicate, Fn.Suppliers.ofList());
    }

    public <U, C extends Collection<T>, E extends Exception> List<C> split(Try.Predicate<? super T, E> predicate, Supplier<? extends C> supplier) throws E {
        Object NONE;
        N.checkArgNotNull(predicate);
        N.checkArgNotNull(supplier);
        ArrayList<Collection> res = new ArrayList<Collection>();
        Iterator elements = this.iterator();
        Object next = NONE = N.NULL_MASK;
        boolean preCondition = false;
        while (next != NONE || elements.hasNext()) {
            Collection piece = (Collection)supplier.get();
            if (next == NONE) {
                next = elements.next();
            }
            while (next != NONE) {
                if (piece.size() == 0) {
                    piece.add(next);
                    preCondition = predicate.test(next);
                    next = elements.hasNext() ? elements.next() : NONE;
                    continue;
                }
                if (predicate.test(next) != preCondition) break;
                piece.add(next);
                next = elements.hasNext() ? elements.next() : NONE;
            }
            res.add(piece);
        }
        return res;
    }

    public <U, E extends Exception, E2 extends Exception> List<List<T>> split(U flag, Try.BiPredicate<? super T, ? super U, E> predicate, Try.Consumer<? super U, E2> flagUpdate) throws E, E2 {
        return this.split(flag, predicate, flagUpdate, Fn.Suppliers.ofList());
    }

    public <U, C extends Collection<T>, E extends Exception, E2 extends Exception> List<C> split(U flag, Try.BiPredicate<? super T, ? super U, E> predicate, Try.Consumer<? super U, E2> flagUpdate, Supplier<? extends C> supplier) throws E, E2 {
        Object NONE;
        N.checkArgNotNull(predicate);
        N.checkArgNotNull(flagUpdate);
        N.checkArgNotNull(supplier);
        ArrayList<Collection> res = new ArrayList<Collection>();
        Iterator elements = this.iterator();
        Object next = NONE = N.NULL_MASK;
        boolean preCondition = false;
        while (next != NONE || elements.hasNext()) {
            Collection piece = (Collection)supplier.get();
            if (next == NONE) {
                next = elements.next();
            }
            while (next != NONE) {
                if (piece.size() == 0) {
                    piece.add(next);
                    preCondition = predicate.test(next, flag);
                    next = elements.hasNext() ? elements.next() : NONE;
                    continue;
                }
                if (predicate.test(next, flag) == preCondition) {
                    piece.add(next);
                    next = elements.hasNext() ? elements.next() : NONE;
                    continue;
                }
                if (flagUpdate == null) break;
                flagUpdate.accept(flag);
                break;
            }
            res.add(piece);
        }
        return res;
    }

    public Pair<List<T>, List<T>> splitAt(int where) {
        N.checkArgNotNegative(where, "where");
        ArrayList left = null;
        ArrayList right = null;
        if (N.isNullOrEmpty(this.coll)) {
            left = new ArrayList();
            right = new ArrayList();
        } else if (where == 0) {
            left = new ArrayList();
            right = new ArrayList(this.coll);
        } else if (where >= this.coll.size()) {
            left = new ArrayList();
            right = new ArrayList(this.coll);
        } else if (this.coll instanceof List) {
            left = new ArrayList(((List)this.coll).subList(0, where));
            right = new ArrayList(((List)this.coll).subList(where, this.size()));
        } else {
            left = new ArrayList(where);
            right = new ArrayList(this.coll.size() - where);
            Iterator iter = this.coll.iterator();
            int cnt = 0;
            while (cnt++ < where) {
                left.add(iter.next());
            }
            while (iter.hasNext()) {
                right.add(iter.next());
            }
        }
        return Pair.of(left, right);
    }

    public <E extends Exception> Pair<List<T>, List<T>> splitBy(Try.Predicate<? super T, E> predicate) throws E {
        N.checkArgNotNull(predicate);
        ArrayList<Object> left = new ArrayList<Object>();
        ArrayList<Object> right = new ArrayList<Object>();
        Iterator iter = this.iterator();
        Object next = N.NULL_MASK;
        while (iter.hasNext() && predicate.test(next = iter.next())) {
            left.add(next);
            next = N.NULL_MASK;
        }
        if (next != N.NULL_MASK) {
            right.add(next);
        }
        while (iter.hasNext()) {
            right.add(iter.next());
        }
        return Pair.of(left, right);
    }

    public List<List<T>> sliding(int windowSize) {
        return this.sliding(windowSize, 1);
    }

    public List<List<T>> sliding(int windowSize, int increment) {
        N.checkArgument(windowSize > 0 && increment > 0, "windowSize=%s and increment=%s must be bigger than 0", windowSize, increment);
        Iterator iter = this.coll.iterator();
        ArrayList<List<T>> result = new ArrayList<List<T>>(this.coll.size() <= windowSize ? 1 : (1 + (this.coll.size() - windowSize)) / increment);
        while (iter.hasNext()) {
            if (increment > windowSize && result.size() > 0) {
                int skipNum = increment - windowSize;
                while (skipNum-- > 0 && iter.hasNext()) {
                    iter.next();
                }
                if (!iter.hasNext()) break;
            }
            ArrayList window = new ArrayList(windowSize);
            int cnt = 0;
            if (increment < windowSize && result.size() > 0) {
                List prev = (List)result.get(result.size() - 1);
                cnt = windowSize - increment;
                if (cnt <= 8) {
                    for (int i = windowSize - cnt; i < windowSize; ++i) {
                        window.add(prev.get(i));
                    }
                } else {
                    window.addAll(prev.subList(windowSize - cnt, windowSize));
                }
            }
            while (cnt++ < windowSize && iter.hasNext()) {
                window.add(iter.next());
            }
            result.add(window);
        }
        return result;
    }

    public String join() {
        return this.join(N.ELEMENT_SEPARATOR);
    }

    public String join(char delimiter) {
        return StringUtil.join(this.coll, delimiter);
    }

    public String join(String delimiter) {
        return StringUtil.join(this.coll, delimiter);
    }

    public <E extends Exception> String join(Try.Function<? super T, String, E> toStringFunc, String delimiter) throws E {
        if (N.isNullOrEmpty(this.coll)) {
            return N.EMPTY_STRING;
        }
        try (Joiner joiner = Joiner.with(delimiter).reuseCachedBuffer(true);){
            for (Object e : this.coll) {
                joiner.append(e);
            }
            String string = joiner.toString();
            return string;
        }
    }

    public u.Nullable<T> onlyOne() throws DuplicatedResultException {
        if (this.isEmpty()) {
            return u.Nullable.empty();
        }
        if (this.size() == 1) {
            return this.first();
        }
        throw new DuplicatedResultException(N.toString(this.coll));
    }

    @Override
    public boolean isEmpty() {
        return this.coll == null || this.coll.isEmpty();
    }

    @Override
    public int size() {
        return this.coll == null ? 0 : this.coll.size();
    }

    @Override
    public Object[] toArray() {
        return this.coll == null ? N.EMPTY_OBJECT_ARRAY : this.coll.toArray();
    }

    @Override
    public <A> A[] toArray(A[] a) {
        return this.coll == null ? a : this.coll.toArray(a);
    }

    public List<T> toList() {
        return this.coll == null ? new ArrayList() : new ArrayList(this.coll);
    }

    public Set<T> toSet() {
        return this.coll == null ? N.newHashSet() : N.newHashSet(this.coll);
    }

    public <C extends Collection<T>> C toCollection(IntFunction<? extends C> supplier) {
        Collection result = (Collection)supplier.apply(this.size());
        if (N.notNullOrEmpty(this.coll)) {
            result.addAll(this.coll);
        }
        return (C)result;
    }

    public Multiset<T> toMultiset() {
        Multiset result = new Multiset(N.initHashCapacity(this.size()));
        if (N.notNullOrEmpty(this.coll)) {
            result.addAll(this.coll);
        }
        return result;
    }

    public Multiset<T> toMultiset(IntFunction<Multiset<T>> supplier) {
        Multiset<T> result = supplier.apply(this.size());
        if (N.notNullOrEmpty(this.coll)) {
            result.addAll(this.coll);
        }
        return result;
    }

    public <K, V, E extends Exception, E2 extends Exception> Map<K, V> toMap(Try.Function<? super T, ? extends K, E> keyMapper, Try.Function<? super T, ? extends V, E2> valueMapper) throws E, E2 {
        return this.toMap(keyMapper, valueMapper, Fn.Factory.ofMap());
    }

    public <K, V, M extends Map<K, V>, E extends Exception, E2 extends Exception> M toMap(Try.Function<? super T, ? extends K, E> keyMapper, Try.Function<? super T, ? extends V, E2> valueMapper, IntFunction<? extends M> mapFactory) throws E, E2 {
        return this.toMap(keyMapper, valueMapper, Fn.throwingMerger(), mapFactory);
    }

    public <K, V, E extends Exception, E2 extends Exception, E3 extends Exception> Map<K, V> toMap(Try.Function<? super T, ? extends K, E> keyMapper, Try.Function<? super T, ? extends V, E2> valueMapper, Try.BinaryOperator<V, E3> mergeFunction) throws E, E2, E3 {
        return this.toMap(keyMapper, valueMapper, mergeFunction, Fn.Factory.ofMap());
    }

    public <K, V, M extends Map<K, V>, E extends Exception, E2 extends Exception, E3 extends Exception> M toMap(Try.Function<? super T, ? extends K, E> keyMapper, Try.Function<? super T, ? extends V, E2> valueMapper, Try.BinaryOperator<V, E3> mergeFunction, IntFunction<? extends M> mapFactory) throws E, E2, E3 {
        Map result = (Map)mapFactory.apply(this.size());
        for (Object e : this.coll) {
            Maps.merge(result, keyMapper.apply(e), valueMapper.apply(e), mergeFunction);
        }
        return (M)result;
    }

    public <K, A, D, E extends Exception> Map<K, D> toMap(Try.Function<? super T, ? extends K, E> keyMapper, Collector<? super T, A, D> downstream) throws E {
        return this.toMap(keyMapper, downstream, Fn.Factory.ofMap());
    }

    public <K, A, D, M extends Map<K, D>, E extends Exception> M toMap(Try.Function<? super T, ? extends K, E> keyMapper, Collector<? super T, A, D> downstream, IntFunction<? extends M> mapFactory) throws E {
        return this.toMap(keyMapper, Fn.Fnn.identity(), downstream, mapFactory);
    }

    public <K, V, A, D, E extends Exception, E2 extends Exception> Map<K, D> toMap(Try.Function<? super T, ? extends K, E> keyMapper, Try.Function<? super T, ? extends V, E2> valueMapper, Collector<? super V, A, D> downstream) throws E, E2 {
        return this.toMap(keyMapper, valueMapper, downstream, Fn.Factory.ofMap());
    }

    public <K, V, A, D, M extends Map<K, D>, E extends Exception, E2 extends Exception> M toMap(Try.Function<? super T, ? extends K, E> keyMapper, Try.Function<? super T, ? extends V, E2> valueMapper, final Collector<? super V, A, D> downstream, IntFunction<? extends M> mapFactory) throws E, E2 {
        Map result = (Map)mapFactory.apply(this.size());
        Supplier<A> downstreamSupplier = downstream.supplier();
        BiConsumer<A, Object> downstreamAccumulator = downstream.accumulator();
        Map intermediate = result;
        Object key = null;
        Object v = null;
        for (Object e : this.coll) {
            key = N.checkArgNotNull(keyMapper.apply(e), "element cannot be mapped to a null key");
            Object v2 = intermediate.get(key);
            v = v2;
            if (v2 == null) {
                A a = downstreamSupplier.get();
                v = a;
                if (a != null) {
                    intermediate.put(key, v);
                }
            }
            downstreamAccumulator.accept(v, valueMapper.apply(e));
        }
        BiFunction function = new BiFunction<K, A, A>(){

            @Override
            public A apply(K k, A v) {
                return downstream.finisher().apply(v);
            }
        };
        Maps.replaceAll(intermediate, function);
        return (M)result;
    }

    public <K, V, E extends Exception, E2 extends Exception> Map<K, V> flatToMap(Try.Function<? super T, ? extends Collection<? extends K>, E> flatKeyMapper, Try.BiFunction<? super K, ? super T, ? extends V, E2> valueMapper) throws E, E2 {
        return this.flatToMap(flatKeyMapper, valueMapper, Fn.Factory.ofMap());
    }

    public <K, V, M extends Map<K, V>, E extends Exception, E2 extends Exception> M flatToMap(Try.Function<? super T, ? extends Collection<? extends K>, E> flatKeyMapper, Try.BiFunction<? super K, ? super T, ? extends V, E2> valueMapper, IntFunction<? extends M> mapFactory) throws E, E2 {
        return this.flatToMap(flatKeyMapper, valueMapper, Fn.throwingMerger(), mapFactory);
    }

    public <K, V, E extends Exception, E2 extends Exception, E3 extends Exception> Map<K, V> flatToMap(Try.Function<? super T, ? extends Collection<? extends K>, E> flatKeyMapper, Try.BiFunction<? super K, ? super T, ? extends V, E2> valueMapper, Try.BinaryOperator<V, E3> mergeFunction) throws E, E2, E3 {
        return this.flatToMap(flatKeyMapper, valueMapper, mergeFunction, Fn.Factory.ofMap());
    }

    public <K, V, M extends Map<K, V>, E extends Exception, E2 extends Exception, E3 extends Exception> M flatToMap(Try.Function<? super T, ? extends Collection<? extends K>, E> flatKeyMapper, Try.BiFunction<? super K, ? super T, ? extends V, E2> valueMapper, Try.BinaryOperator<V, E3> mergeFunction, IntFunction<? extends M> mapFactory) throws E, E2, E3 {
        Map result = (Map)mapFactory.apply(this.size());
        Collection<K> keys = null;
        for (Object e : this.coll) {
            keys = flatKeyMapper.apply(e);
            if (!N.notNullOrEmpty(keys)) continue;
            for (K k : keys) {
                Maps.merge(result, k, valueMapper.apply(k, e), mergeFunction);
            }
        }
        return (M)result;
    }

    public <K, A, D, E extends Exception> Map<K, D> flatToMap(Try.Function<? super T, ? extends Collection<? extends K>, E> flatKeyMapper, Collector<? super T, A, D> downstream) throws E {
        return this.flatToMap(flatKeyMapper, downstream, Fn.Factory.ofMap());
    }

    public <K, A, D, M extends Map<K, D>, E extends Exception> Map<K, D> flatToMap(Try.Function<? super T, ? extends Collection<? extends K>, E> flatKeyMapper, Collector<? super T, A, D> downstream, IntFunction<? extends M> mapFactory) throws E {
        return this.flatToMap(flatKeyMapper, Fn.BiFunctions.returnSecond(), downstream, mapFactory);
    }

    public <K, V, A, D, E extends Exception, E2 extends Exception> Map<K, D> flatToMap(Try.Function<? super T, ? extends Collection<? extends K>, E> flatKeyMapper, Try.BiFunction<? super K, ? super T, ? extends V, E2> valueMapper, Collector<? super V, A, D> downstream) throws E, E2 {
        return this.flatToMap(flatKeyMapper, valueMapper, downstream, Fn.Factory.ofMap());
    }

    public <K, V, A, D, M extends Map<K, D>, E extends Exception, E2 extends Exception> M flatToMap(Try.Function<? super T, ? extends Collection<? extends K>, E> flatKeyMapper, Try.BiFunction<? super K, ? super T, ? extends V, E2> valueMapper, final Collector<? super V, A, D> downstream, IntFunction<? extends M> mapFactory) throws E, E2 {
        Map result = (Map)mapFactory.apply(this.size());
        Supplier<A> downstreamSupplier = downstream.supplier();
        BiConsumer<A, Object> downstreamAccumulator = downstream.accumulator();
        Map intermediate = result;
        Collection<K> keys = null;
        Object v = null;
        for (Object e : this.coll) {
            keys = flatKeyMapper.apply(e);
            if (!N.notNullOrEmpty(keys)) continue;
            for (K k : keys) {
                N.checkArgNotNull(k, "element cannot be mapped to a null key");
                Object v2 = intermediate.get(k);
                v = v2;
                if (v2 == null) {
                    A a = downstreamSupplier.get();
                    v = a;
                    if (a != null) {
                        intermediate.put(k, v);
                    }
                }
                downstreamAccumulator.accept(v, valueMapper.apply(k, e));
            }
        }
        BiFunction function = new BiFunction<K, A, A>(){

            @Override
            public A apply(K k, A v) {
                return downstream.finisher().apply(v);
            }
        };
        Maps.replaceAll(intermediate, function);
        return (M)result;
    }

    public <K, E extends Exception> Map<K, List<T>> groupTo(Try.Function<? super T, ? extends K, E> keyMapper) throws E {
        return this.groupTo(keyMapper, Fn.Factory.ofMap());
    }

    public <K, M extends Map<K, List<T>>, E extends Exception> M groupTo(Try.Function<? super T, ? extends K, E> keyMapper, IntFunction<? extends M> mapFactory) throws E {
        Map result = (Map)mapFactory.apply(this.size());
        Object key = null;
        ArrayList values = null;
        for (Object e : this.coll) {
            key = keyMapper.apply(e);
            values = (ArrayList)result.get(key);
            if (values == null) {
                values = new ArrayList();
                result.put(key, values);
            }
            values.add(e);
        }
        return (M)result;
    }

    public <K, V, E extends Exception, E2 extends Exception> Map<K, List<V>> groupTo(Try.Function<? super T, ? extends K, E> keyMapper, Try.Function<? super T, ? extends V, E2> valueMapper) throws E, E2 {
        return this.groupTo(keyMapper, valueMapper, Fn.Factory.ofMap());
    }

    public <K, V, M extends Map<K, List<V>>, E extends Exception, E2 extends Exception> M groupTo(Try.Function<? super T, ? extends K, E> keyMapper, Try.Function<? super T, ? extends V, E2> valueMapper, IntFunction<? extends M> mapFactory) throws E, E2 {
        Map result = (Map)mapFactory.apply(this.size());
        Object key = null;
        ArrayList<V> values = null;
        for (Object e : this.coll) {
            key = keyMapper.apply(e);
            values = (ArrayList<V>)result.get(key);
            if (values == null) {
                values = new ArrayList<V>();
                result.put(key, values);
            }
            values.add(valueMapper.apply(e));
        }
        return (M)result;
    }

    public <K, E extends Exception> Map<K, List<T>> flatGroupTo(Try.Function<? super T, ? extends Collection<? extends K>, E> flatKeyMapper) throws E {
        return this.flatGroupTo(flatKeyMapper, Fn.Factory.ofMap());
    }

    public <K, M extends Map<K, List<T>>, E extends Exception> M flatGroupTo(Try.Function<? super T, ? extends Collection<? extends K>, E> flatKeyMapper, IntFunction<? extends M> mapFactory) throws E {
        Map result = (Map)mapFactory.apply(this.size());
        Collection<K> keys = null;
        ArrayList values = null;
        for (Object e : this.coll) {
            keys = flatKeyMapper.apply(e);
            if (!N.notNullOrEmpty(keys)) continue;
            for (K k : keys) {
                values = (ArrayList)result.get(k);
                if (values == null) {
                    values = new ArrayList();
                    result.put(k, values);
                }
                values.add(e);
            }
        }
        return (M)result;
    }

    public <K, V, E extends Exception, E2 extends Exception> Map<K, List<V>> flatGroupTo(Try.Function<? super T, ? extends Collection<? extends K>, E> flatKeyMapper, Try.BiFunction<? super K, ? super T, ? extends V, E2> valueMapper) throws E, E2 {
        return this.flatGroupTo(flatKeyMapper, valueMapper, Fn.Factory.ofMap());
    }

    public <K, V, M extends Map<K, List<V>>, E extends Exception, E2 extends Exception> M flatGroupTo(Try.Function<? super T, ? extends Collection<? extends K>, E> flatKeyMapper, Try.BiFunction<? super K, ? super T, ? extends V, E2> valueMapper, IntFunction<? extends M> mapFactory) throws E, E2 {
        Map result = (Map)mapFactory.apply(this.size());
        Collection<K> keys = null;
        ArrayList<V> values = null;
        for (Object e : this.coll) {
            keys = flatKeyMapper.apply(e);
            if (!N.notNullOrEmpty(keys)) continue;
            for (K k : keys) {
                values = (ArrayList<V>)result.get(k);
                if (values == null) {
                    values = new ArrayList<V>();
                    result.put(k, values);
                }
                values.add(valueMapper.apply(k, e));
            }
        }
        return (M)result;
    }

    public <K, E extends Exception> ListMultimap<K, T> toMultimap(Try.Function<? super T, ? extends K, E> keyMapper) throws E {
        return this.toMultimap(keyMapper, Fn.Factory.ofListMultimap());
    }

    public <K, V extends Collection<T>, M extends Multimap<K, T, V>, E extends Exception> M toMultimap(Try.Function<? super T, ? extends K, E> keyMapper, IntFunction<? extends M> mapFactory) throws E {
        Multimap result = (Multimap)mapFactory.apply(this.size());
        for (Object e : this.coll) {
            result.put(keyMapper.apply(e), e);
        }
        return (M)result;
    }

    public <K, V, E extends Exception, E2 extends Exception> ListMultimap<K, V> toMultimap(Try.Function<? super T, ? extends K, E> keyMapper, Try.Function<? super T, ? extends V, E2> valueMapper) throws E, E2 {
        return this.toMultimap(keyMapper, valueMapper, Fn.Factory.ofListMultimap());
    }

    public <K, V, C extends Collection<V>, M extends Multimap<K, V, C>, E extends Exception, E2 extends Exception> M toMultimap(Try.Function<? super T, ? extends K, E> keyMapper, Try.Function<? super T, ? extends V, E2> valueMapper, IntFunction<? extends M> mapFactory) throws E, E2 {
        Multimap result = (Multimap)mapFactory.apply(this.size());
        for (Object e : this.coll) {
            result.put(keyMapper.apply(e), valueMapper.apply(e));
        }
        return (M)result;
    }

    public <K, E extends Exception> ListMultimap<K, T> flatToMultimap(Try.Function<? super T, ? extends Collection<? extends K>, E> flatKeyMapper) throws E {
        return this.flatToMultimap(flatKeyMapper, Fn.Factory.ofListMultimap());
    }

    public <K, V extends Collection<T>, M extends Multimap<K, T, V>, E extends Exception> M flatToMultimap(Try.Function<? super T, ? extends Collection<? extends K>, E> flatKeyMapper, IntFunction<? extends M> mapFactory) throws E {
        Multimap result = (Multimap)mapFactory.apply(this.size());
        Collection<K> ks = null;
        for (Object e : this.coll) {
            ks = flatKeyMapper.apply(e);
            if (!N.notNullOrEmpty(ks)) continue;
            for (K k : ks) {
                result.put(k, e);
            }
        }
        return (M)result;
    }

    public <K, V, E extends Exception, E2 extends Exception> ListMultimap<K, V> flatToMultimap(Try.Function<? super T, ? extends Collection<? extends K>, E> flatKeyMapper, Try.BiFunction<? super K, ? super T, ? extends V, E2> valueMapper) throws E, E2 {
        return this.flatToMultimap(flatKeyMapper, valueMapper, Fn.Factory.ofListMultimap());
    }

    public <K, V, C extends Collection<V>, M extends Multimap<K, V, C>, E extends Exception, E2 extends Exception> M flatToMultimap(Try.Function<? super T, ? extends Collection<? extends K>, E> flatKeyMapper, Try.BiFunction<? super K, ? super T, ? extends V, E2> valueMapper, IntFunction<? extends M> mapFactory) throws E, E2 {
        Multimap result = (Multimap)mapFactory.apply(this.size());
        Collection<K> ks = null;
        for (Object e : this.coll) {
            ks = flatKeyMapper.apply(e);
            if (!N.notNullOrEmpty(ks)) continue;
            for (K k : ks) {
                result.put(k, valueMapper.apply(k, e));
            }
        }
        return (M)result;
    }

    public <U, E extends Exception, E2 extends Exception> List<Pair<T, U>> innerJoin(Collection<U> b, Try.Function<? super T, ?, E> leftKeyMapper, Try.Function<? super U, ?, E2> rightKeyMapper) throws E, E2 {
        ArrayList<Pair<T, U>> result = new ArrayList<Pair<T, U>>(N.min(9, this.size(), N.size(b)));
        if (N.isNullOrEmpty(this.coll) || N.isNullOrEmpty(b)) {
            return result;
        }
        ListMultimap<?, U> rightKeyMap = ListMultimap.from(b, rightKeyMapper);
        for (Object left : this.coll) {
            List rights = (List)rightKeyMap.get(leftKeyMapper.apply(left));
            if (!N.notNullOrEmpty(rights)) continue;
            for (Object right : rights) {
                result.add(Pair.of(left, right));
            }
        }
        return result;
    }

    public <U, E extends Exception> List<Pair<T, U>> innerJoin(Collection<U> b, Try.BiPredicate<? super T, ? super U, E> predicate) throws E {
        ArrayList<Pair<T, U>> result = new ArrayList<Pair<T, U>>(N.min(9, this.size(), N.size(b)));
        if (N.isNullOrEmpty(this.coll) || N.isNullOrEmpty(b)) {
            return result;
        }
        for (Object left : this.coll) {
            for (U right : b) {
                if (!predicate.test(left, right)) continue;
                result.add(Pair.of(left, right));
            }
        }
        return result;
    }

    public <U, E extends Exception, E2 extends Exception> List<Pair<T, U>> fullJoin(Collection<U> b, Try.Function<? super T, ?, E> leftKeyMapper, Try.Function<? super U, ?, E2> rightKeyMapper) throws E, E2 {
        ArrayList<Pair<T, U>> result = new ArrayList<Pair<T, U>>(N.max(9, this.size(), N.size(b)));
        if (N.isNullOrEmpty(this.coll)) {
            for (Object left : this.coll) {
                result.add(Pair.of(left, null));
            }
        } else if (N.isNullOrEmpty(b)) {
            for (U right : b) {
                result.add(Pair.of(null, right));
            }
        } else {
            ListMultimap<?, U> rightKeyMap = ListMultimap.from(b, rightKeyMapper);
            IdentityHashMap joinedRights = new IdentityHashMap();
            for (Object left : this.coll) {
                List rights = (List)rightKeyMap.get(leftKeyMapper.apply(left));
                if (N.notNullOrEmpty(rights)) {
                    for (Object right : rights) {
                        result.add(Pair.of(left, right));
                        joinedRights.put(right, right);
                    }
                    continue;
                }
                result.add(Pair.of(left, null));
            }
            for (Object right : b) {
                if (joinedRights.containsKey(right)) continue;
                result.add(Pair.of(null, right));
            }
        }
        return result;
    }

    public <U, E extends Exception> List<Pair<T, U>> fullJoin(Collection<U> b, Try.BiPredicate<? super T, ? super U, E> predicate) throws E {
        ArrayList<Pair<T, U>> result = new ArrayList<Pair<T, U>>(N.max(9, this.size(), N.size(b)));
        if (N.isNullOrEmpty(this.coll)) {
            for (Object left : this.coll) {
                result.add(Pair.of(left, null));
            }
        } else if (N.isNullOrEmpty(b)) {
            for (U right : b) {
                result.add(Pair.of(null, right));
            }
        } else {
            IdentityHashMap<U, U> joinedRights = new IdentityHashMap<U, U>();
            for (Object left : this.coll) {
                boolean joined = false;
                for (U right : b) {
                    if (!predicate.test(left, right)) continue;
                    result.add(Pair.of(left, right));
                    joinedRights.put(right, right);
                    joined = true;
                }
                if (joined) continue;
                result.add(Pair.of(left, null));
            }
            for (Object right : b) {
                if (joinedRights.containsKey(right)) continue;
                result.add(Pair.of(null, right));
            }
        }
        return result;
    }

    public <U, E extends Exception, E2 extends Exception> List<Pair<T, U>> leftJoin(Collection<U> b, Try.Function<? super T, ?, E> leftKeyMapper, Try.Function<? super U, ?, E2> rightKeyMapper) throws E, E2 {
        ArrayList<Pair<T, U>> result = new ArrayList<Pair<T, U>>(this.size());
        if (N.isNullOrEmpty(this.coll)) {
            return result;
        }
        if (N.isNullOrEmpty(b)) {
            for (Object left : this.coll) {
                result.add(Pair.of(left, null));
            }
        } else {
            ListMultimap<?, U> rightKeyMap = ListMultimap.from(b, rightKeyMapper);
            for (Object left : this.coll) {
                List rights = (List)rightKeyMap.get(leftKeyMapper.apply(left));
                if (N.notNullOrEmpty(rights)) {
                    for (Object right : rights) {
                        result.add(Pair.of(left, right));
                    }
                    continue;
                }
                result.add(Pair.of(left, null));
            }
        }
        return result;
    }

    public <U, E extends Exception> List<Pair<T, U>> leftJoin(Collection<U> b, Try.BiPredicate<? super T, ? super U, E> predicate) throws E {
        ArrayList<Pair<T, U>> result = new ArrayList<Pair<T, U>>(this.size());
        if (N.isNullOrEmpty(this.coll)) {
            return result;
        }
        if (N.isNullOrEmpty(b)) {
            for (Object left : this.coll) {
                result.add(Pair.of(left, null));
            }
        } else {
            for (Object left : this.coll) {
                boolean joined = false;
                for (U right : b) {
                    if (!predicate.test(left, right)) continue;
                    result.add(Pair.of(left, right));
                    joined = true;
                }
                if (joined) continue;
                result.add(Pair.of(left, null));
            }
        }
        return result;
    }

    public <U, E extends Exception, E2 extends Exception> List<Pair<T, U>> rightJoin(Collection<U> b, Try.Function<? super T, ?, E> leftKeyMapper, Try.Function<? super U, ?, E2> rightKeyMapper) throws E, E2 {
        ArrayList<Pair<T, U>> result = new ArrayList<Pair<T, U>>(N.size(b));
        if (N.isNullOrEmpty(b)) {
            return result;
        }
        if (N.isNullOrEmpty(this.coll)) {
            for (U right : b) {
                result.add(Pair.of(null, right));
            }
        } else {
            ListMultimap<?, T> leftKeyMap = ListMultimap.from(this.coll, leftKeyMapper);
            for (U right : b) {
                List lefts = (List)leftKeyMap.get(rightKeyMapper.apply(right));
                if (N.notNullOrEmpty(lefts)) {
                    for (Object left : lefts) {
                        result.add(Pair.of(left, right));
                    }
                    continue;
                }
                result.add(Pair.of(null, right));
            }
        }
        return result;
    }

    public <U, E extends Exception> List<Pair<T, U>> rightJoin(Collection<U> b, Try.BiPredicate<? super T, ? super U, E> predicate) throws E {
        ArrayList<Pair<T, U>> result = new ArrayList<Pair<T, U>>(N.size(b));
        if (N.isNullOrEmpty(b)) {
            return result;
        }
        if (N.isNullOrEmpty(this.coll)) {
            for (U right : b) {
                result.add(Pair.of(null, right));
            }
        } else {
            for (U right : b) {
                boolean joined = false;
                for (Object left : this.coll) {
                    if (!predicate.test(left, right)) continue;
                    result.add(Pair.of(left, right));
                    joined = true;
                }
                if (joined) continue;
                result.add(Pair.of(null, right));
            }
        }
        return result;
    }

    public Seq<T> slice(int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, this.size());
        if (N.isNullOrEmpty(this.coll)) {
            return this;
        }
        if (this.coll instanceof List) {
            return new Seq(((List)this.coll).subList(fromIndex, toIndex));
        }
        return new Seq(new SubCollection(this.coll, fromIndex, toIndex));
    }

    @Override
    public ObjIterator<T> iterator() {
        return ObjIterator.of(this.coll);
    }

    public <R, E extends Exception> R apply(Try.Function<? super Seq<T>, R, E> func) throws E {
        return func.apply(this);
    }

    public <R, E extends Exception> u.Optional<R> applyIfNotEmpty(Try.Function<? super Seq<T>, R, E> func) throws E {
        return this.isEmpty() ? u.Optional.empty() : u.Optional.ofNullable(func.apply(this));
    }

    public <E extends Exception> void accept(Try.Consumer<? super Seq<T>, E> action) throws E {
        action.accept(this);
    }

    public <E extends Exception> void acceptIfNotEmpty(Try.Consumer<? super Seq<T>, E> action) throws E {
        if (this.size() > 0) {
            action.accept(this);
        }
    }

    public void println() {
        N.println(this.toString());
    }

    @Override
    public int hashCode() {
        return this.coll == null ? 0 : this.coll.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Seq) {
            Seq other = (Seq)obj;
            return N.equals(this.coll, other.coll);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.coll == null ? N.NULL_STRING : this.coll.toString();
    }

    private static final class SubCollection<E>
    implements Collection<E> {
        private final Collection<E> c;
        private final int fromIndex;
        private final int toIndex;

        SubCollection(Collection<E> c, int fromIndex, int toIndex) {
            this.c = c;
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            Iterator<E> iter = this.iterator();
            while (iter.hasNext()) {
                if (!N.equals(iter.next(), o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object e : c) {
                if (this.contains(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public int size() {
            return this.toIndex - this.fromIndex;
        }

        @Override
        public Iterator<E> iterator() {
            ObjIterator iter;
            Iterator<Object> iterator = iter = this.c == null ? ObjIterator.empty() : this.c.iterator();
            if (this.fromIndex > 0) {
                int offset = 0;
                while (offset++ < this.fromIndex) {
                    iter.next();
                }
            }
            return new Iterator<E>(){
                private int cursor;
                {
                    this.cursor = SubCollection.this.fromIndex;
                }

                @Override
                public boolean hasNext() {
                    return this.cursor < SubCollection.this.toIndex;
                }

                @Override
                public E next() {
                    if (this.cursor >= SubCollection.this.toIndex) {
                        throw new NoSuchElementException();
                    }
                    ++this.cursor;
                    return iter.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Object[] toArray() {
            Iterator<E> iter = this.iterator();
            Object[] a = new Object[this.size()];
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                a[i] = iter.next();
            }
            return a;
        }

        @Override
        public <A> A[] toArray(A[] a) {
            if (a.length < this.size()) {
                a = N.copyOf(a, this.size());
            }
            Iterator<E> iter = this.iterator();
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                a[i] = iter.next();
            }
            return a;
        }
    }
}

