/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.annotation.Internal;
import com.landawn.abacus.util.ImmutableMap;
import com.landawn.abacus.util.ImmutableSet;
import com.landawn.abacus.util.Maps;
import com.landawn.abacus.util.Multimap;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Try;
import com.landawn.abacus.util.function.IntFunction;
import com.landawn.abacus.util.function.Supplier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class SetMultimap<K, E>
extends Multimap<K, E, Set<E>> {
    SetMultimap() {
        this((Class<Map>)HashMap.class, (Class<Set>)HashSet.class);
    }

    SetMultimap(int initialCapacity) {
        this(new HashMap(initialCapacity), HashSet.class);
    }

    SetMultimap(Class<? extends Map> mapType, Class<? extends Set> valueType) {
        super(mapType, valueType);
    }

    SetMultimap(Supplier<? extends Map<K, Set<E>>> mapSupplier, Supplier<? extends Set<E>> valueSupplier) {
        super(mapSupplier, valueSupplier);
    }

    @Internal
    SetMultimap(Map<K, Set<E>> valueMap, Class<? extends Set> valueType) {
        super(valueMap, SetMultimap.valueType2Supplier(valueType));
    }

    @Internal
    SetMultimap(Map<K, Set<E>> valueMap, Supplier<? extends Set<E>> valueSupplier) {
        super(valueMap, valueSupplier);
    }

    public static <K, E> SetMultimap<K, E> of(K k1, E v1) {
        SetMultimap<K, E> map = new SetMultimap<K, E>();
        map.put(k1, v1);
        return map;
    }

    public static <K, E> SetMultimap<K, E> of(K k1, E v1, K k2, E v2) {
        SetMultimap<K, E> map = new SetMultimap<K, E>();
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public static <K, E> SetMultimap<K, E> of(K k1, E v1, K k2, E v2, K k3, E v3) {
        SetMultimap<K, E> map = new SetMultimap<K, E>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public static <K, E> SetMultimap<K, E> of(K k1, E v1, K k2, E v2, K k3, E v3, K k4, E v4) {
        SetMultimap<K, E> map = new SetMultimap<K, E>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public static <K, E> SetMultimap<K, E> of(K k1, E v1, K k2, E v2, K k3, E v3, K k4, E v4, K k5, E v5) {
        SetMultimap<K, E> map = new SetMultimap<K, E>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public static <K, E> SetMultimap<K, E> of(K k1, E v1, K k2, E v2, K k3, E v3, K k4, E v4, K k5, E v5, K k6, E v6) {
        SetMultimap<K, E> map = new SetMultimap<K, E>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        return map;
    }

    public static <K, E> SetMultimap<K, E> of(K k1, E v1, K k2, E v2, K k3, E v3, K k4, E v4, K k5, E v5, K k6, E v6, K k7, E v7) {
        SetMultimap<K, E> map = new SetMultimap<K, E>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        return map;
    }

    public static <K, E> SetMultimap<K, E> from(Map<? extends K, ? extends E> map) {
        SetMultimap<? extends K, ? extends E> multimap = new SetMultimap<K, E>(Maps.newTargetMap(map), HashSet.class);
        if (N.notNullOrEmpty(map)) {
            multimap.putAll(map);
        }
        return multimap;
    }

    public static <K, E> SetMultimap<K, E> fromm(Map<? extends K, ? extends Collection<? extends E>> map) {
        SetMultimap<K, ? extends E> multimap = new SetMultimap<K, E>(Maps.newTargetMap(map), HashSet.class);
        if (N.notNullOrEmpty(map)) {
            for (Map.Entry<K, Collection<E>> entry : map.entrySet()) {
                multimap.putAll(entry.getKey(), entry.getValue());
            }
        }
        return multimap;
    }

    public static <T, K, X extends Exception> SetMultimap<K, T> from(Collection<? extends T> c, Try.Function<? super T, ? extends K, X> keyMapper) throws X {
        N.checkArgNotNull(keyMapper);
        SetMultimap<K, T> multimap = N.newSetMultimap(N.initHashCapacity(c == null ? 0 : c.size()));
        if (N.notNullOrEmpty(c)) {
            for (T e : c) {
                multimap.put(keyMapper.apply(e), e);
            }
        }
        return multimap;
    }

    public static <T, K, E, X extends Exception, X2 extends Exception> SetMultimap<K, E> from(Collection<? extends T> c, Try.Function<? super T, ? extends K, X> keyMapper, Try.Function<? super T, ? extends E, X2> valueExtractor) throws X, X2 {
        N.checkArgNotNull(keyMapper);
        N.checkArgNotNull(valueExtractor);
        SetMultimap<K, E> multimap = N.newSetMultimap(N.initHashCapacity(c == null ? 0 : c.size()));
        if (N.notNullOrEmpty(c)) {
            for (T e : c) {
                multimap.put(keyMapper.apply(e), valueExtractor.apply(e));
            }
        }
        return multimap;
    }

    public static <K, E> SetMultimap<E, K> invertFrom(Map<K, E> map) {
        SetMultimap<E, K> multimap = new SetMultimap<E, K>(Maps.newOrderingMap(map), HashSet.class);
        if (N.notNullOrEmpty(map)) {
            for (Map.Entry<K, E> entry : map.entrySet()) {
                multimap.put(entry.getValue(), entry.getKey());
            }
        }
        return multimap;
    }

    public static <K, E> SetMultimap<E, K> flatInvertFrom(Map<K, ? extends Collection<? extends E>> map) {
        SetMultimap<E, K> multimap = new SetMultimap<E, K>(Maps.newOrderingMap(map), HashSet.class);
        if (N.notNullOrEmpty(map)) {
            for (Map.Entry<K, Collection<E>> entry : map.entrySet()) {
                Collection<E> c = entry.getValue();
                if (!N.notNullOrEmpty(c)) continue;
                for (E e : c) {
                    multimap.put(e, entry.getKey());
                }
            }
        }
        return multimap;
    }

    public static <K, E, V extends Collection<E>> SetMultimap<E, K> invertFrom(Multimap<K, E, V> map) {
        SetMultimap multimap = new SetMultimap(Maps.newOrderingMap(map.valueMap), HashSet.class);
        if (N.notNullOrEmpty(map)) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                Collection c = (Collection)entry.getValue();
                if (!N.notNullOrEmpty(c)) continue;
                for (Object e : c) {
                    multimap.put(e, entry.getKey());
                }
            }
        }
        return multimap;
    }

    public static <K, E> SetMultimap<K, E> concat(Map<? extends K, ? extends E> a, Map<? extends K, ? extends E> b) {
        if (a == null) {
            return b == null ? N.newSetMultimap() : SetMultimap.from(b);
        }
        SetMultimap<? extends K, ? extends E> res = SetMultimap.from(a);
        res.putAll(b);
        return res;
    }

    public static <K, E> SetMultimap<K, E> concat(Map<? extends K, ? extends E> a, Map<? extends K, ? extends E> b, Map<? extends K, ? extends E> c) {
        if (a == null) {
            if (b == null) {
                return c == null ? N.newSetMultimap() : SetMultimap.from(c);
            }
            SetMultimap<? extends K, ? extends E> res = SetMultimap.from(b);
            res.putAll(c);
            return res;
        }
        SetMultimap<Object, Object> res = SetMultimap.from(a);
        res.putAll(b);
        res.putAll(c);
        return res;
    }

    public static <K, E, V extends Set<E>> SetMultimap<K, E> wrap(Map<K, V> map) {
        N.checkArgNotNull(map);
        N.checkArgument(N.anyNull(map.values()), "The specified map contains null value: %s", map);
        Class valueType = HashSet.class;
        for (Set v : map.values()) {
            if (v == null) continue;
            valueType = v.getClass();
            break;
        }
        return new SetMultimap<K, E>(map, valueType);
    }

    public static <K, E, V extends Set<E>> SetMultimap<K, E> wrapp(Map<K, V> map, Supplier<? extends V> valueSupplier) {
        N.checkArgNotNull(map, "map");
        N.checkArgNotNull(valueSupplier, "valueSupplier");
        return new SetMultimap<K, E>(map, valueSupplier);
    }

    @Deprecated
    public static <K, E, V extends Collection<E>, M extends Multimap<K, E, V>> M from(Map<? extends K, ? extends E> map, IntFunction<? extends M> multimapSupplier) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static <K, E, V extends Collection<E>, M extends Multimap<K, E, V>> M fromm(Map<? extends K, ? extends Collection<? extends E>> map, IntFunction<? extends M> multimapSupplier) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static <T, K, V extends Collection<T>, M extends Multimap<K, T, V>, X extends Exception> M from(Collection<? extends T> c, Try.Function<? super T, ? extends K, X> keyMapper, IntFunction<? extends M> multimapSupplier) throws X {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static <T, K, E, V extends Collection<E>, M extends Multimap<K, E, V>, X extends Exception, X2 extends Exception> M from(Collection<? extends T> c, Try.Function<? super T, ? extends K, X> keyMapper, Try.Function<? super T, ? extends E, X2> valueExtractor, IntFunction<? extends M> multimapSupplier) throws X, X2 {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static <K, E, V extends Collection<K>, M extends Multimap<E, K, V>> M invertFrom(Map<K, E> map, IntFunction<? extends M> multimapSupplier) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static <K, E, V extends Collection<K>, M extends Multimap<E, K, V>> M flatInvertFrom(Map<K, ? extends Collection<? extends E>> map, IntFunction<? extends M> multimapSupplier) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static <K, E, V extends Collection<E>, VV extends Collection<K>, M extends Multimap<E, K, VV>> M invertFrom(Multimap<K, E, V> multimap, IntFunction<? extends M> multimapSupplier) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static <K, E, V extends Collection<E>, M extends Multimap<K, E, V>> M concat(Map<? extends K, ? extends E> a, Map<? extends K, ? extends E> b, IntFunction<? extends M> multimapSupplier) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static <K, E, V extends Collection<E>, M extends Multimap<K, E, V>> M concat(Map<? extends K, ? extends E> a, Map<? extends K, ? extends E> b, Map<? extends K, ? extends E> c, IntFunction<? extends M> multimapSupplier) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static <K, E, V extends Collection<E>> Multimap<K, E, V> wrap(Map<K, V> map, Supplier<? extends V> valueSupplier) {
        throw new UnsupportedOperationException();
    }

    public <X extends Exception> SetMultimap<K, E> filterByKey(Try.Predicate<? super K, X> filter) throws X {
        SetMultimap<K, E> result = new SetMultimap<K, E>(this.mapSupplier, this.valueSupplier);
        for (Map.Entry entry : this.valueMap.entrySet()) {
            if (!filter.test(entry.getKey())) continue;
            result.valueMap.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public <X extends Exception> SetMultimap<K, E> filterByValue(Try.Predicate<? super Set<E>, X> filter) throws X {
        SetMultimap<K, E> result = new SetMultimap<K, E>(this.mapSupplier, this.valueSupplier);
        for (Map.Entry entry : this.valueMap.entrySet()) {
            if (!filter.test((Set<E>)entry.getValue())) continue;
            result.valueMap.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public <X extends Exception> SetMultimap<K, E> filter(Try.BiPredicate<? super K, ? super Set<E>, X> filter) throws X {
        SetMultimap<K, E> result = new SetMultimap<K, E>(this.mapSupplier, this.valueSupplier);
        for (Map.Entry entry : this.valueMap.entrySet()) {
            if (!filter.test(entry.getKey(), (Set<E>)entry.getValue())) continue;
            result.valueMap.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public SetMultimap<K, E> copy() {
        SetMultimap<K, E> copy = new SetMultimap<K, E>(this.mapSupplier, this.valueSupplier);
        copy.putAll(this);
        return copy;
    }

    public ImmutableMap<K, ImmutableSet<E>> toImmutableMap() {
        Map map = Maps.newOrderingMap(this.valueMap);
        for (Map.Entry entry : this.valueMap.entrySet()) {
            map.put(entry.getKey(), ImmutableSet.copyOf((Collection)entry.getValue()));
        }
        return ImmutableMap.of(map);
    }

    public ImmutableMap<K, ImmutableSet<E>> toImmutableMap(IntFunction<? extends Map<K, ImmutableSet<E>>> mapSupplier) {
        Map map = mapSupplier.apply(this.valueMap.size());
        for (Map.Entry entry : this.valueMap.entrySet()) {
            map.put(entry.getKey(), ImmutableSet.copyOf((Collection)entry.getValue()));
        }
        return ImmutableMap.of(map);
    }
}

