/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.annotation.Beta;
import com.landawn.abacus.annotation.Internal;
import com.landawn.abacus.util.Array;
import com.landawn.abacus.util.Joiner;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.Splitter;
import com.landawn.abacus.util.function.IntUnaryOperator;
import com.landawn.abacus.util.u;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.RandomAccess;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public abstract class StringUtil {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(?: |\\u00A0|\\s|[\\s&&[^ ]])\\s*");
    private static final Map<Object, Splitter> splitterPool = new HashMap<Object, Splitter>();
    private static final Map<Object, Splitter> trimSplitterPool = new HashMap<Object, Splitter>();
    private static final Map<Object, Splitter> preserveSplitterPool = new HashMap<Object, Splitter>();
    private static final Map<Object, Splitter> trimPreserveSplitterPool = new HashMap<Object, Splitter>();
    static final Field strValueField;
    static volatile boolean isStringCharsGettable;
    static final Constructor<String> sharedStringConstructor;
    private static final Pattern pattern_accent;
    private static boolean[] alphanumerics;

    private StringUtil() {
    }

    public static String abbreviate(String str, int maxWidth) {
        if (maxWidth < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        return str.length() <= maxWidth ? str : str.substring(0, maxWidth - 3) + "...";
    }

    public static String reverse(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            sb.append(str);
            String string = sb.reverse().toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String reverseDelimited(String str, char delimiter) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        Object[] strs = StringUtil.split(str, delimiter);
        N.reverse(strs);
        return StringUtil.join(strs, delimiter);
    }

    public static String reverseDelimited(String str, String delimiter) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        Object[] strs = StringUtil.split(str, delimiter);
        N.reverse(strs);
        return Joiner.with(delimiter).reuseCachedBuffer(true).appendAll(strs).toString();
    }

    public static String padStart(String str, int minLength) {
        return StringUtil.padStart(str, minLength, ' ');
    }

    public static String padStart(String str, int minLength, char padChar) {
        if (str == null) {
            str = N.EMPTY_STRING;
        } else if (str.length() >= minLength) {
            return str;
        }
        int delta = minLength - str.length();
        char[] chars = new char[minLength];
        N.fill(chars, 0, delta, padChar);
        str.getChars(0, str.length(), chars, delta);
        return StringUtil.newString(chars, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String padStart(String str, int minLength, String padStr) {
        if (str == null) {
            str = N.EMPTY_STRING;
        } else if (str.length() >= minLength) {
            return str;
        }
        int delta = (minLength - str.length()) % padStr.length() == 0 ? (minLength - str.length()) / padStr.length() : (minLength - str.length()) % padStr.length() + 1;
        switch (delta) {
            case 1: {
                return padStr + str;
            }
            case 2: {
                return padStr + padStr + str;
            }
            case 3: {
                return padStr + padStr + padStr + str;
            }
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (int i = 0; i < delta; ++i) {
                sb.append(padStr);
            }
            sb.append(str);
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String padEnd(String str, int minLength) {
        return StringUtil.padEnd(str, minLength, ' ');
    }

    public static String padEnd(String str, int minLength, char padChar) {
        if (str == null) {
            str = N.EMPTY_STRING;
        } else if (str.length() >= minLength) {
            return str;
        }
        char[] chars = new char[minLength];
        str.getChars(0, str.length(), chars, 0);
        N.fill(chars, str.length(), minLength, padChar);
        return StringUtil.newString(chars, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String padEnd(String str, int minLength, String padStr) {
        if (str == null) {
            str = N.EMPTY_STRING;
        } else if (str.length() >= minLength) {
            return str;
        }
        int delta = (minLength - str.length()) % padStr.length() == 0 ? (minLength - str.length()) / padStr.length() : (minLength - str.length()) % padStr.length() + 1;
        switch (delta) {
            case 1: {
                return str + padStr;
            }
            case 2: {
                return str + padStr + padStr;
            }
            case 3: {
                return str + padStr + padStr + padStr;
            }
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            sb.append(str);
            for (int i = 0; i < delta; ++i) {
                sb.append(padStr);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String repeat(char ch, int n) {
        int cnt;
        N.checkArgNotNegative(n, "n");
        if (n == 0) {
            return N.EMPTY_STRING;
        }
        if (n == 1) {
            return String.valueOf(ch);
        }
        if (n < 16) {
            char[] array = new char[n];
            Arrays.fill(array, ch);
            return StringUtil.newString(array, true);
        }
        char[] array = new char[n];
        array[0] = ch;
        for (cnt = 1; cnt < n - cnt; cnt <<= 1) {
            N.copy(array, 0, array, cnt, cnt);
        }
        if (cnt < n) {
            N.copy(array, 0, array, cnt, n - cnt);
        }
        return StringUtil.newString(array, true);
    }

    public static String repeat(char ch, int n, char delimiter) {
        return StringUtil.repeat(String.valueOf(ch), n, String.valueOf(delimiter));
    }

    public static String repeat(String str, int repeat) {
        return StringUtil.repeat(str, repeat, N.EMPTY_STRING);
    }

    public static String repeat(String str, int n, String delimiter) {
        int delimiterLen;
        N.checkArgNotNegative(n, "n");
        str = str == null ? N.EMPTY_STRING : str;
        String string = delimiter = delimiter == null ? N.EMPTY_STRING : delimiter;
        if (n == 0 || N.isNullOrEmpty(str) && N.isNullOrEmpty(delimiter)) {
            return N.EMPTY_STRING;
        }
        if (n == 1) {
            return str;
        }
        int strLen = str.length();
        int len = strLen + (delimiterLen = delimiter.length());
        if (Integer.MAX_VALUE / len < n) {
            throw new ArrayIndexOutOfBoundsException("Required array size too large: " + 1L * (long)len * (long)n);
        }
        int size = len * n - delimiterLen;
        char[] cbuf = new char[size];
        str.getChars(0, strLen, cbuf, 0);
        delimiter.getChars(0, delimiterLen, cbuf, strLen);
        int cnt = 0;
        for (cnt = len; cnt < size - cnt; cnt <<= 1) {
            N.copy(cbuf, 0, cbuf, cnt, cnt);
        }
        if (cnt < size) {
            N.copy(cbuf, 0, cbuf, cnt, size - cnt);
        }
        return StringUtil.newString(cbuf, true);
    }

    public static char toLowerCase(char ch) {
        return Character.toLowerCase(ch);
    }

    public static String toLowerCase(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        return str.toLowerCase();
    }

    public static String toLowerCase(String str, Locale locale) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        return str.toLowerCase(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toLowerCaseWithUnderscore(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                char ch = str.charAt(i);
                if (Character.isUpperCase(ch)) {
                    if (i > 0 && (!Character.isUpperCase(str.charAt(i - 1)) || i < len - 1 && Character.isLowerCase(str.charAt(i + 1))) && sb.length() > 0 && sb.charAt(sb.length() - 1) != '_') {
                        sb.append('_');
                    }
                    sb.append(Character.toLowerCase(ch));
                    continue;
                }
                if (i > 0 && (StringUtil.isAsciiNumeric(ch) && !StringUtil.isAsciiNumeric(str.charAt(i - 1)) || StringUtil.isAsciiNumeric(str.charAt(i - 1)) && !StringUtil.isAsciiNumeric(ch)) && sb.length() > 0 && sb.charAt(sb.length() - 1) != '_') {
                    sb.append('_');
                }
                sb.append(ch);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static char toUpperCase(char ch) {
        return Character.toUpperCase(ch);
    }

    public static String toUpperCase(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        return str.toUpperCase();
    }

    public static String toUpperCase(String str, Locale locale) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        return str.toUpperCase(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toUpperCaseWithUnderscore(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                char ch = str.charAt(i);
                if (Character.isUpperCase(ch)) {
                    if (i > 0 && (!Character.isUpperCase(str.charAt(i - 1)) || i < len - 1 && Character.isLowerCase(str.charAt(i + 1))) && sb.length() > 0 && sb.charAt(sb.length() - 1) != '_') {
                        sb.append('_');
                    }
                    sb.append(ch);
                    continue;
                }
                if (i > 0 && (StringUtil.isAsciiNumeric(ch) && !StringUtil.isAsciiNumeric(str.charAt(i - 1)) || StringUtil.isAsciiNumeric(str.charAt(i - 1)) && !StringUtil.isAsciiNumeric(ch)) && sb.length() > 0 && sb.charAt(sb.length() - 1) != '_') {
                    sb.append('_');
                }
                sb.append(Character.toUpperCase(ch));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toCamelCase(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        if (str.indexOf(95) >= 0) {
            String[] substrs = StringUtil.split(str, '_');
            StringBuilder sb = Objectory.createStringBuilder();
            try {
                for (String substr : substrs) {
                    if (!N.notNullOrEmpty(substr)) continue;
                    sb.append(StringUtil.toLowerCase(substr));
                    if (sb.length() <= substr.length()) continue;
                    sb.setCharAt(sb.length() - substr.length(), Character.toTitleCase(substr.charAt(0)));
                }
                String string = sb.toString();
                return string;
            }
            finally {
                Objectory.recycle(sb);
            }
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isLowerCase(str.charAt(i))) {
                if (i == 1) {
                    return StringUtil.uncapitalize(str);
                }
                if (i <= 1) break;
                return str.substring(0, i - 1).toLowerCase() + str.substring(i - 1);
            }
            if (i + 1 != str.length()) continue;
            return str.toLowerCase();
        }
        return str;
    }

    public static char swapCase(char ch) {
        return Character.isLowerCase(ch) ? Character.toUpperCase(ch) : Character.toLowerCase(ch);
    }

    public static String swapCase(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        char[] cbuf = str.toCharArray();
        char ch = '\u0000';
        int len = cbuf.length;
        for (int i = 0; i < len; ++i) {
            ch = cbuf[i];
            if (Character.isUpperCase(ch) || Character.isTitleCase(ch)) {
                cbuf[i] = Character.toLowerCase(ch);
                continue;
            }
            if (!Character.isLowerCase(ch)) continue;
            cbuf[i] = Character.toUpperCase(ch);
        }
        return StringUtil.newString(cbuf, true);
    }

    public static String capitalize(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        char ch = str.charAt(0);
        if (Character.isTitleCase(ch)) {
            return str;
        }
        if (str.length() == 1) {
            return String.valueOf(Character.toTitleCase(ch));
        }
        return Character.toTitleCase(ch) + str.substring(1);
    }

    public static String uncapitalize(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        char ch = str.charAt(0);
        if (Character.isLowerCase(ch)) {
            return str;
        }
        if (str.length() == 1) {
            return String.valueOf(Character.toLowerCase(ch));
        }
        return Character.toLowerCase(ch) + str.substring(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String quoteEscaped(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        char[] chars = StringUtil.getCharsForReadOnly(str);
        try {
            char ch = '\u0000';
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                ch = chars[i];
                if (ch == '\\' && i < len - 1) {
                    sb.append(ch);
                    sb.append(str.charAt(++i));
                    continue;
                }
                if (ch == '\'' || ch == '\"') {
                    sb.append('\\');
                    sb.append(ch);
                    continue;
                }
                sb.append(ch);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String unicodeEscaped(char ch) {
        if (ch < '\u0010') {
            return "\\u000" + Integer.toHexString(ch);
        }
        if (ch < '\u0100') {
            return "\\u00" + Integer.toHexString(ch);
        }
        if (ch < '\u1000') {
            return "\\u0" + Integer.toHexString(ch);
        }
        return "\\u" + Integer.toHexString(ch);
    }

    public static String normalizeSpace(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        return WHITESPACE_PATTERN.matcher(str.trim()).replaceAll(" ");
    }

    public static String replaceAll(String str, String target, String replacement) {
        return StringUtil.replaceAll(str, 0, target, replacement);
    }

    public static String replaceAll(String str, int fromIndex, String target, String replacement) {
        return StringUtil.replace(str, fromIndex, target, replacement, -1);
    }

    public static String replace(String str, int fromIndex, String target, String replacement, int max) {
        return StringUtil.replace(str, fromIndex, target, replacement, max, false);
    }

    public static String replaceAllIgnoreCase(String str, String target, String replacement) {
        return StringUtil.replaceAllIgnoreCase(str, 0, target, replacement);
    }

    public static String replaceAllIgnoreCase(String str, int fromIndex, String target, String replacement) {
        return StringUtil.replaceIgnoreCase(str, fromIndex, target, replacement, -1);
    }

    public static String replaceIgnoreCase(String str, int fromIndex, String target, String replacement, int max) {
        return StringUtil.replace(str, fromIndex, target, replacement, max, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String replace(String str, int fromIndex, String target, String replacement, int max, boolean ignoreCase) {
        String searchTarget;
        if (replacement == null) {
            throw new IllegalArgumentException("Replacement can't be null");
        }
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(target) || max == 0) {
            return str;
        }
        String searchText = ignoreCase ? str.toLowerCase() : str;
        int end = searchText.indexOf(searchTarget = ignoreCase ? target.toLowerCase() : target, fromIndex);
        if (end == -1) {
            return str;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        int substrLength = target.length();
        sb.append(str, 0, fromIndex);
        int start = fromIndex;
        try {
            while (end != -1) {
                sb.append(str, start, end).append(replacement);
                start = end + substrLength;
                if (--max == 0) break;
                end = searchText.indexOf(searchTarget, start);
            }
            sb.append(str, start, str.length());
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String replacePattern(String source, String regex, String replacement) {
        return Pattern.compile(regex, 32).matcher(source).replaceAll(replacement);
    }

    public static String removeStart(String str, String removeStr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(removeStr)) {
            return str;
        }
        if (str.startsWith(removeStr)) {
            return str.substring(removeStr.length());
        }
        return str;
    }

    public static String removeStartIgnoreCase(String str, String removeStr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(removeStr)) {
            return str;
        }
        if (StringUtil.startsWithIgnoreCase(str, removeStr)) {
            return str.substring(removeStr.length());
        }
        return str;
    }

    public static String removeEnd(String str, String removeStr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(removeStr)) {
            return str;
        }
        if (str.endsWith(removeStr)) {
            return str.substring(0, str.length() - removeStr.length());
        }
        return str;
    }

    public static String removeEndIgnoreCase(String str, String removeStr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(removeStr)) {
            return str;
        }
        if (StringUtil.endsWithIgnoreCase(str, removeStr)) {
            return str.substring(0, str.length() - removeStr.length());
        }
        return str;
    }

    public static String removeAll(String str, char removeChar) {
        return StringUtil.removeAll(str, 0, removeChar);
    }

    public static String removeAll(String str, int fromIndex, char removeChar) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        int index = str.indexOf(removeChar, fromIndex);
        if (index == -1) {
            return str;
        }
        char[] chars = StringUtil.getCharsForReadOnly(str);
        char[] cbuf = new char[str.length()];
        if (index > 0) {
            str.getChars(0, index, cbuf, 0);
        }
        int count = index;
        int len = chars.length;
        for (int i = index + 1; i < len; ++i) {
            if (chars[i] == removeChar) continue;
            cbuf[count++] = chars[i];
        }
        return count == chars.length ? str : new String(cbuf, 0, count);
    }

    public static String removeAll(String str, String removeStr) {
        return StringUtil.removeAll(str, 0, removeStr);
    }

    public static String removeAll(String str, int fromIndex, String removeStr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(removeStr)) {
            return str;
        }
        return StringUtil.replace(str, fromIndex, removeStr, N.EMPTY_STRING, -1);
    }

    public static String removePattern(String source, String regex) {
        return StringUtil.replacePattern(source, regex, N.EMPTY_STRING);
    }

    public static String[] split(String str, char delimiter) {
        Splitter splitter = splitterPool.get(Character.valueOf(delimiter));
        return (splitter == null ? Splitter.with(delimiter).omitEmptyStrings(true) : splitter).splitToArray(str);
    }

    public static String[] split(String str, char delimiter, boolean trim) {
        if (trim) {
            Splitter splitter = trimSplitterPool.get(Character.valueOf(delimiter));
            return (splitter == null ? Splitter.with(delimiter).omitEmptyStrings(true).trim(trim) : splitter).splitToArray(str);
        }
        return StringUtil.split(str, delimiter);
    }

    public static String[] split(String str, String delimiter) {
        Splitter splitter = splitterPool.get(delimiter);
        return (splitter == null ? Splitter.with(delimiter).omitEmptyStrings(true) : splitter).splitToArray(str);
    }

    public static String[] split(String str, String delimiter, boolean trim) {
        if (trim) {
            Splitter splitter = trimSplitterPool.get(delimiter);
            return (splitter == null ? Splitter.with(delimiter).omitEmptyStrings(true).trim(trim) : splitter).splitToArray(str);
        }
        return StringUtil.split(str, delimiter);
    }

    @Deprecated
    public static String[] split(String str, String delimiter, int max) {
        return Splitter.with(delimiter).omitEmptyStrings(true).limit(max).splitToArray(str);
    }

    @Deprecated
    public static String[] split(String str, String delimiter, int max, boolean trim) {
        return Splitter.with(delimiter).omitEmptyStrings(true).trim(trim).limit(max).splitToArray(str);
    }

    public static String[] splitPreserveAllTokens(String str, char delimiter) {
        Splitter splitter = preserveSplitterPool.get(Character.valueOf(delimiter));
        return (splitter == null ? Splitter.with(delimiter) : splitter).splitToArray(str);
    }

    public static String[] splitPreserveAllTokens(String str, char delimiter, boolean trim) {
        if (trim) {
            Splitter splitter = trimPreserveSplitterPool.get(Character.valueOf(delimiter));
            return (splitter == null ? Splitter.with(delimiter).trim(trim) : splitter).splitToArray(str);
        }
        return StringUtil.splitPreserveAllTokens(str, delimiter);
    }

    public static String[] splitPreserveAllTokens(String str, String delimiter) {
        Splitter splitter = preserveSplitterPool.get(delimiter);
        return (splitter == null ? Splitter.with(delimiter) : splitter).splitToArray(str);
    }

    public static String[] splitPreserveAllTokens(String str, String delimiter, boolean trim) {
        if (trim) {
            Splitter splitter = trimPreserveSplitterPool.get(delimiter);
            return (splitter == null ? Splitter.with(delimiter).trim(trim) : splitter).splitToArray(str);
        }
        return StringUtil.splitPreserveAllTokens(str, delimiter);
    }

    @Deprecated
    public static String[] splitPreserveAllTokens(String str, String delimiter, int max) {
        return Splitter.with(delimiter).limit(max).splitToArray(str);
    }

    @Deprecated
    public static String[] splitPreserveAllTokens(String str, String delimiter, int max, boolean trim) {
        return Splitter.with(delimiter).trim(trim).limit(max).splitToArray(str);
    }

    public static String trim(String str) {
        return N.isNullOrEmpty(str) || str.charAt(0) != ' ' && str.charAt(str.length() - 1) != ' ' ? str : str.trim();
    }

    public static String[] trim(String[] strs) {
        if (N.isNullOrEmpty(strs)) {
            return strs;
        }
        String[] res = new String[strs.length];
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            res[i] = StringUtil.trim(strs[i]);
        }
        return res;
    }

    public static String trimToNull(String str) {
        return N.isNullOrEmpty(str = StringUtil.trim(str)) ? null : str;
    }

    public static String[] trimToNull(String[] strs) {
        if (N.isNullOrEmpty(strs)) {
            return strs;
        }
        String[] res = new String[strs.length];
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            res[i] = StringUtil.trimToNull(strs[i]);
        }
        return res;
    }

    public static String trimToEmpty(String str) {
        return N.isNullOrEmpty(str) ? N.EMPTY_STRING : str.trim();
    }

    public static String[] trimToEmpty(String[] strs) {
        if (N.isNullOrEmpty(strs)) {
            return strs;
        }
        String[] res = new String[strs.length];
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            res[i] = StringUtil.trimToEmpty(strs[i]);
        }
        return res;
    }

    public static String strip(String str) {
        return StringUtil.strip(str, null);
    }

    public static String[] strip(String[] strs) {
        if (N.isNullOrEmpty(strs)) {
            return strs;
        }
        String[] res = new String[strs.length];
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            res[i] = StringUtil.strip(strs[i]);
        }
        return res;
    }

    public static String stripToNull(String str) {
        return N.isNullOrEmpty(str = StringUtil.strip(str, null)) ? null : str;
    }

    public static String[] stripToNull(String[] strs) {
        if (N.isNullOrEmpty(strs)) {
            return strs;
        }
        String[] res = new String[strs.length];
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            res[i] = StringUtil.stripToNull(strs[i]);
        }
        return res;
    }

    public static String stripToEmpty(String str) {
        return N.isNullOrEmpty(str) ? N.EMPTY_STRING : StringUtil.strip(str, null);
    }

    public static String[] stripToEmpty(String[] strs) {
        if (N.isNullOrEmpty(strs)) {
            return strs;
        }
        String[] res = new String[strs.length];
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            res[i] = StringUtil.trimToEmpty(strs[i]);
        }
        return res;
    }

    public static String strip(String str, String stripChars) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        return StringUtil.stripEnd(StringUtil.stripStart(str, stripChars), stripChars);
    }

    public static String[] strip(String[] strs, String stripChars) {
        if (N.isNullOrEmpty(strs)) {
            return strs;
        }
        String[] res = new String[strs.length];
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            res[i] = StringUtil.strip(strs[i], stripChars);
        }
        return res;
    }

    public static String stripStart(String str, String stripChars) {
        int start;
        if (N.isNullOrEmpty(str) || stripChars != null && stripChars.isEmpty()) {
            return str;
        }
        int strLen = str.length();
        if (stripChars == null) {
            for (start = 0; start != strLen && Character.isWhitespace(str.charAt(start)); ++start) {
            }
        } else {
            while (start != strLen && stripChars.indexOf(str.charAt(start)) != -1) {
                ++start;
            }
        }
        return start == 0 ? str : str.substring(start);
    }

    public static String[] stripStart(String[] strs, String stripChars) {
        if (N.isNullOrEmpty(strs)) {
            return strs;
        }
        String[] res = new String[strs.length];
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            res[i] = StringUtil.stripStart(strs[i], stripChars);
        }
        return res;
    }

    public static String stripEnd(String str, String stripChars) {
        int end;
        if (N.isNullOrEmpty(str) || stripChars != null && stripChars.isEmpty()) {
            return str;
        }
        if (stripChars == null) {
            for (end = str.length(); end > 0 && Character.isWhitespace(str.charAt(end - 1)); --end) {
            }
        } else {
            while (end > 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return end == str.length() ? str : str.substring(0, end);
    }

    public static String[] stripEnd(String[] strs, String stripChars) {
        if (N.isNullOrEmpty(strs)) {
            return strs;
        }
        String[] res = new String[strs.length];
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            res[i] = StringUtil.stripEnd(strs[i], stripChars);
        }
        return res;
    }

    public static String stripAccents(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        String decomposed = Normalizer.normalize(str, Normalizer.Form.NFD);
        return pattern_accent.matcher(decomposed).replaceAll("");
    }

    public static String[] stripAccents(String[] strs) {
        if (N.isNullOrEmpty(strs)) {
            return strs;
        }
        String[] res = new String[strs.length];
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            res[i] = StringUtil.stripAccents(strs[i]);
        }
        return res;
    }

    public static String chomp(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        if (str.length() == 1) {
            char ch = str.charAt(0);
            if (ch == '\r' || ch == '\n') {
                return N.EMPTY_STRING;
            }
            return str;
        }
        int lastIdx = str.length() - 1;
        char last = str.charAt(lastIdx);
        if (last == '\n') {
            if (str.charAt(lastIdx - 1) == '\r') {
                --lastIdx;
            }
        } else if (last != '\r') {
            ++lastIdx;
        }
        return lastIdx == str.length() ? str : str.substring(0, lastIdx);
    }

    public static String[] chomp(String[] strs) {
        if (N.isNullOrEmpty(strs)) {
            return strs;
        }
        String[] res = new String[strs.length];
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            res[i] = StringUtil.chomp(strs[i]);
        }
        return res;
    }

    public static String chop(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        int strLen = str.length();
        if (strLen < 2) {
            return N.EMPTY_STRING;
        }
        int lastIdx = strLen - 1;
        if (str.charAt(lastIdx) == '\n' && str.charAt(lastIdx - 1) == '\r') {
            return str.substring(0, lastIdx - 1);
        }
        return str.substring(0, lastIdx);
    }

    public static String[] chop(String[] strs) {
        if (N.isNullOrEmpty(strs)) {
            return strs;
        }
        String[] res = new String[strs.length];
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            res[i] = StringUtil.chop(strs[i]);
        }
        return res;
    }

    public static String deleteWhitespace(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        char[] chars = StringUtil.getCharsForReadOnly(str);
        char[] cbuf = new char[chars.length];
        int count = 0;
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(chars[i])) continue;
            cbuf[count++] = chars[i];
        }
        return count == chars.length ? str : new String(cbuf, 0, count);
    }

    public static String[] deleteWhitespace(String[] strs) {
        if (N.isNullOrEmpty(strs)) {
            return strs;
        }
        String[] res = new String[strs.length];
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            res[i] = StringUtil.deleteWhitespace(strs[i]);
        }
        return res;
    }

    public static String appendIfMissing(String str, String suffix) {
        N.checkArgNotNull(suffix);
        if (N.isNullOrEmpty(str)) {
            return suffix;
        }
        if (str.endsWith(suffix)) {
            return str;
        }
        return str + suffix;
    }

    public static String prependIfMissing(String str, String prefix) {
        N.checkArgNotNull(prefix);
        if (N.isNullOrEmpty(str)) {
            return prefix;
        }
        if (str.startsWith(prefix)) {
            return str;
        }
        return prefix + str;
    }

    public static String wrapIfMissing(String str, String prefixSuffix) {
        N.checkArgNotNull(prefixSuffix);
        return StringUtil.wrapIfMissing(str, prefixSuffix, prefixSuffix);
    }

    public static String wrapIfMissing(String str, String prefix, String suffix) {
        N.checkArgNotNull(prefix);
        N.checkArgNotNull(suffix);
        if (N.isNullOrEmpty(str)) {
            return prefix + suffix;
        }
        if (str.startsWith(prefix)) {
            return str.length() - prefix.length() >= suffix.length() && str.endsWith(suffix) ? str : str + suffix;
        }
        if (str.endsWith(suffix)) {
            return prefix + str;
        }
        return StringUtil.concat(prefix, str, suffix);
    }

    public static String wrap(String str, String prefixSuffix) {
        N.checkArgNotNull(prefixSuffix);
        return StringUtil.wrap(str, prefixSuffix, prefixSuffix);
    }

    public static String wrap(String str, String prefix, String suffix) {
        N.checkArgNotNull(prefix);
        N.checkArgNotNull(suffix);
        if (N.isNullOrEmpty(str)) {
            return prefix + suffix;
        }
        return StringUtil.concat(prefix, str, suffix);
    }

    public static String unwrap(String str, String prefixSuffix) {
        N.checkArgNotNull(prefixSuffix);
        return StringUtil.unwrap(str, prefixSuffix, prefixSuffix);
    }

    public static String unwrap(String str, String prefix, String suffix) {
        N.checkArgNotNull(prefix);
        N.checkArgNotNull(suffix);
        if (N.isNullOrEmpty(str)) {
            return N.EMPTY_STRING;
        }
        if (str.length() - prefix.length() >= suffix.length() && str.startsWith(prefix) && str.endsWith(suffix)) {
            return str.substring(prefix.length(), str.length() - suffix.length());
        }
        return str;
    }

    public static boolean isLowerCase(char ch) {
        return Character.isLowerCase(ch);
    }

    public static boolean isAsciiLowerCase(char ch) {
        return ch >= 'a' && ch <= 'z';
    }

    public static boolean isUpperCase(char ch) {
        return Character.isUpperCase(ch);
    }

    public static boolean isAsciiUpperCase(char ch) {
        return ch >= 'A' && ch <= 'Z';
    }

    public static boolean isAllLowerCase(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = StringUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (!Character.isUpperCase(chars[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (!Character.isUpperCase(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAllUpperCase(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = StringUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (!Character.isLowerCase(chars[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (!Character.isLowerCase(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isMixedCase(CharSequence cs) {
        if (N.isNullOrEmpty(cs) || cs.length() == 1) {
            return false;
        }
        boolean containsUppercase = false;
        boolean containsLowercase = false;
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = StringUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (containsUppercase && containsLowercase) {
                    return true;
                }
                if (Character.isUpperCase(chars[i])) {
                    containsUppercase = true;
                    continue;
                }
                if (!Character.isLowerCase(chars[i])) continue;
                containsLowercase = true;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (containsUppercase && containsLowercase) {
                    return true;
                }
                if (Character.isUpperCase(cs.charAt(i))) {
                    containsUppercase = true;
                    continue;
                }
                if (!Character.isLowerCase(cs.charAt(i))) continue;
                containsLowercase = true;
            }
        }
        return containsUppercase && containsLowercase;
    }

    public static boolean isDigit(char ch) {
        return Character.isDigit(ch);
    }

    public static boolean isLetter(char ch) {
        return Character.isLetter(ch);
    }

    public static boolean isLetterOrDigit(char ch) {
        return Character.isLetterOrDigit(ch);
    }

    public static boolean isAscii(char ch) {
        return ch < '\u0080';
    }

    public static boolean isAsciiPrintable(char ch) {
        return ch > '\u001f' && ch < '\u007f';
    }

    public static boolean isAsciiControl(char ch) {
        return ch < ' ' || ch == '\u007f';
    }

    public static boolean isAsciiAlpha(char ch) {
        return StringUtil.isAsciiAlphaUpper(ch) || StringUtil.isAsciiAlphaLower(ch);
    }

    public static boolean isAsciiAlphaUpper(char ch) {
        return ch >= 'A' && ch <= 'Z';
    }

    public static boolean isAsciiAlphaLower(char ch) {
        return ch >= 'a' && ch <= 'z';
    }

    public static boolean isAsciiNumeric(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isAsciiAlphanumeric(char ch) {
        return StringUtil.isAsciiAlpha(ch) || StringUtil.isAsciiNumeric(ch);
    }

    public static boolean isAsciiPrintable(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = StringUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiPrintable(chars[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiPrintable(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAsciiAlpha(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = StringUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiAlpha(chars[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiAlpha(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAsciiAlphaSpace(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = StringUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiAlpha(chars[i]) || chars[i] == ' ') continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiAlpha(cs.charAt(i)) || cs.charAt(i) == ' ') continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAsciiAlphanumeric(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = StringUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiAlphanumeric(chars[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiAlphanumeric(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAsciiAlphanumericSpace(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = StringUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiAlphanumeric(chars[i]) || chars[i] == ' ') continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiAlphanumeric(cs.charAt(i)) || cs.charAt(i) == ' ') continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAsciiNumeric(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = StringUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiNumeric(chars[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isAsciiNumeric(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAlpha(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = StringUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (Character.isLetter(chars[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (Character.isLetter(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAlphaSpace(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = StringUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (Character.isLetter(chars[i]) || chars[i] == ' ') continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (Character.isLetter(cs.charAt(i)) || cs.charAt(i) == ' ') continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAlphanumeric(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = StringUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (Character.isLetterOrDigit(chars[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (Character.isLetterOrDigit(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAlphanumericSpace(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = StringUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (Character.isLetterOrDigit(chars[i]) || chars[i] == ' ') continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (Character.isLetterOrDigit(cs.charAt(i)) || cs.charAt(i) == ' ') continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNumeric(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = StringUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (Character.isDigit(chars[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (Character.isDigit(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNumericSpace(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = StringUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (Character.isDigit(chars[i]) || chars[i] == ' ') continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (Character.isDigit(cs.charAt(i)) || cs.charAt(i) == ' ') continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isWhitespace(CharSequence cs) {
        if (N.isNullOrEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        if (cs.getClass().equals(String.class)) {
            char[] chars = StringUtil.getCharsForReadOnly((String)cs);
            for (int i = 0; i < len; ++i) {
                if (Character.isWhitespace(chars[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (Character.isWhitespace(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNumber(String str) {
        return StringUtil.createNumber(str).isPresent();
    }

    public static boolean isAsciiDigtalNumber(String str) {
        if (N.isNullOrEmpty(str)) {
            return false;
        }
        char[] chs = StringUtil.getCharsForReadOnly(str);
        int i = 0;
        int num = 0;
        if (chs[i] == '+' || chs[i] == '-') {
            ++i;
        }
        while (i < chs.length && chs[i] >= '0' && chs[i] <= '9') {
            ++num;
            ++i;
        }
        if (i < chs.length && chs[i] == '.') {
            if (num == 0) {
                return false;
            }
            num = 0;
            ++i;
        }
        while (i < chs.length && chs[i] >= '0' && chs[i] <= '9') {
            ++num;
            ++i;
        }
        if (num == 0) {
            return false;
        }
        if (i == chs.length) {
            return true;
        }
        if (chs[i] != 'e' && chs[i] != 'E') {
            return false;
        }
        num = 0;
        if (++i < chs.length && (chs[i] == '+' || chs[i] == '-')) {
            ++i;
        }
        while (i < chs.length && chs[i] >= '0' && chs[i] <= '9') {
            ++num;
            ++i;
        }
        if (num == 0) {
            return false;
        }
        return i == chs.length;
    }

    public static boolean isAsciiDigtalInteger(String str) {
        if (N.isNullOrEmpty(str)) {
            return false;
        }
        char[] chs = StringUtil.getCharsForReadOnly(str);
        int i = 0;
        int num = 0;
        if (chs[i] == '+' || chs[i] == '-') {
            ++i;
        }
        while (i < chs.length && chs[i] >= '0' && chs[i] <= '9') {
            ++num;
            ++i;
        }
        if (num == 0) {
            return false;
        }
        return i == chs.length;
    }

    public static int indexOf(String str, int targetChar) {
        if (N.isNullOrEmpty(str)) {
            return -1;
        }
        return str.indexOf(targetChar);
    }

    public static int indexOf(String str, int fromIndex, int targetChar) {
        if (N.isNullOrEmpty(str)) {
            return -1;
        }
        return str.indexOf(targetChar, fromIndex);
    }

    public static int indexOf(String str, String substr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr) || substr.length() > str.length()) {
            return -1;
        }
        return str.indexOf(substr);
    }

    public static int indexOf(String str, int fromIndex, String substr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr) || substr.length() > str.length() - fromIndex) {
            return -1;
        }
        return str.indexOf(substr, fromIndex);
    }

    @SafeVarargs
    public static int indexOfAny(String str, char ... chs) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(chs)) {
            return -1;
        }
        int strLen = str.length();
        int strLast = strLen - 1;
        int chsLen = chs.length;
        int chsLast = chsLen - 1;
        for (int i = 0; i < strLen; ++i) {
            char ch = str.charAt(i);
            for (int j = 0; j < chsLen; ++j) {
                if (chs[j] != ch) continue;
                if (i < strLast && j < chsLast && Character.isHighSurrogate(ch)) {
                    if (chs[j + 1] != str.charAt(i + 1)) continue;
                    return i;
                }
                return i;
            }
        }
        return -1;
    }

    @SafeVarargs
    public static int indexOfAny(String str, String ... substrs) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substrs)) {
            return -1;
        }
        int result = -1;
        int tmp = 0;
        for (String substr : substrs) {
            if (N.isNullOrEmpty(substr) || (tmp = StringUtil.indexOf(str, substr)) == -1 || result != -1 && tmp >= result) continue;
            result = tmp;
        }
        return result;
    }

    @SafeVarargs
    public static int indexOfAnyBut(String str, char ... chs) {
        if (N.isNullOrEmpty(str)) {
            return -1;
        }
        if (N.isNullOrEmpty(chs)) {
            return 0;
        }
        int strLen = str.length();
        int strLast = strLen - 1;
        int chsLen = chs.length;
        int chsLast = chsLen - 1;
        block0: for (int i = 0; i < strLen; ++i) {
            char ch = str.charAt(i);
            for (int j = 0; j < chsLen; ++j) {
                if (chs[j] == ch && (i >= strLast || j >= chsLast || !Character.isHighSurrogate(ch) || chs[j + 1] == str.charAt(i + 1))) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int indexOf(String str, String substr, String delimiter) {
        return StringUtil.indexOf(str, 0, substr, delimiter);
    }

    public static int indexOf(String str, int fromIndex, String substr, String delimiter) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr)) {
            return -1;
        }
        int index = str.indexOf(substr, fromIndex);
        if (index < 0) {
            return -1;
        }
        if (index + substr.length() == str.length()) {
            return index;
        }
        if (str.length() >= index + substr.length() + delimiter.length()) {
            int i = 0;
            int j = index + substr.length();
            int seperatorLen = delimiter.length();
            while (i < seperatorLen) {
                if (delimiter.charAt(i++) == str.charAt(j++)) continue;
                return -1;
            }
            return index;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(String str, String substr) {
        return StringUtil.indexOfIgnoreCase(str, 0, substr);
    }

    public static int indexOfIgnoreCase(String str, int fromIndex, String substr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr) || substr.length() > str.length() - fromIndex) {
            return -1;
        }
        int len = str.length();
        int substrLen = substr.length();
        int end = len - substrLen + 1;
        for (int i = fromIndex; i < end; ++i) {
            if (!str.regionMatches(true, i, substr, 0, substrLen)) continue;
            return i;
        }
        return -1;
    }

    public static int ordinalIndexOf(String str, String substr, int ordinal) {
        return StringUtil.ordinalIndexOf(str, substr, ordinal, false);
    }

    public static int lastIndexOf(String str, int targetChar) {
        if (N.isNullOrEmpty(str)) {
            return -1;
        }
        return str.lastIndexOf(targetChar);
    }

    public static int lastIndexOf(String str, int fromIndex, int targetChar) {
        if (N.isNullOrEmpty(str)) {
            return -1;
        }
        return str.lastIndexOf(targetChar, fromIndex);
    }

    public static int lastIndexOf(String str, String substr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr) || substr.length() > str.length()) {
            return -1;
        }
        return str.lastIndexOf(substr);
    }

    public static int lastIndexOf(String str, int fromIndex, String substr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr) || substr.length() > str.length()) {
            return -1;
        }
        return str.lastIndexOf(substr, fromIndex);
    }

    @SafeVarargs
    public static int lastIndexOfAny(String str, char ... chs) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(chs)) {
            return -1;
        }
        int result = -1;
        int tmp = 0;
        for (char ch : chs) {
            tmp = str.lastIndexOf(ch);
            if (tmp == -1 || result != -1 && tmp <= result) continue;
            result = tmp;
        }
        return result;
    }

    @SafeVarargs
    public static int lastIndexOfAny(String str, String ... substrs) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substrs)) {
            return -1;
        }
        int result = -1;
        int tmp = 0;
        for (String substr : substrs) {
            if (N.isNullOrEmpty(substr) || (tmp = str.lastIndexOf(substr)) == -1 || result != -1 && tmp <= result) continue;
            result = tmp;
        }
        return result;
    }

    public static int lastIndexOf(String str, String substr, String delimiter) {
        return StringUtil.lastIndexOf(str, str.length(), substr, delimiter);
    }

    public static int lastIndexOf(String str, int fromIndex, String substr, String delimiter) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr)) {
            return -1;
        }
        int index = str.lastIndexOf(substr, N.min(fromIndex, str.length()));
        if (index < 0) {
            return -1;
        }
        if (index + substr.length() == str.length()) {
            return index;
        }
        if (str.length() >= index + substr.length() + delimiter.length()) {
            int i = 0;
            int j = index + substr.length();
            int len = delimiter.length();
            while (i < len) {
                if (delimiter.charAt(i++) == str.charAt(j++)) continue;
                return -1;
            }
            return index;
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(String str, String substr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr) || substr.length() > str.length()) {
            return -1;
        }
        return StringUtil.lastIndexOfIgnoreCase(str, str.length(), substr);
    }

    public static int lastIndexOfIgnoreCase(String str, int fromIndex, String substr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr) || substr.length() > str.length()) {
            return -1;
        }
        int substrLen = substr.length();
        for (int i = N.min(fromIndex, str.length() - substr.length()); i >= 0; --i) {
            if (!str.regionMatches(true, i, substr, 0, substrLen)) continue;
            return i;
        }
        return -1;
    }

    public static int lastOrdinalIndexOf(String str, String substr, int ordinal) {
        return StringUtil.ordinalIndexOf(str, substr, ordinal, true);
    }

    private static int ordinalIndexOf(String str, String substr, int ordinal, boolean isLastIndex) {
        if (ordinal < 1) {
            throw new IllegalArgumentException("ordinal(" + ordinal + ") must be >= 1");
        }
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr) || substr.length() > str.length()) {
            return -1;
        }
        int fromIndex = isLastIndex ? str.length() : 0;
        int found = 0;
        while (fromIndex >= 0) {
            int n = fromIndex = isLastIndex ? str.lastIndexOf(substr, fromIndex) : str.indexOf(substr, fromIndex);
            if (fromIndex < 0) {
                return -1;
            }
            if (++found >= ordinal) break;
            fromIndex = isLastIndex ? fromIndex - substr.length() : fromIndex + substr.length();
        }
        return fromIndex;
    }

    public static boolean contains(String str, int targetChar) {
        if (N.isNullOrEmpty(str)) {
            return false;
        }
        return StringUtil.indexOf(str, targetChar) != -1;
    }

    public static boolean contains(String str, String substr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr)) {
            return false;
        }
        return StringUtil.indexOf(str, substr) != -1;
    }

    @SafeVarargs
    public static boolean containsAny(String str, char ... chs) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(chs)) {
            return false;
        }
        return StringUtil.indexOfAny(str, chs) != -1;
    }

    @SafeVarargs
    public static boolean containsOnly(String str, char ... chs) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(chs)) {
            return false;
        }
        return StringUtil.indexOfAnyBut(str, chs) == -1;
    }

    @SafeVarargs
    public static boolean containsNone(String str, char ... chs) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(chs)) {
            return true;
        }
        int strLen = str.length();
        int strLast = strLen - 1;
        int chsLen = chs.length;
        int chsLast = chsLen - 1;
        for (int i = 0; i < strLen; ++i) {
            char ch = str.charAt(i);
            for (int j = 0; j < chsLen; ++j) {
                if (chs[j] != ch) continue;
                if (Character.isHighSurrogate(ch)) {
                    if (j == chsLast) {
                        return false;
                    }
                    if (i >= strLast || chs[j + 1] != str.charAt(i + 1)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public static boolean contains(String str, String substr, String delimiter) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr)) {
            return false;
        }
        return StringUtil.indexOf(str, substr, delimiter) != -1;
    }

    public static boolean containsIgnoreCase(String str, String substr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr)) {
            return false;
        }
        return StringUtil.indexOfIgnoreCase(str, substr) != -1;
    }

    public static boolean containsWhitespace(String str) {
        if (N.isNullOrEmpty(str)) {
            return false;
        }
        char[] chars = StringUtil.getCharsForReadOnly(str);
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isWhitespace(chars[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWith(String str, String prefix) {
        return StringUtil.startsWith(str, prefix, false);
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return StringUtil.startsWith(str, prefix, true);
    }

    private static boolean startsWith(String str, String prefix, boolean ignoreCase) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(prefix) || prefix.length() > str.length()) {
            return false;
        }
        return ignoreCase ? str.regionMatches(true, 0, prefix, 0, prefix.length()) : str.startsWith(prefix);
    }

    @SafeVarargs
    public static boolean startsWithAny(String str, String ... substrs) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substrs)) {
            return false;
        }
        for (String substr : substrs) {
            if (!StringUtil.startsWith(str, substr)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWith(String str, String suffix) {
        return StringUtil.endsWith(str, suffix, false);
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        return StringUtil.endsWith(str, suffix, true);
    }

    private static boolean endsWith(String str, String suffix, boolean ignoreCase) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(suffix) || suffix.length() > str.length()) {
            return false;
        }
        int strOffset = str.length() - suffix.length();
        return ignoreCase ? str.regionMatches(true, strOffset, suffix, 0, suffix.length()) : str.endsWith(suffix);
    }

    @SafeVarargs
    public static boolean endsWithAny(String str, String ... substrs) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substrs)) {
            return false;
        }
        for (String searchString : substrs) {
            if (!StringUtil.endsWith(str, searchString)) continue;
            return true;
        }
        return false;
    }

    public static boolean equals(String a, String b) {
        return a == null ? b == null : (b == null ? false : a.length() == b.length() && a.equals(b));
    }

    public static boolean equalsIgnoreCase(String a, String b) {
        return a == null ? b == null : (b == null ? false : a.equalsIgnoreCase(b));
    }

    public static int indexOfDifference(String a, String b) {
        int i;
        if (N.equals(a, b) || N.isNullOrEmpty(a) && N.isNullOrEmpty(b)) {
            return -1;
        }
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b)) {
            return 0;
        }
        int len = N.min(a.length(), b.length());
        for (i = 0; i < len && a.charAt(i) == b.charAt(i); ++i) {
        }
        if (i < b.length() || i < a.length()) {
            return i;
        }
        return -1;
    }

    @SafeVarargs
    public static int indexOfDifference(String ... strs) {
        if (N.isNullOrEmpty(strs) || strs.length == 1) {
            return -1;
        }
        int arrayLen = strs.length;
        int shortestStrLen = Integer.MAX_VALUE;
        int longestStrLen = 0;
        for (int i = 0; i < arrayLen; ++i) {
            if (strs[i] == null) {
                shortestStrLen = 0;
                continue;
            }
            shortestStrLen = Math.min(strs[i].length(), shortestStrLen);
            longestStrLen = Math.max(strs[i].length(), longestStrLen);
        }
        if (longestStrLen == 0) {
            return -1;
        }
        if (shortestStrLen == 0) {
            return 0;
        }
        int firstDiff = -1;
        for (int stringPos = 0; stringPos < shortestStrLen; ++stringPos) {
            char comparisonChar = strs[0].charAt(stringPos);
            for (int arrayPos = 1; arrayPos < arrayLen; ++arrayPos) {
                if (strs[arrayPos].charAt(stringPos) == comparisonChar) continue;
                firstDiff = stringPos;
                break;
            }
            if (firstDiff != -1) break;
        }
        if (firstDiff == -1 && shortestStrLen != longestStrLen) {
            return shortestStrLen;
        }
        return firstDiff;
    }

    public static String commonPrefix(String a, String b) {
        int p;
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b)) {
            return N.EMPTY_STRING;
        }
        int maxPrefixLength = Math.min(a.length(), b.length());
        for (p = 0; p < maxPrefixLength && a.charAt(p) == b.charAt(p); ++p) {
        }
        if (StringUtil.validSurrogatePairAt(a, p - 1) || StringUtil.validSurrogatePairAt(b, p - 1)) {
            --p;
        }
        if (p == a.length()) {
            return a.toString();
        }
        if (p == b.length()) {
            return b.toString();
        }
        return a.subSequence(0, p).toString();
    }

    @SafeVarargs
    public static String commonPrefix(String ... strs) {
        if (N.isNullOrEmpty(strs)) {
            return N.EMPTY_STRING;
        }
        if (strs.length == 1) {
            return N.isNullOrEmpty(strs[0]) ? N.EMPTY_STRING : strs[0];
        }
        String commonPrefix = StringUtil.commonPrefix(strs[0], strs[1]);
        if (N.isNullOrEmpty(commonPrefix)) {
            return N.EMPTY_STRING;
        }
        int len = strs.length;
        for (int i = 2; i < len; ++i) {
            if (!N.isNullOrEmpty(commonPrefix = StringUtil.commonPrefix(commonPrefix, strs[i]))) continue;
            return commonPrefix;
        }
        return commonPrefix;
    }

    public static String commonSuffix(String a, String b) {
        int s;
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b)) {
            return N.EMPTY_STRING;
        }
        int aLength = a.length();
        int bLength = b.length();
        int maxSuffixLength = Math.min(aLength, bLength);
        for (s = 0; s < maxSuffixLength && a.charAt(aLength - s - 1) == b.charAt(bLength - s - 1); ++s) {
        }
        if (StringUtil.validSurrogatePairAt(a, aLength - s - 1) || StringUtil.validSurrogatePairAt(b, bLength - s - 1)) {
            --s;
        }
        if (s == aLength) {
            return a.toString();
        }
        if (s == bLength) {
            return b.toString();
        }
        return a.subSequence(aLength - s, aLength).toString();
    }

    @SafeVarargs
    public static String commonSuffix(String ... strs) {
        if (N.isNullOrEmpty(strs)) {
            return N.EMPTY_STRING;
        }
        if (strs.length == 1) {
            return N.isNullOrEmpty(strs[0]) ? N.EMPTY_STRING : strs[0];
        }
        String commonSuffix = StringUtil.commonSuffix(strs[0], strs[1]);
        if (N.isNullOrEmpty(commonSuffix)) {
            return N.EMPTY_STRING;
        }
        int len = strs.length;
        for (int i = 2; i < len; ++i) {
            if (!N.isNullOrEmpty(commonSuffix = StringUtil.commonSuffix(commonSuffix, strs[i]))) continue;
            return commonSuffix;
        }
        return commonSuffix;
    }

    static boolean validSurrogatePairAt(String str, int index) {
        return index >= 0 && index <= str.length() - 2 && Character.isHighSurrogate(str.charAt(index)) && Character.isLowSurrogate(str.charAt(index + 1));
    }

    public static int countMatches(String str, char ch) {
        if (N.isNullOrEmpty(str)) {
            return 0;
        }
        int count = 0;
        char[] chs = StringUtil.getCharsForReadOnly(str);
        int len = chs.length;
        for (int i = 0; i < len; ++i) {
            if (chs[i] != ch) continue;
            ++count;
        }
        return count;
    }

    public static int countMatches(String str, String substr) {
        if (N.isNullOrEmpty(str) || N.isNullOrEmpty(substr)) {
            return 0;
        }
        int count = 0;
        int index = 0;
        while ((index = str.indexOf(substr, index)) != -1) {
            ++count;
            index += substr.length();
        }
        return count;
    }

    public static u.Optional<String> substring(String str, int inclusiveBeginIndex, int exclusiveEndIndex) {
        if (inclusiveBeginIndex < 0 || exclusiveEndIndex < 0 || inclusiveBeginIndex > exclusiveEndIndex) {
            return u.Optional.empty();
        }
        return u.Optional.of(str.substring(inclusiveBeginIndex, exclusiveEndIndex));
    }

    public static u.Optional<String> substring(String str, int inclusiveBeginIndex) {
        if (inclusiveBeginIndex < 0) {
            return u.Optional.empty();
        }
        return u.Optional.of(str.substring(inclusiveBeginIndex));
    }

    public static u.Optional<String> substring(String str, char delimiterOfInclusiveBeginIndex) {
        if (N.isNullOrEmpty(str)) {
            return u.Optional.empty();
        }
        return StringUtil.substring(str, str.indexOf(delimiterOfInclusiveBeginIndex));
    }

    public static u.Optional<String> substring(String str, String delimiterOfInclusiveBeginIndex) {
        if (N.isNullOrEmpty(str)) {
            return u.Optional.empty();
        }
        return StringUtil.substring(str, str.indexOf(delimiterOfInclusiveBeginIndex));
    }

    public static u.Optional<String> substring(String str, int inclusiveBeginIndex, char delimiterOfExclusiveEndIndex) {
        if (inclusiveBeginIndex < 0) {
            return u.Optional.empty();
        }
        return StringUtil.substring(str, inclusiveBeginIndex, str.indexOf(delimiterOfExclusiveEndIndex, inclusiveBeginIndex + 1));
    }

    public static u.Optional<String> substring(String str, int inclusiveBeginIndex, String delimiterOfExclusiveEndIndex) {
        if (inclusiveBeginIndex < 0) {
            return u.Optional.empty();
        }
        return StringUtil.substring(str, inclusiveBeginIndex, str.indexOf(delimiterOfExclusiveEndIndex, inclusiveBeginIndex + 1));
    }

    public static u.Optional<String> substring(String str, int inclusiveBeginIndex, IntUnaryOperator funcOfExclusiveEndIndex) {
        if (inclusiveBeginIndex < 0) {
            return u.Optional.empty();
        }
        return StringUtil.substring(str, inclusiveBeginIndex, funcOfExclusiveEndIndex.applyAsInt(inclusiveBeginIndex));
    }

    public static u.Optional<String> substring(String str, char delimiterOfInclusiveBeginIndex, int exclusiveEndIndex) {
        if (exclusiveEndIndex <= 0) {
            return u.Optional.empty();
        }
        return StringUtil.substring(str, str.lastIndexOf(delimiterOfInclusiveBeginIndex, exclusiveEndIndex - 1), exclusiveEndIndex);
    }

    public static u.Optional<String> substring(String str, String delimiterOfInclusiveBeginIndex, int exclusiveEndIndex) {
        if (exclusiveEndIndex <= 0) {
            return u.Optional.empty();
        }
        return StringUtil.substring(str, str.lastIndexOf(delimiterOfInclusiveBeginIndex, exclusiveEndIndex - 1), exclusiveEndIndex);
    }

    public static u.Optional<String> substring(String str, IntUnaryOperator funcOfInclusiveBeginIndex, int exclusiveEndIndex) {
        if (exclusiveEndIndex <= 0) {
            return u.Optional.empty();
        }
        return StringUtil.substring(str, funcOfInclusiveBeginIndex.applyAsInt(exclusiveEndIndex), exclusiveEndIndex);
    }

    public static u.Optional<String> substringBetween(String str, int exclusiveBeginIndex, int exclusiveEndIndex) {
        if (exclusiveBeginIndex < 0 || exclusiveEndIndex < 0 || exclusiveBeginIndex >= exclusiveEndIndex) {
            return u.Optional.empty();
        }
        return u.Optional.of(str.substring(exclusiveBeginIndex + 1, exclusiveEndIndex));
    }

    public static u.Optional<String> substringBetween(String str, int exclusiveBeginIndex, char delimiterOfExclusiveEndIndex) {
        if (exclusiveBeginIndex < 0) {
            return u.Optional.empty();
        }
        return StringUtil.substringBetween(str, exclusiveBeginIndex, str.indexOf(delimiterOfExclusiveEndIndex, exclusiveBeginIndex + 1));
    }

    public static u.Optional<String> substringBetween(String str, int exclusiveBeginIndex, String delimiterOfExclusiveEndIndex) {
        if (exclusiveBeginIndex < 0) {
            return u.Optional.empty();
        }
        return StringUtil.substringBetween(str, exclusiveBeginIndex, str.indexOf(delimiterOfExclusiveEndIndex, exclusiveBeginIndex + 1));
    }

    public static u.Optional<String> substringBetween(String str, int exclusiveBeginIndex, IntUnaryOperator funcOfExclusiveEndIndex) {
        if (exclusiveBeginIndex < 0) {
            return u.Optional.empty();
        }
        return StringUtil.substringBetween(str, exclusiveBeginIndex, funcOfExclusiveEndIndex.applyAsInt(exclusiveBeginIndex));
    }

    public static u.Optional<String> substringBetween(String str, char delimiterOfExclusiveBeginIndex, int exclusiveEndIndex) {
        if (exclusiveEndIndex <= 0) {
            return u.Optional.empty();
        }
        return StringUtil.substringBetween(str, str.lastIndexOf(delimiterOfExclusiveBeginIndex, exclusiveEndIndex - 1), exclusiveEndIndex);
    }

    public static u.Optional<String> substringBetween(String str, String delimiterOfExclusiveBeginIndex, int exclusiveEndIndex) {
        if (exclusiveEndIndex <= 0) {
            return u.Optional.empty();
        }
        int index = str.lastIndexOf(delimiterOfExclusiveBeginIndex, exclusiveEndIndex - 1);
        int exclusiveBeginIndex = index >= 0 ? index + delimiterOfExclusiveBeginIndex.length() - 1 : index;
        return StringUtil.substringBetween(str, exclusiveBeginIndex, exclusiveEndIndex);
    }

    public static u.Optional<String> substringBetween(String str, IntUnaryOperator funcOfExclusiveBeginIndex, int exclusiveEndIndex) {
        if (exclusiveEndIndex <= 0) {
            return u.Optional.empty();
        }
        return StringUtil.substringBetween(str, funcOfExclusiveBeginIndex.applyAsInt(exclusiveEndIndex), exclusiveEndIndex);
    }

    public static u.OptionalChar firstChar(String str) {
        if (str == null || str.length() == 0) {
            return u.OptionalChar.empty();
        }
        return u.OptionalChar.of(str.charAt(0));
    }

    public static u.OptionalChar lastChar(String str) {
        if (str == null || str.length() == 0) {
            return u.OptionalChar.empty();
        }
        return u.OptionalChar.of(str.charAt(str.length() - 1));
    }

    public static String firstChars(String str, int n) {
        N.checkArgNotNegative(n, "n");
        if (str == null || str.length() == 0 || n == 0) {
            return N.EMPTY_STRING;
        }
        if (str.length() <= n) {
            return str;
        }
        return str.substring(0, n);
    }

    public static String lastChars(String str, int n) {
        N.checkArgNotNegative(n, "n");
        if (str == null || str.length() == 0 || n == 0) {
            return N.EMPTY_STRING;
        }
        if (str.length() <= n) {
            return str;
        }
        return str.substring(str.length() - n);
    }

    public static String join(boolean[] a) {
        return StringUtil.join(a, N.ELEMENT_SEPARATOR);
    }

    public static String join(boolean[] a, char delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    public static String join(boolean[] a, String delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(boolean[] a, int fromIndex, int toIndex, char delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (int i = fromIndex; i < toIndex; ++i) {
                if (i > fromIndex) {
                    sb.append(delimiter);
                }
                sb.append(a[i]);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(boolean[] a, int fromIndex, int toIndex, String delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int i;
            if (N.isNullOrEmpty(delimiter)) {
                for (i = fromIndex; i < toIndex; ++i) {
                    sb.append(a[i]);
                }
            } else {
                for (i = fromIndex; i < toIndex; ++i) {
                    if (i > fromIndex) {
                        sb.append(delimiter);
                    }
                    sb.append(a[i]);
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(char[] a) {
        return StringUtil.join(a, N.ELEMENT_SEPARATOR);
    }

    public static String join(char[] a, char delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    public static String join(char[] a, String delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(char[] a, int fromIndex, int toIndex, char delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (int i = fromIndex; i < toIndex; ++i) {
                if (i > fromIndex) {
                    sb.append(delimiter);
                }
                sb.append(a[i]);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(char[] a, int fromIndex, int toIndex, String delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int i;
            if (N.isNullOrEmpty(delimiter)) {
                for (i = fromIndex; i < toIndex; ++i) {
                    sb.append(a[i]);
                }
            } else {
                for (i = fromIndex; i < toIndex; ++i) {
                    if (i > fromIndex) {
                        sb.append(delimiter);
                    }
                    sb.append(a[i]);
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(byte[] a) {
        return StringUtil.join(a, N.ELEMENT_SEPARATOR);
    }

    public static String join(byte[] a, char delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    public static String join(byte[] a, String delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(byte[] a, int fromIndex, int toIndex, char delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (int i = fromIndex; i < toIndex; ++i) {
                if (i > fromIndex) {
                    sb.append(delimiter);
                }
                sb.append(a[i]);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(byte[] a, int fromIndex, int toIndex, String delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int i;
            if (N.isNullOrEmpty(delimiter)) {
                for (i = fromIndex; i < toIndex; ++i) {
                    sb.append(a[i]);
                }
            } else {
                for (i = fromIndex; i < toIndex; ++i) {
                    if (i > fromIndex) {
                        sb.append(delimiter);
                    }
                    sb.append(a[i]);
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(short[] a) {
        return StringUtil.join(a, N.ELEMENT_SEPARATOR);
    }

    public static String join(short[] a, char delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    public static String join(short[] a, String delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(short[] a, int fromIndex, int toIndex, char delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (int i = fromIndex; i < toIndex; ++i) {
                if (i > fromIndex) {
                    sb.append(delimiter);
                }
                sb.append(a[i]);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(short[] a, int fromIndex, int toIndex, String delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int i;
            if (N.isNullOrEmpty(delimiter)) {
                for (i = fromIndex; i < toIndex; ++i) {
                    sb.append(a[i]);
                }
            } else {
                for (i = fromIndex; i < toIndex; ++i) {
                    if (i > fromIndex) {
                        sb.append(delimiter);
                    }
                    sb.append(a[i]);
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(int[] a) {
        return StringUtil.join(a, N.ELEMENT_SEPARATOR);
    }

    public static String join(int[] a, char delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    public static String join(int[] a, String delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(int[] a, int fromIndex, int toIndex, char delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (int i = fromIndex; i < toIndex; ++i) {
                if (i > fromIndex) {
                    sb.append(delimiter);
                }
                sb.append(a[i]);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(int[] a, int fromIndex, int toIndex, String delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int i;
            if (N.isNullOrEmpty(delimiter)) {
                for (i = fromIndex; i < toIndex; ++i) {
                    sb.append(a[i]);
                }
            } else {
                for (i = fromIndex; i < toIndex; ++i) {
                    if (i > fromIndex) {
                        sb.append(delimiter);
                    }
                    sb.append(a[i]);
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(long[] a) {
        return StringUtil.join(a, N.ELEMENT_SEPARATOR);
    }

    public static String join(long[] a, char delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    public static String join(long[] a, String delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(long[] a, int fromIndex, int toIndex, char delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (int i = fromIndex; i < toIndex; ++i) {
                if (i > fromIndex) {
                    sb.append(delimiter);
                }
                sb.append(a[i]);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(long[] a, int fromIndex, int toIndex, String delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int i;
            if (N.isNullOrEmpty(delimiter)) {
                for (i = fromIndex; i < toIndex; ++i) {
                    sb.append(a[i]);
                }
            } else {
                for (i = fromIndex; i < toIndex; ++i) {
                    if (i > fromIndex) {
                        sb.append(delimiter);
                    }
                    sb.append(a[i]);
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(float[] a) {
        return StringUtil.join(a, N.ELEMENT_SEPARATOR);
    }

    public static String join(float[] a, char delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    public static String join(float[] a, String delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(float[] a, int fromIndex, int toIndex, char delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (int i = fromIndex; i < toIndex; ++i) {
                if (i > fromIndex) {
                    sb.append(delimiter);
                }
                sb.append(a[i]);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(float[] a, int fromIndex, int toIndex, String delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int i;
            if (N.isNullOrEmpty(delimiter)) {
                for (i = fromIndex; i < toIndex; ++i) {
                    sb.append(a[i]);
                }
            } else {
                for (i = fromIndex; i < toIndex; ++i) {
                    if (i > fromIndex) {
                        sb.append(delimiter);
                    }
                    sb.append(a[i]);
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(double[] a) {
        return StringUtil.join(a, N.ELEMENT_SEPARATOR);
    }

    public static String join(double[] a, char delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    public static String join(double[] a, String delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(double[] a, int fromIndex, int toIndex, char delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (int i = fromIndex; i < toIndex; ++i) {
                if (i > fromIndex) {
                    sb.append(delimiter);
                }
                sb.append(a[i]);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(double[] a, int fromIndex, int toIndex, String delimiter) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int i;
            if (N.isNullOrEmpty(delimiter)) {
                for (i = fromIndex; i < toIndex; ++i) {
                    sb.append(a[i]);
                }
            } else {
                for (i = fromIndex; i < toIndex; ++i) {
                    if (i > fromIndex) {
                        sb.append(delimiter);
                    }
                    sb.append(a[i]);
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(Object[] a) {
        return StringUtil.join(a, N.ELEMENT_SEPARATOR);
    }

    public static String join(Object[] a, char delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    public static String join(Object[] a, String delimiter) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(a, 0, a.length, delimiter);
    }

    public static String join(Object[] a, int fromIndex, int toIndex, char delimiter) {
        return StringUtil.join(a, fromIndex, toIndex, delimiter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(Object[] a, int fromIndex, int toIndex, char delimiter, boolean trim) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return trim ? N.toString(a[fromIndex]).trim() : N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (int i = fromIndex; i < toIndex; ++i) {
                if (i > fromIndex) {
                    sb.append(delimiter);
                }
                sb.append(trim ? N.toString(a[i]).trim() : N.toString(a[i]));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(Object[] a, int fromIndex, int toIndex, String delimiter) {
        return StringUtil.join(a, fromIndex, toIndex, delimiter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(Object[] a, int fromIndex, int toIndex, String delimiter, boolean trim) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        if (toIndex - fromIndex == 1) {
            return trim ? N.toString(a[fromIndex]).trim() : N.toString(a[fromIndex]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int i;
            if (N.isNullOrEmpty(delimiter)) {
                for (i = fromIndex; i < toIndex; ++i) {
                    sb.append(trim ? N.toString(a[i]).trim() : N.toString(a[i]));
                }
            } else {
                for (i = fromIndex; i < toIndex; ++i) {
                    if (i > fromIndex) {
                        sb.append(delimiter);
                    }
                    sb.append(trim ? N.toString(a[i]).trim() : N.toString(a[i]));
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(Collection<?> c) {
        return StringUtil.join(c, N.ELEMENT_SEPARATOR);
    }

    public static String join(Collection<?> c, char delimiter) {
        if (N.isNullOrEmpty(c)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(c, 0, c.size(), delimiter);
    }

    public static String join(Collection<?> c, String delimiter) {
        if (N.isNullOrEmpty(c)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.join(c, 0, c.size(), delimiter);
    }

    public static String join(Collection<?> c, int fromIndex, int toIndex, char delimiter) {
        return StringUtil.join(c, fromIndex, toIndex, delimiter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(Collection<?> c, int fromIndex, int toIndex, char delimiter, boolean trim) {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (N.isNullOrEmpty(c) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int i = 0;
            for (Object e : c) {
                if (i++ > fromIndex) {
                    sb.append(delimiter);
                }
                if (i > fromIndex) {
                    sb.append(trim ? N.toString(e).trim() : N.toString(e));
                }
                if (i < toIndex) continue;
                break;
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String join(Collection<?> c, int fromIndex, int toIndex, String delimiter) {
        return StringUtil.join(c, fromIndex, toIndex, delimiter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String join(Collection<?> c, int fromIndex, int toIndex, String delimiter, boolean trim) {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (N.isNullOrEmpty(c) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            if (c instanceof List && c instanceof RandomAccess) {
                List list = (List)c;
                if (N.isNullOrEmpty(delimiter)) {
                    for (int i = fromIndex; i < toIndex; ++i) {
                        sb.append(trim ? N.toString(list.get(i)).trim() : N.toString(list.get(i)));
                    }
                } else {
                    for (int i = fromIndex; i < toIndex; ++i) {
                        if (i > fromIndex) {
                            sb.append(delimiter);
                        }
                        sb.append(trim ? N.toString(list.get(i)).trim() : N.toString(list.get(i)));
                    }
                }
            } else {
                int i = 0;
                if (N.isNullOrEmpty(delimiter)) {
                    for (Object e : c) {
                        if (i++ >= fromIndex) {
                            sb.append(trim ? N.toString(e).trim() : N.toString(e));
                        }
                        if (i < toIndex) continue;
                        break;
                    }
                } else {
                    for (Object e : c) {
                        if (i++ > fromIndex) {
                            sb.append(delimiter);
                        }
                        if (i > fromIndex) {
                            sb.append(trim ? N.toString(e).trim() : N.toString(e));
                        }
                        if (i < toIndex) continue;
                        break;
                    }
                }
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String joinEntries(Map<?, ?> m) {
        return StringUtil.joinEntries(m, N.ELEMENT_SEPARATOR);
    }

    public static String joinEntries(Map<?, ?> m, char entryDelimiter) {
        if (N.isNullOrEmpty(m)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.joinEntries(m, 0, m.size(), entryDelimiter);
    }

    public static String joinEntries(Map<?, ?> m, String entryDelimiter) {
        if (N.isNullOrEmpty(m)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.joinEntries(m, 0, m.size(), entryDelimiter);
    }

    public static String joinEntries(Map<?, ?> m, int fromIndex, int toIndex, char entryDelimiter) {
        return StringUtil.joinEntries(m, fromIndex, toIndex, entryDelimiter, false);
    }

    public static String joinEntries(Map<?, ?> m, int fromIndex, int toIndex, char entryDelimiter, boolean trim) {
        return StringUtil.joinEntries(m, fromIndex, toIndex, entryDelimiter, '=', trim);
    }

    public static String joinEntries(Map<?, ?> m, int fromIndex, int toIndex, String entryDelimiter) {
        return StringUtil.joinEntries(m, fromIndex, toIndex, entryDelimiter, false);
    }

    public static String joinEntries(Map<?, ?> m, int fromIndex, int toIndex, String entryDelimiter, boolean trim) {
        return StringUtil.joinEntries(m, fromIndex, toIndex, entryDelimiter, "=", trim);
    }

    public static String joinEntries(Map<?, ?> m, char entryDelimiter, char keyValueDelimiter) {
        if (N.isNullOrEmpty(m)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.joinEntries(m, 0, m.size(), entryDelimiter, keyValueDelimiter);
    }

    public static String joinEntries(Map<?, ?> m, String entryDelimiter, String keyValueDelimiter) {
        if (N.isNullOrEmpty(m)) {
            return N.EMPTY_STRING;
        }
        return StringUtil.joinEntries(m, 0, m.size(), entryDelimiter, keyValueDelimiter);
    }

    public static String joinEntries(Map<?, ?> m, int fromIndex, int toIndex, char entryDelimiter, char keyValueDelimiter) {
        return StringUtil.joinEntries(m, fromIndex, toIndex, entryDelimiter, keyValueDelimiter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String joinEntries(Map<?, ?> m, int fromIndex, int toIndex, char entryDelimiter, char keyValueDelimiter, boolean trim) {
        N.checkFromToIndex(fromIndex, toIndex, N.size(m));
        if (N.isNullOrEmpty(m) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int i = 0;
            for (Map.Entry<?, ?> entry : m.entrySet()) {
                if (i++ > fromIndex) {
                    sb.append(entryDelimiter);
                }
                if (i > fromIndex) {
                    sb.append(trim ? N.toString(entry.getKey()).trim() : N.toString(entry.getKey()));
                    sb.append(keyValueDelimiter);
                    sb.append(trim ? N.toString(entry.getValue()).trim() : N.toString(entry.getValue()));
                }
                if (i < toIndex) continue;
                break;
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String joinEntries(Map<?, ?> m, int fromIndex, int toIndex, String entryDelimiter, String keyValueDelimiter) {
        return StringUtil.joinEntries(m, fromIndex, toIndex, entryDelimiter, keyValueDelimiter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String joinEntries(Map<?, ?> m, int fromIndex, int toIndex, String entryDelimiter, String keyValueDelimiter, boolean trim) {
        N.checkFromToIndex(fromIndex, toIndex, N.size(m));
        if (N.isNullOrEmpty(m) || fromIndex == toIndex) {
            return N.EMPTY_STRING;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            int i = 0;
            for (Map.Entry<?, ?> entry : m.entrySet()) {
                if (i++ > fromIndex) {
                    sb.append(entryDelimiter);
                }
                if (i > fromIndex) {
                    sb.append(trim ? N.toString(entry.getKey()).trim() : N.toString(entry.getKey()));
                    sb.append(keyValueDelimiter);
                    sb.append(trim ? N.toString(entry.getValue()).trim() : N.toString(entry.getValue()));
                }
                if (i < toIndex) continue;
                break;
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String concat(String a, String b) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            String string = sb.append(a).append(b).toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String concat(String a, String b, String c) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            String string = sb.append(a).append(b).append(c).toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String concat(String a, String b, String c, String d) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            String string = sb.append(a).append(b).append(c).append(d).toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String concat(String a, String b, String c, String d, String e) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            String string = sb.append(a).append(b).append(c).append(d).append(e).toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String concat(String a, String b, String c, String d, String e, String f) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            String string = sb.append(a).append(b).append(c).append(d).append(e).append(f).toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String concat(String a, String b, String c, String d, String e, String f, String g) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            String string = sb.append(a).append(b).append(c).append(d).append(e).append(f).append(g).toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String concat(String a, String b, String c, String d, String e, String f, String g, String h) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            String string = sb.append(a).append(b).append(c).append(d).append(e).append(f).append(g).append(h).toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String concat(String a, String b, String c, String d, String e, String f, String g, String h, String i) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            String string = sb.append(a).append(b).append(c).append(d).append(e).append(f).append(g).append(h).append(i).toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public static String concat(String ... a) {
        if (N.isNullOrEmpty(a)) {
            return N.EMPTY_STRING;
        }
        if (a.length == 1) {
            return N.toString(a[0]);
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            for (String e : a) {
                sb.append(e);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String concat(Object a, Object b) {
        return StringUtil.concat(N.toString(a), N.toString(b));
    }

    public static String concat(Object a, Object b, Object c) {
        return StringUtil.concat(N.toString(a), N.toString(b), N.toString(c));
    }

    public static String concat(Object a, Object b, Object c, Object d) {
        return StringUtil.concat(N.toString(a), N.toString(b), N.toString(c), N.toString(d));
    }

    public static String concat(Object a, Object b, Object c, Object d, Object e) {
        return StringUtil.concat(N.toString(a), N.toString(b), N.toString(c), N.toString(d), N.toString(e));
    }

    public static String concat(Object a, Object b, Object c, Object d, Object e, Object f) {
        return StringUtil.concat(N.toString(a), N.toString(b), N.toString(c), N.toString(d), N.toString(e), N.toString(f));
    }

    public static String concat(Object a, Object b, Object c, Object d, Object e, Object f, Object g) {
        return StringUtil.concat(N.toString(a), N.toString(b), N.toString(c), N.toString(d), N.toString(e), N.toString(f), N.toString(g));
    }

    public static String concat(Object a, Object b, Object c, Object d, Object e, Object f, Object g, Object h) {
        return StringUtil.concat(N.toString(a), N.toString(b), N.toString(c), N.toString(d), N.toString(e), N.toString(f), N.toString(g), N.toString(h));
    }

    public static String concat(Object a, Object b, Object c, Object d, Object e, Object f, Object g, Object h, Object i) {
        return StringUtil.concat(N.toString(a), N.toString(b), N.toString(c), N.toString(d), N.toString(e), N.toString(f), N.toString(g), N.toString(h), N.toString(i));
    }

    public static u.OptionalInt createInteger(String str) {
        if (N.isNullOrEmpty(str)) {
            return u.OptionalInt.empty();
        }
        try {
            return u.OptionalInt.of(Integer.decode(str));
        }
        catch (NumberFormatException e) {
            return u.OptionalInt.empty();
        }
    }

    public static u.OptionalLong createLong(String str) {
        if (N.isNullOrEmpty(str)) {
            return u.OptionalLong.empty();
        }
        try {
            return u.OptionalLong.of(Long.decode(str));
        }
        catch (NumberFormatException e) {
            return u.OptionalLong.empty();
        }
    }

    public static u.OptionalFloat createFloat(String str) {
        if (N.isNullOrEmpty(str)) {
            return u.OptionalFloat.empty();
        }
        try {
            return u.OptionalFloat.of(Float.parseFloat(str));
        }
        catch (NumberFormatException e) {
            return u.OptionalFloat.empty();
        }
    }

    public static u.OptionalDouble createDouble(String str) {
        if (N.isNullOrEmpty(str)) {
            return u.OptionalDouble.empty();
        }
        try {
            return u.OptionalDouble.of(Double.parseDouble(str));
        }
        catch (NumberFormatException e) {
            return u.OptionalDouble.empty();
        }
    }

    public static u.Optional<BigInteger> createBigInteger(String str) {
        if (N.isNullOrEmptyOrBlank(str)) {
            return u.Optional.empty();
        }
        int pos = 0;
        int radix = 10;
        boolean negate = false;
        if (str.startsWith("-")) {
            negate = true;
            pos = 1;
        }
        if (str.startsWith("0x", pos) || str.startsWith("0X", pos)) {
            radix = 16;
            pos += 2;
        } else if (str.startsWith("#", pos)) {
            radix = 16;
            ++pos;
        } else if (str.startsWith("0", pos) && str.length() > pos + 1) {
            radix = 8;
            ++pos;
        }
        try {
            BigInteger value = new BigInteger(str.substring(pos), radix);
            return u.Optional.of(negate ? value.negate() : value);
        }
        catch (NumberFormatException e) {
            return u.Optional.empty();
        }
    }

    public static u.Optional<BigDecimal> createBigDecimal(String str) {
        if (N.isNullOrEmptyOrBlank(str) || str.trim().startsWith("--")) {
            return u.Optional.empty();
        }
        try {
            return u.Optional.of(new BigDecimal(str));
        }
        catch (NumberFormatException e) {
            return u.Optional.empty();
        }
    }

    public static u.Optional<Number> createNumber(String str) {
        String exp;
        String mant;
        String dec;
        if (N.isNullOrEmptyOrBlank(str)) {
            return u.Optional.empty();
        }
        char ch = '\u0000';
        ch = str.charAt(0);
        if (!(ch < '\u0080' && alphanumerics[ch] && (ch = str.charAt(str.length() - 1)) < '\u0080' && alphanumerics[ch] && (ch = str.charAt(str.length() / 2)) < '\u0080' && alphanumerics[ch])) {
            return u.Optional.empty();
        }
        String[] hex_prefixes = new String[]{"0x", "0X", "-0x", "-0X", "#", "-#"};
        int pfxLen = 0;
        for (String pfx : hex_prefixes) {
            if (!str.startsWith(pfx)) continue;
            pfxLen += pfx.length();
            break;
        }
        if (pfxLen > 0) {
            char firstSigDigit = '\u0000';
            for (int i = pfxLen; i < str.length() && (firstSigDigit = str.charAt(i)) == '0'; ++i) {
                ++pfxLen;
            }
            int hexDigits = str.length() - pfxLen;
            if (hexDigits > 16 || hexDigits == 16 && firstSigDigit > '7') {
                return StringUtil.createBigInteger(str);
            }
            if (hexDigits > 8 || hexDigits == 8 && firstSigDigit > '7') {
                return StringUtil.createLong(str).boxed();
            }
            return StringUtil.createInteger(str).boxed();
        }
        char lastChar = str.charAt(str.length() - 1);
        int decPos = str.indexOf(46);
        int expPos = str.indexOf(101) + str.indexOf(69) + 1;
        u.Optional<Number> op = null;
        if (decPos > -1) {
            if (expPos > -1) {
                if (expPos < decPos || expPos > str.length()) {
                    return u.Optional.empty();
                }
                dec = str.substring(decPos + 1, expPos);
            } else {
                dec = str.substring(decPos + 1);
            }
            mant = StringUtil.getMantissa(str, decPos);
        } else {
            if (expPos > -1) {
                if (expPos > str.length()) {
                    return u.Optional.empty();
                }
                mant = StringUtil.getMantissa(str, expPos);
            } else {
                mant = StringUtil.getMantissa(str);
            }
            dec = null;
        }
        if (!Character.isDigit(lastChar) && lastChar != '.') {
            exp = expPos > -1 && expPos < str.length() - 1 ? str.substring(expPos + 1, str.length() - 1) : null;
            String numeric = str.substring(0, str.length() - 1);
            boolean allZeros = StringUtil.isAllZeros(mant) && StringUtil.isAllZeros(exp);
            switch (lastChar) {
                case 'L': 
                case 'l': {
                    if (dec == null && exp == null && (numeric.charAt(0) == '-' && StringUtil.isNumeric(numeric.substring(1)) || StringUtil.isNumeric(numeric))) {
                        op = StringUtil.createLong(numeric).boxed();
                        if (op.isPresent()) {
                            return op;
                        }
                        return StringUtil.createBigInteger(numeric);
                    }
                    return u.Optional.empty();
                }
                case 'F': 
                case 'f': {
                    try {
                        Float f = Float.valueOf(str);
                        if (!f.isInfinite() && (f.floatValue() != 0.0f || allZeros)) {
                            return u.Optional.of(f);
                        }
                    }
                    catch (NumberFormatException f) {
                        // empty catch block
                    }
                }
                case 'D': 
                case 'd': {
                    try {
                        Double d = Double.valueOf(str);
                        if (!d.isInfinite() && ((double)d.floatValue() != 0.0 || allZeros)) {
                            return u.Optional.of(d);
                        }
                    }
                    catch (NumberFormatException d) {
                        // empty catch block
                    }
                    return StringUtil.createBigDecimal(numeric);
                }
            }
            return u.Optional.empty();
        }
        exp = expPos > -1 && expPos < str.length() - 1 ? str.substring(expPos + 1, str.length()) : null;
        if (dec == null && exp == null) {
            op = StringUtil.createInteger(str).boxed();
            if (op.isPresent()) {
                return op;
            }
            op = StringUtil.createLong(str).boxed();
            if (op.isPresent()) {
                return op;
            }
            return StringUtil.createBigInteger(str);
        }
        boolean allZeros = StringUtil.isAllZeros(mant) && StringUtil.isAllZeros(exp);
        try {
            Float f = Float.valueOf(str);
            Double d = Double.valueOf(str);
            if (!f.isInfinite() && (f.floatValue() != 0.0f || allZeros) && f.toString().equals(d.toString())) {
                return u.Optional.of(f);
            }
            if (!d.isInfinite() && (d != 0.0 || allZeros)) {
                u.Optional<Number> b = StringUtil.createBigDecimal(str);
                if (b.isPresent() && b.get().compareTo(BigDecimal.valueOf(d)) == 0) {
                    return u.Optional.of(d);
                }
                return b;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return StringUtil.createBigDecimal(str);
    }

    private static String getMantissa(String str) {
        return StringUtil.getMantissa(str, str.length());
    }

    private static String getMantissa(String str, int stopPos) {
        char firstChar = str.charAt(0);
        boolean hasSign = firstChar == '-' || firstChar == '+';
        return hasSign ? str.substring(1, stopPos) : str.substring(0, stopPos);
    }

    private static boolean isAllZeros(String str) {
        if (str == null) {
            return true;
        }
        for (int i = str.length() - 1; i >= 0; --i) {
            if (str.charAt(i) == '0') continue;
            return false;
        }
        return str.length() > 0;
    }

    public static String lenientFormat(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        if (args == null) {
            args = new Object[]{"(Object[])null"};
        } else {
            for (int i = 0; i < args.length; ++i) {
                args[i] = StringUtil.lenientToString(args[i]);
            }
        }
        StringBuilder sb = Objectory.createStringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            sb.append(template, templateStart, placeholderStart);
            sb.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        sb.append(template, templateStart, template.length());
        if (i < args.length) {
            sb.append(" [");
            sb.append(args[i++]);
            while (i < args.length) {
                sb.append(", ");
                sb.append(args[i++]);
            }
            sb.append(']');
        }
        String result = sb.toString();
        Objectory.recycle(sb);
        return result;
    }

    private static String lenientToString(Object obj) {
        try {
            return String.valueOf(obj);
        }
        catch (Exception e) {
            String objectToString = obj.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(obj));
            Logger.getLogger("com.google.common.base.Strings").log(Level.WARNING, "Exception during lenientFormat for " + objectToString, e);
            return "<" + objectToString + " threw " + e.getClass().getName() + ">";
        }
    }

    public static String sort(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        char[] chs = str.toCharArray();
        Array.sort(chs);
        return StringUtil.newString(chs, true);
    }

    @Deprecated
    @Beta
    @Internal
    public static char[] getCharsForReadOnly(String str) {
        if (isStringCharsGettable && strValueField != null && str.length() > 3) {
            try {
                char[] chars = (char[])strValueField.get(str);
                if (chars.length == str.length()) {
                    return chars;
                }
                isStringCharsGettable = false;
            }
            catch (Exception e) {
                isStringCharsGettable = false;
            }
        }
        return str.toCharArray();
    }

    @Internal
    static String newString(char[] a, boolean share) {
        if (share && sharedStringConstructor != null) {
            try {
                return sharedStringConstructor.newInstance(a, true);
            }
            catch (Exception e) {
                throw N.toRuntimeException(e);
            }
        }
        return String.valueOf(a);
    }

    static {
        List<String> delimiters = N.asList(" ", "  ", "   ", "\t", "\n", "\r", ",", ", ", ";", "; ", ":", ": ", " : ", "-", " - ", "_", " _ ", "#", "##", " # ", "=", "==", " = ", "|", " | ", "||", " || ", "&", "&&", "@", "@@", "$", "$$", "*", "**", "+", "++");
        for (String delimiter : delimiters) {
            splitterPool.put(delimiter, Splitter.with(delimiter).omitEmptyStrings(true));
            trimSplitterPool.put(delimiter, Splitter.with(delimiter).omitEmptyStrings(true).trim(true));
            preserveSplitterPool.put(delimiter, Splitter.with(delimiter));
            trimPreserveSplitterPool.put(delimiter, Splitter.with(delimiter).trim(true));
            if (delimiter.length() != 1) continue;
            char delimiterChar = delimiter.charAt(0);
            splitterPool.put(Character.valueOf(delimiterChar), Splitter.with(delimiterChar).omitEmptyStrings(true));
            trimSplitterPool.put(Character.valueOf(delimiterChar), Splitter.with(delimiterChar).omitEmptyStrings(true).trim(true));
            preserveSplitterPool.put(Character.valueOf(delimiterChar), Splitter.with(delimiterChar));
            trimPreserveSplitterPool.put(Character.valueOf(delimiterChar), Splitter.with(delimiterChar).trim(true));
        }
        isStringCharsGettable = true;
        Field tmp = null;
        Field field = strValueField = tmp != null && tmp.getName().equals("value") && tmp.getType().equals(char[].class) ? tmp : null;
        if (strValueField != null) {
            strValueField.setAccessible(true);
        }
        Constructor tmpConstructor = null;
        try {
            tmpConstructor = String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
            tmpConstructor.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        sharedStringConstructor = tmpConstructor;
        pattern_accent = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        alphanumerics = new boolean[128];
        StringUtil.alphanumerics[48] = true;
        StringUtil.alphanumerics[49] = true;
        StringUtil.alphanumerics[50] = true;
        StringUtil.alphanumerics[51] = true;
        StringUtil.alphanumerics[52] = true;
        StringUtil.alphanumerics[53] = true;
        StringUtil.alphanumerics[54] = true;
        StringUtil.alphanumerics[55] = true;
        StringUtil.alphanumerics[56] = true;
        StringUtil.alphanumerics[57] = true;
        StringUtil.alphanumerics[43] = true;
        StringUtil.alphanumerics[45] = true;
        StringUtil.alphanumerics[46] = true;
        StringUtil.alphanumerics[35] = true;
        StringUtil.alphanumerics[120] = true;
        StringUtil.alphanumerics[88] = true;
        StringUtil.alphanumerics[101] = true;
        StringUtil.alphanumerics[69] = true;
        StringUtil.alphanumerics[97] = true;
        StringUtil.alphanumerics[98] = true;
        StringUtil.alphanumerics[99] = true;
        StringUtil.alphanumerics[100] = true;
        StringUtil.alphanumerics[101] = true;
        StringUtil.alphanumerics[102] = true;
        StringUtil.alphanumerics[108] = true;
        StringUtil.alphanumerics[76] = true;
        StringUtil.alphanumerics[102] = true;
        StringUtil.alphanumerics[70] = true;
        StringUtil.alphanumerics[100] = true;
        StringUtil.alphanumerics[68] = true;
    }

    public static final class Strings
    extends StringUtil {
        private Strings() {
        }
    }
}

