/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import java.io.IOException;
import java.io.Writer;

public final class StringWriter
extends Writer {
    private final StringBuilder buf;

    public StringWriter() {
        this(new StringBuilder());
    }

    public StringWriter(int initialSize) {
        this(new StringBuilder(initialSize));
    }

    public StringWriter(StringBuilder sb) {
        this.buf = sb;
        this.lock = this.buf;
    }

    public StringBuilder stringBuilder() {
        return this.buf;
    }

    @Override
    public void write(int c) {
        this.buf.append((char)c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        this.buf.append(cbuf, off, len);
    }

    @Override
    public void write(String str) {
        this.buf.append(str);
    }

    @Override
    public void write(String str, int off, int len) {
        this.buf.append(str, off, off + len);
    }

    @Override
    public StringWriter append(CharSequence csq) throws IOException {
        this.buf.append(csq);
        return this;
    }

    @Override
    public StringWriter append(CharSequence csq, int start, int end) throws IOException {
        this.buf.append(csq, start, end);
        return this;
    }

    @Override
    public StringWriter append(char c) {
        this.buf.append(c);
        return this;
    }

    public String toString() {
        return this.buf.toString();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
    }
}

