/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.N;

public class Timed<T> {
    private final long timeInMillis;
    private final T value;

    Timed(T value, long timeInMillis) {
        this.value = value;
        this.timeInMillis = timeInMillis;
    }

    public static <T> Timed<T> of(T value) {
        return new Timed<T>(value, System.currentTimeMillis());
    }

    public static <T> Timed<T> of(T value, long timeInMillis) {
        return new Timed<T>(value, timeInMillis);
    }

    public long timestamp() {
        return this.timeInMillis;
    }

    public T value() {
        return this.value;
    }

    public int hashCode() {
        return (int)(this.timeInMillis * 31L + (long)(this.value == null ? 0 : this.value.hashCode()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Timed) {
            Timed other = (Timed)obj;
            return this.timeInMillis == other.timeInMillis && N.equals(this.value, other.value);
        }
        return false;
    }

    public String toString() {
        return this.timeInMillis + ": " + N.toString(this.value);
    }
}

