/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;

public final class Try<T extends AutoCloseable> {
    private final T t;

    Try(T t) {
        N.checkArgNotNull(t);
        this.t = t;
    }

    public static <T extends AutoCloseable> Try<T> of(T t) {
        return new Try<T>(t);
    }

    public static <T extends AutoCloseable> Try<T> of(Supplier<T, ? extends Exception> supplier) {
        try {
            return new Try<AutoCloseable>((AutoCloseable)supplier.get());
        }
        catch (Exception e) {
            throw N.toRuntimeException(e);
        }
    }

    public static void run(Runnable<? extends Exception> cmd) {
        try {
            cmd.run();
        }
        catch (Exception e) {
            throw N.toRuntimeException(e);
        }
    }

    public static void run(Runnable<? extends Exception> cmd, com.landawn.abacus.util.function.Consumer<? super Exception> actionOnError) {
        N.checkArgNotNull(actionOnError);
        try {
            cmd.run();
        }
        catch (Exception e) {
            actionOnError.accept(e);
        }
    }

    public static <R> R call(java.util.concurrent.Callable<R> cmd) {
        try {
            return cmd.call();
        }
        catch (Exception e) {
            throw N.toRuntimeException(e);
        }
    }

    public static <R> R call(java.util.concurrent.Callable<R> cmd, com.landawn.abacus.util.function.Function<? super Exception, R> actionOnError) {
        N.checkArgNotNull(actionOnError);
        try {
            return cmd.call();
        }
        catch (Exception e) {
            return actionOnError.apply(e);
        }
    }

    public static <R> R call(java.util.concurrent.Callable<R> cmd, com.landawn.abacus.util.function.Supplier<R> supplier) {
        N.checkArgNotNull(supplier);
        try {
            return cmd.call();
        }
        catch (Exception e) {
            return supplier.get();
        }
    }

    public static <R> R call(java.util.concurrent.Callable<R> cmd, R defaultValue) {
        try {
            return cmd.call();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <R> R call(java.util.concurrent.Callable<R> cmd, com.landawn.abacus.util.function.Predicate<? super Exception> predicate, com.landawn.abacus.util.function.Supplier<R> supplier) {
        N.checkArgNotNull(predicate);
        N.checkArgNotNull(supplier);
        try {
            return cmd.call();
        }
        catch (Exception e) {
            if (predicate.test(e)) {
                return supplier.get();
            }
            throw N.toRuntimeException(e);
        }
    }

    public static <R> R call(java.util.concurrent.Callable<R> cmd, com.landawn.abacus.util.function.Predicate<? super Exception> predicate, R defaultValue) {
        N.checkArgNotNull(predicate);
        try {
            return cmd.call();
        }
        catch (Exception e) {
            if (predicate.test(e)) {
                return defaultValue;
            }
            throw N.toRuntimeException(e);
        }
    }

    public T val() {
        return this.t;
    }

    public void run(Consumer<? super T, ? extends Exception> cmd) {
        try {
            cmd.accept(this.t);
        }
        catch (Exception e) {
            throw N.toRuntimeException(e);
        }
        finally {
            IOUtil.close(this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Consumer<? super T, ? extends Exception> cmd, com.landawn.abacus.util.function.Consumer<? super Exception> actionOnError) {
        N.checkArgNotNull(actionOnError);
        try {
            cmd.accept(this.t);
        }
        catch (Exception e) {
            actionOnError.accept(e);
        }
        finally {
            IOUtil.close(this.t);
        }
    }

    public <R> R call(Function<? super T, R, ? extends Exception> cmd) {
        try {
            R r = cmd.apply(this.t);
            return r;
        }
        catch (Exception e) {
            throw N.toRuntimeException(e);
        }
        finally {
            IOUtil.close(this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R call(Function<? super T, R, ? extends Exception> cmd, com.landawn.abacus.util.function.Function<? super Exception, R> actionOnError) {
        N.checkArgNotNull(actionOnError);
        try {
            R r = cmd.apply(this.t);
            return r;
        }
        catch (Exception e) {
            R r = actionOnError.apply(e);
            return r;
        }
        finally {
            IOUtil.close(this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R call(Function<? super T, R, ? extends Exception> cmd, com.landawn.abacus.util.function.Supplier<R> supplier) {
        N.checkArgNotNull(supplier);
        try {
            R r = cmd.apply(this.t);
            return r;
        }
        catch (Exception e) {
            R r = supplier.get();
            return r;
        }
        finally {
            IOUtil.close(this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R call(Function<? super T, R, ? extends Exception> cmd, R defaultValue) {
        try {
            R r = cmd.apply(this.t);
            return r;
        }
        catch (Exception e) {
            R r = defaultValue;
            return r;
        }
        finally {
            IOUtil.close(this.t);
        }
    }

    public <R> R call(Function<? super T, R, ? extends Exception> cmd, com.landawn.abacus.util.function.Predicate<? super Exception> predicate, com.landawn.abacus.util.function.Supplier<R> supplier) {
        N.checkArgNotNull(predicate);
        N.checkArgNotNull(supplier);
        try {
            R r = cmd.apply(this.t);
            return r;
        }
        catch (Exception e) {
            if (predicate.test(e)) {
                R r = supplier.get();
                return r;
            }
            throw N.toRuntimeException(e);
        }
        finally {
            IOUtil.close(this.t);
        }
    }

    public <R> R call(Function<? super T, R, ? extends Exception> cmd, com.landawn.abacus.util.function.Predicate<? super Exception> predicate, R defaultValue) {
        N.checkArgNotNull(predicate);
        try {
            R r = cmd.apply(this.t);
            return r;
        }
        catch (Exception e) {
            if (predicate.test(e)) {
                R r = defaultValue;
                return r;
            }
            throw N.toRuntimeException(e);
        }
        finally {
            IOUtil.close(this.t);
        }
    }

    public static final class EE {
        private EE() {
        }

        public static interface TriConsumer<A, B, C, E extends Exception, E2 extends Exception> {
            public void accept(A var1, B var2, C var3) throws E, E2;
        }

        public static interface BiConsumer<T, U, E extends Exception, E2 extends Exception> {
            public void accept(T var1, U var2) throws E, E2;
        }

        public static interface Consumer<T, E extends Exception, E2 extends Exception> {
            public void accept(T var1) throws E, E2;
        }

        public static interface TriFunction<A, B, C, R, E extends Exception, E2 extends Exception> {
            public R apply(A var1, B var2, C var3) throws E, E2;
        }

        public static interface BiFunction<T, U, R, E extends Exception, E2 extends Exception> {
            public R apply(T var1, U var2) throws E, E2;
        }

        public static interface Function<T, R, E extends Exception, E2 extends Exception> {
            public R apply(T var1) throws E, E2;
        }

        public static interface TriPredicate<A, B, C, E extends Exception, E2 extends Exception> {
            public boolean test(A var1, B var2, C var3) throws E, E2;
        }

        public static interface BiPredicate<T, U, E extends Exception, E2 extends Exception> {
            public boolean test(T var1, U var2) throws E, E2;
        }

        public static interface Predicate<T, E extends Exception, E2 extends Exception> {
            public boolean test(T var1) throws E, E2;
        }

        public static interface Supplier<T, E extends Exception, E2 extends Exception> {
            public T get() throws E, E2;
        }

        public static interface Callable<R, E extends Exception, E2 extends Exception>
        extends java.util.concurrent.Callable<R> {
            @Override
            public R call() throws E, E2;
        }

        public static interface Runnable<E extends Exception, E2 extends Exception> {
            public void run() throws E, E2;
        }
    }

    public static interface ObjDoubleConsumer<T, E extends Exception> {
        public void accept(T var1, double var2) throws E;
    }

    public static interface ObjFloatConsumer<T, E extends Exception> {
        public void accept(T var1, float var2) throws E;
    }

    public static interface ObjLongConsumer<T, E extends Exception> {
        public void accept(T var1, long var2) throws E;
    }

    public static interface ObjIntConsumer<T, E extends Exception> {
        public void accept(T var1, int var2) throws E;
    }

    public static interface ObjShortConsumer<T, E extends Exception> {
        public void accept(T var1, short var2) throws E;
    }

    public static interface ObjByteConsumer<T, E extends Exception> {
        public void accept(T var1, byte var2) throws E;
    }

    public static interface ObjCharConsumer<T, E extends Exception> {
        public void accept(T var1, char var2) throws E;
    }

    public static interface ObjBooleanConsumer<T, E extends Exception> {
        public void accept(T var1, boolean var2) throws E;
    }

    public static interface DoubleTriConsumer<E extends Exception> {
        public void accept(double var1, double var3, double var5) throws E;
    }

    public static interface FloatTriConsumer<E extends Exception> {
        public void accept(float var1, float var2, float var3) throws E;
    }

    public static interface LongTriConsumer<E extends Exception> {
        public void accept(long var1, long var3, long var5) throws E;
    }

    public static interface IntTriConsumer<E extends Exception> {
        public void accept(int var1, int var2, int var3) throws E;
    }

    public static interface ShortTriConsumer<E extends Exception> {
        public void accept(short var1, short var2, short var3) throws E;
    }

    public static interface ByteTriConsumer<E extends Exception> {
        public void accept(byte var1, byte var2, byte var3) throws E;
    }

    public static interface CharTriConsumer<E extends Exception> {
        public void accept(char var1, char var2, char var3) throws E;
    }

    public static interface BooleanTriConsumer<E extends Exception> {
        public void accept(boolean var1, boolean var2, boolean var3) throws E;
    }

    public static interface DoubleTriFunction<R, E extends Exception> {
        public R apply(double var1, double var3, double var5) throws E;
    }

    public static interface FloatTriFunction<R, E extends Exception> {
        public R apply(float var1, float var2, float var3) throws E;
    }

    public static interface LongTriFunction<R, E extends Exception> {
        public R apply(long var1, long var3, long var5) throws E;
    }

    public static interface IntTriFunction<R, E extends Exception> {
        public R apply(int var1, int var2, int var3) throws E;
    }

    public static interface ShortTriFunction<R, E extends Exception> {
        public R apply(short var1, short var2, short var3) throws E;
    }

    public static interface ByteTriFunction<R, E extends Exception> {
        public R apply(byte var1, byte var2, byte var3) throws E;
    }

    public static interface CharTriFunction<R, E extends Exception> {
        public R apply(char var1, char var2, char var3) throws E;
    }

    public static interface BooleanTriFunction<R, E extends Exception> {
        public R apply(boolean var1, boolean var2, boolean var3) throws E;
    }

    public static interface DoubleTriPredicate<E extends Exception> {
        public boolean test(double var1, double var3, double var5) throws E;
    }

    public static interface FloatTriPredicate<E extends Exception> {
        public boolean test(float var1, float var2, float var3) throws E;
    }

    public static interface LongTriPredicate<E extends Exception> {
        public boolean test(long var1, long var3, long var5) throws E;
    }

    public static interface IntTriPredicate<E extends Exception> {
        public boolean test(int var1, int var2, int var3) throws E;
    }

    public static interface ShortTriPredicate<E extends Exception> {
        public boolean test(short var1, short var2, short var3) throws E;
    }

    public static interface ByteTriPredicate<E extends Exception> {
        public boolean test(byte var1, byte var2, byte var3) throws E;
    }

    public static interface CharTriPredicate<E extends Exception> {
        public boolean test(char var1, char var2, char var3) throws E;
    }

    public static interface BooleanTriPredicate<E extends Exception> {
        public boolean test(boolean var1, boolean var2, boolean var3) throws E;
    }

    public static interface DoubleBiConsumer<E extends Exception> {
        public void accept(double var1, double var3) throws E;
    }

    public static interface FloatBiConsumer<E extends Exception> {
        public void accept(float var1, float var2) throws E;
    }

    public static interface LongBiConsumer<E extends Exception> {
        public void accept(long var1, long var3) throws E;
    }

    public static interface IntBiConsumer<E extends Exception> {
        public void accept(int var1, int var2) throws E;
    }

    public static interface ShortBiConsumer<E extends Exception> {
        public void accept(short var1, short var2) throws E;
    }

    public static interface ByteBiConsumer<E extends Exception> {
        public void accept(byte var1, byte var2) throws E;
    }

    public static interface CharBiConsumer<E extends Exception> {
        public void accept(char var1, char var2) throws E;
    }

    public static interface BooleanBiConsumer<E extends Exception> {
        public void accept(boolean var1, boolean var2) throws E;
    }

    public static interface DoubleBiFunction<R, E extends Exception> {
        public R apply(double var1, double var3) throws E;
    }

    public static interface FloatBiFunction<R, E extends Exception> {
        public R apply(float var1, float var2) throws E;
    }

    public static interface LongBiFunction<R, E extends Exception> {
        public R apply(long var1, long var3) throws E;
    }

    public static interface IntBiFunction<R, E extends Exception> {
        public R apply(int var1, int var2) throws E;
    }

    public static interface ShortBiFunction<R, E extends Exception> {
        public R apply(short var1, short var2) throws E;
    }

    public static interface ByteBiFunction<R, E extends Exception> {
        public R apply(byte var1, byte var2) throws E;
    }

    public static interface CharBiFunction<R, E extends Exception> {
        public R apply(char var1, char var2) throws E;
    }

    public static interface BooleanBiFunction<R, E extends Exception> {
        public R apply(boolean var1, boolean var2) throws E;
    }

    public static interface DoubleBiPredicate<E extends Exception> {
        public boolean test(double var1, double var3) throws E;
    }

    public static interface FloatBiPredicate<E extends Exception> {
        public boolean test(float var1, float var2) throws E;
    }

    public static interface LongBiPredicate<E extends Exception> {
        public boolean test(long var1, long var3) throws E;
    }

    public static interface IntBiPredicate<E extends Exception> {
        public boolean test(int var1, int var2) throws E;
    }

    public static interface ShortBiPredicate<E extends Exception> {
        public boolean test(short var1, short var2) throws E;
    }

    public static interface ByteBiPredicate<E extends Exception> {
        public boolean test(byte var1, byte var2) throws E;
    }

    public static interface CharBiPredicate<E extends Exception> {
        public boolean test(char var1, char var2) throws E;
    }

    public static interface BooleanBiPredicate<E extends Exception> {
        public boolean test(boolean var1, boolean var2) throws E;
    }

    public static interface DoubleTernaryOperator<E extends Exception> {
        public double applyAsDouble(double var1, double var3, double var5) throws E;
    }

    public static interface FloatTernaryOperator<E extends Exception> {
        public float applyAsFloat(float var1, float var2, float var3) throws E;
    }

    public static interface LongTernaryOperator<E extends Exception> {
        public long applyAsLong(long var1, long var3, long var5) throws E;
    }

    public static interface IntTernaryOperator<E extends Exception> {
        public int applyAsInt(int var1, int var2, int var3) throws E;
    }

    public static interface ShortTernaryOperator<E extends Exception> {
        public short applyAsShort(short var1, short var2, short var3) throws E;
    }

    public static interface ByteTernaryOperator<E extends Exception> {
        public byte applyAsByte(byte var1, byte var2, byte var3) throws E;
    }

    public static interface CharTernaryOperator<E extends Exception> {
        public char applyAsChar(char var1, char var2, char var3) throws E;
    }

    public static interface BooleanTernaryOperator<E extends Exception> {
        public boolean applyAsBoolean(boolean var1, boolean var2, boolean var3) throws E;
    }

    public static interface DoubleBinaryOperator<E extends Exception> {
        public double applyAsDouble(double var1, double var3) throws E;
    }

    public static interface FloatBinaryOperator<E extends Exception> {
        public float applyAsFloat(float var1, float var2) throws E;
    }

    public static interface LongBinaryOperator<E extends Exception> {
        public long applyAsLong(long var1, long var3) throws E;
    }

    public static interface IntBinaryOperator<E extends Exception> {
        public int applyAsInt(int var1, int var2) throws E;
    }

    public static interface ShortBinaryOperator<E extends Exception> {
        public short applyAsShort(short var1, short var2) throws E;
    }

    public static interface ByteBinaryOperator<E extends Exception> {
        public byte applyAsByte(byte var1, byte var2) throws E;
    }

    public static interface CharBinaryOperator<E extends Exception> {
        public char applyAsChar(char var1, char var2) throws E;
    }

    public static interface BooleanBinaryOperator<E extends Exception> {
        public boolean applyAsBoolean(boolean var1, boolean var2) throws E;
    }

    public static interface DoubleUnaryOperator<E extends Exception> {
        public double applyAsDouble(double var1) throws E;
    }

    public static interface FloatUnaryOperator<E extends Exception> {
        public float applyAsFloat(float var1) throws E;
    }

    public static interface LongUnaryOperator<E extends Exception> {
        public long applyAsLong(long var1) throws E;
    }

    public static interface IntUnaryOperator<E extends Exception> {
        public int applyAsInt(int var1) throws E;
    }

    public static interface ShortUnaryOperator<E extends Exception> {
        public short applyAsShort(short var1) throws E;
    }

    public static interface ByteUnaryOperator<E extends Exception> {
        public byte applyAsByte(byte var1) throws E;
    }

    public static interface CharUnaryOperator<E extends Exception> {
        public char applyAsChar(char var1) throws E;
    }

    public static interface BooleanUnaryOperator<E extends Exception> {
        public boolean applyAsBoolean(boolean var1) throws E;
    }

    public static interface TernaryOperator<T, E extends Exception>
    extends BiFunction<T, T, T, E> {
    }

    public static interface BinaryOperator<T, E extends Exception>
    extends BiFunction<T, T, T, E> {
    }

    public static interface UnaryOperator<T, E extends Exception>
    extends Function<T, T, E> {
    }

    public static interface ToDoubleFunction<T, E extends Exception> {
        public double applyAsDouble(T var1) throws E;
    }

    public static interface ToFloatFunction<T, E extends Exception> {
        public float applyAsFloat(T var1) throws E;
    }

    public static interface ToLongFunction<T, E extends Exception> {
        public long applyAsLong(T var1) throws E;
    }

    public static interface ToIntFunction<T, E extends Exception> {
        public int applyAsInt(T var1) throws E;
    }

    public static interface ToShortFunction<T, E extends Exception> {
        public short applyAsShort(T var1) throws E;
    }

    public static interface ToByteFunction<T, E extends Exception> {
        public byte applyAsByte(T var1) throws E;
    }

    public static interface ToCharFunction<T, E extends Exception> {
        public char applyAsChar(T var1) throws E;
    }

    public static interface ToBooleanFunction<T, E extends Exception> {
        public boolean applyAsBoolean(T var1) throws E;
    }

    public static interface DoubleConsumer<E extends Exception> {
        public void accept(double var1) throws E;
    }

    public static interface DoubleFunction<R, E extends Exception> {
        public R apply(double var1) throws E;
    }

    public static interface DoublePredicate<E extends Exception> {
        public boolean test(double var1) throws E;
    }

    public static interface FloatConsumer<E extends Exception> {
        public void accept(float var1) throws E;
    }

    public static interface FloatFunction<R, E extends Exception> {
        public R apply(float var1) throws E;
    }

    public static interface FloatPredicate<E extends Exception> {
        public boolean test(float var1) throws E;
    }

    public static interface LongConsumer<E extends Exception> {
        public void accept(long var1) throws E;
    }

    public static interface LongFunction<R, E extends Exception> {
        public R apply(long var1) throws E;
    }

    public static interface LongPredicate<E extends Exception> {
        public boolean test(long var1) throws E;
    }

    public static interface IntConsumer<E extends Exception> {
        public void accept(int var1) throws E;
    }

    public static interface IntFunction<R, E extends Exception> {
        public R apply(int var1) throws E;
    }

    public static interface IntPredicate<E extends Exception> {
        public boolean test(int var1) throws E;
    }

    public static interface ShortConsumer<E extends Exception> {
        public void accept(short var1) throws E;
    }

    public static interface ShortFunction<R, E extends Exception> {
        public R apply(short var1) throws E;
    }

    public static interface ShortPredicate<E extends Exception> {
        public boolean test(short var1) throws E;
    }

    public static interface ByteConsumer<E extends Exception> {
        public void accept(byte var1) throws E;
    }

    public static interface ByteFunction<R, E extends Exception> {
        public R apply(byte var1) throws E;
    }

    public static interface BytePredicate<E extends Exception> {
        public boolean test(byte var1) throws E;
    }

    public static interface CharConsumer<E extends Exception> {
        public void accept(char var1) throws E;
    }

    public static interface CharFunction<R, E extends Exception> {
        public R apply(char var1) throws E;
    }

    public static interface CharPredicate<E extends Exception> {
        public boolean test(char var1) throws E;
    }

    public static interface BooleanConsumer<E extends Exception> {
        public void accept(boolean var1) throws E;
    }

    public static interface BooleanFunction<R, E extends Exception> {
        public R apply(boolean var1) throws E;
    }

    public static interface BooleanPredicate<E extends Exception> {
        public boolean test(boolean var1) throws E;
    }

    public static interface IndexedBiPredicate<U, T, E extends Exception> {
        public boolean test(U var1, int var2, T var3) throws E;
    }

    public static interface IndexedPredicate<T, E extends Exception> {
        public boolean test(int var1, T var2) throws E;
    }

    public static interface IndexedBiFunction<U, T, R, E extends Exception> {
        public R apply(U var1, int var2, T var3) throws E;
    }

    public static interface IndexedFunction<T, R, E extends Exception> {
        public R apply(int var1, T var2) throws E;
    }

    public static interface IndexedBiConsumer<U, T, E extends Exception> {
        public void accept(U var1, int var2, T var3) throws E;
    }

    public static interface IndexedConsumer<T, E extends Exception> {
        public void accept(int var1, T var2) throws E;
    }

    public static interface QuadConsumer<A, B, C, D, E extends Exception> {
        public void accept(A var1, B var2, C var3, D var4) throws E;
    }

    public static interface TriConsumer<A, B, C, E extends Exception> {
        public void accept(A var1, B var2, C var3) throws E;
    }

    public static interface BiConsumer<T, U, E extends Exception> {
        public void accept(T var1, U var2) throws E;
    }

    public static interface Consumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }

    public static interface QuadFunction<A, B, C, D, R, E extends Exception> {
        public R apply(A var1, B var2, C var3, D var4) throws E;
    }

    public static interface TriFunction<A, B, C, R, E extends Exception> {
        public R apply(A var1, B var2, C var3) throws E;
    }

    public static interface BiFunction<T, U, R, E extends Exception> {
        public R apply(T var1, U var2) throws E;
    }

    public static interface Function<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }

    public static interface QuadPredicate<A, B, C, D, E extends Exception> {
        public boolean test(A var1, B var2, C var3, D var4) throws E;
    }

    public static interface TriPredicate<A, B, C, E extends Exception> {
        public boolean test(A var1, B var2, C var3) throws E;
    }

    public static interface BiPredicate<T, U, E extends Exception> {
        public boolean test(T var1, U var2) throws E;
    }

    public static interface Predicate<T, E extends Exception> {
        public boolean test(T var1) throws E;
    }

    public static interface DoubleSupplier<E extends Exception> {
        public double getAsDouble() throws E;
    }

    public static interface FloatSupplier<E extends Exception> {
        public float getAsFloat() throws E;
    }

    public static interface LongSupplier<E extends Exception> {
        public long getAsLong() throws E;
    }

    public static interface IntSupplier<E extends Exception> {
        public int getAsInt() throws E;
    }

    public static interface ShortSupplier<E extends Exception> {
        public short getAsShort() throws E;
    }

    public static interface ByteSupplier<E extends Exception> {
        public byte getAsByte() throws E;
    }

    public static interface CharSupplier<E extends Exception> {
        public char getAsChar() throws E;
    }

    public static interface BooleanSupplier<E extends Exception> {
        public boolean getAsBoolean() throws E;
    }

    public static interface Supplier<T, E extends Exception> {
        public T get() throws E;
    }

    public static interface Callable<R, E extends Exception>
    extends java.util.concurrent.Callable<R> {
        @Override
        public R call() throws E;
    }

    public static interface Runnable<E extends Exception> {
        public void run() throws E;
    }
}

