/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.parser.ParserUtil;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.util.Charsets;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.Maps;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.StringUtil;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;

public final class URLEncodedUtil {
    public static final char QP_SEP_A = '&';
    public static final char QP_SEP_S = ';';
    public static final String NAME_VALUE_SEPARATOR = "=";
    private static final char[] QP_SEPS;
    private static final String QP_SEP_PATTERN;
    private static final BitSet UNRESERVED;
    private static final BitSet PUNCT;
    private static final BitSet USERINFO;
    private static final BitSet PATHSAFE;
    private static final BitSet URIC;
    private static final BitSet RESERVED;
    private static final BitSet URLENCODER;
    private static final int RADIX = 16;

    private URLEncodedUtil() {
    }

    public static Map<String, String> decode(String urlQuery) {
        return URLEncodedUtil.decode(urlQuery, Charsets.UTF_8);
    }

    public static Map<String, String> decode(String urlQuery, Charset charset) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (N.isNullOrEmpty(urlQuery)) {
            return result;
        }
        Scanner scanner = new Scanner(urlQuery);
        scanner.useDelimiter(QP_SEP_PATTERN);
        String name = null;
        String value = null;
        while (scanner.hasNext()) {
            String token = scanner.next();
            int i = token.indexOf(NAME_VALUE_SEPARATOR);
            if (i != -1) {
                name = URLEncodedUtil.decodeFormFields(token.substring(0, i).trim(), charset);
                value = URLEncodedUtil.decodeFormFields(token.substring(i + 1).trim(), charset);
            } else {
                name = URLEncodedUtil.decodeFormFields(token.trim(), charset);
                value = null;
            }
            result.put(name, value);
        }
        scanner.close();
        return result;
    }

    public static <T> T decode(Class<T> targetClass, String urlQuery) {
        return URLEncodedUtil.decode(targetClass, urlQuery, Charsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T decode(Class<T> targetClass, String urlQuery, Charset charset) {
        T result = N.newInstance(targetClass);
        if (N.isNullOrEmpty(urlQuery)) {
            return result;
        }
        Scanner scanner = new Scanner(urlQuery);
        scanner.useDelimiter(QP_SEP_PATTERN);
        Type<Object> propType = null;
        Object propValue = null;
        String name = null;
        String value = null;
        ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(targetClass);
        try {
            while (scanner.hasNext()) {
                String token = scanner.next();
                int i = token.indexOf(NAME_VALUE_SEPARATOR);
                if (i != -1) {
                    name = URLEncodedUtil.decodeFormFields(token.substring(0, i).trim(), charset);
                    value = URLEncodedUtil.decodeFormFields(token.substring(i + 1).trim(), charset);
                } else {
                    name = URLEncodedUtil.decodeFormFields(token.trim(), charset);
                    value = null;
                }
                propType = entityInfo.getPropInfo((String)name).jsonXmlType;
                propValue = value == null ? propType.defaultValue() : propType.valueOf(value);
                ClassUtil.setPropValue(result, name, propValue);
            }
        }
        finally {
            scanner.close();
        }
        return result;
    }

    public static <T> T parameters2Entity(Class<T> targetClass, Map<String, String[]> parameters) {
        T result = N.newInstance(targetClass);
        if (N.isNullOrEmpty(parameters)) {
            return result;
        }
        ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(targetClass);
        ParserUtil.PropInfo propInfo = null;
        Object propValue = null;
        Object[] values = null;
        for (String key : parameters.keySet()) {
            propInfo = entityInfo.getPropInfo(key);
            values = parameters.get(key);
            propValue = N.isNullOrEmpty(values) ? propInfo.jsonXmlType.defaultValue() : (propInfo.jsonXmlType.clazz().equals(String[].class) ? values : propInfo.jsonXmlType.valueOf(StringUtil.join(values, ", ")));
            propInfo.setPropValue(result, propValue);
        }
        return result;
    }

    public static String encode(Object parameters) {
        return URLEncodedUtil.encode(parameters, Charsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encode(Object parameters, Charset charset) {
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            URLEncodedUtil.encode(sb, parameters, charset);
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static String encode(String url, Object parameters) {
        return URLEncodedUtil.encode(url, parameters, Charsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encode(String url, Object parameters, Charset charset) {
        if (parameters == null || parameters instanceof Map && ((Map)parameters).isEmpty()) {
            return url;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            sb.append(url);
            sb.append('?');
            URLEncodedUtil.encode(sb, parameters, charset);
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public static void encode(StringBuilder output, Object parameters) {
        URLEncodedUtil.encode(output, parameters, Charsets.UTF_8);
    }

    public static void encode(StringBuilder output, Object parameters, Charset charset) {
        if (parameters == null || parameters instanceof Map && ((Map)parameters).isEmpty()) {
            return;
        }
        if (parameters instanceof Map) {
            Map map = (Map)parameters;
            int i = 0;
            for (Map.Entry entry : map.entrySet()) {
                if (i++ > 0) {
                    output.append('&');
                }
                URLEncodedUtil.encodeFormFields(output, (String)entry.getKey(), charset);
                output.append(NAME_VALUE_SEPARATOR);
                URLEncodedUtil.encodeFormFields(output, N.stringOf(entry.getValue()), charset);
            }
        } else if (ClassUtil.isEntity(parameters.getClass())) {
            URLEncodedUtil.encode(output, Maps.entity2Map(parameters, true), charset);
        } else if (parameters instanceof Object[]) {
            Object[] a = (Object[])parameters;
            if (0 != a.length % 2) {
                throw new IllegalArgumentException("The parameters must be the pairs of property name and value, or Map, or an entity class with getter/setter methods.");
            }
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    output.append('&');
                }
                URLEncodedUtil.encodeFormFields(output, (String)a[i], charset);
                output.append(NAME_VALUE_SEPARATOR);
                URLEncodedUtil.encodeFormFields(output, N.stringOf(a[++i]), charset);
            }
        } else {
            URLEncodedUtil.encodeFormFields(output, N.stringOf(parameters), charset);
        }
    }

    private static String decodeFormFields(String content, Charset charset) {
        if (content == null) {
            return null;
        }
        return URLEncodedUtil.urlDecode(content, charset != null ? charset : Charsets.UTF_8, true);
    }

    private static String urlDecode(String content, Charset charset, boolean plusAsBlank) {
        if (content == null) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.allocate(content.length());
        CharBuffer cb = CharBuffer.wrap(content);
        while (cb.hasRemaining()) {
            char c = cb.get();
            if (c == '%' && cb.remaining() >= 2) {
                char uc = cb.get();
                char lc = cb.get();
                int u2 = Character.digit(uc, 16);
                int l = Character.digit(lc, 16);
                if (u2 != -1 && l != -1) {
                    bb.put((byte)((u2 << 4) + l));
                    continue;
                }
                bb.put((byte)37);
                bb.put((byte)uc);
                bb.put((byte)lc);
                continue;
            }
            if (plusAsBlank && c == '+') {
                bb.put((byte)32);
                continue;
            }
            bb.put((byte)c);
        }
        bb.flip();
        return charset.decode(bb).toString();
    }

    private static void encodeFormFields(StringBuilder sb, String content, Charset charset) {
        URLEncodedUtil.urlEncode(sb, content, charset != null ? charset : Charsets.UTF_8, URLENCODER, true);
    }

    private static void urlEncode(StringBuilder sb, String content, Charset charset, BitSet safechars, boolean blankAsPlus) {
        if (content == null) {
            sb.append(N.NULL_STRING);
            return;
        }
        ByteBuffer bb = charset.encode(content);
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (safechars.get(b)) {
                sb.append((char)b);
                continue;
            }
            if (blankAsPlus && b == 32) {
                sb.append('+');
                continue;
            }
            sb.append('%');
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            sb.append(hex1);
            sb.append(hex2);
        }
    }

    static void encUserInfo(StringBuilder sb, String content, Charset charset) {
        URLEncodedUtil.urlEncode(sb, content, charset, USERINFO, false);
    }

    static void encUric(StringBuilder sb, String content, Charset charset) {
        URLEncodedUtil.urlEncode(sb, content, charset, URIC, false);
    }

    static void encPath(StringBuilder sb, String content, Charset charset) {
        URLEncodedUtil.urlEncode(sb, content, charset, PATHSAFE, false);
    }

    static {
        int i;
        QP_SEPS = new char[]{'&', ';'};
        QP_SEP_PATTERN = "[" + new String(QP_SEPS) + "]";
        UNRESERVED = new BitSet(256);
        PUNCT = new BitSet(256);
        USERINFO = new BitSet(256);
        PATHSAFE = new BitSet(256);
        URIC = new BitSet(256);
        RESERVED = new BitSet(256);
        URLENCODER = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            UNRESERVED.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            UNRESERVED.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            UNRESERVED.set(i);
        }
        UNRESERVED.set(95);
        UNRESERVED.set(45);
        UNRESERVED.set(46);
        UNRESERVED.set(42);
        URLENCODER.or(UNRESERVED);
        UNRESERVED.set(33);
        UNRESERVED.set(126);
        UNRESERVED.set(39);
        UNRESERVED.set(40);
        UNRESERVED.set(41);
        PUNCT.set(44);
        PUNCT.set(59);
        PUNCT.set(58);
        PUNCT.set(36);
        PUNCT.set(38);
        PUNCT.set(43);
        PUNCT.set(61);
        USERINFO.or(UNRESERVED);
        USERINFO.or(PUNCT);
        PATHSAFE.or(UNRESERVED);
        PATHSAFE.set(47);
        PATHSAFE.set(59);
        PATHSAFE.set(58);
        PATHSAFE.set(64);
        PATHSAFE.set(38);
        PATHSAFE.set(61);
        PATHSAFE.set(43);
        PATHSAFE.set(36);
        PATHSAFE.set(44);
        RESERVED.set(59);
        RESERVED.set(47);
        RESERVED.set(63);
        RESERVED.set(58);
        RESERVED.set(64);
        RESERVED.set(38);
        RESERVED.set(61);
        RESERVED.set(43);
        RESERVED.set(36);
        RESERVED.set(44);
        RESERVED.set(91);
        RESERVED.set(93);
        URIC.or(RESERVED);
        URIC.or(UNRESERVED);
    }
}

