/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.N;
import java.util.regex.Pattern;

public class ValidatorUtil {
    private static final Pattern emailPattern = Pattern.compile("^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$");
    private static final Pattern passwordPattern = Pattern.compile("((?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*[" + ValidatorUtil.escapeSpeicalChars("`~!@#$%^&*()-_=+[{]}\\|;:'\",<.>/?") + "]).{6,16})");

    public static boolean isValidEmailAddress(String emailAddress) {
        return !N.isNullOrEmpty(emailAddress) && emailPattern.matcher(emailAddress).matches();
    }

    public static boolean isValidPassword(String password) {
        return !N.isNullOrEmpty(password) && passwordPattern.matcher(password).matches();
    }

    public static Validator<String> buildPasswordValidator(boolean forceCapitalLetter, boolean forceNumber, String specialChars, int minLength, int maxLength) {
        final StringBuilder sb = new StringBuilder("((?=.*[a-z])");
        if (forceCapitalLetter) {
            sb.append("(?=.*[A-Z])");
        }
        if (forceNumber) {
            sb.append("(?=.*[0-9])");
        }
        if (N.notNullOrEmpty(specialChars)) {
            sb.append(ValidatorUtil.escapeSpeicalChars(specialChars));
        }
        sb.append(".{" + minLength + "," + maxLength + "})");
        return new Validator<String>(){
            private final Pattern pwdPattern;
            {
                this.pwdPattern = Pattern.compile(sb.toString());
            }

            @Override
            public boolean isValid(String value) {
                return N.notNullOrEmpty(value) && this.pwdPattern.matcher(value).matches();
            }
        };
    }

    private static String escapeSpeicalChars(String regexString) {
        return regexString.replaceAll("([\\\\\\.\\[\\{\\(\\*\\+\\?\\^\\$\\|\\)\\]\\}])", "\\\\$1");
    }

    public static interface Validator<T> {
        public boolean isValid(T var1);
    }
}

