/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.N;
import com.landawn.abacus.util.function.BiPredicate;
import com.landawn.abacus.util.function.Function;
import com.landawn.abacus.util.function.ToIntFunction;

public final class Wrapper<T> {
    static final ToIntFunction<Object> arrayHashFunction = new ToIntFunction<Object>(){

        @Override
        public int applyAsInt(Object value) {
            return N.deepHashCode(value);
        }
    };
    static final BiPredicate<Object, Object> arrayEqualsFunction = new BiPredicate<Object, Object>(){

        @Override
        public boolean test(Object t, Object u2) {
            return N.deepEquals(t, u2);
        }
    };
    private final T value;
    private final ToIntFunction<? super T> hashFunction;
    private final BiPredicate<? super T, ? super T> equalsFunction;
    private final Function<? super T, String> toStringFunction;
    private int hashCode;

    private Wrapper(T value, ToIntFunction<? super T> hashFunction, BiPredicate<? super T, ? super T> equalsFunction) {
        this((T)value, hashFunction, equalsFunction, null);
    }

    private Wrapper(T value, ToIntFunction<? super T> hashFunction, BiPredicate<? super T, ? super T> equalsFunction, Function<? super T, String> toStringFunction) {
        this.value = value;
        this.hashFunction = hashFunction;
        this.equalsFunction = equalsFunction;
        this.toStringFunction = toStringFunction;
    }

    public static <T> Wrapper<T> of(T array) {
        return new Wrapper<Object>(array, arrayHashFunction, arrayEqualsFunction);
    }

    public static <T> Wrapper<T> of(T value, ToIntFunction<? super T> hashFunction, BiPredicate<? super T, ? super T> equalsFunction) {
        N.checkArgNotNull(hashFunction, "hashFunction");
        N.checkArgNotNull(equalsFunction, "equalsFunction");
        return new Wrapper<T>(value, hashFunction, equalsFunction);
    }

    public static <T> Wrapper<T> of(T value, ToIntFunction<? super T> hashFunction, BiPredicate<? super T, ? super T> equalsFunction, Function<? super T, String> toStringFunction) {
        N.checkArgNotNull(hashFunction, "hashFunction");
        N.checkArgNotNull(equalsFunction, "equalsFunction");
        N.checkArgNotNull(toStringFunction, "toStringFunction");
        return new Wrapper<T>(value, hashFunction, equalsFunction, toStringFunction);
    }

    public T value() {
        return this.value;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.value == null ? 0 : this.hashFunction.applyAsInt(this.value);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Wrapper && this.equalsFunction.test(((Wrapper)obj).value, this.value);
    }

    public String toString() {
        if (this.toStringFunction == null) {
            if (this.value == null) {
                return "Wrapper[null]";
            }
            return String.format("Wrapper[%s]", N.toString(this.value));
        }
        return this.toStringFunction.apply(this.value);
    }
}

