/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.exception.AbacusException;
import com.landawn.abacus.exception.ParseException;
import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.parser.XMLParser;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.util.ByteArrayOutputStream;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XMLUtil {
    protected static final Logger logger;
    static final String NAME = "name";
    static final String TYPE = "type";
    private static final int POOL_SIZE = 1000;
    private static final SAXParserFactory saxParserFactory;
    private static final Queue<SAXParser> saxParserPool;
    private static final DocumentBuilderFactory docBuilderFactory;
    private static final Queue<DocumentBuilder> contentDocBuilderPool;
    private static final XMLInputFactory xmlInputFactory;
    private static final XMLOutputFactory xmlOutputFactory;
    private static final TransformerFactory transferFactory;
    private static final Map<String, JAXBContext> pathJaxbContextPool;
    private static final Map<Class<?>, JAXBContext> classJaxbContextPool;
    private static final Map<Class<?>, Map<String, Class<?>>> nodeNameClassMapPool;
    private static final Map<String, NodeType> nodeTypePool;

    private XMLUtil() {
    }

    public static String marshal(Object jaxbEntity) {
        Class<?> cls = jaxbEntity.getClass();
        JAXBContext jc = classJaxbContextPool.get(cls);
        ByteArrayOutputStream writer = Objectory.createByteArrayOutputStream();
        try {
            if (jc == null) {
                jc = JAXBContext.newInstance((Class[])new Class[]{cls});
                classJaxbContextPool.put(cls, jc);
            }
            Marshaller marshaller = jc.createMarshaller();
            marshaller.marshal(jaxbEntity, (OutputStream)writer);
            writer.flush();
            String string = writer.toString();
            return string;
        }
        catch (JAXBException e) {
            throw N.toRuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(writer);
        }
    }

    public static <T> T unmarshal(Class<? extends T> cls, String xml) {
        JAXBContext jc = classJaxbContextPool.get(cls);
        try {
            if (jc == null) {
                jc = JAXBContext.newInstance((Class[])new Class[]{cls});
                classJaxbContextPool.put(cls, jc);
            }
            Unmarshaller nnmarshaller = jc.createUnmarshaller();
            StringReader reader = new StringReader(xml);
            return (T)nnmarshaller.unmarshal((Reader)reader);
        }
        catch (JAXBException e) {
            throw N.toRuntimeException(e);
        }
    }

    public static Marshaller createMarshaller(String contextPath) {
        JAXBContext jc = pathJaxbContextPool.get(contextPath);
        try {
            if (jc == null) {
                jc = JAXBContext.newInstance((String)contextPath);
                pathJaxbContextPool.put(contextPath, jc);
            }
            return jc.createMarshaller();
        }
        catch (JAXBException e) {
            throw N.toRuntimeException(e);
        }
    }

    public static Marshaller createMarshaller(Class<?> cls) {
        JAXBContext jc = classJaxbContextPool.get(cls);
        try {
            if (jc == null) {
                jc = JAXBContext.newInstance((Class[])new Class[]{cls});
                classJaxbContextPool.put(cls, jc);
            }
            return jc.createMarshaller();
        }
        catch (JAXBException e) {
            throw N.toRuntimeException(e);
        }
    }

    public static Unmarshaller createUnmarshaller(String contextPath) {
        JAXBContext jc = pathJaxbContextPool.get(contextPath);
        try {
            if (jc == null) {
                jc = JAXBContext.newInstance((String)contextPath);
                pathJaxbContextPool.put(contextPath, jc);
            }
            return jc.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw N.toRuntimeException(e);
        }
    }

    public static Unmarshaller createUnmarshaller(Class<?> cls) {
        JAXBContext jc = classJaxbContextPool.get(cls);
        try {
            if (jc == null) {
                jc = JAXBContext.newInstance((Class[])new Class[]{cls});
                classJaxbContextPool.put(cls, jc);
            }
            return jc.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw N.toRuntimeException(e);
        }
    }

    public static DocumentBuilder createDOMParser() {
        DocumentBuilderFactory documentBuilderFactory = docBuilderFactory;
        synchronized (documentBuilderFactory) {
            try {
                return docBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw N.toRuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentBuilder createDOMParser(boolean ignoreComments, boolean ignoringElementContentWhitespace) {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = docBuilderFactory;
        synchronized (documentBuilderFactory) {
            try {
                boolean orgIgnoreComments = docBuilderFactory.isIgnoringComments();
                boolean orgIgnoringElementContentWhitespace = docBuilderFactory.isIgnoringElementContentWhitespace();
                docBuilderFactory.setIgnoringComments(ignoreComments);
                docBuilderFactory.setIgnoringElementContentWhitespace(ignoringElementContentWhitespace);
                documentBuilder = docBuilderFactory.newDocumentBuilder();
                docBuilderFactory.setIgnoringComments(orgIgnoreComments);
                docBuilderFactory.setIgnoringElementContentWhitespace(orgIgnoringElementContentWhitespace);
            }
            catch (ParserConfigurationException e) {
                throw N.toRuntimeException(e);
            }
        }
        return documentBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentBuilder createContentParser() {
        Queue<DocumentBuilder> queue = contentDocBuilderPool;
        synchronized (queue) {
            DocumentBuilder documentBuilder = contentDocBuilderPool.poll();
            try {
                if (documentBuilder == null) {
                    boolean orgIgnoreComments = docBuilderFactory.isIgnoringComments();
                    boolean orgIgnoringElementContentWhitespace = docBuilderFactory.isIgnoringElementContentWhitespace();
                    if (!orgIgnoreComments) {
                        docBuilderFactory.setIgnoringComments(true);
                    }
                    if (!orgIgnoringElementContentWhitespace) {
                        docBuilderFactory.setIgnoringElementContentWhitespace(true);
                    }
                    documentBuilder = docBuilderFactory.newDocumentBuilder();
                    docBuilderFactory.setIgnoringComments(orgIgnoreComments);
                    docBuilderFactory.setIgnoringElementContentWhitespace(orgIgnoringElementContentWhitespace);
                }
            }
            catch (ParserConfigurationException e) {
                throw N.toRuntimeException(e);
            }
            return documentBuilder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recycleContentParser(DocumentBuilder docBuilder) {
        if (docBuilder == null) {
            return;
        }
        Queue<DocumentBuilder> queue = contentDocBuilderPool;
        synchronized (queue) {
            if (contentDocBuilderPool.size() < 1000) {
                docBuilder.reset();
                contentDocBuilderPool.add(docBuilder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SAXParser createSAXParser() {
        Queue<SAXParser> queue = saxParserPool;
        synchronized (queue) {
            SAXParser saxParser = saxParserPool.poll();
            if (saxParser == null) {
                try {
                    saxParser = saxParserFactory.newSAXParser();
                }
                catch (ParserConfigurationException e) {
                    throw N.toRuntimeException(e);
                }
                catch (SAXException e) {
                    throw new ParseException(e);
                }
            }
            return saxParser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recycleSAXParser(SAXParser saxParser) {
        if (saxParser == null) {
            return;
        }
        Queue<SAXParser> queue = saxParserPool;
        synchronized (queue) {
            if (saxParserPool.size() < 1000) {
                saxParser.reset();
                saxParserPool.add(saxParser);
            }
        }
    }

    public static XMLStreamReader createXMLStreamReader(Reader reader) {
        try {
            return xmlInputFactory.createXMLStreamReader(reader);
        }
        catch (XMLStreamException e) {
            throw N.toRuntimeException(e);
        }
    }

    public static XMLStreamReader createXMLStreamReader(InputStream stream) {
        try {
            return xmlInputFactory.createXMLStreamReader(stream);
        }
        catch (XMLStreamException e) {
            throw N.toRuntimeException(e);
        }
    }

    public static XMLStreamReader createXMLStreamReader(InputStream stream, String encoding) {
        try {
            return xmlInputFactory.createXMLStreamReader(stream, encoding);
        }
        catch (XMLStreamException e) {
            throw N.toRuntimeException(e);
        }
    }

    public static XMLStreamReader createFilteredStreamReader(XMLStreamReader reader, StreamFilter filter) {
        try {
            return xmlInputFactory.createFilteredReader(reader, filter);
        }
        catch (XMLStreamException e) {
            throw N.toRuntimeException(e);
        }
    }

    public static XMLStreamWriter createXMLStreamWriter(Writer writer) {
        try {
            return xmlOutputFactory.createXMLStreamWriter(writer);
        }
        catch (XMLStreamException e) {
            throw N.toRuntimeException(e);
        }
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream stream) {
        try {
            return xmlOutputFactory.createXMLStreamWriter(stream);
        }
        catch (XMLStreamException e) {
            throw N.toRuntimeException(e);
        }
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream stream, String encoding) {
        try {
            return xmlOutputFactory.createXMLStreamWriter(stream, encoding);
        }
        catch (XMLStreamException e) {
            throw N.toRuntimeException(e);
        }
    }

    public static Transformer createXMLTransformer() {
        try {
            return transferFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw N.toRuntimeException(e);
        }
    }

    public static String xmlEncode(Object entity) {
        ByteArrayOutputStream os = Objectory.createByteArrayOutputStream();
        XMLEncoder xmlEncoder = new XMLEncoder(os);
        xmlEncoder.writeObject(entity);
        xmlEncoder.flush();
        xmlEncoder.close();
        String result = os.toString();
        Objectory.recycle(os);
        return result;
    }

    public static <T> T xmlDecode(String xml) {
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
        XMLDecoder xmlDecoder = new XMLDecoder(is);
        Object entity = xmlDecoder.readObject();
        xmlDecoder.close();
        return (T)entity;
    }

    public static List<Element> getElementsByTagName(Element node, String tagName) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodeList = node.getElementsByTagName(tagName);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getParentNode().isSameNode(node)) continue;
            result.add((Element)nodeList.item(i));
        }
        return result;
    }

    public static List<Node> getNodesByName(Node node, String nodeName) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (node.getNodeName().equals(nodeName)) {
            nodes.add(node);
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            List<Node> temp = XMLUtil.getNodesByName(nodeList.item(i), nodeName);
            if (temp.size() <= 0) continue;
            nodes.addAll(temp);
        }
        return nodes;
    }

    public static Node getNextNodeByName(Node node, String nodeName) {
        if (node.getNodeName().equals(nodeName)) {
            return node;
        }
        NodeList nodeList = node.getChildNodes();
        Node subNode = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            subNode = nodeList.item(i);
            if (!subNode.getNodeName().equals(nodeName)) continue;
            return subNode;
        }
        Node nextNode = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            nextNode = XMLUtil.getNextNodeByName(nodeList.item(i), nodeName);
            if (nextNode == null) continue;
            return nextNode;
        }
        return null;
    }

    public static Map<String, String> readAttributes(Node node) {
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        NamedNodeMap attrNodes = node.getAttributes();
        if (attrNodes == null || attrNodes.getLength() == 0) {
            return attrs;
        }
        for (int i = 0; i < attrNodes.getLength(); ++i) {
            String attrName = attrNodes.item(i).getNodeName();
            String attrValue = attrNodes.item(i).getNodeValue();
            attrs.put(attrName, attrValue);
        }
        return attrs;
    }

    public static String getAttribute(Node node, String attrName) {
        NamedNodeMap attrsNode = node.getAttributes();
        if (attrsNode == null) {
            return null;
        }
        Node attrNode = attrsNode.getNamedItem(attrName);
        return attrNode == null ? null : attrNode.getNodeValue();
    }

    public static boolean isTextElement(Node node) {
        NodeList childNodeList = node.getChildNodes();
        for (int i = 0; i < childNodeList.getLength(); ++i) {
            if (childNodeList.item(i).getNodeType() != 1) continue;
            return false;
        }
        return true;
    }

    public static String getTextContent(Node node) {
        return node.getTextContent();
    }

    public static String getTextContent(Node node, boolean ignoreWhiteChar) {
        String textContent = node.getTextContent();
        if (ignoreWhiteChar && N.notNullOrEmpty(textContent)) {
            StringBuilder sb = Objectory.createStringBuilder();
            block3: for (char c : textContent.toCharArray()) {
                switch (c) {
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': {
                        if (sb.length() <= 0 || sb.charAt(sb.length() - 1) == ' ') continue block3;
                        sb.append(' ');
                        continue block3;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            int length = sb.length();
            if (length > 0 && (sb.charAt(0) == ' ' || sb.charAt(length - 1) == ' ')) {
                int from = 0;
                while (sb.charAt(from) == ' ' && ++from < length) {
                }
                int to = length - 1;
                while (sb.charAt(to) == ' ' && --to >= 0) {
                }
                textContent = from <= to ? sb.substring(from, to + 1) : "";
            } else {
                textContent = sb.toString();
            }
            Objectory.recycle(sb);
        }
        return textContent;
    }

    static Class<?> getAttributeTypeClass(Node node) {
        String typeAttr = XMLUtil.getAttribute(node, TYPE);
        if (typeAttr == null) {
            return null;
        }
        Type type = N.typeOf(typeAttr);
        if (type != null) {
            return type.clazz();
        }
        try {
            return ClassUtil.forClass(typeAttr);
        }
        catch (AbacusException e) {
            return null;
        }
    }

    static Class<?> getConcreteClass(Class<?> targetClass, Class<?> typeClass) {
        if (typeClass == null) {
            return targetClass;
        }
        if (targetClass == null) {
            return typeClass;
        }
        if (targetClass.isAssignableFrom(typeClass)) {
            return typeClass;
        }
        return targetClass;
    }

    static Class<?> getConcreteClass(Class<?> targetClass, Node node) {
        if (node == null) {
            return targetClass;
        }
        Class<?> typeClass = XMLUtil.getAttributeTypeClass(node);
        return XMLUtil.getConcreteClass(targetClass, typeClass);
    }

    static <T> Class<T> getClassByNodeName(Class<?> cls, String nodeName) {
        if (cls == null) {
            return null;
        }
        Class<Object> nodeClass = null;
        Map<String, Class<?>> nodeNameClassMap = nodeNameClassMapPool.get(cls);
        if (nodeNameClassMap == null) {
            nodeNameClassMap = new ConcurrentHashMap();
            nodeNameClassMapPool.put(cls, nodeNameClassMap);
        } else {
            nodeClass = nodeNameClassMap.get(nodeName);
        }
        if (nodeClass == null) {
            String packName = null;
            if (cls == null || cls.getPackage() == null || cls.getPackage().getName() == null || cls.getPackage().getName().startsWith("java.lang") || cls.getPackage().getName().startsWith("java.util")) {
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                String xmlUtilPackageName = XMLParser.class.getPackage().getName();
                String className = null;
                for (int i = stackTrace.length - 1; i >= 0; --i) {
                    className = stackTrace[i].getClassName();
                    if (className.startsWith("java.lang") || className.startsWith("java.util") || className.startsWith(xmlUtilPackageName)) continue;
                    packName = ClassUtil.forClass(className).getPackage().getName();
                    break;
                }
            } else {
                packName = cls.getPackage().getName();
            }
            if (N.isNullOrEmpty(packName)) {
                return null;
            }
            String[] tokens = packName.split("\\.");
            if (tokens.length > 3) {
                String tmp = "";
                for (int i = 0; i < 3; ++i) {
                    if (i > 0) {
                        tmp = tmp + ".";
                    }
                    tmp = tmp + tokens[i];
                }
                packName = tmp;
            }
            List<Class<?>> classList = ClassUtil.getClassesByPackage(packName, true, true);
            for (Class<?> e : classList) {
                if (!ClassUtil.getSimpleClassName(e).equalsIgnoreCase(nodeName)) continue;
                nodeClass = e;
                break;
            }
            if (nodeClass == null && !nodeName.equalsIgnoreCase(ClassUtil.formalizePropName(nodeName))) {
                nodeClass = XMLUtil.getClassByNodeName(cls, ClassUtil.formalizePropName(nodeName));
            }
            if (nodeClass == null) {
                nodeClass = ClassUtil.CLASS_MASK;
            }
            nodeNameClassMap.put(nodeName, nodeClass);
        }
        return nodeClass == ClassUtil.CLASS_MASK ? null : nodeClass;
    }

    static NodeType getNodeType(String nodeName, NodeType previousNodeType) {
        if (previousNodeType == NodeType.ENTITY) {
            return NodeType.PROPERTY;
        }
        NodeType nodeType = nodeTypePool.get(nodeName);
        if (nodeType == null) {
            return NodeType.ENTITY;
        }
        return nodeType;
    }

    static {
        block3: {
            logger = LoggerFactory.getLogger(XMLUtil.class);
            saxParserFactory = SAXParserFactory.newInstance();
            saxParserPool = new ArrayBlockingQueue<SAXParser>(1000);
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            contentDocBuilderPool = new ArrayBlockingQueue<DocumentBuilder>(1000);
            xmlInputFactory = XMLInputFactory.newInstance();
            try {
                if (!Class.forName("com.ctc.wstx.stax.WstxInputFactory").isAssignableFrom(xmlInputFactory.getClass()) && logger.isWarnEnabled()) {
                    logger.warn("It's recommended to use woodstox: https://github.com/FasterXML/woodstox");
                }
            }
            catch (Throwable e) {
                if (!logger.isWarnEnabled()) break block3;
                logger.warn("It's recommended to use woodstox: https://github.com/FasterXML/woodstox");
            }
        }
        xmlOutputFactory = XMLOutputFactory.newInstance();
        transferFactory = TransformerFactory.newInstance();
        pathJaxbContextPool = new ConcurrentHashMap<String, JAXBContext>(1000);
        classJaxbContextPool = new ConcurrentHashMap(1000);
        nodeNameClassMapPool = new ConcurrentHashMap(1000);
        nodeTypePool = new HashMap<String, NodeType>();
        nodeTypePool.put("array", NodeType.ARRAY);
        nodeTypePool.put("list", NodeType.COLLECTION);
        nodeTypePool.put("e", NodeType.ELEMENT);
        nodeTypePool.put("map", NodeType.MAP);
        nodeTypePool.put("entry", NodeType.ENTRY);
        nodeTypePool.put("key", NodeType.KEY);
        nodeTypePool.put("value", NodeType.VALUE);
    }

    static enum NodeType {
        ENTITY,
        PROPERTY,
        ARRAY,
        ELEMENT,
        COLLECTION,
        MAP,
        ENTRY,
        KEY,
        VALUE;

    }
}

