/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util.stream;

import com.landawn.abacus.DataSet;
import com.landawn.abacus.exception.DuplicatedResultException;
import com.landawn.abacus.util.Array;
import com.landawn.abacus.util.BiMap;
import com.landawn.abacus.util.Comparators;
import com.landawn.abacus.util.Fn;
import com.landawn.abacus.util.ImmutableList;
import com.landawn.abacus.util.ImmutableMap;
import com.landawn.abacus.util.ImmutableSet;
import com.landawn.abacus.util.Joiner;
import com.landawn.abacus.util.KahanSummation;
import com.landawn.abacus.util.ListMultimap;
import com.landawn.abacus.util.Multimap;
import com.landawn.abacus.util.Multiset;
import com.landawn.abacus.util.MutableBoolean;
import com.landawn.abacus.util.MutableLong;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Pair;
import com.landawn.abacus.util.Tuple;
import com.landawn.abacus.util.function.BiConsumer;
import com.landawn.abacus.util.function.BiFunction;
import com.landawn.abacus.util.function.BinaryOperator;
import com.landawn.abacus.util.function.Consumer;
import com.landawn.abacus.util.function.Function;
import com.landawn.abacus.util.function.IntFunction;
import com.landawn.abacus.util.function.Predicate;
import com.landawn.abacus.util.function.Supplier;
import com.landawn.abacus.util.function.ToDoubleFunction;
import com.landawn.abacus.util.function.ToIntFunction;
import com.landawn.abacus.util.function.ToLongFunction;
import com.landawn.abacus.util.function.TriFunction;
import com.landawn.abacus.util.stream.Collector;
import com.landawn.abacus.util.u;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public abstract class Collectors {
    static final Object NONE = new Object();
    @Deprecated
    static final Set<Collector.Characteristics> CH_CONCURRENT_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH));
    @Deprecated
    static final Set<Collector.Characteristics> CH_CONCURRENT_NOID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED));
    static final Set<Collector.Characteristics> CH_UNORDERED_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH));
    static final Set<Collector.Characteristics> CH_UNORDERED_NOID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.UNORDERED));
    static final Set<Collector.Characteristics> CH_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));
    static final Set<Collector.Characteristics> CH_NOID = Collections.emptySet();
    static final Function<List<Object>, ImmutableList<Object>> ImmutableList_Finisher = new Function<List<Object>, ImmutableList<Object>>(){

        @Override
        public ImmutableList<Object> apply(List<Object> t) {
            return ImmutableList.of(t);
        }
    };
    static final Function<Set<Object>, ImmutableSet<Object>> ImmutableSet_Finisher = new Function<Set<Object>, ImmutableSet<Object>>(){

        @Override
        public ImmutableSet<Object> apply(Set<Object> t) {
            return ImmutableSet.of(t);
        }
    };
    static final Function<Map<Object, Object>, ImmutableMap<Object, Object>> ImmutableMap_Finisher = new Function<Map<Object, Object>, ImmutableMap<Object, Object>>(){

        @Override
        public ImmutableMap<Object, Object> apply(Map<Object, Object> t) {
            return ImmutableMap.of(t);
        }
    };
    static final BiConsumer<Multiset<Object>, Object> Multiset_Accumulator = new BiConsumer<Multiset<Object>, Object>(){

        @Override
        public void accept(Multiset<Object> c, Object t) {
            c.add(t);
        }
    };
    static final BinaryOperator<Multiset<Object>> Multiset_Combiner = new BinaryOperator<Multiset<Object>>(){

        @Override
        public Multiset<Object> apply(Multiset<Object> a, Multiset<Object> b) {
            a.addAll(b);
            return a;
        }
    };
    static final BiConsumer<Joiner, CharSequence> Joiner_Accumulator = new BiConsumer<Joiner, CharSequence>(){

        @Override
        public void accept(Joiner a, CharSequence t) {
            a.append(t);
        }
    };
    static final BinaryOperator<Joiner> Joiner_Combiner = new BinaryOperator<Joiner>(){

        @Override
        public Joiner apply(Joiner a, Joiner b) {
            if (a.length() > b.length()) {
                a.merge(b);
                b.close();
                return a;
            }
            b.merge(a);
            a.close();
            return b;
        }
    };
    static final Function<Joiner, String> Joiner_Finisher = new Function<Joiner, String>(){

        @Override
        public String apply(Joiner a) {
            return a.toString();
        }
    };
    static final Function<Object, ? extends Long> Counting_Accumulator = new Function<Object, Long>(){

        @Override
        public Long apply(Object t) {
            return 1L;
        }
    };
    static final BinaryOperator<Long> Counting_Combiner = new BinaryOperator<Long>(){

        @Override
        public Long apply(Long a, Long b) {
            return a + b;
        }
    };
    static final Function<Object, ? extends Integer> CountingInt_Accumulator = new Function<Object, Integer>(){

        @Override
        public Integer apply(Object t) {
            return 1;
        }
    };
    static final BinaryOperator<Integer> CountingInt_Combiner = new BinaryOperator<Integer>(){

        @Override
        public Integer apply(Integer a, Integer b) {
            return a + b;
        }
    };
    static final Supplier<long[]> SummingInt_Supplier = new Supplier<long[]>(){

        @Override
        public long[] get() {
            return new long[1];
        }
    };
    static final BinaryOperator<long[]> SummingInt_Combiner = new BinaryOperator<long[]>(){

        @Override
        public long[] apply(long[] a, long[] b) {
            a[0] = a[0] + b[0];
            return a;
        }
    };
    static final Function<long[], Long> SummingInt_Finisher = new Function<long[], Long>(){

        @Override
        public Long apply(long[] a) {
            return a[0];
        }
    };
    static final Supplier<long[]> SummingInt_Supplier_2 = new Supplier<long[]>(){

        @Override
        public long[] get() {
            return new long[2];
        }
    };
    static final BinaryOperator<long[]> SummingInt_Combiner_2 = new BinaryOperator<long[]>(){

        @Override
        public long[] apply(long[] a, long[] b) {
            a[0] = a[0] + b[0];
            a[1] = a[1] + b[1];
            return a;
        }
    };
    static final Function<long[], u.OptionalLong> SummingInt_Finisher_2 = new Function<long[], u.OptionalLong>(){

        @Override
        public u.OptionalLong apply(long[] a) {
            return a[1] == 0L ? u.OptionalLong.empty() : u.OptionalLong.of(a[0]);
        }
    };
    static final Supplier<long[]> SummingLong_Supplier = new Supplier<long[]>(){

        @Override
        public long[] get() {
            return new long[1];
        }
    };
    static final BinaryOperator<long[]> SummingLong_Combiner = new BinaryOperator<long[]>(){

        @Override
        public long[] apply(long[] a, long[] b) {
            a[0] = a[0] + b[0];
            return a;
        }
    };
    static final Function<long[], Long> SummingLong_Finisher = new Function<long[], Long>(){

        @Override
        public Long apply(long[] a) {
            return a[0];
        }
    };
    static final Supplier<long[]> SummingLong_Supplier_2 = new Supplier<long[]>(){

        @Override
        public long[] get() {
            return new long[2];
        }
    };
    static final BinaryOperator<long[]> SummingLong_Combiner_2 = new BinaryOperator<long[]>(){

        @Override
        public long[] apply(long[] a, long[] b) {
            a[0] = a[0] + b[0];
            a[1] = a[1] + b[1];
            return a;
        }
    };
    static final Function<long[], u.OptionalLong> SummingLong_Finisher_2 = new Function<long[], u.OptionalLong>(){

        @Override
        public u.OptionalLong apply(long[] a) {
            return a[1] == 0L ? u.OptionalLong.empty() : u.OptionalLong.of(a[0]);
        }
    };
    static final Supplier<KahanSummation> SummingDouble_Supplier = new Supplier<KahanSummation>(){

        @Override
        public KahanSummation get() {
            return new KahanSummation();
        }
    };
    static final BinaryOperator<KahanSummation> SummingDouble_Combiner = new BinaryOperator<KahanSummation>(){

        @Override
        public KahanSummation apply(KahanSummation a, KahanSummation b) {
            a.combine(b);
            return a;
        }
    };
    static final Function<KahanSummation, Double> SummingDouble_Finisher = new Function<KahanSummation, Double>(){

        @Override
        public Double apply(KahanSummation a) {
            return a.sum();
        }
    };
    static final Supplier<KahanSummation> SummingDouble_Supplier_2 = new Supplier<KahanSummation>(){

        @Override
        public KahanSummation get() {
            return new KahanSummation();
        }
    };
    static final BinaryOperator<KahanSummation> SummingDouble_Combiner_2 = new BinaryOperator<KahanSummation>(){

        @Override
        public KahanSummation apply(KahanSummation a, KahanSummation b) {
            a.combine(b);
            return a;
        }
    };
    static final Function<KahanSummation, u.OptionalDouble> SummingDouble_Finisher_2 = new Function<KahanSummation, u.OptionalDouble>(){

        @Override
        public u.OptionalDouble apply(KahanSummation a) {
            return a.count() == 0L ? u.OptionalDouble.empty() : u.OptionalDouble.of(a.sum());
        }
    };
    static final Supplier<BigInteger[]> SummingBigInteger_Supplier = new Supplier<BigInteger[]>(){

        @Override
        public BigInteger[] get() {
            return new BigInteger[]{BigInteger.ZERO};
        }
    };
    static final BinaryOperator<BigInteger[]> SummingBigInteger_Combiner = new BinaryOperator<BigInteger[]>(){

        @Override
        public BigInteger[] apply(BigInteger[] a, BigInteger[] b) {
            a[0] = a[0].add(b[0]);
            return a;
        }
    };
    static final Function<BigInteger[], BigInteger> SummingBigInteger_Finisher = new Function<BigInteger[], BigInteger>(){

        @Override
        public BigInteger apply(BigInteger[] a) {
            return a[0];
        }
    };
    static final Supplier<BigDecimal[]> SummingBigDecimal_Supplier = new Supplier<BigDecimal[]>(){

        @Override
        public BigDecimal[] get() {
            return new BigDecimal[]{BigDecimal.ZERO};
        }
    };
    static final BinaryOperator<BigDecimal[]> SummingBigDecimal_Combiner = new BinaryOperator<BigDecimal[]>(){

        @Override
        public BigDecimal[] apply(BigDecimal[] a, BigDecimal[] b) {
            a[0] = a[0].add(b[0]);
            return a;
        }
    };
    static final Function<BigDecimal[], BigDecimal> SummingBigDecimal_Finisher = new Function<BigDecimal[], BigDecimal>(){

        @Override
        public BigDecimal apply(BigDecimal[] a) {
            return a[0];
        }
    };
    static final Supplier<long[]> AveragingInt_Supplier = new Supplier<long[]>(){

        @Override
        public long[] get() {
            return new long[2];
        }
    };
    static final BinaryOperator<long[]> AveragingInt_Combiner = new BinaryOperator<long[]>(){

        @Override
        public long[] apply(long[] a, long[] b) {
            a[0] = a[0] + b[0];
            a[1] = a[1] + b[1];
            return a;
        }
    };
    static final Function<long[], Double> AveragingInt_Finisher = new Function<long[], Double>(){

        @Override
        public Double apply(long[] a) {
            return a[1] == 0L ? 0.0 : (double)a[0] / (double)a[1];
        }
    };
    static final Function<long[], u.OptionalDouble> AveragingInt_Finisher_2 = new Function<long[], u.OptionalDouble>(){

        @Override
        public u.OptionalDouble apply(long[] a) {
            if (a[1] == 0L) {
                return u.OptionalDouble.empty();
            }
            return u.OptionalDouble.of((double)a[0] / (double)a[1]);
        }
    };
    static final Supplier<long[]> AveragingLong_Supplier = new Supplier<long[]>(){

        @Override
        public long[] get() {
            return new long[2];
        }
    };
    static final BinaryOperator<long[]> AveragingLong_Combiner = new BinaryOperator<long[]>(){

        @Override
        public long[] apply(long[] a, long[] b) {
            a[0] = a[0] + b[0];
            a[1] = a[1] + b[1];
            return a;
        }
    };
    static final Function<long[], Double> AveragingLong_Finisher = new Function<long[], Double>(){

        @Override
        public Double apply(long[] a) {
            return a[1] == 0L ? 0.0 : (double)a[0] / (double)a[1];
        }
    };
    static final Function<long[], u.OptionalDouble> AveragingLong_Finisher_2 = new Function<long[], u.OptionalDouble>(){

        @Override
        public u.OptionalDouble apply(long[] a) {
            if (a[1] == 0L) {
                return u.OptionalDouble.empty();
            }
            return u.OptionalDouble.of((double)a[0] / (double)a[1]);
        }
    };
    static final Supplier<KahanSummation> AveragingDouble_Supplier = new Supplier<KahanSummation>(){

        @Override
        public KahanSummation get() {
            return new KahanSummation();
        }
    };
    static final BinaryOperator<KahanSummation> AveragingDouble_Combiner = new BinaryOperator<KahanSummation>(){

        @Override
        public KahanSummation apply(KahanSummation a, KahanSummation b) {
            a.combine(b);
            return a;
        }
    };
    static final Function<KahanSummation, Double> AveragingDouble_Finisher = new Function<KahanSummation, Double>(){

        @Override
        public Double apply(KahanSummation a) {
            return a.average().orElse(0.0);
        }
    };
    static final Function<KahanSummation, u.OptionalDouble> AveragingDouble_Finisher_2 = new Function<KahanSummation, u.OptionalDouble>(){

        @Override
        public u.OptionalDouble apply(KahanSummation a) {
            return a.average();
        }
    };
    static final Supplier<Pair<BigInteger, MutableLong>> AveragingBigInteger_Supplier = new Supplier<Pair<BigInteger, MutableLong>>(){

        @Override
        public Pair<BigInteger, MutableLong> get() {
            return Pair.of(BigInteger.ZERO, MutableLong.of(0L));
        }
    };
    static final BinaryOperator<Pair<BigInteger, MutableLong>> AveragingBigInteger_Combiner = new BinaryOperator<Pair<BigInteger, MutableLong>>(){

        @Override
        public Pair<BigInteger, MutableLong> apply(Pair<BigInteger, MutableLong> a, Pair<BigInteger, MutableLong> b) {
            a.setLeft(((BigInteger)a.left).add((BigInteger)b.left));
            ((MutableLong)a.right).add(((MutableLong)b.right).value());
            return a;
        }
    };
    static final Function<Pair<BigInteger, MutableLong>, BigDecimal> AveragingBigInteger_Finisher = new Function<Pair<BigInteger, MutableLong>, BigDecimal>(){

        @Override
        public BigDecimal apply(Pair<BigInteger, MutableLong> a) {
            return ((MutableLong)a.right).value() == 0L ? BigDecimal.ZERO : new BigDecimal((BigInteger)a.left).divide(new BigDecimal(((MutableLong)a.right).value()));
        }
    };
    static final Supplier<Pair<BigDecimal, MutableLong>> AveragingBigDecimal_Supplier = new Supplier<Pair<BigDecimal, MutableLong>>(){

        @Override
        public Pair<BigDecimal, MutableLong> get() {
            return Pair.of(BigDecimal.ZERO, MutableLong.of(0L));
        }
    };
    static final BinaryOperator<Pair<BigDecimal, MutableLong>> AveragingBigDecimal_Combiner = new BinaryOperator<Pair<BigDecimal, MutableLong>>(){

        @Override
        public Pair<BigDecimal, MutableLong> apply(Pair<BigDecimal, MutableLong> a, Pair<BigDecimal, MutableLong> b) {
            a.setLeft(((BigDecimal)a.left).add((BigDecimal)b.left));
            ((MutableLong)a.right).add(((MutableLong)b.right).value());
            return a;
        }
    };
    static final Function<Pair<BigDecimal, MutableLong>, BigDecimal> AveragingBigDecimal_Finisher = new Function<Pair<BigDecimal, MutableLong>, BigDecimal>(){

        @Override
        public BigDecimal apply(Pair<BigDecimal, MutableLong> a) {
            return ((MutableLong)a.right).value() == 0L ? BigDecimal.ZERO : ((BigDecimal)a.left).divide(new BigDecimal(((MutableLong)a.right).value()));
        }
    };
    static final Function<u.Holder<Object>, Object> Reducing_Finisher_0 = new Function<u.Holder<Object>, Object>(){

        @Override
        public Object apply(u.Holder<Object> a) {
            return a.value();
        }
    };
    static final BiConsumer<OptHolder<Object>, Object> Reducing_Accumulator = new BiConsumer<OptHolder<Object>, Object>(){

        @Override
        public void accept(OptHolder<Object> a, Object t) {
            a.accept(t);
        }
    };
    static final BinaryOperator<OptHolder<Object>> Reducing_Combiner = new BinaryOperator<OptHolder<Object>>(){

        @Override
        public OptHolder<Object> apply(OptHolder<Object> a, OptHolder<Object> b) {
            if (b.present) {
                a.accept(b.value);
            }
            return a;
        }
    };
    static final Function<OptHolder<Object>, u.Optional<Object>> Reducing_Finisher = new Function<OptHolder<Object>, u.Optional<Object>>(){

        @Override
        public u.Optional<Object> apply(OptHolder<Object> a) {
            return a.present ? u.Optional.of(a.value) : u.Optional.empty();
        }
    };
    static final BiConsumer<MappingOptHolder<Object, Object>, Object> Reducing_Accumulator_2 = new BiConsumer<MappingOptHolder<Object, Object>, Object>(){

        @Override
        public void accept(MappingOptHolder<Object, Object> a, Object t) {
            a.accept(t);
        }
    };
    static final BinaryOperator<MappingOptHolder<Object, Object>> Reducing_Combiner_2 = new BinaryOperator<MappingOptHolder<Object, Object>>(){

        @Override
        public MappingOptHolder<Object, Object> apply(MappingOptHolder<Object, Object> a, MappingOptHolder<Object, Object> b) {
            if (b.present) {
                if (a.present) {
                    a.value = a.op.apply(a.value, b.value);
                } else {
                    a.value = b.value;
                    a.present = true;
                }
            }
            return a;
        }
    };
    static final Function<MappingOptHolder<Object, Object>, u.Optional<Object>> Reducing_Finisher_2 = new Function<MappingOptHolder<Object, Object>, u.Optional<Object>>(){

        @Override
        public u.Optional<Object> apply(MappingOptHolder<Object, Object> a) {
            return a.present ? u.Optional.of(a.value) : u.Optional.empty();
        }
    };
    private static final Supplier<u.Holder<u.Optional<Object>>> onlyOne_supplier = new Supplier<u.Holder<u.Optional<Object>>>(){

        @Override
        public u.Holder<u.Optional<Object>> get() {
            return u.Holder.of(u.Optional.empty());
        }
    };
    private static final BiConsumer<u.Holder<u.Optional<Object>>, Object> onlyOne_accumulator = new BiConsumer<u.Holder<u.Optional<Object>>, Object>(){

        @Override
        public void accept(u.Holder<u.Optional<Object>> holder, Object val) {
            if (((u.Optional)holder.value()).isPresent()) {
                throw new DuplicatedResultException("Duplicate values");
            }
            holder.setValue((Object)u.Optional.of(val));
        }
    };
    private static final BinaryOperator<u.Holder<u.Optional<Object>>> onlyOne_combiner = new BinaryOperator<u.Holder<u.Optional<Object>>>(){

        @Override
        public u.Holder<u.Optional<Object>> apply(u.Holder<u.Optional<Object>> t, u.Holder<u.Optional<Object>> u2) {
            if (((u.Optional)t.value()).isPresent() && ((u.Optional)u2.value()).isPresent()) {
                throw new DuplicatedResultException("Duplicate values");
            }
            return ((u.Optional)t.value()).isPresent() ? t : u2;
        }
    };
    private static final Function<u.Holder<u.Optional<Object>>, u.Optional<Object>> onlyOne_finisher = new Function<u.Holder<u.Optional<Object>>, u.Optional<Object>>(){

        @Override
        public u.Optional<Object> apply(u.Holder<u.Optional<Object>> t) {
            return (u.Optional)t.value();
        }
    };
    private static final Supplier<u.Holder<Object>> first_last_supplier = new Supplier<u.Holder<Object>>(){

        @Override
        public u.Holder<Object> get() {
            return u.Holder.of(NONE);
        }
    };
    private static final BiConsumer<u.Holder<Object>, Object> first_accumulator = new BiConsumer<u.Holder<Object>, Object>(){

        @Override
        public void accept(u.Holder<Object> holder, Object val) {
            if (holder.value() == NONE) {
                holder.setValue(val);
            }
        }
    };
    private static final BiConsumer<u.Holder<Object>, Object> last_accumulator = new BiConsumer<u.Holder<Object>, Object>(){

        @Override
        public void accept(u.Holder<Object> holder, Object val) {
            holder.setValue(val);
        }
    };
    private static final BinaryOperator<u.Holder<Object>> first_last_combiner = new BinaryOperator<u.Holder<Object>>(){

        @Override
        public u.Holder<Object> apply(u.Holder<Object> t, u.Holder<Object> u2) {
            if (t.value() != NONE && u2.value() != NONE) {
                throw new UnsupportedOperationException("The 'first' and 'last' Collector only can be used in sequential stream");
            }
            return t.value() != NONE ? t : u2;
        }
    };
    private static final Function<u.Holder<Object>, u.Optional<Object>> first_last_finisher = new Function<u.Holder<Object>, u.Optional<Object>>(){

        @Override
        public u.Optional<Object> apply(u.Holder<Object> t) {
            return t.value() == NONE ? u.Optional.empty() : u.Optional.of(t.value());
        }
    };
    private static final Supplier<NoSuchElementException> noSuchElementExceptionSupplier = new Supplier<NoSuchElementException>(){

        @Override
        public NoSuchElementException get() {
            return new NoSuchElementException();
        }
    };

    Collectors() {
    }

    public static <T, C extends Collection<T>> Collector<T, ?, C> toCollection(Supplier<? extends C> collectionFactory) {
        BiConsumer accumulator = Fn.BiConsumers.ofAdd();
        BinaryOperator combiner = Fn.BinaryOperators.ofAddAllToBigger();
        return new CollectorImpl(collectionFactory, accumulator, combiner, CH_ID);
    }

    public static <T> Collector<T, ?, List<T>> toList() {
        Supplier supplier = Fn.Suppliers.ofList();
        return Collectors.toCollection(supplier);
    }

    public static <T> Collector<T, ?, LinkedList<T>> toLinkedList() {
        Supplier supplier = Fn.Suppliers.ofLinkedList();
        return Collectors.toCollection(supplier);
    }

    public static <T> Collector<T, ?, ImmutableList<T>> toImmutableList() {
        Collector<T, ?, List<T>> downstream = Collectors.toList();
        Function<List<Object>, ImmutableList<Object>> finisher = ImmutableList_Finisher;
        return Collectors.collectingAndThen(downstream, finisher);
    }

    public static <T> Collector<T, ?, Set<T>> toSet() {
        Supplier supplier = Fn.Suppliers.ofSet();
        return Collectors.toCollection(supplier);
    }

    public static <T> Collector<T, ?, Set<T>> toLinkedHashSet() {
        Supplier supplier = Fn.Suppliers.ofLinkedHashSet();
        return Collectors.toCollection(supplier);
    }

    public static <T> Collector<T, ?, ImmutableSet<T>> toImmutableSet() {
        Collector<T, ?, Set<T>> downstream = Collectors.toSet();
        Function<Set<Object>, ImmutableSet<Object>> finisher = ImmutableSet_Finisher;
        return Collectors.collectingAndThen(downstream, finisher);
    }

    public static <T> Collector<T, ?, Queue<T>> toQueue() {
        Supplier supplier = Fn.Suppliers.ofQueue();
        return Collectors.toCollection(supplier);
    }

    public static <T> Collector<T, ?, Deque<T>> toDeque() {
        Supplier supplier = Fn.Suppliers.ofDeque();
        return Collectors.toCollection(supplier);
    }

    public static <T, C extends Collection<T>> Collector<T, ?, C> toCollection(Supplier<? extends C> collectionFactory, final int atMostSize) {
        BiConsumer accumulator = new BiConsumer<C, T>(){

            @Override
            public void accept(C c, T t) {
                if (c.size() < atMostSize) {
                    c.add(t);
                }
            }
        };
        BinaryOperator combiner = new BinaryOperator<C>(){

            @Override
            public C apply(C a, C b) {
                if (a.size() < atMostSize) {
                    int n = atMostSize - a.size();
                    if (b.size() <= n) {
                        a.addAll(b);
                    } else if (b instanceof List) {
                        a.addAll(((List)b).subList(0, n));
                    } else {
                        Iterator iter = b.iterator();
                        for (int i = 0; i < n; ++i) {
                            a.add(iter.next());
                        }
                    }
                }
                return a;
            }
        };
        return new CollectorImpl(collectionFactory, accumulator, combiner, CH_ID);
    }

    public static <T> Collector<T, ?, List<T>> toList(final int atMostSize) {
        Supplier supplier = new Supplier<List<T>>(){

            @Override
            public List<T> get() {
                return new ArrayList(N.min(256, atMostSize));
            }
        };
        return Collectors.toCollection(supplier, atMostSize);
    }

    public static <T> Collector<T, ?, Set<T>> toSet(final int atMostSize) {
        Supplier supplier = new Supplier<Set<T>>(){

            @Override
            public Set<T> get() {
                return N.newHashSet(N.initHashCapacity(atMostSize));
            }
        };
        return Collectors.toCollection(supplier, atMostSize);
    }

    public static <T> Collector<T, ?, Multiset<T>> toMultiset() {
        Supplier supplier = Fn.Suppliers.ofMultiset();
        return Collectors.toMultiset(supplier);
    }

    public static <T> Collector<T, ?, Multiset<T>> toMultiset(Supplier<Multiset<T>> supplier) {
        BiConsumer<Multiset<Object>, Object> accumulator = Multiset_Accumulator;
        BinaryOperator<Multiset<Object>> combiner = Multiset_Combiner;
        return new CollectorImpl(supplier, accumulator, combiner, CH_UNORDERED_ID);
    }

    public static <T> Collector<T, ?, Object[]> toArray() {
        return Collectors.toArray(Fn.Suppliers.ofEmptyObjectArray());
    }

    public static <T, A> Collector<T, ?, A[]> toArray(final Supplier<A[]> arraySupplier) {
        Supplier supplier = Fn.Suppliers.ofList();
        BiConsumer accumulator = Fn.BiConsumers.ofAdd();
        BinaryOperator combiner = Fn.BinaryOperators.ofAddAllToBigger();
        Function finisher = new Function<List<A>, A[]>(){

            @Override
            public A[] apply(List<A> t) {
                Object[] a = (Object[])arraySupplier.get();
                if (a.length >= t.size()) {
                    return t.toArray(a);
                }
                return t.toArray((Object[])Array.newInstance(a.getClass().getComponentType(), t.size()));
            }
        };
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_NOID);
    }

    public static <T, A> Collector<T, ?, A[]> toArray(final IntFunction<A[]> arraySupplier) {
        Supplier supplier = Fn.Suppliers.ofList();
        BiConsumer accumulator = Fn.BiConsumers.ofAdd();
        BinaryOperator combiner = Fn.BinaryOperators.ofAddAllToBigger();
        Function finisher = new Function<List<A>, A[]>(){

            @Override
            public A[] apply(List<A> t) {
                return t.toArray((Object[])arraySupplier.apply(t.size()));
            }
        };
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_NOID);
    }

    public static <T> Collector<T, ?, u.Optional<T>> onlyOne() {
        Supplier<u.Holder<u.Optional<Object>>> supplier = onlyOne_supplier;
        BiConsumer<u.Holder<u.Optional<Object>>, Object> accumulator = onlyOne_accumulator;
        BinaryOperator<u.Holder<u.Optional<Object>>> combiner = onlyOne_combiner;
        Function<u.Holder<u.Optional<Object>>, u.Optional<Object>> finisher = onlyOne_finisher;
        return new CollectorImpl<Object, u.Holder<u.Optional<Object>>, u.Optional<Object>>(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T> Collector<T, ?, u.Optional<T>> onlyOne(Predicate<? super T> predicate) {
        Collector<T, ?, u.Optional<T>> downstream = Collectors.onlyOne();
        return Collectors.filtering(predicate, downstream);
    }

    public static <T> Collector<T, ?, u.Optional<T>> first() {
        Supplier<u.Holder<Object>> supplier = first_last_supplier;
        BiConsumer<u.Holder<Object>, Object> accumulator = first_accumulator;
        BinaryOperator<u.Holder<Object>> combiner = first_last_combiner;
        Function<u.Holder<Object>, u.Optional<Object>> finisher = first_last_finisher;
        return new CollectorImpl<Object, u.Holder<Object>, u.Optional<Object>>(supplier, accumulator, combiner, finisher, CH_NOID);
    }

    public static <T> Collector<T, ?, u.Optional<T>> last() {
        Supplier<u.Holder<Object>> supplier = first_last_supplier;
        BiConsumer<u.Holder<Object>, Object> accumulator = last_accumulator;
        BinaryOperator<u.Holder<Object>> combiner = first_last_combiner;
        Function<u.Holder<Object>, u.Optional<Object>> finisher = first_last_finisher;
        return new CollectorImpl<Object, u.Holder<Object>, u.Optional<Object>>(supplier, accumulator, combiner, finisher, CH_NOID);
    }

    public static <T> Collector<T, ?, List<T>> first(final int n) {
        N.checkArgNotNegative(n, "n");
        Supplier supplier = new Supplier<List<T>>(){

            @Override
            public List<T> get() {
                return new ArrayList(N.min(256, n));
            }
        };
        BiConsumer accumulator = new BiConsumer<List<T>, T>(){

            @Override
            public void accept(List<T> c, T t) {
                if (c.size() < n) {
                    c.add(t);
                }
            }
        };
        BinaryOperator combiner = new BinaryOperator<List<T>>(){

            @Override
            public List<T> apply(List<T> a, List<T> b) {
                if (N.notNullOrEmpty(a) && N.notNullOrEmpty(b)) {
                    throw new UnsupportedOperationException("The 'first' and 'last' Collector only can be used in sequential stream");
                }
                return a.size() > 0 ? a : b;
            }
        };
        return new CollectorImpl(supplier, accumulator, combiner, CH_ID);
    }

    public static <T> Collector<T, ?, List<T>> last(final int n) {
        N.checkArgNotNegative(n, "n");
        Supplier supplier = new Supplier<Deque<T>>(){

            @Override
            public Deque<T> get() {
                return (Deque)((Object)(n <= 1024 ? new ArrayDeque(n) : new LinkedList()));
            }
        };
        BiConsumer accumulator = new BiConsumer<Deque<T>, T>(){

            @Override
            public void accept(Deque<T> dqueue, T t) {
                if (n > 0) {
                    if (dqueue.size() >= n) {
                        dqueue.pollFirst();
                    }
                    dqueue.offerLast(t);
                }
            }
        };
        BinaryOperator combiner = new BinaryOperator<Deque<T>>(){

            @Override
            public Deque<T> apply(Deque<T> a, Deque<T> b) {
                if (N.notNullOrEmpty(a) && N.notNullOrEmpty(b)) {
                    throw new UnsupportedOperationException("The 'first' and 'last' Collector only can be used in sequential stream");
                }
                while (b.size() < n && !a.isEmpty()) {
                    b.addFirst(a.pollLast());
                }
                return b;
            }
        };
        Function finisher = new Function<Deque<T>, List<T>>(){

            @Override
            public List<T> apply(Deque<T> dqueue) {
                return new ArrayList(dqueue);
            }
        };
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_NOID);
    }

    public static Collector<CharSequence, ?, String> joining() {
        return Collectors.joining("", "", "");
    }

    public static Collector<CharSequence, ?, String> joining(CharSequence delimiter) {
        return Collectors.joining(delimiter, "", "");
    }

    public static Collector<CharSequence, ?, String> joining(final CharSequence delimiter, final CharSequence prefix, final CharSequence suffix) {
        Supplier<Joiner> supplier = new Supplier<Joiner>(){

            @Override
            public Joiner get() {
                return Joiner.with(delimiter, prefix, suffix).reuseCachedBuffer(true);
            }
        };
        BiConsumer<Joiner, CharSequence> accumulator = Joiner_Accumulator;
        BinaryOperator<Joiner> combiner = Joiner_Combiner;
        Function<Joiner, String> finisher = Joiner_Finisher;
        return new CollectorImpl<CharSequence, Joiner, String>(supplier, accumulator, combiner, finisher, CH_NOID);
    }

    public static <T> Collector<T, ?, List<T>> filtering(Predicate<? super T> predicate) {
        Collector<T, ?, List<T>> downstream = Collectors.toList();
        return Collectors.filtering(predicate, downstream);
    }

    public static <T, A, R> Collector<T, ?, R> filtering(final Predicate<? super T> predicate, Collector<? super T, A, R> downstream) {
        final BiConsumer<A, ? super T> downstreamAccumulator = downstream.accumulator();
        BiConsumer accumulator = new BiConsumer<A, T>(){

            @Override
            public void accept(A a, T t) {
                if (predicate.test(t)) {
                    downstreamAccumulator.accept(a, t);
                }
            }
        };
        return new CollectorImpl(downstream.supplier(), accumulator, downstream.combiner(), downstream.finisher(), downstream.characteristics());
    }

    public static <T, U> Collector<T, ?, List<U>> mapping(Function<? super T, ? extends U> mapper) {
        return Collectors.mapping(mapper, Collectors.toList());
    }

    public static <T, U, A, R> Collector<T, ?, R> mapping(final Function<? super T, ? extends U> mapper, Collector<? super U, A, R> downstream) {
        final BiConsumer<A, ? super U> downstreamAccumulator = downstream.accumulator();
        BiConsumer accumulator = new BiConsumer<A, T>(){

            @Override
            public void accept(A a, T t) {
                downstreamAccumulator.accept(a, mapper.apply(t));
            }
        };
        return new CollectorImpl(downstream.supplier(), accumulator, downstream.combiner(), downstream.finisher(), downstream.characteristics());
    }

    public static <T, U> Collector<T, ?, List<U>> flattMapping(Function<? super T, ? extends Collection<? extends U>> mapper) {
        return Collectors.flattMapping(mapper, Collectors.toList());
    }

    public static <T, U, A, R> Collector<T, ?, R> flattMapping(final Function<? super T, ? extends Collection<? extends U>> mapper, Collector<? super U, A, R> downstream) {
        final BiConsumer<A, ? super U> downstreamAccumulator = downstream.accumulator();
        BiConsumer accumulator = new BiConsumer<A, T>(){

            @Override
            public void accept(A a, T t) {
                Collection c = (Collection)mapper.apply(t);
                if (N.notNullOrEmpty(c)) {
                    for (Object u2 : c) {
                        downstreamAccumulator.accept(a, u2);
                    }
                }
            }
        };
        return new CollectorImpl(downstream.supplier(), accumulator, downstream.combiner(), downstream.finisher(), downstream.characteristics());
    }

    public static <T, T2, U> Collector<T, ?, List<U>> flattMapping(Function<? super T, ? extends Collection<? extends T2>> flatMapper, BiFunction<? super T, ? super T2, ? extends U> mapper) {
        return Collectors.flattMapping(flatMapper, mapper, Collectors.toList());
    }

    public static <T, T2, U, A, R> Collector<T, ?, R> flattMapping(final Function<? super T, ? extends Collection<? extends T2>> flatMapper, final BiFunction<? super T, ? super T2, ? extends U> mapper, Collector<? super U, A, R> downstream) {
        final BiConsumer<A, ? super U> downstreamAccumulator = downstream.accumulator();
        BiConsumer accumulator = new BiConsumer<A, T>(){

            @Override
            public void accept(A a, T t) {
                Collection c = (Collection)flatMapper.apply(t);
                if (N.notNullOrEmpty(c)) {
                    for (Object t2 : c) {
                        downstreamAccumulator.accept(a, mapper.apply(t, t2));
                    }
                }
            }
        };
        return new CollectorImpl(downstream.supplier(), accumulator, downstream.combiner(), downstream.finisher(), downstream.characteristics());
    }

    public static <T, A, R, RR> Collector<T, A, RR> collectingAndThen(Collector<T, A, R> downstream, final Function<R, RR> finisher) {
        N.checkArgNotNull(finisher);
        final Function<A, R> downstreamFinisher = downstream.finisher();
        Function thenFinisher = new Function<A, RR>(){

            @Override
            public RR apply(A t) {
                return finisher.apply(downstreamFinisher.apply(t));
            }
        };
        Set<Collector.Characteristics> characteristics = downstream.characteristics();
        if (characteristics.contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            if (characteristics.size() == 1) {
                characteristics = CH_NOID;
            } else {
                characteristics = EnumSet.copyOf(characteristics);
                characteristics.remove((Object)Collector.Characteristics.IDENTITY_FINISH);
                characteristics = Collections.unmodifiableSet(characteristics);
            }
        }
        return new CollectorImpl(downstream.supplier(), downstream.accumulator(), downstream.combiner(), thenFinisher, characteristics);
    }

    public static <T> Collector<T, ?, List<T>> distinctBy(final Function<? super T, ?> mapper) {
        Supplier supplier = Fn.Suppliers.ofLinkedHashMap();
        BiConsumer accumulator = new BiConsumer<Map<Object, T>, T>(){

            @Override
            public void accept(Map<Object, T> map, T t) {
                Object key = mapper.apply(t);
                if (!map.containsKey(key)) {
                    map.put(key, t);
                }
            }
        };
        BinaryOperator combiner = new BinaryOperator<Map<Object, T>>(){

            @Override
            public Map<Object, T> apply(Map<Object, T> a, Map<Object, T> b) {
                for (Map.Entry entry : b.entrySet()) {
                    if (a.containsKey(entry.getKey())) continue;
                    a.put(entry.getKey(), entry.getValue());
                }
                return a;
            }
        };
        Function finisher = new Function<Map<Object, T>, List<T>>(){

            @Override
            public List<T> apply(Map<Object, T> map) {
                return new ArrayList(map.values());
            }
        };
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T> Collector<T, ?, Integer> distinctCount(final Function<? super T, ?> mapper) {
        Supplier supplier = Fn.Suppliers.ofSet();
        BiConsumer accumulator = new BiConsumer<Set<Object>, T>(){

            @Override
            public void accept(Set<Object> c, T t) {
                c.add(mapper.apply(t));
            }
        };
        BinaryOperator combiner = Fn.BinaryOperators.ofAddAllToBigger();
        Function<Set<Object>, Integer> finisher = new Function<Set<Object>, Integer>(){

            @Override
            public Integer apply(Set<Object> c) {
                return c.size();
            }
        };
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T> Collector<T, ?, Long> counting() {
        Function<Object, ? extends Long> accumulator = Counting_Accumulator;
        BinaryOperator<Long> combiner = Counting_Combiner;
        return Collectors.reducing(0L, accumulator, combiner);
    }

    public static <T> Collector<T, ?, Integer> countingInt() {
        Function<Object, ? extends Integer> accumulator = CountingInt_Accumulator;
        BinaryOperator<Integer> combiner = CountingInt_Combiner;
        return Collectors.reducing(0, accumulator, combiner);
    }

    public static <T extends Comparable> Collector<T, ?, u.Optional<T>> min() {
        return Collectors.min(Fn.nullsLast());
    }

    public static <T> Collector<T, ?, u.Optional<T>> min(final Comparator<? super T> comparator) {
        N.checkArgNotNull(comparator);
        BinaryOperator op = new BinaryOperator<T>(){

            @Override
            public T apply(T a, T b) {
                return comparator.compare(a, b) <= 0 ? a : b;
            }
        };
        return Collectors.reducing(op);
    }

    public static <T> Collector<T, ?, T> minOrGet(final Comparator<? super T> comparator, Supplier<? extends T> other) {
        N.checkArgNotNull(comparator);
        BinaryOperator op = new BinaryOperator<T>(){

            @Override
            public T apply(T a, T b) {
                return comparator.compare(a, b) <= 0 ? a : b;
            }
        };
        return Collectors.reducingOrGet(op, other);
    }

    public static <T, X extends RuntimeException> Collector<T, ?, T> minOrThrow(final Comparator<? super T> comparator, Supplier<? extends X> exceptionSupplier) {
        N.checkArgNotNull(comparator);
        BinaryOperator op = new BinaryOperator<T>(){

            @Override
            public T apply(T a, T b) {
                return comparator.compare(a, b) <= 0 ? a : b;
            }
        };
        return Collectors.reducingOrThrow(op, exceptionSupplier);
    }

    public static <T> Collector<T, ?, T> minOrThrow(Comparator<? super T> comparator) {
        return Collectors.minOrThrow(comparator, noSuchElementExceptionSupplier);
    }

    public static <T extends Comparable> Collector<T, ?, u.Optional<T>> max() {
        return Collectors.max(Fn.nullsFirst());
    }

    public static <T> Collector<T, ?, u.Optional<T>> max(final Comparator<? super T> comparator) {
        N.checkArgNotNull(comparator);
        BinaryOperator op = new BinaryOperator<T>(){

            @Override
            public T apply(T a, T b) {
                return comparator.compare(a, b) >= 0 ? a : b;
            }
        };
        return Collectors.reducing(op);
    }

    public static <T> Collector<T, ?, T> maxOrGet(final Comparator<? super T> comparator, Supplier<? extends T> other) {
        N.checkArgNotNull(comparator);
        BinaryOperator op = new BinaryOperator<T>(){

            @Override
            public T apply(T a, T b) {
                return comparator.compare(a, b) >= 0 ? a : b;
            }
        };
        return Collectors.reducingOrGet(op, other);
    }

    public static <T, X extends RuntimeException> Collector<T, ?, T> maxOrThrow(final Comparator<? super T> comparator, Supplier<? extends X> exceptionSupplier) {
        N.checkArgNotNull(comparator);
        BinaryOperator op = new BinaryOperator<T>(){

            @Override
            public T apply(T a, T b) {
                return comparator.compare(a, b) >= 0 ? a : b;
            }
        };
        return Collectors.reducingOrThrow(op, exceptionSupplier);
    }

    public static <T> Collector<T, ?, T> maxOrThrow(Comparator<? super T> comparator) {
        return Collectors.maxOrThrow(comparator, noSuchElementExceptionSupplier);
    }

    public static <T> Collector<T, ?, u.Optional<T>> minBy(Function<? super T, ? extends Comparable> keyMapper) {
        return Collectors.min(Comparators.comparingBy(keyMapper));
    }

    public static <T> Collector<T, ?, T> minByOrGet(Function<? super T, ? extends Comparable> keyMapper, Supplier<? extends T> other) {
        return Collectors.minOrGet(Comparators.comparingBy(keyMapper), other);
    }

    public static <T, X extends RuntimeException> Collector<T, ?, T> minByOrThrow(Function<? super T, ? extends Comparable> keyMapper, Supplier<? extends X> exceptionSupplier) {
        return Collectors.minOrThrow(Comparators.comparingBy(keyMapper), exceptionSupplier);
    }

    public static <T> Collector<T, ?, T> minByOrThrow(Function<? super T, ? extends Comparable> keyMapper) {
        return Collectors.minOrThrow(Comparators.comparingBy(keyMapper));
    }

    public static <T> Collector<T, ?, u.Optional<T>> maxBy(Function<? super T, ? extends Comparable> keyMapper) {
        return Collectors.max(Comparators.comparingBy(keyMapper));
    }

    public static <T> Collector<T, ?, T> maxByOrGet(Function<? super T, ? extends Comparable> keyMapper, Supplier<? extends T> other) {
        return Collectors.maxOrGet(Comparators.comparingBy(keyMapper), other);
    }

    public static <T, X extends RuntimeException> Collector<T, ?, T> maxByOrThrow(Function<? super T, ? extends Comparable> keyMapper, Supplier<? extends X> exceptionSupplier) {
        return Collectors.maxOrThrow(Comparators.comparingBy(keyMapper), exceptionSupplier);
    }

    public static <T> Collector<T, ?, T> maxByOrThrow(Function<? super T, ? extends Comparable> keyMapper) {
        return Collectors.maxOrThrow(Comparators.comparingBy(keyMapper));
    }

    public static <T extends Comparable, R> Collector<T, ?, u.Optional<Pair<T, T>>> minMax() {
        return Collectors.minMax(Fn.naturalOrder());
    }

    public static <T, R> Collector<T, ?, u.Optional<Pair<T, T>>> minMax(Comparator<? super T> comparator) {
        return Collectors.minMax(comparator, Fn.pair());
    }

    public static <T, R> Collector<T, ?, u.Optional<R>> minMax(Comparator<? super T> comparator, final BiFunction<? super T, ? super T, ? extends R> finisher) {
        BiFunction finisher2 = new BiFunction<u.Optional<T>, u.Optional<T>, u.Optional<R>>(){

            @Override
            public u.Optional<R> apply(u.Optional<T> min, u.Optional<T> max) {
                return min.isPresent() ? u.Optional.of(finisher.apply(min.get(), max.get())) : u.Optional.empty();
            }
        };
        return Collectors.combine(Collectors.min(comparator), Collectors.max(comparator), finisher2);
    }

    public static <T, R> Collector<T, ?, u.Optional<Pair<T, T>>> minMaxBy(Function<? super T, ? extends Comparable> keyMapper) {
        return Collectors.minMax(Comparators.comparingBy(keyMapper));
    }

    public static <T, R> Collector<T, ?, u.Optional<R>> minMaxBy(Function<? super T, ? extends Comparable> keyMapper, BiFunction<? super T, ? super T, ? extends R> finisher) {
        return Collectors.minMax(Comparators.comparingBy(keyMapper), finisher);
    }

    public static <T extends Comparable> Collector<T, ?, List<T>> maxAll() {
        return Collectors.maxAll(Fn.nullsFirst());
    }

    public static <T> Collector<T, ?, List<T>> maxAll(Comparator<? super T> comparator) {
        return Collectors.maxAll(comparator, Integer.MAX_VALUE);
    }

    public static <T> Collector<T, ?, List<T>> maxAll(final Comparator<? super T> comparator, final int atMostSize) {
        Supplier supplier = new Supplier<Pair<T, List<T>>>(){

            @Override
            public Pair<T, List<T>> get() {
                ArrayList list = new ArrayList(Math.min(16, atMostSize));
                return Pair.of(NONE, list);
            }
        };
        BiConsumer accumulator = new BiConsumer<Pair<T, List<T>>, T>(){

            @Override
            public void accept(Pair<T, List<T>> a, T t) {
                if (a.left == NONE) {
                    a.left = t;
                    if (((List)a.right).size() < atMostSize) {
                        ((List)a.right).add(t);
                    }
                } else {
                    int cmp = comparator.compare(t, a.left);
                    if (cmp > 0) {
                        a.left = t;
                        ((List)a.right).clear();
                    }
                    if (cmp >= 0 && ((List)a.right).size() < atMostSize) {
                        ((List)a.right).add(t);
                    }
                }
            }
        };
        BinaryOperator combiner = new BinaryOperator<Pair<T, List<T>>>(){

            @Override
            public Pair<T, List<T>> apply(Pair<T, List<T>> a, Pair<T, List<T>> b) {
                if (b.left == NONE) {
                    return a;
                }
                if (a.left == NONE) {
                    return b;
                }
                int cmp = comparator.compare(a.left, b.left);
                if (cmp > 0) {
                    return a;
                }
                if (cmp < 0) {
                    return b;
                }
                if (((List)a.right).size() < atMostSize) {
                    if (((List)b.right).size() <= atMostSize - ((List)a.right).size()) {
                        ((List)a.right).addAll((Collection)b.right);
                    } else {
                        ((List)a.right).addAll(((List)b.right).subList(0, atMostSize - ((List)a.right).size()));
                    }
                }
                return a;
            }
        };
        Function finisher = new Function<Pair<T, List<T>>, List<T>>(){

            @Override
            public List<T> apply(Pair<T, List<T>> a) {
                return (List)a.right;
            }
        };
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T extends Comparable> Collector<T, ?, List<T>> maxAll(boolean areAllLargestSame) {
        return Collectors.maxAll(Integer.MAX_VALUE, areAllLargestSame);
    }

    public static <T extends Comparable> Collector<T, ?, List<T>> maxAll(int atMostSize, boolean areAllLargestSame) {
        return Collectors.maxAll(Fn.nullsFirst(), atMostSize, areAllLargestSame);
    }

    public static <T> Collector<T, ?, List<T>> maxAll(Comparator<? super T> comparator, final int atMostSize, boolean areAllLargestSame) {
        N.checkArgPositive(atMostSize, "atMostSize");
        if (areAllLargestSame) {
            Function finisher = new Function<Pair<u.Optional<T>, Integer>, List<T>>(){

                @Override
                public List<T> apply(Pair<u.Optional<T>, Integer> t) {
                    int n = N.min(atMostSize, (int)((Integer)t.right));
                    return n == 0 ? new ArrayList() : N.repeat(((u.Optional)t.left).get(), n);
                }
            };
            return Collectors.maxAlll(comparator, Collectors.countingInt(), finisher);
        }
        return Collectors.maxAll(comparator, atMostSize);
    }

    public static <T extends Comparable, A, D> Collector<T, ?, D> maxAll(Collector<T, A, D> downstream) {
        return Collectors.maxAll(Fn.nullsFirst(), downstream);
    }

    public static <T, A, D> Collector<T, ?, D> maxAll(final Comparator<? super T> comparator, final Collector<? super T, A, D> downstream) {
        final Supplier<A> downstreamSupplier = downstream.supplier();
        final BiConsumer<A, ? super T> downstreamAccumulator = downstream.accumulator();
        final BinaryOperator<A> downstreamCombiner = downstream.combiner();
        final MutableBoolean isCollection = MutableBoolean.of(false);
        final MutableBoolean isMap = MutableBoolean.of(false);
        Supplier supplier = new Supplier<Pair<T, A>>(){

            @Override
            public Pair<T, A> get() {
                Object container = downstreamSupplier.get();
                if (container instanceof Collection && ((Collection)container).size() == 0) {
                    try {
                        ((Collection)container).clear();
                        isCollection.setTrue();
                    }
                    catch (Exception exception) {}
                } else if (container instanceof Map && ((Map)container).size() == 0) {
                    try {
                        ((Map)container).clear();
                        isMap.setTrue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return Pair.of(Collectors.none(), container);
            }
        };
        BiConsumer accumulator = new BiConsumer<Pair<T, A>, T>(){

            @Override
            public void accept(Pair<T, A> a, T t) {
                if (a.left == NONE) {
                    a.left = t;
                    downstreamAccumulator.accept(a.right, t);
                } else {
                    int cmp = comparator.compare(t, a.left);
                    if (cmp > 0) {
                        if (isCollection.isTrue()) {
                            ((Collection)a.right).clear();
                        } else if (isMap.isTrue()) {
                            ((Map)a.right).clear();
                        } else {
                            a.right = downstreamSupplier.get();
                        }
                        a.left = t;
                    }
                    if (cmp >= 0) {
                        downstreamAccumulator.accept(a.right, t);
                    }
                }
            }
        };
        BinaryOperator combiner = new BinaryOperator<Pair<T, A>>(){

            @Override
            public Pair<T, A> apply(Pair<T, A> a, Pair<T, A> b) {
                if (b.left == NONE) {
                    return a;
                }
                if (a.left == NONE) {
                    return b;
                }
                int cmp = comparator.compare(a.left, b.left);
                if (cmp > 0) {
                    return a;
                }
                if (cmp < 0) {
                    return b;
                }
                a.right = downstreamCombiner.apply(a.right, b.right);
                return a;
            }
        };
        Function finisher = new Function<Pair<T, A>, D>(){

            @Override
            public D apply(Pair<T, A> t) {
                return downstream.finisher().apply(t.right);
            }
        };
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    static <T> T none() {
        return (T)NONE;
    }

    public static <T extends Comparable, A, D> Collector<T, ?, Pair<u.Optional<T>, D>> maxAlll(Collector<T, A, D> downstream) {
        return Collectors.maxAlll(Fn.nullsFirst(), downstream);
    }

    public static <T, A, D> Collector<T, ?, Pair<u.Optional<T>, D>> maxAlll(Comparator<? super T> comparator, Collector<? super T, A, D> downstream) {
        return Collectors.maxAlll(comparator, downstream, Fn.identity());
    }

    public static <T, A, D, R> Collector<T, ?, R> maxAlll(final Comparator<? super T> comparator, final Collector<? super T, A, D> downstream, final Function<Pair<u.Optional<T>, D>, R> finisher) {
        final Supplier<A> downstreamSupplier = downstream.supplier();
        final BiConsumer<A, ? super T> downstreamAccumulator = downstream.accumulator();
        final BinaryOperator<A> downstreamCombiner = downstream.combiner();
        final MutableBoolean isCollection = MutableBoolean.of(false);
        final MutableBoolean isMap = MutableBoolean.of(false);
        Supplier supplier = new Supplier<Pair<T, A>>(){

            @Override
            public Pair<T, A> get() {
                Object container = downstreamSupplier.get();
                if (container instanceof Collection && ((Collection)container).size() == 0) {
                    try {
                        ((Collection)container).clear();
                        isCollection.setTrue();
                    }
                    catch (Exception exception) {}
                } else if (container instanceof Map && ((Map)container).size() == 0) {
                    try {
                        ((Map)container).clear();
                        isMap.setTrue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return Pair.of(Collectors.none(), container);
            }
        };
        BiConsumer accumulator = new BiConsumer<Pair<T, A>, T>(){

            @Override
            public void accept(Pair<T, A> a, T t) {
                if (a.left == NONE) {
                    a.left = t;
                    downstreamAccumulator.accept(a.right, t);
                } else {
                    int cmp = comparator.compare(t, a.left);
                    if (cmp > 0) {
                        if (isCollection.isTrue()) {
                            ((Collection)a.right).clear();
                        } else if (isMap.isTrue()) {
                            ((Map)a.right).clear();
                        } else {
                            a.right = downstreamSupplier.get();
                        }
                        a.left = t;
                    }
                    if (cmp >= 0) {
                        downstreamAccumulator.accept(a.right, t);
                    }
                }
            }
        };
        BinaryOperator combiner = new BinaryOperator<Pair<T, A>>(){

            @Override
            public Pair<T, A> apply(Pair<T, A> a, Pair<T, A> b) {
                if (b.left == NONE) {
                    return a;
                }
                if (a.left == NONE) {
                    return b;
                }
                int cmp = comparator.compare(a.left, b.left);
                if (cmp > 0) {
                    return a;
                }
                if (cmp < 0) {
                    return b;
                }
                a.right = downstreamCombiner.apply(a.right, b.right);
                return a;
            }
        };
        Function finalFinisher = new Function<Pair<T, A>, R>(){

            @Override
            public R apply(Pair<T, A> a) {
                Pair result = a;
                result.setLeft(a.left == NONE ? u.Optional.empty() : u.Optional.of(a.left));
                result.setRight(downstream.finisher().apply(a.right));
                return finisher.apply(result);
            }
        };
        return new CollectorImpl(supplier, accumulator, combiner, finalFinisher, CH_UNORDERED_NOID);
    }

    public static <T extends Comparable> Collector<T, ?, List<T>> minAll() {
        return Collectors.minAll(Fn.nullsLast());
    }

    public static <T> Collector<T, ?, List<T>> minAll(Comparator<? super T> comparator) {
        return Collectors.minAll(comparator, Integer.MAX_VALUE);
    }

    public static <T> Collector<T, ?, List<T>> minAll(Comparator<? super T> comparator, int atMostSize) {
        return Collectors.maxAll(Fn.reversedOrder(comparator), atMostSize);
    }

    public static <T extends Comparable> Collector<T, ?, List<T>> minAll(boolean areAllSmallestSame) {
        return Collectors.minAll(Integer.MAX_VALUE, areAllSmallestSame);
    }

    public static <T extends Comparable> Collector<T, ?, List<T>> minAll(int atMostSize, boolean areAllSmallestSame) {
        return Collectors.minAll(Fn.nullsLast(), atMostSize, areAllSmallestSame);
    }

    public static <T> Collector<T, ?, List<T>> minAll(Comparator<? super T> comparator, int atMostSize, boolean areAllSmallestSame) {
        return Collectors.maxAll(Fn.reversedOrder(comparator), atMostSize, areAllSmallestSame);
    }

    public static <T extends Comparable, A, D> Collector<T, ?, D> minAll(Collector<T, A, D> downstream) {
        return Collectors.minAll(Fn.nullsLast(), downstream);
    }

    public static <T, A, D> Collector<T, ?, D> minAll(Comparator<? super T> comparator, Collector<T, A, D> downstream) {
        return Collectors.maxAll(Fn.reversedOrder(comparator), downstream);
    }

    public static <T extends Comparable, A, D> Collector<T, ?, Pair<u.Optional<T>, D>> minAlll(Collector<T, A, D> downstream) {
        return Collectors.minAlll(Fn.nullsLast(), downstream);
    }

    public static <T, A, D> Collector<T, ?, Pair<u.Optional<T>, D>> minAlll(Comparator<? super T> comparator, Collector<? super T, A, D> downstream) {
        return Collectors.minAlll(comparator, downstream, Fn.identity());
    }

    public static <T, A, D, R> Collector<T, ?, R> minAlll(Comparator<? super T> comparator, Collector<? super T, A, D> downstream, Function<Pair<u.Optional<T>, D>, R> finisher) {
        return Collectors.maxAlll(Fn.reversedOrder(comparator), downstream, finisher);
    }

    public static <T> Collector<T, ?, Long> summingInt(final ToIntFunction<? super T> mapper) {
        Supplier<long[]> supplier = SummingInt_Supplier;
        BiConsumer accumulator = new BiConsumer<long[], T>(){

            @Override
            public void accept(long[] a, T t) {
                a[0] = a[0] + (long)mapper.applyAsInt(t);
            }
        };
        BinaryOperator<long[]> combiner = SummingInt_Combiner;
        Function<long[], Long> finisher = SummingInt_Finisher;
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T> Collector<T, ?, u.OptionalLong> summingIntt(final ToIntFunction<? super T> mapper) {
        Supplier<long[]> supplier = SummingInt_Supplier_2;
        BiConsumer accumulator = new BiConsumer<long[], T>(){

            @Override
            public void accept(long[] a, T t) {
                a[0] = a[0] + (long)mapper.applyAsInt(t);
            }
        };
        BinaryOperator<long[]> combiner = SummingInt_Combiner_2;
        Function<long[], u.OptionalLong> finisher = SummingInt_Finisher_2;
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T> Collector<T, ?, Long> summingLong(final ToLongFunction<? super T> mapper) {
        Supplier<long[]> supplier = SummingLong_Supplier;
        BiConsumer accumulator = new BiConsumer<long[], T>(){

            @Override
            public void accept(long[] a, T t) {
                a[0] = a[0] + mapper.applyAsLong(t);
            }
        };
        BinaryOperator<long[]> combiner = SummingLong_Combiner;
        Function<long[], Long> finisher = SummingLong_Finisher;
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T> Collector<T, ?, u.OptionalLong> summingLongg(final ToLongFunction<? super T> mapper) {
        Supplier<long[]> supplier = SummingLong_Supplier_2;
        BiConsumer accumulator = new BiConsumer<long[], T>(){

            @Override
            public void accept(long[] a, T t) {
                a[0] = a[0] + mapper.applyAsLong(t);
            }
        };
        BinaryOperator<long[]> combiner = SummingLong_Combiner_2;
        Function<long[], u.OptionalLong> finisher = SummingLong_Finisher_2;
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T> Collector<T, ?, Double> summingDouble(final ToDoubleFunction<? super T> mapper) {
        Supplier<KahanSummation> supplier = SummingDouble_Supplier;
        BiConsumer accumulator = new BiConsumer<KahanSummation, T>(){

            @Override
            public void accept(KahanSummation a, T t) {
                a.add(mapper.applyAsDouble(t));
            }
        };
        BinaryOperator<KahanSummation> combiner = SummingDouble_Combiner;
        Function<KahanSummation, Double> finisher = SummingDouble_Finisher;
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T> Collector<T, ?, u.OptionalDouble> summingDoubble(final ToDoubleFunction<? super T> mapper) {
        Supplier<KahanSummation> supplier = SummingDouble_Supplier_2;
        BiConsumer accumulator = new BiConsumer<KahanSummation, T>(){

            @Override
            public void accept(KahanSummation a, T t) {
                a.add(mapper.applyAsDouble(t));
            }
        };
        BinaryOperator<KahanSummation> combiner = SummingDouble_Combiner_2;
        Function<KahanSummation, u.OptionalDouble> finisher = SummingDouble_Finisher_2;
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T> Collector<T, ?, BigInteger> summingBigInteger(final Function<? super T, BigInteger> mapper) {
        Supplier<BigInteger[]> supplier = SummingBigInteger_Supplier;
        BiConsumer accumulator = new BiConsumer<BigInteger[], T>(){

            @Override
            public void accept(BigInteger[] a, T t) {
                a[0] = a[0].add((BigInteger)mapper.apply(t));
            }
        };
        BinaryOperator<BigInteger[]> combiner = SummingBigInteger_Combiner;
        Function<BigInteger[], BigInteger> finisher = SummingBigInteger_Finisher;
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T> Collector<T, ?, BigDecimal> summingBigDecimal(final Function<? super T, BigDecimal> mapper) {
        Supplier<BigDecimal[]> supplier = SummingBigDecimal_Supplier;
        BiConsumer accumulator = new BiConsumer<BigDecimal[], T>(){

            @Override
            public void accept(BigDecimal[] a, T t) {
                a[0] = a[0].add((BigDecimal)mapper.apply(t));
            }
        };
        BinaryOperator<BigDecimal[]> combiner = SummingBigDecimal_Combiner;
        Function<BigDecimal[], BigDecimal> finisher = SummingBigDecimal_Finisher;
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T> Collector<T, ?, Double> averagingInt(final ToIntFunction<? super T> mapper) {
        Supplier<long[]> supplier = AveragingInt_Supplier;
        BiConsumer accumulator = new BiConsumer<long[], T>(){

            @Override
            public void accept(long[] a, T t) {
                a[0] = a[0] + (long)mapper.applyAsInt(t);
                a[1] = a[1] + 1L;
            }
        };
        BinaryOperator<long[]> combiner = AveragingInt_Combiner;
        Function<long[], Double> finisher = AveragingInt_Finisher;
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T> Collector<T, ?, u.OptionalDouble> averagingIntt(final ToIntFunction<? super T> mapper) {
        Supplier<long[]> supplier = AveragingInt_Supplier;
        BiConsumer accumulator = new BiConsumer<long[], T>(){

            @Override
            public void accept(long[] a, T t) {
                a[0] = a[0] + (long)mapper.applyAsInt(t);
                a[1] = a[1] + 1L;
            }
        };
        BinaryOperator<long[]> combiner = AveragingInt_Combiner;
        Function<long[], u.OptionalDouble> finisher = AveragingInt_Finisher_2;
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T> Collector<T, ?, Double> averagingLong(final ToLongFunction<? super T> mapper) {
        Supplier<long[]> supplier = AveragingLong_Supplier;
        BiConsumer accumulator = new BiConsumer<long[], T>(){

            @Override
            public void accept(long[] a, T t) {
                a[0] = a[0] + mapper.applyAsLong(t);
                a[1] = a[1] + 1L;
            }
        };
        BinaryOperator<long[]> combiner = AveragingLong_Combiner;
        Function<long[], Double> finisher = AveragingLong_Finisher;
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T> Collector<T, ?, u.OptionalDouble> averagingLongg(final ToLongFunction<? super T> mapper) {
        Supplier<long[]> supplier = AveragingLong_Supplier;
        BiConsumer accumulator = new BiConsumer<long[], T>(){

            @Override
            public void accept(long[] a, T t) {
                a[0] = a[0] + mapper.applyAsLong(t);
                a[1] = a[1] + 1L;
            }
        };
        BinaryOperator<long[]> combiner = AveragingLong_Combiner;
        Function<long[], u.OptionalDouble> finisher = AveragingLong_Finisher_2;
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T> Collector<T, ?, Double> averagingDouble(final ToDoubleFunction<? super T> mapper) {
        Supplier<KahanSummation> supplier = AveragingDouble_Supplier;
        BiConsumer accumulator = new BiConsumer<KahanSummation, T>(){

            @Override
            public void accept(KahanSummation a, T t) {
                a.add(mapper.applyAsDouble(t));
            }
        };
        BinaryOperator<KahanSummation> combiner = AveragingDouble_Combiner;
        Function<KahanSummation, Double> finisher = AveragingDouble_Finisher;
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T> Collector<T, ?, u.OptionalDouble> averagingDoubble(final ToDoubleFunction<? super T> mapper) {
        Supplier<KahanSummation> supplier = AveragingDouble_Supplier;
        BiConsumer accumulator = new BiConsumer<KahanSummation, T>(){

            @Override
            public void accept(KahanSummation a, T t) {
                a.add(mapper.applyAsDouble(t));
            }
        };
        BinaryOperator<KahanSummation> combiner = AveragingDouble_Combiner;
        Function<KahanSummation, u.OptionalDouble> finisher = AveragingDouble_Finisher_2;
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T> Collector<T, ?, BigDecimal> averagingBigInteger(final Function<? super T, BigInteger> mapper) {
        Supplier<Pair<BigInteger, MutableLong>> supplier = AveragingBigInteger_Supplier;
        BiConsumer accumulator = new BiConsumer<Pair<BigInteger, MutableLong>, T>(){

            @Override
            public void accept(Pair<BigInteger, MutableLong> a, T t) {
                a.setLeft(((BigInteger)a.left).add((BigInteger)mapper.apply(t)));
                ((MutableLong)a.right).increment();
            }
        };
        BinaryOperator<Pair<BigInteger, MutableLong>> combiner = AveragingBigInteger_Combiner;
        Function<Pair<BigInteger, MutableLong>, BigDecimal> finisher = AveragingBigInteger_Finisher;
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T> Collector<T, ?, BigDecimal> averagingBigDecimal(final Function<? super T, BigDecimal> mapper) {
        Supplier<Pair<BigDecimal, MutableLong>> supplier = AveragingBigDecimal_Supplier;
        BiConsumer accumulator = new BiConsumer<Pair<BigDecimal, MutableLong>, T>(){

            @Override
            public void accept(Pair<BigDecimal, MutableLong> a, T t) {
                a.setLeft(((BigDecimal)a.left).add((BigDecimal)mapper.apply(t)));
                ((MutableLong)a.right).increment();
            }
        };
        BinaryOperator<Pair<BigDecimal, MutableLong>> combiner = AveragingBigDecimal_Combiner;
        Function<Pair<BigDecimal, MutableLong>, BigDecimal> finisher = AveragingBigDecimal_Finisher;
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T> Collector<T, ?, T> reducing(T identity, final BinaryOperator<T> op) {
        BiConsumer accumulator = new BiConsumer<u.Holder<T>, T>(){

            @Override
            public void accept(u.Holder<T> a, T t) {
                a.setValue(op.apply(a.value(), t));
            }
        };
        BinaryOperator combiner = new BinaryOperator<u.Holder<T>>(){

            @Override
            public u.Holder<T> apply(u.Holder<T> a, u.Holder<T> b) {
                a.setValue(op.apply(a.value(), b.value()));
                return a;
            }
        };
        Function<u.Holder<Object>, Object> finisher = Reducing_Finisher_0;
        return new CollectorImpl(Collectors.holderSupplier(identity), accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T> Collector<T, ?, u.Optional<T>> reducing(final BinaryOperator<T> op) {
        Supplier supplier = new Supplier<OptHolder<T>>(){

            @Override
            public OptHolder<T> get() {
                return new OptHolder(op);
            }
        };
        BiConsumer<OptHolder<Object>, Object> accumulator = Reducing_Accumulator;
        BinaryOperator<OptHolder<Object>> combiner = Reducing_Combiner;
        Function<OptHolder<Object>, u.Optional<Object>> finisher = Reducing_Finisher;
        return new CollectorImpl<Object, OptHolder<Object>, u.Optional<Object>>(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T> Collector<T, ?, T> reducingOrGet(final BinaryOperator<T> op, final Supplier<? extends T> other) {
        Supplier supplier = new Supplier<OptHolder<T>>(){

            @Override
            public OptHolder<T> get() {
                return new OptHolder(op);
            }
        };
        BiConsumer<OptHolder<Object>, Object> accumulator = Reducing_Accumulator;
        BinaryOperator<OptHolder<Object>> combiner = Reducing_Combiner;
        Function finisher = new Function<OptHolder<T>, T>(){

            @Override
            public T apply(OptHolder<T> a) {
                return a.present ? a.value : other.get();
            }
        };
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T, X extends RuntimeException> Collector<T, ?, T> reducingOrThrow(final BinaryOperator<T> op, final Supplier<? extends X> exceptionSupplier) {
        Supplier supplier = new Supplier<OptHolder<T>>(){

            @Override
            public OptHolder<T> get() {
                return new OptHolder(op);
            }
        };
        BiConsumer<OptHolder<Object>, Object> accumulator = Reducing_Accumulator;
        BinaryOperator<OptHolder<Object>> combiner = Reducing_Combiner;
        Function finisher = new Function<OptHolder<T>, T>(){

            @Override
            public T apply(OptHolder<T> a) {
                if (a.present) {
                    return a.value;
                }
                throw (RuntimeException)exceptionSupplier.get();
            }
        };
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T> Collector<T, ?, T> reducingOrThrow(BinaryOperator<T> op) {
        return Collectors.reducingOrThrow(op, noSuchElementExceptionSupplier);
    }

    public static <T, U> Collector<T, ?, U> reducing(U identity, final Function<? super T, ? extends U> mapper, final BinaryOperator<U> op) {
        BiConsumer accumulator = new BiConsumer<u.Holder<U>, T>(){

            @Override
            public void accept(u.Holder<U> a, T t) {
                a.setValue(op.apply(a.value(), mapper.apply(t)));
            }
        };
        BinaryOperator combiner = new BinaryOperator<u.Holder<U>>(){

            @Override
            public u.Holder<U> apply(u.Holder<U> a, u.Holder<U> b) {
                a.setValue(op.apply(a.value(), b.value()));
                return a;
            }
        };
        Function<u.Holder<Object>, Object> finisher = Reducing_Finisher_0;
        return new CollectorImpl(Collectors.holderSupplier(identity), accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T, U> Collector<T, ?, u.Optional<U>> reducing(final Function<? super T, ? extends U> mapper, final BinaryOperator<U> op) {
        Supplier supplier = new Supplier<MappingOptHolder<T, U>>(){

            @Override
            public MappingOptHolder<T, U> get() {
                return new MappingOptHolder(mapper, op);
            }
        };
        BiConsumer<MappingOptHolder<Object, Object>, Object> accumulator = Reducing_Accumulator_2;
        BinaryOperator<MappingOptHolder<Object, Object>> combiner = Reducing_Combiner_2;
        Function<MappingOptHolder<Object, Object>, u.Optional<Object>> finisher = Reducing_Finisher_2;
        return new CollectorImpl<Object, MappingOptHolder<Object, Object>, u.Optional<Object>>(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    private static <T> Supplier<u.Holder<T>> holderSupplier(final T identity) {
        return new Supplier<u.Holder<T>>(){

            @Override
            public u.Holder<T> get() {
                return u.Holder.of(identity);
            }
        };
    }

    public static <T, U> Collector<T, ?, U> reducingOrGet(final Function<? super T, ? extends U> mapper, final BinaryOperator<U> op, final Supplier<? extends U> other) {
        Supplier supplier = new Supplier<MappingOptHolder<T, U>>(){

            @Override
            public MappingOptHolder<T, U> get() {
                return new MappingOptHolder(mapper, op);
            }
        };
        BiConsumer<MappingOptHolder<Object, Object>, Object> accumulator = Reducing_Accumulator_2;
        BinaryOperator<MappingOptHolder<Object, Object>> combiner = Reducing_Combiner_2;
        Function finisher = new Function<MappingOptHolder<T, U>, U>(){

            @Override
            public U apply(MappingOptHolder<T, U> a) {
                return a.present ? a.value : other.get();
            }
        };
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T, U, X extends RuntimeException> Collector<T, ?, U> reducingOrThrow(final Function<? super T, ? extends U> mapper, final BinaryOperator<U> op, final Supplier<? extends X> exceptionSupplier) {
        Supplier supplier = new Supplier<MappingOptHolder<T, U>>(){

            @Override
            public MappingOptHolder<T, U> get() {
                return new MappingOptHolder(mapper, op);
            }
        };
        BiConsumer<MappingOptHolder<Object, Object>, Object> accumulator = Reducing_Accumulator_2;
        BinaryOperator<MappingOptHolder<Object, Object>> combiner = Reducing_Combiner_2;
        Function finisher = new Function<MappingOptHolder<T, U>, U>(){

            @Override
            public U apply(MappingOptHolder<T, U> a) {
                if (a.present) {
                    return a.value;
                }
                throw (RuntimeException)exceptionSupplier.get();
            }
        };
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T, U> Collector<T, ?, U> reducingOrThrow(Function<? super T, ? extends U> mapper, BinaryOperator<U> op) {
        return Collectors.reducingOrThrow(mapper, op, noSuchElementExceptionSupplier);
    }

    public static Collector<CharSequence, ?, String> commonPrefix() {
        Supplier<Pair<CharSequence, Integer>> supplier = new Supplier<Pair<CharSequence, Integer>>(){

            @Override
            public Pair<CharSequence, Integer> get() {
                return Pair.of(null, -1);
            }
        };
        final BiConsumer<Pair<CharSequence, Integer>, CharSequence> accumulator = new BiConsumer<Pair<CharSequence, Integer>, CharSequence>(){

            @Override
            public void accept(Pair<CharSequence, Integer> a, CharSequence t) {
                if ((Integer)a.right == -1) {
                    a.left = t;
                    a.right = t.length();
                } else if ((Integer)a.right > 0) {
                    if (t.length() < (Integer)a.right) {
                        a.right = t.length();
                    }
                    int to = (Integer)a.right;
                    for (int i = 0; i < to; ++i) {
                        if (((CharSequence)a.left).charAt(i) == t.charAt(i)) continue;
                        if (i > 0 && Character.isHighSurrogate(t.charAt(i - 1)) && (Character.isLowSurrogate(t.charAt(i)) || Character.isLowSurrogate(((CharSequence)a.left).charAt(i)))) {
                            --i;
                        }
                        a.right = i;
                        break;
                    }
                }
            }
        };
        BinaryOperator<Pair<CharSequence, Integer>> combiner = new BinaryOperator<Pair<CharSequence, Integer>>(){

            @Override
            public Pair<CharSequence, Integer> apply(Pair<CharSequence, Integer> a, Pair<CharSequence, Integer> b) {
                if ((Integer)a.right == -1) {
                    return b;
                }
                if ((Integer)b.right != -1) {
                    accumulator.accept(a, ((CharSequence)b.left).subSequence(0, (Integer)b.right));
                }
                return a;
            }
        };
        Function<Pair<CharSequence, Integer>, String> finisher = new Function<Pair<CharSequence, Integer>, String>(){

            @Override
            public String apply(Pair<CharSequence, Integer> a) {
                return a.left == null ? "" : ((CharSequence)a.left).subSequence(0, (Integer)a.right).toString();
            }
        };
        return new CollectorImpl<CharSequence, Pair<CharSequence, Integer>, String>(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static Collector<CharSequence, ?, String> commonSuffix() {
        Supplier<Pair<CharSequence, Integer>> supplier = new Supplier<Pair<CharSequence, Integer>>(){

            @Override
            public Pair<CharSequence, Integer> get() {
                return Pair.of(null, -1);
            }
        };
        final BiConsumer<Pair<CharSequence, Integer>, CharSequence> accumulator = new BiConsumer<Pair<CharSequence, Integer>, CharSequence>(){

            @Override
            public void accept(Pair<CharSequence, Integer> a, CharSequence t) {
                if ((Integer)a.right == -1) {
                    a.left = t;
                    a.right = t.length();
                } else if ((Integer)a.right > 0) {
                    int alen = ((CharSequence)a.left).length();
                    int blen = t.length();
                    if (blen < (Integer)a.right) {
                        a.right = blen;
                    }
                    int to = (Integer)a.right;
                    for (int i = 0; i < to; ++i) {
                        if (((CharSequence)a.left).charAt(alen - 1 - i) == t.charAt(blen - 1 - i)) continue;
                        if (i > 0 && Character.isLowSurrogate(t.charAt(blen - i)) && (Character.isHighSurrogate(t.charAt(blen - 1 - i)) || Character.isHighSurrogate(((CharSequence)a.left).charAt(alen - 1 - i)))) {
                            --i;
                        }
                        a.right = i;
                        break;
                    }
                }
            }
        };
        BinaryOperator<Pair<CharSequence, Integer>> combiner = new BinaryOperator<Pair<CharSequence, Integer>>(){

            @Override
            public Pair<CharSequence, Integer> apply(Pair<CharSequence, Integer> a, Pair<CharSequence, Integer> b) {
                if ((Integer)a.right == -1) {
                    return b;
                }
                if ((Integer)b.right != -1) {
                    accumulator.accept(a, ((CharSequence)b.left).subSequence(((CharSequence)b.left).length() - (Integer)b.right, ((CharSequence)b.left).length()));
                }
                return a;
            }
        };
        Function<Pair<CharSequence, Integer>, String> finisher = new Function<Pair<CharSequence, Integer>, String>(){

            @Override
            public String apply(Pair<CharSequence, Integer> a) {
                return a.left == null ? "" : ((CharSequence)a.left).subSequence(((CharSequence)a.left).length() - (Integer)a.right, ((CharSequence)a.left).length()).toString();
            }
        };
        return new CollectorImpl<CharSequence, Pair<CharSequence, Integer>, String>(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T, K> Collector<T, ?, Map<K, List<T>>> groupingBy(Function<? super T, ? extends K> keyMapper) {
        Collector<T, ?, List<T>> downstream = Collectors.toList();
        return Collectors.groupingBy(keyMapper, downstream);
    }

    public static <T, K, M extends Map<K, List<T>>> Collector<T, ?, M> groupingBy(Function<? super T, ? extends K> keyMapper, Supplier<? extends M> mapFactory) {
        Collector<T, ?, List<T>> downstream = Collectors.toList();
        return Collectors.groupingBy(keyMapper, downstream, mapFactory);
    }

    public static <T, K, A, D> Collector<T, ?, Map<K, D>> groupingBy(Function<? super T, ? extends K> keyMapper, Collector<? super T, A, D> downstream) {
        Supplier mapFactory = Fn.Suppliers.ofMap();
        return Collectors.groupingBy(keyMapper, downstream, mapFactory);
    }

    public static <T, K, A, D, M extends Map<K, D>> Collector<T, ?, M> groupingBy(final Function<? super T, ? extends K> keyMapper, Collector<? super T, A, D> downstream, Supplier<? extends M> mapFactory) {
        final Supplier<A> downstreamSupplier = downstream.supplier();
        final BiConsumer<A, ? super T> downstreamAccumulator = downstream.accumulator();
        final Function mappingFunction = new Function<K, A>(){

            @Override
            public A apply(K k) {
                return downstreamSupplier.get();
            }
        };
        BiConsumer accumulator = new BiConsumer<Map<K, A>, T>(){

            @Override
            public void accept(Map<K, A> m, T t) {
                Object key = N.checkArgNotNull(keyMapper.apply(t), "element cannot be mapped to a null key");
                Object container = Collectors.computeIfAbsent(m, key, mappingFunction);
                downstreamAccumulator.accept(container, t);
            }
        };
        BinaryOperator<M> combiner = Collectors.mapMerger(downstream.combiner());
        Supplier<? extends M> mangledFactory = mapFactory;
        final Function<A, D> downstreamFinisher = downstream.finisher();
        final BiFunction function = new BiFunction<K, A, A>(){

            @Override
            public A apply(K k, A v) {
                return downstreamFinisher.apply(v);
            }
        };
        Function finisher = new Function<Map<K, A>, M>(){

            @Override
            public M apply(Map<K, A> intermediate) {
                Collectors.replaceAll(intermediate, function);
                Map castResult = intermediate;
                return castResult;
            }
        };
        return new CollectorImpl(mangledFactory, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T, K> Collector<T, ?, ConcurrentMap<K, List<T>>> groupingByConcurrent(Function<? super T, ? extends K> keyMapper) {
        Collector<T, ?, List<T>> downstream = Collectors.toList();
        return Collectors.groupingByConcurrent(keyMapper, downstream);
    }

    public static <T, K, M extends ConcurrentMap<K, List<T>>> Collector<T, ?, M> groupingByConcurrent(Function<? super T, ? extends K> keyMapper, Supplier<? extends M> mapFactory) {
        Collector<T, ?, List<T>> downstream = Collectors.toList();
        return Collectors.groupingByConcurrent(keyMapper, downstream, mapFactory);
    }

    public static <T, K, A, D> Collector<T, ?, ConcurrentMap<K, D>> groupingByConcurrent(Function<? super T, ? extends K> keyMapper, Collector<? super T, A, D> downstream) {
        Supplier mapFactory = Fn.Suppliers.ofConcurrentMap();
        return Collectors.groupingByConcurrent(keyMapper, downstream, mapFactory);
    }

    public static <T, K, A, D, M extends ConcurrentMap<K, D>> Collector<T, ?, M> groupingByConcurrent(final Function<? super T, ? extends K> keyMapper, Collector<? super T, A, D> downstream, Supplier<? extends M> mapFactory) {
        final Supplier<A> downstreamSupplier = downstream.supplier();
        final BiConsumer<A, ? super T> downstreamAccumulator = downstream.accumulator();
        final Function mappingFunction = new Function<K, A>(){

            @Override
            public A apply(K k) {
                return downstreamSupplier.get();
            }
        };
        BiConsumer accumulator = new BiConsumer<ConcurrentMap<K, A>, T>(){

            @Override
            public void accept(ConcurrentMap<K, A> m, T t) {
                Object key = N.checkArgNotNull(keyMapper.apply(t), "element cannot be mapped to a null key");
                Object container = Collectors.computeIfAbsent(m, key, mappingFunction);
                downstreamAccumulator.accept(container, t);
            }
        };
        BinaryOperator<M> combiner = Collectors.mapMerger(downstream.combiner());
        Supplier<? extends M> mangledFactory = mapFactory;
        if (downstream.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return new CollectorImpl(mangledFactory, accumulator, combiner, CH_UNORDERED_ID);
        }
        final Function<A, D> downstreamFinisher = downstream.finisher();
        final BiFunction function = new BiFunction<K, A, A>(){

            @Override
            public A apply(K k, A v) {
                return downstreamFinisher.apply(v);
            }
        };
        Function finisher = new Function<ConcurrentMap<K, A>, M>(){

            @Override
            public M apply(ConcurrentMap<K, A> intermediate) {
                Collectors.replaceAll(intermediate, function);
                ConcurrentMap castResult = intermediate;
                return castResult;
            }
        };
        return new CollectorImpl(mangledFactory, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T> Collector<T, ?, Map<Boolean, List<T>>> partitioningBy(Predicate<? super T> predicate) {
        Collector<T, ?, List<T>> downstream = Collectors.toList();
        return Collectors.partitioningBy(predicate, downstream);
    }

    public static <T, D, A> Collector<T, ?, Map<Boolean, D>> partitioningBy(final Predicate<? super T> predicate, final Collector<? super T, A, D> downstream) {
        Supplier supplier = new Supplier<Map<Boolean, A>>(){

            @Override
            public Map<Boolean, A> get() {
                HashMap map = new HashMap(2);
                map.put(true, downstream.supplier().get());
                map.put(false, downstream.supplier().get());
                return map;
            }
        };
        final BiConsumer<A, ? super T> downstreamAccumulator = downstream.accumulator();
        BiConsumer accumulator = new BiConsumer<Map<Boolean, A>, T>(){

            @Override
            public void accept(Map<Boolean, A> a, T t) {
                downstreamAccumulator.accept(predicate.test(t) ? a.get(Boolean.TRUE) : a.get(Boolean.FALSE), t);
            }
        };
        final BinaryOperator<A> op = downstream.combiner();
        BinaryOperator combiner = new BinaryOperator<Map<Boolean, A>>(){

            @Override
            public Map<Boolean, A> apply(Map<Boolean, A> a, Map<Boolean, A> b) {
                a.put(Boolean.TRUE, op.apply(a.get(Boolean.TRUE), b.get(Boolean.TRUE)));
                a.put(Boolean.FALSE, op.apply(a.get(Boolean.FALSE), b.get(Boolean.FALSE)));
                return a;
            }
        };
        Function finisher = new Function<Map<Boolean, A>, Map<Boolean, D>>(){

            @Override
            public Map<Boolean, D> apply(Map<Boolean, A> a) {
                Map result = a;
                result.put(Boolean.TRUE, downstream.finisher().apply(a.get(Boolean.TRUE)));
                result.put(Boolean.FALSE, downstream.finisher().apply(a.get(Boolean.FALSE)));
                return result;
            }
        };
        return new CollectorImpl(supplier, accumulator, combiner, finisher, CH_UNORDERED_NOID);
    }

    public static <T, K> Collector<T, ?, Map<K, Long>> countingBy(Function<? super T, ? extends K> keyMapper) {
        return Collectors.countingBy(keyMapper, Fn.Suppliers.ofMap());
    }

    public static <T, K, M extends Map<K, Long>> Collector<T, ?, M> countingBy(Function<? super T, ? extends K> keyMapper, Supplier<? extends M> mapFactory) {
        Collector<T, ?, Long> downstream = Collectors.counting();
        return Collectors.groupingBy(keyMapper, downstream, mapFactory);
    }

    public static <T, K> Collector<T, ?, Map<K, Integer>> countingIntBy(Function<? super T, ? extends K> keyMapper) {
        return Collectors.countingIntBy(keyMapper, Fn.Suppliers.ofMap());
    }

    public static <T, K, M extends Map<K, Integer>> Collector<T, ?, M> countingIntBy(Function<? super T, ? extends K> keyMapper, Supplier<? extends M> mapFactory) {
        Collector<T, ?, Integer> downstream = Collectors.countingInt();
        return Collectors.groupingBy(keyMapper, downstream, mapFactory);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> toMap() {
        Function keyMapper = Fn.key();
        Function valueMapper = Fn.value();
        return Collectors.toMap(keyMapper, valueMapper);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> toMap(BinaryOperator<V> mergeFunction) {
        Function keyMapper = Fn.key();
        Function valueMapper = Fn.value();
        return Collectors.toMap(keyMapper, valueMapper, mergeFunction);
    }

    public static <K, V, M extends Map<K, V>> Collector<Map.Entry<K, V>, ?, M> toMap(Supplier<? extends M> mapFactory) {
        Function keyMapper = Fn.key();
        Function valueMapper = Fn.value();
        return Collectors.toMap(keyMapper, valueMapper, mapFactory);
    }

    public static <K, V, M extends Map<K, V>> Collector<Map.Entry<K, V>, ?, M> toMap(BinaryOperator<V> mergeFunction, Supplier<? extends M> mapFactory) {
        Function keyMapper = Fn.key();
        Function valueMapper = Fn.value();
        return Collectors.toMap(keyMapper, valueMapper, mergeFunction, mapFactory);
    }

    public static <T, K, V> Collector<T, ?, Map<K, V>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        BinaryOperator mergeFunction = Fn.throwingMerger();
        return Collectors.toMap(keyMapper, valueMapper, mergeFunction);
    }

    public static <T, K, V> Collector<T, ?, Map<K, V>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, BinaryOperator<V> mergeFunction) {
        Supplier mapFactory = Fn.Suppliers.ofMap();
        return Collectors.toMap(keyMapper, valueMapper, mergeFunction, mapFactory);
    }

    public static <T, K, V, M extends Map<K, V>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, Supplier<? extends M> mapFactory) {
        BinaryOperator mergeFunction = Fn.throwingMerger();
        return Collectors.toMap(keyMapper, valueMapper, mergeFunction, mapFactory);
    }

    public static <T, K, V, M extends Map<K, V>> Collector<T, ?, M> toMap(final Function<? super T, ? extends K> keyMapper, final Function<? super T, ? extends V> valueMapper, final BinaryOperator<V> mergeFunction, Supplier<? extends M> mapFactory) {
        BiConsumer accumulator = new BiConsumer<M, T>(){

            @Override
            public void accept(M map, T element) {
                Collectors.merge(map, keyMapper.apply(element), valueMapper.apply(element), mergeFunction);
            }
        };
        BinaryOperator<M> combiner = Collectors.mapMerger(mergeFunction);
        return new CollectorImpl(mapFactory, accumulator, combiner, CH_UNORDERED_ID);
    }

    public static <T, K, A, D> Collector<T, ?, Map<K, D>> toMap(Function<? super T, ? extends K> keyMapper, Collector<? super T, A, D> downstream) {
        return Collectors.groupingBy(keyMapper, downstream);
    }

    public static <T, K, A, D, M extends Map<K, D>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Collector<? super T, A, D> downstream, Supplier<? extends M> mapFactory) {
        return Collectors.groupingBy(keyMapper, downstream, mapFactory);
    }

    public static <T, K, V, A, D> Collector<T, ?, Map<K, D>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, Collector<? super V, A, D> downstream) {
        return Collectors.groupingBy(keyMapper, Collectors.mapping(valueMapper, downstream));
    }

    public static <T, K, V, A, D, M extends Map<K, D>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, Collector<? super V, A, D> downstream, Supplier<? extends M> mapFactory) {
        return Collectors.groupingBy(keyMapper, Collectors.mapping(valueMapper, downstream), mapFactory);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, ImmutableMap<K, V>> toImmutableMap() {
        Collector<Map.Entry<K, V>, ?, Map<K, V>> downstream = Collectors.toMap();
        Function<Map<Object, Object>, ImmutableMap<Object, Object>> finisher = ImmutableMap_Finisher;
        return Collectors.collectingAndThen(downstream, finisher);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, ImmutableMap<K, V>> toImmutableMap(BinaryOperator<V> mergeFunction) {
        Collector<Map.Entry<K, V>, ?, Map<K, V>> downstream = Collectors.toMap(mergeFunction);
        Function<Map<Object, Object>, ImmutableMap<Object, Object>> finisher = ImmutableMap_Finisher;
        return Collectors.collectingAndThen(downstream, finisher);
    }

    public static <T, K, V> Collector<T, ?, ImmutableMap<K, V>> toImmutableMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        Collector<? super T, ?, Map<? extends K, ? extends V>> downstream = Collectors.toMap(keyMapper, valueMapper);
        Function<Map<Object, Object>, ImmutableMap<Object, Object>> finisher = ImmutableMap_Finisher;
        return Collectors.collectingAndThen(downstream, finisher);
    }

    public static <T, K, V> Collector<T, ?, ImmutableMap<K, V>> toImmutableMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, BinaryOperator<V> mergeFunction) {
        Collector<? super T, ?, Map<? extends K, ? extends V>> downstream = Collectors.toMap(keyMapper, valueMapper, mergeFunction);
        Function<Map<Object, Object>, ImmutableMap<Object, Object>> finisher = ImmutableMap_Finisher;
        return Collectors.collectingAndThen(downstream, finisher);
    }

    public static <T, K, V> Collector<T, ?, Map<K, V>> toLinkedHashMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        BinaryOperator mergeFunction = Fn.throwingMerger();
        return Collectors.toLinkedHashMap(keyMapper, valueMapper, mergeFunction);
    }

    public static <T, K, V> Collector<T, ?, Map<K, V>> toLinkedHashMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, BinaryOperator<V> mergeFunction) {
        Supplier mapFactory = Fn.Suppliers.ofLinkedHashMap();
        return Collectors.toMap(keyMapper, valueMapper, mergeFunction, mapFactory);
    }

    public static <T, K, V> Collector<T, ?, ConcurrentMap<K, V>> toConcurrentMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        BinaryOperator mergeFunction = Fn.throwingMerger();
        return Collectors.toConcurrentMap(keyMapper, valueMapper, mergeFunction);
    }

    public static <T, K, V, M extends ConcurrentMap<K, V>> Collector<T, ?, M> toConcurrentMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, Supplier<? extends M> mapFactory) {
        BinaryOperator mergeFunction = Fn.throwingMerger();
        return Collectors.toConcurrentMap(keyMapper, valueMapper, mergeFunction, mapFactory);
    }

    public static <T, K, V> Collector<T, ?, ConcurrentMap<K, V>> toConcurrentMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, BinaryOperator<V> mergeFunction) {
        Supplier mapFactory = Fn.Suppliers.ofConcurrentMap();
        return Collectors.toConcurrentMap(keyMapper, valueMapper, mergeFunction, mapFactory);
    }

    public static <T, K, V, M extends ConcurrentMap<K, V>> Collector<T, ?, M> toConcurrentMap(final Function<? super T, ? extends K> keyMapper, final Function<? super T, ? extends V> valueMapper, final BinaryOperator<V> mergeFunction, Supplier<? extends M> mapFactory) {
        BiConsumer accumulator = new BiConsumer<M, T>(){

            @Override
            public void accept(M map, T element) {
                Collectors.merge(map, keyMapper.apply(element), valueMapper.apply(element), mergeFunction);
            }
        };
        BinaryOperator<M> combiner = Collectors.concurrentMapMerger(mergeFunction);
        return new CollectorImpl(mapFactory, accumulator, combiner, CH_UNORDERED_ID);
    }

    public static <T, K, V> Collector<T, ?, BiMap<K, V>> toBiMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        BinaryOperator mergeFunction = Fn.throwingMerger();
        return Collectors.toBiMap(keyMapper, valueMapper, mergeFunction);
    }

    public static <T, K, V> Collector<T, ?, BiMap<K, V>> toBiMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, Supplier<BiMap<K, V>> mapFactory) {
        BinaryOperator mergeFunction = Fn.throwingMerger();
        return Collectors.toBiMap(keyMapper, valueMapper, mergeFunction, mapFactory);
    }

    public static <T, K, V> Collector<T, ?, BiMap<K, V>> toBiMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, BinaryOperator<V> mergeFunction) {
        Supplier mapFactory = Fn.Suppliers.ofBiMap();
        return Collectors.toBiMap(keyMapper, valueMapper, mergeFunction, mapFactory);
    }

    public static <T, K, V> Collector<T, ?, BiMap<K, V>> toBiMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, BinaryOperator<V> mergeFunction, Supplier<BiMap<K, V>> mapFactory) {
        return Collectors.toMap(keyMapper, valueMapper, mergeFunction, mapFactory);
    }

    public static <K, V> Collector<Map.Entry<? extends K, ? extends V>, ?, ListMultimap<K, V>> toMultimap() {
        Function keyMapper = Fn.key();
        Function valueMapper = Fn.value();
        return Collectors.toMultimap(keyMapper, valueMapper);
    }

    public static <K, V, C extends Collection<V>, M extends Multimap<K, V, C>> Collector<Map.Entry<? extends K, ? extends V>, ?, M> toMultimap(Supplier<? extends M> mapFactory) {
        Function keyMapper = Fn.key();
        Function valueMapper = Fn.value();
        return Collectors.toMultimap(keyMapper, valueMapper, mapFactory);
    }

    public static <T, K> Collector<T, ?, ListMultimap<K, T>> toMultimap(Function<? super T, ? extends K> keyMapper) {
        Function valueMapper = Fn.identity();
        return Collectors.toMultimap(keyMapper, valueMapper);
    }

    public static <T, K, C extends Collection<T>, M extends Multimap<K, T, C>> Collector<T, ?, M> toMultimap(Function<? super T, ? extends K> keyMapper, Supplier<? extends M> mapFactory) {
        Function valueMapper = Fn.identity();
        return Collectors.toMultimap(keyMapper, valueMapper, mapFactory);
    }

    public static <T, K, V> Collector<T, ?, ListMultimap<K, V>> toMultimap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        Supplier mapFactory = Fn.Suppliers.ofListMultimap();
        return Collectors.toMultimap(keyMapper, valueMapper, mapFactory);
    }

    public static <T, K, V, C extends Collection<V>, M extends Multimap<K, V, C>> Collector<T, ?, M> toMultimap(final Function<? super T, ? extends K> keyMapper, final Function<? super T, ? extends V> valueMapper, Supplier<? extends M> mapFactory) {
        BiConsumer accumulator = new BiConsumer<M, T>(){

            @Override
            public void accept(M map, T element) {
                ((Multimap)map).put(keyMapper.apply(element), valueMapper.apply(element));
            }
        };
        BinaryOperator<M> combiner = Collectors.multimapMerger();
        return new CollectorImpl(mapFactory, accumulator, combiner, CH_UNORDERED_ID);
    }

    public static <T> Collector<T, ?, DataSet> toDataSet() {
        return Collectors.toDataSet(null);
    }

    public static <T> Collector<T, ?, DataSet> toDataSet(final List<String> columnNames) {
        Collector<T, ?, List<T>> collector = Collectors.toList();
        Function finisher = new Function<List<T>, DataSet>(){

            @Override
            public DataSet apply(List<T> t) {
                return N.newDataSet(columnNames, t);
            }
        };
        return new CollectorImpl(collector.supplier(), collector.accumulator(), collector.combiner(), finisher, CH_NOID);
    }

    public static <T, A1, A2, R1, R2> Collector<T, Tuple.Tuple2<A1, A2>, Tuple.Tuple2<R1, R2>> combine(Collector<? super T, A1, R1> collector1, Collector<? super T, A2, R2> collector2) {
        Set<Collector.Characteristics> characteristics;
        final Supplier<A1> supplier1 = collector1.supplier();
        final Supplier<A2> supplier2 = collector2.supplier();
        final BiConsumer<A1, ? super T> accumulator1 = collector1.accumulator();
        final BiConsumer<A2, ? super T> accumulator2 = collector2.accumulator();
        final BinaryOperator<A1> combiner1 = collector1.combiner();
        final BinaryOperator<A2> combiner2 = collector2.combiner();
        final Function<A1, R1> finisher1 = collector1.finisher();
        final Function<A2, R2> finisher2 = collector2.finisher();
        Supplier supplier = new Supplier<Tuple.Tuple2<A1, A2>>(){

            @Override
            public Tuple.Tuple2<A1, A2> get() {
                return Tuple.of(supplier1.get(), supplier2.get());
            }
        };
        BiConsumer accumulator = new BiConsumer<Tuple.Tuple2<A1, A2>, T>(){

            @Override
            public void accept(Tuple.Tuple2<A1, A2> acct, T e) {
                accumulator1.accept(acct._1, e);
                accumulator2.accept(acct._2, e);
            }
        };
        BinaryOperator combiner = new BinaryOperator<Tuple.Tuple2<A1, A2>>(){

            @Override
            public Tuple.Tuple2<A1, A2> apply(Tuple.Tuple2<A1, A2> t, Tuple.Tuple2<A1, A2> u2) {
                return Tuple.of(combiner1.apply(t._1, u2._1), combiner2.apply(t._2, u2._2));
            }
        };
        List<Collector.Characteristics> common = N.intersection(collector1.characteristics(), collector2.characteristics());
        Set<Collector.Characteristics> set = characteristics = N.isNullOrEmpty(common) ? CH_NOID : N.newHashSet(common);
        if (characteristics.contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return new CollectorImpl(supplier, accumulator, combiner, characteristics);
        }
        Function finisher = new Function<Tuple.Tuple2<A1, A2>, Tuple.Tuple2<R1, R2>>(){

            @Override
            public Tuple.Tuple2<R1, R2> apply(Tuple.Tuple2<A1, A2> t) {
                return Tuple.of(finisher1.apply(t._1), finisher2.apply(t._2));
            }
        };
        return new CollectorImpl(supplier, accumulator, combiner, finisher, characteristics);
    }

    public static <T, A1, A2, R1, R2, R> Collector<T, Tuple.Tuple2<A1, A2>, R> combine(Collector<? super T, A1, R1> collector1, Collector<? super T, A2, R2> collector2, final BiFunction<? super R1, ? super R2, R> finisher) {
        final Supplier<A1> supplier1 = collector1.supplier();
        final Supplier<A2> supplier2 = collector2.supplier();
        final BiConsumer<A1, ? super T> accumulator1 = collector1.accumulator();
        final BiConsumer<A2, ? super T> accumulator2 = collector2.accumulator();
        final BinaryOperator<A1> combiner1 = collector1.combiner();
        final BinaryOperator<A2> combiner2 = collector2.combiner();
        final Function<A1, R1> finisher1 = collector1.finisher();
        final Function<A2, R2> finisher2 = collector2.finisher();
        Supplier supplier = new Supplier<Tuple.Tuple2<A1, A2>>(){

            @Override
            public Tuple.Tuple2<A1, A2> get() {
                return Tuple.of(supplier1.get(), supplier2.get());
            }
        };
        BiConsumer accumulator = new BiConsumer<Tuple.Tuple2<A1, A2>, T>(){

            @Override
            public void accept(Tuple.Tuple2<A1, A2> acct, T e) {
                accumulator1.accept(acct._1, e);
                accumulator2.accept(acct._2, e);
            }
        };
        BinaryOperator combiner = new BinaryOperator<Tuple.Tuple2<A1, A2>>(){

            @Override
            public Tuple.Tuple2<A1, A2> apply(Tuple.Tuple2<A1, A2> t, Tuple.Tuple2<A1, A2> u2) {
                return Tuple.of(combiner1.apply(t._1, u2._1), combiner2.apply(t._2, u2._2));
            }
        };
        List<Collector.Characteristics> common = N.intersection(collector1.characteristics(), collector2.characteristics());
        common.remove((Object)Collector.Characteristics.IDENTITY_FINISH);
        Set<Collector.Characteristics> characteristics = N.isNullOrEmpty(common) ? CH_NOID : N.newHashSet(common);
        Function finalFinisher = new Function<Tuple.Tuple2<A1, A2>, R>(){

            @Override
            public R apply(Tuple.Tuple2<A1, A2> t) {
                return finisher.apply(finisher1.apply(t._1), finisher2.apply(t._2));
            }
        };
        return new CollectorImpl(supplier, accumulator, combiner, finalFinisher, characteristics);
    }

    public static <T, A1, A2, A3, R1, R2, R3> Collector<T, Tuple.Tuple3<A1, A2, A3>, Tuple.Tuple3<R1, R2, R3>> combine(Collector<? super T, A1, R1> collector1, Collector<? super T, A2, R2> collector2, Collector<? super T, A3, R3> collector3) {
        Set<Collector.Characteristics> characteristics;
        final Supplier<A1> supplier1 = collector1.supplier();
        final Supplier<A2> supplier2 = collector2.supplier();
        final Supplier<A3> supplier3 = collector3.supplier();
        final BiConsumer<A1, ? super T> accumulator1 = collector1.accumulator();
        final BiConsumer<A2, ? super T> accumulator2 = collector2.accumulator();
        final BiConsumer<A3, ? super T> accumulator3 = collector3.accumulator();
        final BinaryOperator<A1> combiner1 = collector1.combiner();
        final BinaryOperator<A2> combiner2 = collector2.combiner();
        final BinaryOperator<A3> combiner3 = collector3.combiner();
        final Function<A1, R1> finisher1 = collector1.finisher();
        final Function<A2, R2> finisher2 = collector2.finisher();
        final Function<A3, R3> finisher3 = collector3.finisher();
        Supplier supplier = new Supplier<Tuple.Tuple3<A1, A2, A3>>(){

            @Override
            public Tuple.Tuple3<A1, A2, A3> get() {
                return Tuple.of(supplier1.get(), supplier2.get(), supplier3.get());
            }
        };
        BiConsumer accumulator = new BiConsumer<Tuple.Tuple3<A1, A2, A3>, T>(){

            @Override
            public void accept(Tuple.Tuple3<A1, A2, A3> acct, T e) {
                accumulator1.accept(acct._1, e);
                accumulator2.accept(acct._2, e);
                accumulator3.accept(acct._3, e);
            }
        };
        BinaryOperator combiner = new BinaryOperator<Tuple.Tuple3<A1, A2, A3>>(){

            @Override
            public Tuple.Tuple3<A1, A2, A3> apply(Tuple.Tuple3<A1, A2, A3> t, Tuple.Tuple3<A1, A2, A3> u2) {
                return Tuple.of(combiner1.apply(t._1, u2._1), combiner2.apply(t._2, u2._2), combiner3.apply(t._3, u2._3));
            }
        };
        List<Collector.Characteristics> common = N.intersection(collector1.characteristics(), collector2.characteristics());
        if (N.notNullOrEmpty(common)) {
            common = N.intersection(common, collector3.characteristics());
        }
        Set<Collector.Characteristics> set = characteristics = N.isNullOrEmpty(common) ? CH_NOID : N.newHashSet(common);
        if (characteristics.contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return new CollectorImpl(supplier, accumulator, combiner, characteristics);
        }
        Function finisher = new Function<Tuple.Tuple3<A1, A2, A3>, Tuple.Tuple3<R1, R2, R3>>(){

            @Override
            public Tuple.Tuple3<R1, R2, R3> apply(Tuple.Tuple3<A1, A2, A3> t) {
                return Tuple.of(finisher1.apply(t._1), finisher2.apply(t._2), finisher3.apply(t._3));
            }
        };
        return new CollectorImpl(supplier, accumulator, combiner, finisher, characteristics);
    }

    public static <T, A1, A2, A3, R1, R2, R3, R> Collector<T, Tuple.Tuple3<A1, A2, A3>, R> combine(Collector<? super T, A1, R1> collector1, Collector<? super T, A2, R2> collector2, Collector<? super T, A3, R3> collector3, final TriFunction<? super R1, ? super R2, ? super R3, R> finisher) {
        final Supplier<A1> supplier1 = collector1.supplier();
        final Supplier<A2> supplier2 = collector2.supplier();
        final Supplier<A3> supplier3 = collector3.supplier();
        final BiConsumer<A1, ? super T> accumulator1 = collector1.accumulator();
        final BiConsumer<A2, ? super T> accumulator2 = collector2.accumulator();
        final BiConsumer<A3, ? super T> accumulator3 = collector3.accumulator();
        final BinaryOperator<A1> combiner1 = collector1.combiner();
        final BinaryOperator<A2> combiner2 = collector2.combiner();
        final BinaryOperator<A3> combiner3 = collector3.combiner();
        final Function<A1, R1> finisher1 = collector1.finisher();
        final Function<A2, R2> finisher2 = collector2.finisher();
        final Function<A3, R3> finisher3 = collector3.finisher();
        Supplier supplier = new Supplier<Tuple.Tuple3<A1, A2, A3>>(){

            @Override
            public Tuple.Tuple3<A1, A2, A3> get() {
                return Tuple.of(supplier1.get(), supplier2.get(), supplier3.get());
            }
        };
        BiConsumer accumulator = new BiConsumer<Tuple.Tuple3<A1, A2, A3>, T>(){

            @Override
            public void accept(Tuple.Tuple3<A1, A2, A3> acct, T e) {
                accumulator1.accept(acct._1, e);
                accumulator2.accept(acct._2, e);
                accumulator3.accept(acct._3, e);
            }
        };
        BinaryOperator combiner = new BinaryOperator<Tuple.Tuple3<A1, A2, A3>>(){

            @Override
            public Tuple.Tuple3<A1, A2, A3> apply(Tuple.Tuple3<A1, A2, A3> t, Tuple.Tuple3<A1, A2, A3> u2) {
                return Tuple.of(combiner1.apply(t._1, u2._1), combiner2.apply(t._2, u2._2), combiner3.apply(t._3, u2._3));
            }
        };
        List<Collector.Characteristics> common = N.intersection(collector1.characteristics(), collector2.characteristics());
        if (N.notNullOrEmpty(common)) {
            common = N.intersection(common, collector3.characteristics());
        }
        common.remove((Object)Collector.Characteristics.IDENTITY_FINISH);
        Set<Collector.Characteristics> characteristics = N.isNullOrEmpty(common) ? CH_NOID : N.newHashSet(common);
        Function finalFinisher = new Function<Tuple.Tuple3<A1, A2, A3>, R>(){

            @Override
            public R apply(Tuple.Tuple3<A1, A2, A3> t) {
                return finisher.apply(finisher1.apply(t._1), finisher2.apply(t._2), finisher3.apply(t._3));
            }
        };
        return new CollectorImpl(supplier, accumulator, combiner, finalFinisher, characteristics);
    }

    public static <T, A1, A2, A3, A4, R1, R2, R3, R4> Collector<T, Tuple.Tuple4<A1, A2, A3, A4>, Tuple.Tuple4<R1, R2, R3, R4>> combine(Collector<? super T, A1, R1> collector1, Collector<? super T, A2, R2> collector2, Collector<? super T, A3, R3> collector3, Collector<? super T, A4, R4> collector4) {
        List<Collector<? super T, A4, R4>> collectors = N.asList(collector1, collector2, collector3, collector4);
        Function func = new Function<List<?>, Tuple.Tuple4<A1, A2, A3, A4>>(){

            @Override
            public Tuple.Tuple4<A1, A2, A3, A4> apply(List<?> t) {
                return (Tuple.Tuple4)Tuple.Tuple4.from(t);
            }
        };
        return Collectors.collectingAndThen(Collectors.combine(collectors), func);
    }

    public static <T, A1, A2, A3, A4, A5, R1, R2, R3, R4, R5> Collector<T, Tuple.Tuple5<A1, A2, A3, A4, A5>, Tuple.Tuple5<R1, R2, R3, R4, R5>> combine(Collector<? super T, A1, R1> collector1, Collector<? super T, A2, R2> collector2, Collector<? super T, A3, R3> collector3, Collector<? super T, A4, R4> collector4, Collector<? super T, A5, R5> collector5) {
        List<Collector<? super T, A5, R5>> collectors = N.asList(collector1, collector2, collector3, collector4, collector5);
        Function func = new Function<List<?>, Tuple.Tuple5<A1, A2, A3, A4, A5>>(){

            @Override
            public Tuple.Tuple5<A1, A2, A3, A4, A5> apply(List<?> t) {
                return (Tuple.Tuple5)Tuple.Tuple5.from(t);
            }
        };
        return Collectors.collectingAndThen(Collectors.combine(collectors), func);
    }

    public static <T> Collector<T, ?, List<?>> combine(List<? extends Collector<? super T, ?, ?>> collectors) {
        Set<Collector.Characteristics> characteristics;
        N.checkArgument(N.notNullOrEmpty(collectors), "The specified 'collectors' can't be null or empty");
        final int len = collectors.size();
        final Collector[] cs = collectors.toArray(new Collector[len]);
        Supplier<List<Object>> supplier = new Supplier<List<Object>>(){

            @Override
            public List<Object> get() {
                ArrayList<Object> res = new ArrayList<Object>(len);
                for (int i = 0; i < len; ++i) {
                    res.add(cs[i].supplier().get());
                }
                return res;
            }
        };
        BiConsumer accumulator = new BiConsumer<List<Object>, T>(){

            @Override
            public void accept(List<Object> acct, T e) {
                for (int i = 0; i < len; ++i) {
                    cs[i].accumulator().accept(acct.get(i), e);
                }
            }
        };
        BinaryOperator<List<Object>> combiner = new BinaryOperator<List<Object>>(){

            @Override
            public List<Object> apply(List<Object> t, List<Object> u2) {
                for (int i = 0; i < len; ++i) {
                    t.set(i, cs[i].combiner().apply(t.get(i), u2.get(i)));
                }
                return t;
            }
        };
        Collection<Collector.Characteristics> common = cs[0].characteristics();
        for (int i = 1; i < len && N.notNullOrEmpty(common); ++i) {
            common = N.intersection(common, cs[i].characteristics());
        }
        Set<Collector.Characteristics> set = characteristics = N.isNullOrEmpty(common) ? CH_NOID : N.newHashSet(common);
        if (characteristics.contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return new CollectorImpl(supplier, accumulator, combiner, characteristics);
        }
        Function<List<Object>, List<Object>> finisher = new Function<List<Object>, List<Object>>(){

            @Override
            public List<Object> apply(List<Object> t) {
                for (int i = 0; i < len; ++i) {
                    t.set(i, cs[i].finisher().apply(t.get(i)));
                }
                return t;
            }
        };
        return new CollectorImpl(supplier, accumulator, combiner, finisher, characteristics);
    }

    static <K, V> void replaceAll(Map<K, V> map, BiFunction<? super K, ? super V, ? extends V> function) {
        N.checkArgNotNull(function);
        try {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                entry.setValue(function.apply(entry.getKey(), entry.getValue()));
            }
        }
        catch (IllegalStateException ise) {
            throw new ConcurrentModificationException(ise);
        }
    }

    private static <K, V> V computeIfAbsent(Map<K, V> map, K key, Function<? super K, ? extends V> mappingFunction) {
        N.checkArgNotNull(mappingFunction);
        V v = null;
        V v2 = map.get(key);
        v = v2;
        if (v2 == null) {
            V newValue = null;
            V v3 = mappingFunction.apply(key);
            newValue = v3;
            if (v3 != null) {
                map.put(key, newValue);
                return newValue;
            }
        }
        return v;
    }

    private static <K, V, M extends Map<K, V>> BinaryOperator<M> mapMerger(final BinaryOperator<V> mergeFunction) {
        N.checkArgNotNull(mergeFunction);
        return new BinaryOperator<M>(){

            @Override
            public M apply(M m1, M m2) {
                for (Map.Entry e : m2.entrySet()) {
                    Object oldValue = m1.get(e.getKey());
                    if (oldValue == null && !m1.containsKey(e.getKey())) {
                        m1.put(e.getKey(), e.getValue());
                        continue;
                    }
                    m1.put(e.getKey(), mergeFunction.apply(oldValue, e.getValue()));
                }
                return m1;
            }
        };
    }

    private static <K, V, M extends ConcurrentMap<K, V>> BinaryOperator<M> concurrentMapMerger(final BinaryOperator<V> mergeFunction) {
        N.checkArgNotNull(mergeFunction);
        return new BinaryOperator<M>(){

            @Override
            public M apply(M m1, M m2) {
                for (Map.Entry e : m2.entrySet()) {
                    Object oldValue = m1.get(e.getKey());
                    if (oldValue == null && !m1.containsKey(e.getKey())) {
                        m1.put(e.getKey(), e.getValue());
                        continue;
                    }
                    m1.put(e.getKey(), mergeFunction.apply(oldValue, e.getValue()));
                }
                return m1;
            }
        };
    }

    private static <K, U, V extends Collection<U>, M extends Multimap<K, U, V>> BinaryOperator<M> multimapMerger() {
        return new BinaryOperator<M>(){

            @Override
            public M apply(M m1, M m2) {
                Object key = null;
                Collection value = null;
                for (Map.Entry e : ((Multimap)m2).entrySet()) {
                    N.checkArgNotNull(e.getValue());
                    key = e.getKey();
                    value = (Collection)e.getValue();
                    if (!N.notNullOrEmpty(value)) continue;
                    Object oldValue = ((Multimap)m1).get(key);
                    if (oldValue == null) {
                        ((Multimap)m1).putAll(key, value);
                        continue;
                    }
                    oldValue.addAll(value);
                }
                return m1;
            }
        };
    }

    static <K, V> void merge(Map<K, V> map, K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        N.checkArgNotNull(remappingFunction);
        V oldValue = map.get(key);
        if (oldValue == null && !map.containsKey(key)) {
            map.put(key, value);
        } else {
            map.put(key, remappingFunction.apply(oldValue, value));
        }
    }

    public static abstract class MoreCollectors
    extends Collectors {
        protected MoreCollectors() {
        }
    }

    private static class MappingOptHolder<T, U>
    implements Consumer<T> {
        Function<? super T, ? extends U> mapper;
        BinaryOperator<U> op;
        U value = null;
        boolean present = false;

        MappingOptHolder(Function<? super T, ? extends U> mapper, BinaryOperator<U> op) {
            this.mapper = mapper;
            this.op = op;
        }

        @Override
        public void accept(T t) {
            if (this.present) {
                this.value = this.op.apply(this.value, this.mapper.apply(t));
            } else {
                this.value = this.mapper.apply(t);
                this.present = true;
            }
        }
    }

    private static class OptHolder<T>
    implements Consumer<T> {
        BinaryOperator<T> op = null;
        T value = null;
        boolean present = false;

        OptHolder(BinaryOperator<T> op) {
            this.op = op;
        }

        @Override
        public void accept(T t) {
            if (this.present) {
                this.value = this.op.apply(this.value, t);
            } else {
                this.value = t;
                this.present = true;
            }
        }
    }

    static class CollectorImpl<T, A, R>
    implements Collector<T, A, R> {
        private static final Function<Object, Object> IDENTITY_FINISHER = new Function<Object, Object>(){

            @Override
            public Object apply(Object t) {
                return t;
            }
        };
        private final Supplier<A> supplier;
        private final BiConsumer<A, T> accumulator;
        private final BinaryOperator<A> combiner;
        private final Function<A, R> finisher;
        private final Set<Collector.Characteristics> characteristics;

        CollectorImpl(Supplier<? extends A> supplier, BiConsumer<? super A, ? super T> accumulator, BinaryOperator<A> combiner, Set<Collector.Characteristics> characteristics) {
            this(supplier, accumulator, combiner, IDENTITY_FINISHER, characteristics);
        }

        CollectorImpl(Supplier<? extends A> supplier, BiConsumer<? super A, ? super T> accumulator, BinaryOperator<A> combiner, Function<? super A, ? extends R> finisher, Set<Collector.Characteristics> characteristics) {
            this.supplier = supplier;
            this.accumulator = accumulator;
            this.combiner = combiner;
            this.finisher = finisher;
            this.characteristics = characteristics == null ? N.emptySet() : characteristics;
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public BinaryOperator<A> combiner() {
            return this.combiner;
        }

        @Override
        public Function<A, R> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.characteristics;
        }
    }
}

