/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.ImmutableList;
import com.landawn.abacus.util.ImmutableSet;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Try;
import com.landawn.abacus.util.function.Supplier;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class u {
    private u() {
    }

    static abstract class Reference<T, H extends Reference<T, H>> {
        private T value;

        protected Reference() {
            this(null);
        }

        protected Reference(T value) {
            this.value = value;
        }

        public T value() {
            return this.value;
        }

        @Deprecated
        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public T getAndSet(T value) {
            T result = this.value;
            this.value = value;
            return result;
        }

        public T setAndGet(T value) {
            this.value = value;
            return this.value;
        }

        public final <E extends Exception> T getAndUpdate(Try.UnaryOperator<T, E> updateFunction) throws E {
            T res = this.value;
            this.value = updateFunction.apply(this.value);
            return res;
        }

        public final <E extends Exception> T updateAndGet(Try.UnaryOperator<T, E> updateFunction) throws E {
            this.value = updateFunction.apply(this.value);
            return this.value;
        }

        public <E extends Exception> boolean setIf(T newValue, Try.Predicate<? super T, E> predicate) throws E {
            if (predicate.test(this.value)) {
                this.value = newValue;
                return true;
            }
            return false;
        }

        public <E extends Exception> boolean setIf(T newValue, Try.BiPredicate<? super T, ? super T, E> predicate) throws E {
            if (predicate.test(this.value, newValue)) {
                this.value = newValue;
                return true;
            }
            return false;
        }

        public boolean isNull() {
            return this.value == null;
        }

        public boolean isNotNull() {
            return this.value != null;
        }

        public <E extends Exception> void ifNotNull(Try.Consumer<? super T, E> action) throws E {
            N.checkArgNotNull(action, "action");
            if (this.isNotNull()) {
                action.accept(this.value);
            }
        }

        public <E extends Exception, E2 extends Exception> void ifNotNullOrElse(Try.Consumer<? super T, E> action, Try.Runnable<E2> emptyAction) throws E, E2 {
            N.checkArgNotNull(action, "action");
            N.checkArgNotNull(emptyAction, "emptyAction");
            if (this.isNotNull()) {
                action.accept(this.value);
            } else {
                emptyAction.run();
            }
        }

        public <E extends Exception> void accept(Try.Consumer<? super T, E> action) throws E {
            action.accept(this.value);
        }

        @Deprecated
        public <E extends Exception> void acceptIfNotNull(Try.Consumer<? super T, E> action) throws E {
            N.checkArgNotNull(action, "action");
            if (this.isNotNull()) {
                action.accept(this.value);
            }
        }

        public <U, E extends Exception> U map(Try.Function<? super T, ? extends U, E> mapper) throws E {
            return mapper.apply(this.value);
        }

        public <U, E extends Exception> Nullable<U> mapIfNotNull(Try.Function<? super T, ? extends U, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isNotNull()) {
                return Nullable.of(mapper.apply(this.value));
            }
            return Nullable.empty();
        }

        public <E extends Exception> Nullable<T> filter(Try.Predicate<? super T, E> predicate) throws E {
            if (predicate.test(this.value)) {
                return Nullable.of(this.value);
            }
            return Nullable.empty();
        }

        public <E extends Exception> Optional<T> filterIfNotNull(Try.Predicate<? super T, E> predicate) throws E {
            N.checkArgNotNull(predicate, "predicate");
            if (this.isNotNull() && predicate.test(this.value)) {
                return Optional.of(this.value);
            }
            return Optional.empty();
        }

        public T orElseIfNull(T other) {
            return this.isNotNull() ? this.value : other;
        }

        public <E extends Exception> T orElseGetIfNull(Try.Supplier<? extends T, E> other) throws E {
            N.checkArgNotNull(other, "other");
            if (this.isNotNull()) {
                return this.value;
            }
            return other.get();
        }

        public <X extends Throwable> T orElseThrowIfNull(Supplier<? extends X> exceptionSupplier) throws X {
            N.checkArgNotNull(exceptionSupplier, "exceptionSupplier");
            if (this.isNotNull()) {
                return this.value;
            }
            throw (Throwable)exceptionSupplier.get();
        }

        public Nullable<T> toNullable() {
            return Nullable.of(this.value);
        }

        public Optional<T> toOptional() {
            return Optional.ofNullable(this.value);
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Reference && N.equals(((Reference)obj).value, this.value);
        }

        public String toString() {
            if (this.value == null) {
                return "Reference[null]";
            }
            return String.format("Reference[%s]", N.toString(this.value));
        }
    }

    public static final class R<T>
    extends Reference<T, R<T>> {
        public R() {
            this(null);
        }

        R(T value) {
            super(value);
        }

        public static <T> R<T> of(T value) {
            return new R<T>(value);
        }
    }

    public static final class Holder<T>
    extends Reference<T, Holder<T>> {
        public Holder() {
            this(null);
        }

        Holder(T value) {
            super(value);
        }

        public static <T> Holder<T> of(T value) {
            return new Holder<T>(value);
        }
    }

    public static final class Nullable<T> {
        private static final Nullable<?> EMPTY = new Nullable();
        private final T value;
        private final boolean isPresent;

        private Nullable() {
            this.value = null;
            this.isPresent = false;
        }

        private Nullable(T value) {
            this.value = value;
            this.isPresent = true;
        }

        public static <T> Nullable<T> empty() {
            return EMPTY;
        }

        public static <T> Nullable<T> of(T value) {
            return new Nullable<T>(value);
        }

        public static <T> Nullable<T> from(Optional<T> optional) {
            if (optional.isPresent()) {
                return new Nullable<T>(optional.get());
            }
            return Nullable.empty();
        }

        public T get() throws NoSuchElementException {
            return this.orElseThrow();
        }

        public boolean isPresent() {
            return this.isPresent;
        }

        public boolean isNotPresent() {
            return !this.isPresent;
        }

        @Deprecated
        public boolean isEmpty() {
            return !this.isPresent;
        }

        public boolean isNull() {
            return this.value == null;
        }

        public boolean isNotNull() {
            return this.value != null;
        }

        public <E extends Exception> Nullable<T> ifPresent(Try.Consumer<? super T, E> action) throws E {
            N.checkArgNotNull(action, "action");
            if (this.isPresent()) {
                action.accept(this.value);
            }
            return this;
        }

        public <E extends Exception, E2 extends Exception> Nullable<T> ifPresentOrElse(Try.Consumer<? super T, E> action, Try.Runnable<E2> emptyAction) throws E, E2 {
            N.checkArgNotNull(action, "action");
            N.checkArgNotNull(emptyAction, "emptyAction");
            if (this.isPresent()) {
                action.accept(this.value);
            } else {
                emptyAction.run();
            }
            return this;
        }

        public <E extends Exception> Nullable<T> ifNotNull(Try.Consumer<? super T, E> action) throws E {
            N.checkArgNotNull(action, "action");
            if (this.isNotNull()) {
                action.accept(this.value);
            }
            return this;
        }

        public <E extends Exception, E2 extends Exception> Nullable<T> ifNotNullOrElse(Try.Consumer<? super T, E> action, Try.Runnable<E2> emptyAction) throws E, E2 {
            N.checkArgNotNull(action, "action");
            N.checkArgNotNull(emptyAction, "emptyAction");
            if (this.isNotNull()) {
                action.accept(this.value);
            } else {
                emptyAction.run();
            }
            return this;
        }

        public <E extends Exception> Nullable<T> filter(Try.Predicate<? super T, E> predicate) throws E {
            N.checkArgNotNull(predicate, "predicate");
            if (this.isPresent() && predicate.test(this.value)) {
                return this;
            }
            return Nullable.empty();
        }

        public <E extends Exception> Optional<T> filterIfNotNull(Try.Predicate<? super T, E> predicate) throws E {
            N.checkArgNotNull(predicate, "predicate");
            if (this.isNotNull() && predicate.test(this.value)) {
                return Optional.of(this.value);
            }
            return Optional.empty();
        }

        public <U, E extends Exception> Nullable<U> map(Try.Function<? super T, ? extends U, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent()) {
                return Nullable.of(mapper.apply(this.value));
            }
            return Nullable.empty();
        }

        public <E extends Exception> OptionalBoolean mapToBoolean(Try.ToBooleanFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent()) {
                return OptionalBoolean.of(mapper.applyAsBoolean(this.value));
            }
            return OptionalBoolean.empty();
        }

        public <E extends Exception> OptionalChar mapToChar(Try.ToCharFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent()) {
                return OptionalChar.of(mapper.applyAsChar(this.value));
            }
            return OptionalChar.empty();
        }

        public <E extends Exception> OptionalByte mapToByte(Try.ToByteFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent()) {
                return OptionalByte.of(mapper.applyAsByte(this.value));
            }
            return OptionalByte.empty();
        }

        public <E extends Exception> OptionalShort mapToShort(Try.ToShortFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent()) {
                return OptionalShort.of(mapper.applyAsShort(this.value));
            }
            return OptionalShort.empty();
        }

        public <E extends Exception> OptionalInt mapToInt(Try.ToIntFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent()) {
                return OptionalInt.of(mapper.applyAsInt(this.value));
            }
            return OptionalInt.empty();
        }

        public <E extends Exception> OptionalLong mapToLong(Try.ToLongFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent()) {
                return OptionalLong.of(mapper.applyAsLong(this.value));
            }
            return OptionalLong.empty();
        }

        public <E extends Exception> OptionalFloat mapToFloat(Try.ToFloatFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent()) {
                return OptionalFloat.of(mapper.applyAsFloat(this.value));
            }
            return OptionalFloat.empty();
        }

        public <E extends Exception> OptionalDouble mapToDouble(Try.ToDoubleFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent()) {
                return OptionalDouble.of(mapper.applyAsDouble(this.value));
            }
            return OptionalDouble.empty();
        }

        public <U, E extends Exception> Nullable<U> mapIfNotNull(Try.Function<? super T, ? extends U, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isNotNull()) {
                return Nullable.of(mapper.apply(this.value));
            }
            return Nullable.empty();
        }

        public <E extends Exception> OptionalBoolean mapToBooleanIfNotNull(Try.ToBooleanFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isNotNull()) {
                return OptionalBoolean.of(mapper.applyAsBoolean(this.value));
            }
            return OptionalBoolean.empty();
        }

        public <E extends Exception> OptionalChar mapToCharIfNotNull(Try.ToCharFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isNotNull()) {
                return OptionalChar.of(mapper.applyAsChar(this.value));
            }
            return OptionalChar.empty();
        }

        public <E extends Exception> OptionalByte mapToByteIfNotNull(Try.ToByteFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isNotNull()) {
                return OptionalByte.of(mapper.applyAsByte(this.value));
            }
            return OptionalByte.empty();
        }

        public <E extends Exception> OptionalShort mapToShortIfNotNull(Try.ToShortFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isNotNull()) {
                return OptionalShort.of(mapper.applyAsShort(this.value));
            }
            return OptionalShort.empty();
        }

        public <E extends Exception> OptionalInt mapToIntIfNotNull(Try.ToIntFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isNotNull()) {
                return OptionalInt.of(mapper.applyAsInt(this.value));
            }
            return OptionalInt.empty();
        }

        public <E extends Exception> OptionalLong mapToLongIfNotNull(Try.ToLongFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isNotNull()) {
                return OptionalLong.of(mapper.applyAsLong(this.value));
            }
            return OptionalLong.empty();
        }

        public <E extends Exception> OptionalFloat mapToFloatIfNotNull(Try.ToFloatFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isNotNull()) {
                return OptionalFloat.of(mapper.applyAsFloat(this.value));
            }
            return OptionalFloat.empty();
        }

        public <E extends Exception> OptionalDouble mapToDoubleIfNotNull(Try.ToDoubleFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isNotNull()) {
                return OptionalDouble.of(mapper.applyAsDouble(this.value));
            }
            return OptionalDouble.empty();
        }

        public <U, E extends Exception> Nullable<U> flatMap(Try.Function<? super T, Nullable<U>, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent()) {
                return Objects.requireNonNull(mapper.apply(this.value));
            }
            return Nullable.empty();
        }

        public <U, E extends Exception> Nullable<U> flatMapIfNotNull(Try.Function<? super T, Nullable<U>, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isNotNull()) {
                return Objects.requireNonNull(mapper.apply(this.value));
            }
            return Nullable.empty();
        }

        public <E extends Exception> Nullable<T> or(Try.Supplier<Nullable<? extends T>, E> supplier) throws E {
            N.checkArgNotNull(supplier, "supplier");
            if (this.isPresent()) {
                return this;
            }
            return Objects.requireNonNull(supplier.get());
        }

        public <E extends Exception> Nullable<T> orIfNull(Try.Supplier<Nullable<? extends T>, E> supplier) throws E {
            N.checkArgNotNull(supplier, "supplier");
            if (this.isNotNull()) {
                return this;
            }
            return Objects.requireNonNull(supplier.get());
        }

        public T orNull() {
            return this.isPresent() ? (T)this.value : null;
        }

        public T orElse(T other) {
            return this.isPresent() ? this.value : other;
        }

        public <E extends Exception> T orElseGet(Try.Supplier<? extends T, E> other) throws E {
            N.checkArgNotNull(other, "other");
            if (this.isPresent()) {
                return this.value;
            }
            return other.get();
        }

        public T orElseThrow() throws NoSuchElementException {
            if (this.isPresent()) {
                return this.value;
            }
            throw new NoSuchElementException("No value is present");
        }

        public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
            N.checkArgNotNull(exceptionSupplier, "exceptionSupplier");
            if (this.isPresent()) {
                return this.value;
            }
            throw (Throwable)exceptionSupplier.get();
        }

        public T orElseIfNull(T other) {
            return this.isNotNull() ? this.value : other;
        }

        public <E extends Exception> T orElseGetIfNull(Try.Supplier<? extends T, E> other) throws E {
            N.checkArgNotNull(other, "other");
            if (this.isNotNull()) {
                return this.value;
            }
            return other.get();
        }

        public T orElseThrowIfNull() throws NoSuchElementException {
            if (this.isNotNull()) {
                return this.value;
            }
            throw new NoSuchElementException("No value is present");
        }

        public <X extends Throwable> T orElseThrowIfNull(Supplier<? extends X> exceptionSupplier) throws X {
            N.checkArgNotNull(exceptionSupplier, "exceptionSupplier");
            if (this.isNotNull()) {
                return this.value;
            }
            throw (Throwable)exceptionSupplier.get();
        }

        public List<T> toList() {
            if (this.isPresent()) {
                return N.asList(this.value);
            }
            return new ArrayList();
        }

        public List<T> toListIfNotNull() {
            if (this.isNotNull()) {
                return N.asList(this.value);
            }
            return new ArrayList();
        }

        public Set<T> toSet() {
            if (this.isPresent()) {
                return N.asSet(this.value);
            }
            return N.newHashSet();
        }

        public Set<T> toSetIfNotNull() {
            if (this.isNotNull()) {
                return N.asSet(this.value);
            }
            return N.newHashSet();
        }

        public ImmutableList<T> toImmutableList() {
            if (this.isPresent()) {
                return ImmutableList.of(this.value);
            }
            return ImmutableList.empty();
        }

        public ImmutableList<T> toImmutableListIfNotNull() {
            if (this.isNotNull()) {
                return ImmutableList.of(this.value);
            }
            return ImmutableList.empty();
        }

        public ImmutableSet<T> toImmutableSet() {
            if (this.isPresent()) {
                return ImmutableSet.of(this.value);
            }
            return ImmutableSet.empty();
        }

        public ImmutableSet<T> toImmutableSetIfNotNull() {
            if (this.isNotNull()) {
                return ImmutableSet.of(this.value);
            }
            return ImmutableSet.empty();
        }

        public Optional<T> toOptional() {
            if (this.value == null) {
                return Optional.empty();
            }
            return Optional.of(this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Nullable) {
                Nullable other = (Nullable)obj;
                return N.equals(this.isPresent, other.isPresent) && N.equals(this.value, other.value);
            }
            return false;
        }

        public int hashCode() {
            return N.hashCode(this.isPresent) * 31 + N.hashCode(this.value);
        }

        public String toString() {
            if (this.value == null) {
                return this.isPresent ? "Nullable[null]" : "Nullable.empty";
            }
            return String.format("Nullable[%s]", N.toString(this.value));
        }
    }

    public static final class OptionalDouble
    implements Comparable<OptionalDouble> {
        private static final OptionalDouble EMPTY = new OptionalDouble();
        private final double value;
        private final boolean isPresent;

        private OptionalDouble() {
            this.value = 0.0;
            this.isPresent = false;
        }

        private OptionalDouble(double value) {
            this.value = value;
            this.isPresent = true;
        }

        public static OptionalDouble empty() {
            return EMPTY;
        }

        public static OptionalDouble of(double value) {
            return new OptionalDouble(value);
        }

        public static OptionalDouble ofNullable(Double val) {
            if (val == null) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of(val);
        }

        public double get() throws NoSuchElementException {
            return this.orElseThrow();
        }

        public boolean isPresent() {
            return this.isPresent;
        }

        public <E extends Exception> OptionalDouble ifPresent(Try.DoubleConsumer<E> action) throws E {
            N.checkArgNotNull(action, "action");
            if (this.isPresent) {
                action.accept(this.value);
            }
            return this;
        }

        public <E extends Exception, E2 extends Exception> OptionalDouble ifPresentOrElse(Try.DoubleConsumer<E> action, Try.Runnable<E2> emptyAction) throws E, E2 {
            N.checkArgNotNull(action, "action");
            N.checkArgNotNull(emptyAction, "emptyAction");
            if (this.isPresent) {
                action.accept(this.value);
            } else {
                emptyAction.run();
            }
            return this;
        }

        public <E extends Exception> OptionalDouble filter(Try.DoublePredicate<E> predicate) throws E {
            N.checkArgNotNull(predicate, "predicate");
            if (this.isPresent && predicate.test(this.value)) {
                return this;
            }
            return OptionalDouble.empty();
        }

        public <E extends Exception> OptionalDouble map(Try.DoubleUnaryOperator<E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return OptionalDouble.of(mapper.applyAsDouble(this.value));
            }
            return OptionalDouble.empty();
        }

        public <E extends Exception> OptionalInt mapToInt(Try.ToIntFunction<Double, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return OptionalInt.of(mapper.applyAsInt(this.value));
            }
            return OptionalInt.empty();
        }

        public <E extends Exception> OptionalLong mapToLong(Try.ToLongFunction<Double, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return OptionalLong.of(mapper.applyAsLong(this.value));
            }
            return OptionalLong.empty();
        }

        public <T, E extends Exception> Nullable<T> mapToObj(Try.DoubleFunction<T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return Nullable.of(mapper.apply(this.value));
            }
            return Nullable.empty();
        }

        public <E extends Exception> OptionalDouble flatMap(Try.DoubleFunction<OptionalDouble, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return Objects.requireNonNull(mapper.apply(this.value));
            }
            return OptionalDouble.empty();
        }

        public <E extends Exception> OptionalDouble or(Try.Supplier<OptionalDouble, E> supplier) throws E {
            if (this.isPresent) {
                return this;
            }
            return Objects.requireNonNull(supplier.get());
        }

        public double orZero() {
            return this.isPresent ? this.value : 0.0;
        }

        public double orElseThrow() throws NoSuchElementException {
            if (this.isPresent) {
                return this.value;
            }
            throw new NoSuchElementException("No value present");
        }

        public double orElse(double other) {
            return this.isPresent ? this.value : other;
        }

        public <E extends Exception> double orElseGet(Try.DoubleSupplier<E> other) throws E {
            N.checkArgNotNull(other, "other");
            if (this.isPresent) {
                return this.value;
            }
            return other.getAsDouble();
        }

        public <X extends Throwable> double orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
            N.checkArgNotNull(exceptionSupplier, "exceptionSupplier");
            if (this.isPresent) {
                return this.value;
            }
            throw (Throwable)exceptionSupplier.get();
        }

        @Override
        public int compareTo(OptionalDouble optional) {
            if (optional == null || !optional.isPresent) {
                return this.isPresent ? 1 : 0;
            }
            if (!this.isPresent) {
                return -1;
            }
            return Double.compare(this.get(), optional.get());
        }

        public Optional<Double> boxed() {
            if (this.isPresent) {
                return Optional.of(this.value);
            }
            return Optional.empty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof OptionalDouble) {
                OptionalDouble other = (OptionalDouble)obj;
                return this.isPresent && other.isPresent ? N.equals(this.value, other.value) : this.isPresent == other.isPresent;
            }
            return false;
        }

        public int hashCode() {
            return N.hashCode(this.isPresent) * 31 + N.hashCode(this.value);
        }

        public String toString() {
            if (this.isPresent) {
                return String.format("OptionalDouble[%s]", this.value);
            }
            return "OptionalDouble.empty";
        }
    }

    public static final class OptionalFloat
    implements Comparable<OptionalFloat> {
        private static final OptionalFloat EMPTY = new OptionalFloat();
        private final float value;
        private final boolean isPresent;

        private OptionalFloat() {
            this.value = 0.0f;
            this.isPresent = false;
        }

        private OptionalFloat(float value) {
            this.value = value;
            this.isPresent = true;
        }

        public static OptionalFloat empty() {
            return EMPTY;
        }

        public static OptionalFloat of(float value) {
            return new OptionalFloat(value);
        }

        public static OptionalFloat ofNullable(Float val) {
            if (val == null) {
                return OptionalFloat.empty();
            }
            return OptionalFloat.of(val.floatValue());
        }

        public float get() throws NoSuchElementException {
            return this.orElseThrow();
        }

        public boolean isPresent() {
            return this.isPresent;
        }

        public <E extends Exception> OptionalFloat ifPresent(Try.FloatConsumer<E> action) throws E {
            N.checkArgNotNull(action, "action");
            if (this.isPresent) {
                action.accept(this.value);
            }
            return this;
        }

        public <E extends Exception, E2 extends Exception> OptionalFloat ifPresentOrElse(Try.FloatConsumer<E> action, Try.Runnable<E2> emptyAction) throws E, E2 {
            N.checkArgNotNull(action, "action");
            N.checkArgNotNull(emptyAction, "emptyAction");
            if (this.isPresent) {
                action.accept(this.value);
            } else {
                emptyAction.run();
            }
            return this;
        }

        public <E extends Exception> OptionalFloat filter(Try.FloatPredicate<E> predicate) throws E {
            N.checkArgNotNull(predicate, "predicate");
            if (this.isPresent && predicate.test(this.value)) {
                return this;
            }
            return OptionalFloat.empty();
        }

        public <E extends Exception> OptionalFloat map(Try.FloatUnaryOperator<E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return OptionalFloat.of(mapper.applyAsFloat(this.value));
            }
            return OptionalFloat.empty();
        }

        public <E extends Exception> OptionalDouble mapToDouble(Try.ToDoubleFunction<Float, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return OptionalDouble.of(mapper.applyAsDouble(Float.valueOf(this.value)));
            }
            return OptionalDouble.empty();
        }

        public <T, E extends Exception> Nullable<T> mapToObj(Try.FloatFunction<T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return Nullable.of(mapper.apply(this.value));
            }
            return Nullable.empty();
        }

        public <E extends Exception> OptionalFloat flatMap(Try.FloatFunction<OptionalFloat, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return Objects.requireNonNull(mapper.apply(this.value));
            }
            return OptionalFloat.empty();
        }

        public <E extends Exception> OptionalFloat or(Try.Supplier<OptionalFloat, E> supplier) throws E {
            if (this.isPresent) {
                return this;
            }
            return Objects.requireNonNull(supplier.get());
        }

        public float orZero() {
            return this.isPresent ? this.value : 0.0f;
        }

        public float orElseThrow() throws NoSuchElementException {
            if (this.isPresent) {
                return this.value;
            }
            throw new NoSuchElementException("No value present");
        }

        public float orElse(float other) {
            return this.isPresent ? this.value : other;
        }

        public <E extends Exception> float orElseGet(Try.FloatSupplier<E> other) throws E {
            N.checkArgNotNull(other, "other");
            if (this.isPresent) {
                return this.value;
            }
            return other.getAsFloat();
        }

        public <X extends Throwable> float orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
            N.checkArgNotNull(exceptionSupplier, "exceptionSupplier");
            if (this.isPresent) {
                return this.value;
            }
            throw (Throwable)exceptionSupplier.get();
        }

        @Override
        public int compareTo(OptionalFloat optional) {
            if (optional == null || !optional.isPresent) {
                return this.isPresent ? 1 : 0;
            }
            if (!this.isPresent) {
                return -1;
            }
            return Float.compare(this.get(), optional.get());
        }

        public Optional<Float> boxed() {
            if (this.isPresent) {
                return Optional.of(Float.valueOf(this.value));
            }
            return Optional.empty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof OptionalFloat) {
                OptionalFloat other = (OptionalFloat)obj;
                return this.isPresent && other.isPresent ? N.equals(this.value, other.value) : this.isPresent == other.isPresent;
            }
            return false;
        }

        public int hashCode() {
            return N.hashCode(this.isPresent) * 31 + N.hashCode(this.value);
        }

        public String toString() {
            if (this.isPresent) {
                return String.format("OptionalFloat[%s]", Float.valueOf(this.value));
            }
            return "OptionalFloat.empty";
        }
    }

    public static final class OptionalLong
    implements Comparable<OptionalLong> {
        private static final OptionalLong EMPTY = new OptionalLong();
        private final long value;
        private final boolean isPresent;

        private OptionalLong() {
            this.value = 0L;
            this.isPresent = false;
        }

        private OptionalLong(long value) {
            this.value = value;
            this.isPresent = true;
        }

        public static OptionalLong empty() {
            return EMPTY;
        }

        public static OptionalLong of(long value) {
            return new OptionalLong(value);
        }

        public static OptionalLong ofNullable(Long val) {
            if (val == null) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(val);
        }

        public long get() throws NoSuchElementException {
            return this.orElseThrow();
        }

        public boolean isPresent() {
            return this.isPresent;
        }

        public <E extends Exception> OptionalLong ifPresent(Try.LongConsumer<E> action) throws E {
            N.checkArgNotNull(action, "action");
            if (this.isPresent) {
                action.accept(this.value);
            }
            return this;
        }

        public <E extends Exception, E2 extends Exception> OptionalLong ifPresentOrElse(Try.LongConsumer<E> action, Try.Runnable<E2> emptyAction) throws E, E2 {
            N.checkArgNotNull(action, "action");
            N.checkArgNotNull(emptyAction, "emptyAction");
            if (this.isPresent) {
                action.accept(this.value);
            } else {
                emptyAction.run();
            }
            return this;
        }

        public <E extends Exception> OptionalLong filter(Try.LongPredicate<E> predicate) throws E {
            N.checkArgNotNull(predicate, "predicate");
            if (this.isPresent && predicate.test(this.value)) {
                return this;
            }
            return OptionalLong.empty();
        }

        public <E extends Exception> OptionalLong map(Try.LongUnaryOperator<E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return OptionalLong.of(mapper.applyAsLong(this.value));
            }
            return OptionalLong.empty();
        }

        public <E extends Exception> OptionalInt mapToInt(Try.ToIntFunction<Long, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return OptionalInt.of(mapper.applyAsInt(this.value));
            }
            return OptionalInt.empty();
        }

        public <E extends Exception> OptionalDouble mapToDouble(Try.ToDoubleFunction<Long, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return OptionalDouble.of(mapper.applyAsDouble(this.value));
            }
            return OptionalDouble.empty();
        }

        public <T, E extends Exception> Nullable<T> mapToObj(Try.LongFunction<T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return Nullable.of(mapper.apply(this.value));
            }
            return Nullable.empty();
        }

        public <E extends Exception> OptionalLong flatMap(Try.LongFunction<OptionalLong, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return Objects.requireNonNull(mapper.apply(this.value));
            }
            return OptionalLong.empty();
        }

        public <E extends Exception> OptionalLong or(Try.Supplier<OptionalLong, E> supplier) throws E {
            if (this.isPresent) {
                return this;
            }
            return Objects.requireNonNull(supplier.get());
        }

        public long orZero() {
            return this.isPresent ? this.value : 0L;
        }

        public long orElseThrow() throws NoSuchElementException {
            if (this.isPresent) {
                return this.value;
            }
            throw new NoSuchElementException("No value present");
        }

        public long orElse(long other) {
            return this.isPresent ? this.value : other;
        }

        public <E extends Exception> long orElseGet(Try.LongSupplier<E> other) throws E {
            N.checkArgNotNull(other, "other");
            if (this.isPresent) {
                return this.value;
            }
            return other.getAsLong();
        }

        public <X extends Throwable> long orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
            N.checkArgNotNull(exceptionSupplier, "exceptionSupplier");
            if (this.isPresent) {
                return this.value;
            }
            throw (Throwable)exceptionSupplier.get();
        }

        @Override
        public int compareTo(OptionalLong optional) {
            if (optional == null || !optional.isPresent) {
                return this.isPresent ? 1 : 0;
            }
            if (!this.isPresent) {
                return -1;
            }
            return Long.compare(this.get(), optional.get());
        }

        public Optional<Long> boxed() {
            if (this.isPresent) {
                return Optional.of(this.value);
            }
            return Optional.empty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof OptionalLong) {
                OptionalLong other = (OptionalLong)obj;
                return this.isPresent && other.isPresent ? this.value == other.value : this.isPresent == other.isPresent;
            }
            return false;
        }

        public int hashCode() {
            return N.hashCode(this.isPresent) * 31 + N.hashCode(this.value);
        }

        public String toString() {
            if (this.isPresent) {
                return String.format("OptionalLong[%s]", this.value);
            }
            return "OptionalLong.empty";
        }
    }

    public static final class OptionalInt
    implements Comparable<OptionalInt> {
        private static final OptionalInt EMPTY = new OptionalInt();
        private static final int MIN_CACHED_VALUE = -128;
        private static final int MAX_CACHED_VALUE = 1025;
        private static final OptionalInt[] POOL = new OptionalInt[1153];
        private final int value;
        private final boolean isPresent;

        private OptionalInt() {
            this.value = 0;
            this.isPresent = false;
        }

        private OptionalInt(int value) {
            this.value = value;
            this.isPresent = true;
        }

        public static OptionalInt empty() {
            return EMPTY;
        }

        public static OptionalInt of(int value) {
            return value >= -128 && value < 1025 ? POOL[value - -128] : new OptionalInt(value);
        }

        public static OptionalInt ofNullable(Integer val) {
            if (val == null) {
                return OptionalInt.empty();
            }
            return OptionalInt.of(val);
        }

        public int get() throws NoSuchElementException {
            return this.orElseThrow();
        }

        public boolean isPresent() {
            return this.isPresent;
        }

        public <E extends Exception> OptionalInt ifPresent(Try.IntConsumer<E> action) throws E {
            N.checkArgNotNull(action, "action");
            if (this.isPresent) {
                action.accept(this.value);
            }
            return this;
        }

        public <E extends Exception, E2 extends Exception> OptionalInt ifPresentOrElse(Try.IntConsumer<E> action, Try.Runnable<E2> emptyAction) throws E, E2 {
            N.checkArgNotNull(action, "action");
            N.checkArgNotNull(emptyAction, "emptyAction");
            if (this.isPresent) {
                action.accept(this.value);
            } else {
                emptyAction.run();
            }
            return this;
        }

        public <E extends Exception> OptionalInt filter(Try.IntPredicate<E> predicate) throws E {
            N.checkArgNotNull(predicate, "predicate");
            if (this.isPresent && predicate.test(this.value)) {
                return this;
            }
            return OptionalInt.empty();
        }

        public <E extends Exception> OptionalInt map(Try.IntUnaryOperator<E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return OptionalInt.of(mapper.applyAsInt(this.value));
            }
            return OptionalInt.empty();
        }

        public <E extends Exception> OptionalLong mapToLong(Try.ToLongFunction<Integer, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return OptionalLong.of(mapper.applyAsLong(this.value));
            }
            return OptionalLong.empty();
        }

        public <E extends Exception> OptionalDouble mapToDouble(Try.ToDoubleFunction<Integer, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return OptionalDouble.of(mapper.applyAsDouble(this.value));
            }
            return OptionalDouble.empty();
        }

        public <T, E extends Exception> Nullable<T> mapToObj(Try.IntFunction<T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return Nullable.of(mapper.apply(this.value));
            }
            return Nullable.empty();
        }

        public <E extends Exception> OptionalInt flatMap(Try.IntFunction<OptionalInt, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return Objects.requireNonNull(mapper.apply(this.value));
            }
            return OptionalInt.empty();
        }

        public <E extends Exception> OptionalInt or(Try.Supplier<OptionalInt, E> supplier) throws E {
            if (this.isPresent) {
                return this;
            }
            return Objects.requireNonNull(supplier.get());
        }

        public int orZero() {
            return this.isPresent ? this.value : 0;
        }

        public int orElseThrow() throws NoSuchElementException {
            if (this.isPresent) {
                return this.value;
            }
            throw new NoSuchElementException("No value present");
        }

        public int orElse(int other) {
            return this.isPresent ? this.value : other;
        }

        public <E extends Exception> int orElseGet(Try.IntSupplier<E> other) throws E {
            N.checkArgNotNull(other, "other");
            if (this.isPresent) {
                return this.value;
            }
            return other.getAsInt();
        }

        public <X extends Throwable> int orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
            N.checkArgNotNull(exceptionSupplier, "exceptionSupplier");
            if (this.isPresent) {
                return this.value;
            }
            throw (Throwable)exceptionSupplier.get();
        }

        @Override
        public int compareTo(OptionalInt optional) {
            if (optional == null || !optional.isPresent) {
                return this.isPresent ? 1 : 0;
            }
            if (!this.isPresent) {
                return -1;
            }
            return Integer.compare(this.get(), optional.get());
        }

        public Optional<Integer> boxed() {
            if (this.isPresent) {
                return Optional.of(this.value);
            }
            return Optional.empty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof OptionalInt) {
                OptionalInt other = (OptionalInt)obj;
                return this.isPresent && other.isPresent ? this.value == other.value : this.isPresent == other.isPresent;
            }
            return false;
        }

        public int hashCode() {
            return N.hashCode(this.isPresent) * 31 + N.hashCode(this.value);
        }

        public String toString() {
            if (this.isPresent) {
                return String.format("OptionalInt[%s]", this.value);
            }
            return "OptionalInt.empty";
        }

        static {
            int to = 1153;
            for (int i = 0; i < to; ++i) {
                OptionalInt.POOL[i] = new OptionalInt(i + -128);
            }
        }
    }

    public static final class OptionalShort
    implements Comparable<OptionalShort> {
        private static final OptionalShort EMPTY = new OptionalShort();
        private final short value;
        private final boolean isPresent;

        private OptionalShort() {
            this.value = 0;
            this.isPresent = false;
        }

        private OptionalShort(short value) {
            this.value = value;
            this.isPresent = true;
        }

        public static OptionalShort empty() {
            return EMPTY;
        }

        public static OptionalShort of(short value) {
            return new OptionalShort(value);
        }

        public static OptionalShort ofNullable(Short val) {
            if (val == null) {
                return OptionalShort.empty();
            }
            return OptionalShort.of(val);
        }

        public short get() throws NoSuchElementException {
            return this.orElseThrow();
        }

        public boolean isPresent() {
            return this.isPresent;
        }

        public <E extends Exception> OptionalShort ifPresent(Try.ShortConsumer<E> action) throws E {
            N.checkArgNotNull(action, "action");
            if (this.isPresent) {
                action.accept(this.value);
            }
            return this;
        }

        public <E extends Exception, E2 extends Exception> OptionalShort ifPresentOrElse(Try.ShortConsumer<E> action, Try.Runnable<E2> emptyAction) throws E, E2 {
            N.checkArgNotNull(action, "action");
            N.checkArgNotNull(emptyAction, "emptyAction");
            if (this.isPresent) {
                action.accept(this.value);
            } else {
                emptyAction.run();
            }
            return this;
        }

        public <E extends Exception> OptionalShort filter(Try.ShortPredicate<E> predicate) throws E {
            N.checkArgNotNull(predicate, "predicate");
            if (this.isPresent && predicate.test(this.value)) {
                return this;
            }
            return OptionalShort.empty();
        }

        public <E extends Exception> OptionalShort map(Try.ShortUnaryOperator<E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return OptionalShort.of(mapper.applyAsShort(this.value));
            }
            return OptionalShort.empty();
        }

        public <E extends Exception> OptionalInt mapToInt(Try.ToIntFunction<Short, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return OptionalInt.of(mapper.applyAsInt(this.value));
            }
            return OptionalInt.empty();
        }

        public <T, E extends Exception> Nullable<T> mapToObj(Try.ShortFunction<T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return Nullable.of(mapper.apply(this.value));
            }
            return Nullable.empty();
        }

        public <E extends Exception> OptionalShort flatMap(Try.ShortFunction<OptionalShort, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return Objects.requireNonNull(mapper.apply(this.value));
            }
            return OptionalShort.empty();
        }

        public <E extends Exception> OptionalShort or(Try.Supplier<OptionalShort, E> supplier) throws E {
            if (this.isPresent) {
                return this;
            }
            return Objects.requireNonNull(supplier.get());
        }

        public short orZero() {
            return this.isPresent ? this.value : (short)0;
        }

        public short orElseThrow() throws NoSuchElementException {
            if (this.isPresent) {
                return this.value;
            }
            throw new NoSuchElementException("No value present");
        }

        public short orElse(short other) {
            return this.isPresent ? this.value : other;
        }

        public <E extends Exception> short orElseGet(Try.ShortSupplier<E> other) throws E {
            N.checkArgNotNull(other, "other");
            if (this.isPresent) {
                return this.value;
            }
            return other.getAsShort();
        }

        public <X extends Throwable> short orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
            N.checkArgNotNull(exceptionSupplier, "exceptionSupplier");
            if (this.isPresent) {
                return this.value;
            }
            throw (Throwable)exceptionSupplier.get();
        }

        @Override
        public int compareTo(OptionalShort optional) {
            if (optional == null || !optional.isPresent) {
                return this.isPresent ? 1 : 0;
            }
            if (!this.isPresent) {
                return -1;
            }
            return Short.compare(this.get(), optional.get());
        }

        public Optional<Short> boxed() {
            if (this.isPresent) {
                return Optional.of(this.value);
            }
            return Optional.empty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof OptionalShort) {
                OptionalShort other = (OptionalShort)obj;
                return this.isPresent && other.isPresent ? this.value == other.value : this.isPresent == other.isPresent;
            }
            return false;
        }

        public int hashCode() {
            return N.hashCode(this.isPresent) * 31 + N.hashCode(this.value);
        }

        public String toString() {
            if (this.isPresent) {
                return String.format("OptionalShort[%s]", this.value);
            }
            return "OptionalShort.empty";
        }
    }

    public static final class OptionalByte
    implements Comparable<OptionalByte> {
        private static final OptionalByte EMPTY = new OptionalByte();
        private static final OptionalByte[] POOL = new OptionalByte[256];
        private final byte value;
        private final boolean isPresent;

        private OptionalByte() {
            this.value = 0;
            this.isPresent = false;
        }

        private OptionalByte(byte value) {
            this.value = value;
            this.isPresent = true;
        }

        public static OptionalByte empty() {
            return EMPTY;
        }

        public static OptionalByte of(byte value) {
            return POOL[value - -128];
        }

        public static OptionalByte ofNullable(Byte val) {
            if (val == null) {
                return OptionalByte.empty();
            }
            return OptionalByte.of(val);
        }

        public byte get() throws NoSuchElementException {
            return this.orElseThrow();
        }

        public boolean isPresent() {
            return this.isPresent;
        }

        public <E extends Exception> OptionalByte ifPresent(Try.ByteConsumer<E> action) throws E {
            N.checkArgNotNull(action, "action");
            if (this.isPresent) {
                action.accept(this.value);
            }
            return this;
        }

        public <E extends Exception, E2 extends Exception> OptionalByte ifPresentOrElse(Try.ByteConsumer<E> action, Try.Runnable<E2> emptyAction) throws E, E2 {
            N.checkArgNotNull(action, "action");
            N.checkArgNotNull(emptyAction, "emptyAction");
            if (this.isPresent) {
                action.accept(this.value);
            } else {
                emptyAction.run();
            }
            return this;
        }

        public <E extends Exception> OptionalByte filter(Try.BytePredicate<E> predicate) throws E {
            N.checkArgNotNull(predicate, "predicate");
            if (this.isPresent && predicate.test(this.value)) {
                return this;
            }
            return OptionalByte.empty();
        }

        public <E extends Exception> OptionalByte map(Try.ByteUnaryOperator<E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return OptionalByte.of(mapper.applyAsByte(this.value));
            }
            return OptionalByte.empty();
        }

        public <E extends Exception> OptionalInt mapToInt(Try.ToIntFunction<Byte, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return OptionalInt.of(mapper.applyAsInt(this.value));
            }
            return OptionalInt.empty();
        }

        public <T, E extends Exception> Nullable<T> mapToObj(Try.ByteFunction<T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return Nullable.of(mapper.apply(this.value));
            }
            return Nullable.empty();
        }

        public <E extends Exception> OptionalByte flatMap(Try.ByteFunction<OptionalByte, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return Objects.requireNonNull(mapper.apply(this.value));
            }
            return OptionalByte.empty();
        }

        public <E extends Exception> OptionalByte or(Try.Supplier<OptionalByte, E> supplier) throws E {
            if (this.isPresent) {
                return this;
            }
            return Objects.requireNonNull(supplier.get());
        }

        public byte orZero() {
            return this.isPresent ? this.value : (byte)0;
        }

        public byte orElseThrow() throws NoSuchElementException {
            if (this.isPresent) {
                return this.value;
            }
            throw new NoSuchElementException("No value present");
        }

        public byte orElse(byte other) {
            return this.isPresent ? this.value : other;
        }

        public <E extends Exception> byte orElseGet(Try.ByteSupplier<E> other) throws E {
            N.checkArgNotNull(other, "other");
            if (this.isPresent) {
                return this.value;
            }
            return other.getAsByte();
        }

        public <X extends Throwable> byte orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
            N.checkArgNotNull(exceptionSupplier, "exceptionSupplier");
            if (this.isPresent) {
                return this.value;
            }
            throw (Throwable)exceptionSupplier.get();
        }

        @Override
        public int compareTo(OptionalByte optional) {
            if (optional == null || !optional.isPresent) {
                return this.isPresent ? 1 : 0;
            }
            if (!this.isPresent) {
                return -1;
            }
            return Byte.compare(this.get(), optional.get());
        }

        public Optional<Byte> boxed() {
            if (this.isPresent) {
                return Optional.of(this.value);
            }
            return Optional.empty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof OptionalByte) {
                OptionalByte other = (OptionalByte)obj;
                return this.isPresent && other.isPresent ? this.value == other.value : this.isPresent == other.isPresent;
            }
            return false;
        }

        public int hashCode() {
            return N.hashCode(this.isPresent) * 31 + N.hashCode(this.value);
        }

        public String toString() {
            if (this.isPresent) {
                return String.format("OptionalByte[%s]", this.value);
            }
            return "OptionalByte.empty";
        }

        static {
            for (int i = 0; i < 256; ++i) {
                OptionalByte.POOL[i] = new OptionalByte((byte)(i - 128));
            }
        }
    }

    public static final class OptionalChar
    implements Comparable<OptionalChar> {
        private static final OptionalChar EMPTY = new OptionalChar();
        private static final OptionalChar CHAR_0 = new OptionalChar('\u0000');
        private final char value;
        private final boolean isPresent;

        private OptionalChar() {
            this.value = '\u0000';
            this.isPresent = false;
        }

        private OptionalChar(char value) {
            this.value = value;
            this.isPresent = true;
        }

        public static OptionalChar empty() {
            return EMPTY;
        }

        public static OptionalChar of(char value) {
            return value == '\u0000' ? CHAR_0 : new OptionalChar(value);
        }

        public static OptionalChar ofNullable(Character val) {
            if (val == null) {
                return OptionalChar.empty();
            }
            return OptionalChar.of(val.charValue());
        }

        public char get() throws NoSuchElementException {
            return this.orElseThrow();
        }

        public boolean isPresent() {
            return this.isPresent;
        }

        public <E extends Exception> OptionalChar ifPresent(Try.CharConsumer<E> action) throws E {
            N.checkArgNotNull(action, "action");
            if (this.isPresent()) {
                action.accept(this.value);
            }
            return this;
        }

        public <E extends Exception, E2 extends Exception> OptionalChar ifPresentOrElse(Try.CharConsumer<E> action, Try.Runnable<E2> emptyAction) throws E, E2 {
            N.checkArgNotNull(action, "action");
            N.checkArgNotNull(emptyAction, "emptyAction");
            if (this.isPresent()) {
                action.accept(this.value);
            } else {
                emptyAction.run();
            }
            return this;
        }

        public <E extends Exception> OptionalChar filter(Try.CharPredicate<E> predicate) throws E {
            N.checkArgNotNull(predicate, "predicate");
            if (this.isPresent() && predicate.test(this.value)) {
                return this;
            }
            return OptionalChar.empty();
        }

        public <E extends Exception> OptionalChar map(Try.CharUnaryOperator<E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent()) {
                return OptionalChar.of(mapper.applyAsChar(this.value));
            }
            return OptionalChar.empty();
        }

        public <E extends Exception> OptionalInt mapToInt(Try.ToIntFunction<Character, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return OptionalInt.of(mapper.applyAsInt(Character.valueOf(this.value)));
            }
            return OptionalInt.empty();
        }

        public <T, E extends Exception> Nullable<T> mapToObj(Try.CharFunction<T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent()) {
                return Nullable.of(mapper.apply(this.value));
            }
            return Nullable.empty();
        }

        public <E extends Exception> OptionalChar flatMap(Try.CharFunction<OptionalChar, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent()) {
                return Objects.requireNonNull(mapper.apply(this.value));
            }
            return OptionalChar.empty();
        }

        public <E extends Exception> OptionalChar or(Try.Supplier<OptionalChar, E> supplier) throws E {
            if (this.isPresent()) {
                return this;
            }
            return Objects.requireNonNull(supplier.get());
        }

        public char orZero() {
            return this.isPresent() ? this.value : (char)'\u0000';
        }

        public char orElseThrow() throws NoSuchElementException {
            if (this.isPresent()) {
                return this.value;
            }
            throw new NoSuchElementException("No value present");
        }

        public char orElse(char other) {
            return this.isPresent() ? this.value : other;
        }

        public <E extends Exception> char orElseGet(Try.CharSupplier<E> other) throws E {
            N.checkArgNotNull(other, "other");
            if (this.isPresent()) {
                return this.value;
            }
            return other.getAsChar();
        }

        public <X extends Throwable> char orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
            N.checkArgNotNull(exceptionSupplier, "exceptionSupplier");
            if (this.isPresent()) {
                return this.value;
            }
            throw (Throwable)exceptionSupplier.get();
        }

        @Override
        public int compareTo(OptionalChar optional) {
            if (optional == null || !optional.isPresent()) {
                return this.isPresent ? 1 : 0;
            }
            if (!this.isPresent) {
                return -1;
            }
            return Character.compare(this.get(), optional.get());
        }

        public Optional<Character> boxed() {
            if (this.isPresent()) {
                return Optional.of(Character.valueOf(this.value));
            }
            return Optional.empty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof OptionalChar) {
                OptionalChar other = (OptionalChar)obj;
                return this.isPresent && other.isPresent ? this.value == other.value : this.isPresent == other.isPresent;
            }
            return false;
        }

        public int hashCode() {
            return N.hashCode(this.isPresent()) * 31 + N.hashCode(this.value);
        }

        public String toString() {
            if (this.isPresent()) {
                return String.format("OptionalChar[%s]", Character.valueOf(this.value));
            }
            return "OptionalChar.empty";
        }
    }

    public static final class OptionalBoolean
    implements Comparable<OptionalBoolean> {
        private static final OptionalBoolean EMPTY = new OptionalBoolean();
        private static final OptionalBoolean TRUE = new OptionalBoolean(true);
        private static final OptionalBoolean FALSE = new OptionalBoolean(false);
        private final boolean value;
        private final boolean isPresent;

        private OptionalBoolean() {
            this.value = false;
            this.isPresent = false;
        }

        private OptionalBoolean(boolean value) {
            this.value = value;
            this.isPresent = true;
        }

        public static OptionalBoolean empty() {
            return EMPTY;
        }

        public static OptionalBoolean of(boolean value) {
            return value ? TRUE : FALSE;
        }

        public static OptionalBoolean ofNullable(Boolean val) {
            if (val == null) {
                return OptionalBoolean.empty();
            }
            return OptionalBoolean.of(val);
        }

        public boolean get() throws NoSuchElementException {
            return this.orElseThrow();
        }

        public boolean isPresent() {
            return this.isPresent;
        }

        public <E extends Exception> OptionalBoolean ifPresent(Try.BooleanConsumer<E> action) throws E {
            N.checkArgNotNull(action, "action");
            if (this.isPresent) {
                action.accept(this.value);
            }
            return this;
        }

        public <E extends Exception, E2 extends Exception> OptionalBoolean ifPresentOrElse(Try.BooleanConsumer<E> action, Try.Runnable<E2> emptyAction) throws E, E2 {
            N.checkArgNotNull(action, "action");
            N.checkArgNotNull(emptyAction, "emptyAction");
            if (this.isPresent) {
                action.accept(this.value);
            } else {
                emptyAction.run();
            }
            return this;
        }

        public <E extends Exception> OptionalBoolean filter(Try.BooleanPredicate<E> predicate) throws E {
            N.checkArgNotNull(predicate, "predicate");
            if (this.isPresent && predicate.test(this.value)) {
                return this;
            }
            return OptionalBoolean.empty();
        }

        public <E extends Exception> OptionalBoolean map(Try.BooleanUnaryOperator<E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return OptionalBoolean.of(mapper.applyAsBoolean(this.value));
            }
            return OptionalBoolean.empty();
        }

        public <T, E extends Exception> Nullable<T> mapToObj(Try.BooleanFunction<T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return Nullable.of(mapper.apply(this.value));
            }
            return Nullable.empty();
        }

        public <E extends Exception> OptionalBoolean flatMap(Try.BooleanFunction<OptionalBoolean, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent) {
                return Objects.requireNonNull(mapper.apply(this.value));
            }
            return OptionalBoolean.empty();
        }

        public <E extends Exception> OptionalBoolean or(Try.Supplier<OptionalBoolean, E> supplier) throws E {
            if (this.isPresent) {
                return this;
            }
            return Objects.requireNonNull(supplier.get());
        }

        public boolean orFalse() {
            return this.isPresent ? this.value : false;
        }

        public boolean orTrue() {
            return this.isPresent ? this.value : true;
        }

        public boolean orElseThrow() throws NoSuchElementException {
            if (this.isPresent) {
                return this.value;
            }
            throw new NoSuchElementException("No value present");
        }

        public boolean orElse(boolean other) {
            return this.isPresent ? this.value : other;
        }

        public <E extends Exception> boolean orElseGet(Try.BooleanSupplier<E> other) throws E {
            N.checkArgNotNull(other, "other");
            if (this.isPresent) {
                return this.value;
            }
            return other.getAsBoolean();
        }

        public <X extends Throwable> boolean orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
            N.checkArgNotNull(exceptionSupplier, "exceptionSupplier");
            if (this.isPresent) {
                return this.value;
            }
            throw (Throwable)exceptionSupplier.get();
        }

        @Override
        public int compareTo(OptionalBoolean optional) {
            if (optional == null || !optional.isPresent) {
                return this.isPresent ? 1 : 0;
            }
            if (!this.isPresent) {
                return -1;
            }
            return Boolean.compare(this.get(), optional.get());
        }

        public Optional<Boolean> boxed() {
            if (this.isPresent) {
                return Optional.of(this.value);
            }
            return Optional.empty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof OptionalBoolean) {
                OptionalBoolean other = (OptionalBoolean)obj;
                return this.isPresent && other.isPresent ? this.value == other.value : this.isPresent == other.isPresent;
            }
            return false;
        }

        public int hashCode() {
            return N.hashCode(this.isPresent) * 31 + N.hashCode(this.value);
        }

        public String toString() {
            if (this.isPresent) {
                return String.format("OptionalBoolean[%s]", this.value);
            }
            return "OptionalBoolean.empty";
        }
    }

    public static final class Optional<T> {
        private static final Optional<?> EMPTY = new Optional();
        private final T value;

        private Optional() {
            this.value = null;
        }

        private Optional(T value) {
            this.value = N.checkArgNotNull(value);
        }

        public static <T> Optional<T> empty() {
            return EMPTY;
        }

        public static <T> Optional<T> of(T value) {
            return new Optional<T>(value);
        }

        public static <T> Optional<T> ofNullable(T value) {
            if (value == null) {
                return Optional.empty();
            }
            return new Optional<T>(value);
        }

        public T get() throws NoSuchElementException {
            return this.orElseThrow();
        }

        public boolean isPresent() {
            return this.value != null;
        }

        public boolean isEmpty() {
            return this.value == null;
        }

        public <E extends Exception> Optional<T> ifPresent(Try.Consumer<? super T, E> action) throws E {
            N.checkArgNotNull(action, "action");
            if (this.isPresent()) {
                action.accept(this.value);
            }
            return this;
        }

        public <E extends Exception, E2 extends Exception> Optional<T> ifPresentOrElse(Try.Consumer<? super T, E> action, Try.Runnable<E2> emptyAction) throws E, E2 {
            N.checkArgNotNull(action, "action");
            N.checkArgNotNull(emptyAction, "emptyAction");
            if (this.isPresent()) {
                action.accept(this.value);
            } else {
                emptyAction.run();
            }
            return this;
        }

        public <E extends Exception> Optional<T> filter(Try.Predicate<? super T, E> predicate) throws E {
            N.checkArgNotNull(predicate, "predicate");
            if (this.isPresent() && predicate.test(this.value)) {
                return this;
            }
            return Optional.empty();
        }

        public <U, E extends Exception> Nullable<U> map(Try.Function<? super T, ? extends U, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent()) {
                return Nullable.of(mapper.apply(this.value));
            }
            return Nullable.empty();
        }

        public <E extends Exception> OptionalBoolean mapToBoolean(Try.ToBooleanFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent()) {
                return OptionalBoolean.of(mapper.applyAsBoolean(this.value));
            }
            return OptionalBoolean.empty();
        }

        public <E extends Exception> OptionalChar mapToChar(Try.ToCharFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent()) {
                return OptionalChar.of(mapper.applyAsChar(this.value));
            }
            return OptionalChar.empty();
        }

        public <E extends Exception> OptionalByte mapToByte(Try.ToByteFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent()) {
                return OptionalByte.of(mapper.applyAsByte(this.value));
            }
            return OptionalByte.empty();
        }

        public <E extends Exception> OptionalShort mapToShort(Try.ToShortFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent()) {
                return OptionalShort.of(mapper.applyAsShort(this.value));
            }
            return OptionalShort.empty();
        }

        public <E extends Exception> OptionalInt mapToInt(Try.ToIntFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent()) {
                return OptionalInt.of(mapper.applyAsInt(this.value));
            }
            return OptionalInt.empty();
        }

        public <E extends Exception> OptionalLong mapToLong(Try.ToLongFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent()) {
                return OptionalLong.of(mapper.applyAsLong(this.value));
            }
            return OptionalLong.empty();
        }

        public <E extends Exception> OptionalFloat mapToFloat(Try.ToFloatFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent()) {
                return OptionalFloat.of(mapper.applyAsFloat(this.value));
            }
            return OptionalFloat.empty();
        }

        public <E extends Exception> OptionalDouble mapToDouble(Try.ToDoubleFunction<? super T, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent()) {
                return OptionalDouble.of(mapper.applyAsDouble(this.value));
            }
            return OptionalDouble.empty();
        }

        public <U, E extends Exception> Optional<U> flatMap(Try.Function<? super T, Optional<U>, E> mapper) throws E {
            N.checkArgNotNull(mapper, "mapper");
            if (this.isPresent()) {
                return Objects.requireNonNull(mapper.apply(this.value));
            }
            return Optional.empty();
        }

        public <E extends Exception> Optional<T> or(Try.Supplier<Optional<? extends T>, E> supplier) throws E {
            N.checkArgNotNull(supplier, "supplier");
            if (this.isPresent()) {
                return this;
            }
            return Objects.requireNonNull(supplier.get());
        }

        public T orNull() {
            return this.isPresent() ? (T)this.value : null;
        }

        public T orElse(T other) {
            return this.isPresent() ? this.value : other;
        }

        public <E extends Exception> T orElseGet(Try.Supplier<? extends T, E> other) throws E {
            if (this.isPresent()) {
                return this.value;
            }
            return other.get();
        }

        public T orElseThrow() throws NoSuchElementException {
            if (this.isPresent()) {
                return this.value;
            }
            throw new NoSuchElementException("No value is present");
        }

        public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
            if (this.isPresent()) {
                return this.value;
            }
            throw (Throwable)exceptionSupplier.get();
        }

        public List<T> toList() {
            if (this.isPresent()) {
                return N.asList(this.value);
            }
            return new ArrayList();
        }

        public Set<T> toSet() {
            if (this.isPresent()) {
                return N.asSet(this.value);
            }
            return N.newHashSet();
        }

        public ImmutableList<T> toImmutableList() {
            if (this.isPresent()) {
                return ImmutableList.of(this.value);
            }
            return ImmutableList.empty();
        }

        public ImmutableSet<T> toImmutableSet() {
            if (this.isPresent()) {
                return ImmutableSet.of(this.value);
            }
            return ImmutableSet.empty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Optional) {
                Optional other = (Optional)obj;
                return N.equals(this.value, other.value);
            }
            return false;
        }

        public int hashCode() {
            return N.hashCode(this.isPresent()) * 31 + N.hashCode(this.value);
        }

        public String toString() {
            if (this.isPresent()) {
                return String.format("Optional[%s]", N.toString(this.value));
            }
            return "Optional.empty";
        }
    }
}

