/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.commons.types.IBaseScore;
import com.langfuse.client.resources.commons.types.ScoreSource;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BaseScore
implements IBaseScore {
    private final String id;
    private final String traceId;
    private final String name;
    private final ScoreSource source;
    private final Optional<String> observationId;
    private final OffsetDateTime timestamp;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    private final Optional<String> authorUserId;
    private final Optional<String> comment;
    private final Optional<String> configId;
    private final Optional<String> queueId;
    private final Optional<String> environment;
    private final Map<String, Object> additionalProperties;

    private BaseScore(String id, String traceId, String name, ScoreSource source, Optional<String> observationId, OffsetDateTime timestamp, OffsetDateTime createdAt, OffsetDateTime updatedAt, Optional<String> authorUserId, Optional<String> comment, Optional<String> configId, Optional<String> queueId, Optional<String> environment, Map<String, Object> additionalProperties) {
        this.id = id;
        this.traceId = traceId;
        this.name = name;
        this.source = source;
        this.observationId = observationId;
        this.timestamp = timestamp;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.authorUserId = authorUserId;
        this.comment = comment;
        this.configId = configId;
        this.queueId = queueId;
        this.environment = environment;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="traceId")
    public String getTraceId() {
        return this.traceId;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="source")
    public ScoreSource getSource() {
        return this.source;
    }

    @Override
    @JsonProperty(value="observationId")
    public Optional<String> getObservationId() {
        return this.observationId;
    }

    @Override
    @JsonProperty(value="timestamp")
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    @Override
    @JsonProperty(value="createdAt")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="authorUserId")
    public Optional<String> getAuthorUserId() {
        return this.authorUserId;
    }

    @Override
    @JsonProperty(value="comment")
    public Optional<String> getComment() {
        return this.comment;
    }

    @Override
    @JsonProperty(value="configId")
    public Optional<String> getConfigId() {
        return this.configId;
    }

    @Override
    @JsonProperty(value="queueId")
    public Optional<String> getQueueId() {
        return this.queueId;
    }

    @Override
    @JsonProperty(value="environment")
    public Optional<String> getEnvironment() {
        return this.environment;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BaseScore && this.equalTo((BaseScore)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BaseScore other) {
        return this.id.equals(other.id) && this.traceId.equals(other.traceId) && this.name.equals(other.name) && this.source.equals((Object)other.source) && this.observationId.equals(other.observationId) && this.timestamp.equals(other.timestamp) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.authorUserId.equals(other.authorUserId) && this.comment.equals(other.comment) && this.configId.equals(other.configId) && this.queueId.equals(other.queueId) && this.environment.equals(other.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.traceId, this.name, this.source, this.observationId, this.timestamp, this.createdAt, this.updatedAt, this.authorUserId, this.comment, this.configId, this.queueId, this.environment});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    TraceIdStage,
    NameStage,
    SourceStage,
    TimestampStage,
    CreatedAtStage,
    UpdatedAtStage,
    _FinalStage {
        private String id;
        private String traceId;
        private String name;
        private ScoreSource source;
        private OffsetDateTime timestamp;
        private OffsetDateTime createdAt;
        private OffsetDateTime updatedAt;
        private Optional<String> environment = Optional.empty();
        private Optional<String> queueId = Optional.empty();
        private Optional<String> configId = Optional.empty();
        private Optional<String> comment = Optional.empty();
        private Optional<String> authorUserId = Optional.empty();
        private Optional<String> observationId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BaseScore other) {
            this.id(other.getId());
            this.traceId(other.getTraceId());
            this.name(other.getName());
            this.source(other.getSource());
            this.observationId(other.getObservationId());
            this.timestamp(other.getTimestamp());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.authorUserId(other.getAuthorUserId());
            this.comment(other.getComment());
            this.configId(other.getConfigId());
            this.queueId(other.getQueueId());
            this.environment(other.getEnvironment());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public TraceIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="traceId")
        public NameStage traceId(@NotNull String traceId) {
            this.traceId = Objects.requireNonNull(traceId, "traceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public SourceStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="source")
        public TimestampStage source(@NotNull ScoreSource source) {
            this.source = Objects.requireNonNull(source, "source must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="timestamp")
        public CreatedAtStage timestamp(@NotNull OffsetDateTime timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="createdAt")
        public UpdatedAtStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updatedAt")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage environment(String environment) {
            this.environment = Optional.ofNullable(environment);
            return this;
        }

        @Override
        @JsonSetter(value="environment", nulls=Nulls.SKIP)
        public _FinalStage environment(Optional<String> environment) {
            this.environment = environment;
            return this;
        }

        @Override
        public _FinalStage queueId(String queueId) {
            this.queueId = Optional.ofNullable(queueId);
            return this;
        }

        @Override
        @JsonSetter(value="queueId", nulls=Nulls.SKIP)
        public _FinalStage queueId(Optional<String> queueId) {
            this.queueId = queueId;
            return this;
        }

        @Override
        public _FinalStage configId(String configId) {
            this.configId = Optional.ofNullable(configId);
            return this;
        }

        @Override
        @JsonSetter(value="configId", nulls=Nulls.SKIP)
        public _FinalStage configId(Optional<String> configId) {
            this.configId = configId;
            return this;
        }

        @Override
        public _FinalStage comment(String comment) {
            this.comment = Optional.ofNullable(comment);
            return this;
        }

        @Override
        @JsonSetter(value="comment", nulls=Nulls.SKIP)
        public _FinalStage comment(Optional<String> comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public _FinalStage authorUserId(String authorUserId) {
            this.authorUserId = Optional.ofNullable(authorUserId);
            return this;
        }

        @Override
        @JsonSetter(value="authorUserId", nulls=Nulls.SKIP)
        public _FinalStage authorUserId(Optional<String> authorUserId) {
            this.authorUserId = authorUserId;
            return this;
        }

        @Override
        public _FinalStage observationId(String observationId) {
            this.observationId = Optional.ofNullable(observationId);
            return this;
        }

        @Override
        @JsonSetter(value="observationId", nulls=Nulls.SKIP)
        public _FinalStage observationId(Optional<String> observationId) {
            this.observationId = observationId;
            return this;
        }

        @Override
        public BaseScore build() {
            return new BaseScore(this.id, this.traceId, this.name, this.source, this.observationId, this.timestamp, this.createdAt, this.updatedAt, this.authorUserId, this.comment, this.configId, this.queueId, this.environment, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BaseScore build();

        public _FinalStage observationId(Optional<String> var1);

        public _FinalStage observationId(String var1);

        public _FinalStage authorUserId(Optional<String> var1);

        public _FinalStage authorUserId(String var1);

        public _FinalStage comment(Optional<String> var1);

        public _FinalStage comment(String var1);

        public _FinalStage configId(Optional<String> var1);

        public _FinalStage configId(String var1);

        public _FinalStage queueId(Optional<String> var1);

        public _FinalStage queueId(String var1);

        public _FinalStage environment(Optional<String> var1);

        public _FinalStage environment(String var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface CreatedAtStage {
        public UpdatedAtStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface TimestampStage {
        public CreatedAtStage timestamp(@NotNull OffsetDateTime var1);
    }

    public static interface SourceStage {
        public TimestampStage source(@NotNull ScoreSource var1);
    }

    public static interface NameStage {
        public SourceStage name(@NotNull String var1);
    }

    public static interface TraceIdStage {
        public NameStage traceId(@NotNull String var1);
    }

    public static interface IdStage {
        public TraceIdStage id(@NotNull String var1);

        public Builder from(BaseScore var1);
    }
}

