/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.commons.types.ModelUsageUnit;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Model {
    private final String id;
    private final String modelName;
    private final String matchPattern;
    private final Optional<OffsetDateTime> startDate;
    private final Optional<ModelUsageUnit> unit;
    private final Optional<Double> inputPrice;
    private final Optional<Double> outputPrice;
    private final Optional<Double> totalPrice;
    private final Optional<String> tokenizerId;
    private final Optional<Object> tokenizerConfig;
    private final boolean isLangfuseManaged;
    private final Map<String, Object> additionalProperties;

    private Model(String id, String modelName, String matchPattern, Optional<OffsetDateTime> startDate, Optional<ModelUsageUnit> unit, Optional<Double> inputPrice, Optional<Double> outputPrice, Optional<Double> totalPrice, Optional<String> tokenizerId, Optional<Object> tokenizerConfig, boolean isLangfuseManaged, Map<String, Object> additionalProperties) {
        this.id = id;
        this.modelName = modelName;
        this.matchPattern = matchPattern;
        this.startDate = startDate;
        this.unit = unit;
        this.inputPrice = inputPrice;
        this.outputPrice = outputPrice;
        this.totalPrice = totalPrice;
        this.tokenizerId = tokenizerId;
        this.tokenizerConfig = tokenizerConfig;
        this.isLangfuseManaged = isLangfuseManaged;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="modelName")
    public String getModelName() {
        return this.modelName;
    }

    @JsonProperty(value="matchPattern")
    public String getMatchPattern() {
        return this.matchPattern;
    }

    @JsonProperty(value="startDate")
    public Optional<OffsetDateTime> getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="unit")
    public Optional<ModelUsageUnit> getUnit() {
        return this.unit;
    }

    @JsonProperty(value="inputPrice")
    public Optional<Double> getInputPrice() {
        return this.inputPrice;
    }

    @JsonProperty(value="outputPrice")
    public Optional<Double> getOutputPrice() {
        return this.outputPrice;
    }

    @JsonProperty(value="totalPrice")
    public Optional<Double> getTotalPrice() {
        return this.totalPrice;
    }

    @JsonProperty(value="tokenizerId")
    public Optional<String> getTokenizerId() {
        return this.tokenizerId;
    }

    @JsonProperty(value="tokenizerConfig")
    public Optional<Object> getTokenizerConfig() {
        return this.tokenizerConfig;
    }

    @JsonProperty(value="isLangfuseManaged")
    public boolean getIsLangfuseManaged() {
        return this.isLangfuseManaged;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Model && this.equalTo((Model)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Model other) {
        return this.id.equals(other.id) && this.modelName.equals(other.modelName) && this.matchPattern.equals(other.matchPattern) && this.startDate.equals(other.startDate) && this.unit.equals(other.unit) && this.inputPrice.equals(other.inputPrice) && this.outputPrice.equals(other.outputPrice) && this.totalPrice.equals(other.totalPrice) && this.tokenizerId.equals(other.tokenizerId) && this.tokenizerConfig.equals(other.tokenizerConfig) && this.isLangfuseManaged == other.isLangfuseManaged;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.modelName, this.matchPattern, this.startDate, this.unit, this.inputPrice, this.outputPrice, this.totalPrice, this.tokenizerId, this.tokenizerConfig, this.isLangfuseManaged);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    ModelNameStage,
    MatchPatternStage,
    IsLangfuseManagedStage,
    _FinalStage {
        private String id;
        private String modelName;
        private String matchPattern;
        private boolean isLangfuseManaged;
        private Optional<Object> tokenizerConfig = Optional.empty();
        private Optional<String> tokenizerId = Optional.empty();
        private Optional<Double> totalPrice = Optional.empty();
        private Optional<Double> outputPrice = Optional.empty();
        private Optional<Double> inputPrice = Optional.empty();
        private Optional<ModelUsageUnit> unit = Optional.empty();
        private Optional<OffsetDateTime> startDate = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Model other) {
            this.id(other.getId());
            this.modelName(other.getModelName());
            this.matchPattern(other.getMatchPattern());
            this.startDate(other.getStartDate());
            this.unit(other.getUnit());
            this.inputPrice(other.getInputPrice());
            this.outputPrice(other.getOutputPrice());
            this.totalPrice(other.getTotalPrice());
            this.tokenizerId(other.getTokenizerId());
            this.tokenizerConfig(other.getTokenizerConfig());
            this.isLangfuseManaged(other.getIsLangfuseManaged());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public ModelNameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="modelName")
        public MatchPatternStage modelName(@NotNull String modelName) {
            this.modelName = Objects.requireNonNull(modelName, "modelName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="matchPattern")
        public IsLangfuseManagedStage matchPattern(@NotNull String matchPattern) {
            this.matchPattern = Objects.requireNonNull(matchPattern, "matchPattern must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="isLangfuseManaged")
        public _FinalStage isLangfuseManaged(boolean isLangfuseManaged) {
            this.isLangfuseManaged = isLangfuseManaged;
            return this;
        }

        @Override
        public _FinalStage tokenizerConfig(Object tokenizerConfig) {
            this.tokenizerConfig = Optional.ofNullable(tokenizerConfig);
            return this;
        }

        @Override
        @JsonSetter(value="tokenizerConfig", nulls=Nulls.SKIP)
        public _FinalStage tokenizerConfig(Optional<Object> tokenizerConfig) {
            this.tokenizerConfig = tokenizerConfig;
            return this;
        }

        @Override
        public _FinalStage tokenizerId(String tokenizerId) {
            this.tokenizerId = Optional.ofNullable(tokenizerId);
            return this;
        }

        @Override
        @JsonSetter(value="tokenizerId", nulls=Nulls.SKIP)
        public _FinalStage tokenizerId(Optional<String> tokenizerId) {
            this.tokenizerId = tokenizerId;
            return this;
        }

        @Override
        public _FinalStage totalPrice(Double totalPrice) {
            this.totalPrice = Optional.ofNullable(totalPrice);
            return this;
        }

        @Override
        @JsonSetter(value="totalPrice", nulls=Nulls.SKIP)
        public _FinalStage totalPrice(Optional<Double> totalPrice) {
            this.totalPrice = totalPrice;
            return this;
        }

        @Override
        public _FinalStage outputPrice(Double outputPrice) {
            this.outputPrice = Optional.ofNullable(outputPrice);
            return this;
        }

        @Override
        @JsonSetter(value="outputPrice", nulls=Nulls.SKIP)
        public _FinalStage outputPrice(Optional<Double> outputPrice) {
            this.outputPrice = outputPrice;
            return this;
        }

        @Override
        public _FinalStage inputPrice(Double inputPrice) {
            this.inputPrice = Optional.ofNullable(inputPrice);
            return this;
        }

        @Override
        @JsonSetter(value="inputPrice", nulls=Nulls.SKIP)
        public _FinalStage inputPrice(Optional<Double> inputPrice) {
            this.inputPrice = inputPrice;
            return this;
        }

        @Override
        public _FinalStage unit(ModelUsageUnit unit) {
            this.unit = Optional.ofNullable(unit);
            return this;
        }

        @Override
        @JsonSetter(value="unit", nulls=Nulls.SKIP)
        public _FinalStage unit(Optional<ModelUsageUnit> unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public _FinalStage startDate(OffsetDateTime startDate) {
            this.startDate = Optional.ofNullable(startDate);
            return this;
        }

        @Override
        @JsonSetter(value="startDate", nulls=Nulls.SKIP)
        public _FinalStage startDate(Optional<OffsetDateTime> startDate) {
            this.startDate = startDate;
            return this;
        }

        @Override
        public Model build() {
            return new Model(this.id, this.modelName, this.matchPattern, this.startDate, this.unit, this.inputPrice, this.outputPrice, this.totalPrice, this.tokenizerId, this.tokenizerConfig, this.isLangfuseManaged, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Model build();

        public _FinalStage startDate(Optional<OffsetDateTime> var1);

        public _FinalStage startDate(OffsetDateTime var1);

        public _FinalStage unit(Optional<ModelUsageUnit> var1);

        public _FinalStage unit(ModelUsageUnit var1);

        public _FinalStage inputPrice(Optional<Double> var1);

        public _FinalStage inputPrice(Double var1);

        public _FinalStage outputPrice(Optional<Double> var1);

        public _FinalStage outputPrice(Double var1);

        public _FinalStage totalPrice(Optional<Double> var1);

        public _FinalStage totalPrice(Double var1);

        public _FinalStage tokenizerId(Optional<String> var1);

        public _FinalStage tokenizerId(String var1);

        public _FinalStage tokenizerConfig(Optional<Object> var1);

        public _FinalStage tokenizerConfig(Object var1);
    }

    public static interface IsLangfuseManagedStage {
        public _FinalStage isLangfuseManaged(boolean var1);
    }

    public static interface MatchPatternStage {
        public IsLangfuseManagedStage matchPattern(@NotNull String var1);
    }

    public static interface ModelNameStage {
        public MatchPatternStage modelName(@NotNull String var1);
    }

    public static interface IdStage {
        public ModelNameStage id(@NotNull String var1);

        public Builder from(Model var1);
    }
}

