/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.commons.types.IObservation;
import com.langfuse.client.resources.commons.types.MapValue;
import com.langfuse.client.resources.commons.types.ObservationLevel;
import com.langfuse.client.resources.commons.types.Usage;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Observation
implements IObservation {
    private final String id;
    private final Optional<String> traceId;
    private final String type;
    private final Optional<String> name;
    private final OffsetDateTime startTime;
    private final Optional<OffsetDateTime> endTime;
    private final Optional<OffsetDateTime> completionStartTime;
    private final Optional<String> model;
    private final Optional<Map<String, MapValue>> modelParameters;
    private final Optional<Object> input;
    private final Optional<String> version;
    private final Optional<Object> metadata;
    private final Optional<Object> output;
    private final Optional<Usage> usage;
    private final ObservationLevel level;
    private final Optional<String> statusMessage;
    private final Optional<String> parentObservationId;
    private final Optional<String> promptId;
    private final Optional<Map<String, Integer>> usageDetails;
    private final Optional<Map<String, Double>> costDetails;
    private final Optional<String> environment;
    private final Map<String, Object> additionalProperties;

    private Observation(String id, Optional<String> traceId, String type, Optional<String> name, OffsetDateTime startTime, Optional<OffsetDateTime> endTime, Optional<OffsetDateTime> completionStartTime, Optional<String> model, Optional<Map<String, MapValue>> modelParameters, Optional<Object> input, Optional<String> version, Optional<Object> metadata, Optional<Object> output, Optional<Usage> usage, ObservationLevel level, Optional<String> statusMessage, Optional<String> parentObservationId, Optional<String> promptId, Optional<Map<String, Integer>> usageDetails, Optional<Map<String, Double>> costDetails, Optional<String> environment, Map<String, Object> additionalProperties) {
        this.id = id;
        this.traceId = traceId;
        this.type = type;
        this.name = name;
        this.startTime = startTime;
        this.endTime = endTime;
        this.completionStartTime = completionStartTime;
        this.model = model;
        this.modelParameters = modelParameters;
        this.input = input;
        this.version = version;
        this.metadata = metadata;
        this.output = output;
        this.usage = usage;
        this.level = level;
        this.statusMessage = statusMessage;
        this.parentObservationId = parentObservationId;
        this.promptId = promptId;
        this.usageDetails = usageDetails;
        this.costDetails = costDetails;
        this.environment = environment;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="traceId")
    public Optional<String> getTraceId() {
        return this.traceId;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="startTime")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    @Override
    @JsonProperty(value="endTime")
    public Optional<OffsetDateTime> getEndTime() {
        return this.endTime;
    }

    @Override
    @JsonProperty(value="completionStartTime")
    public Optional<OffsetDateTime> getCompletionStartTime() {
        return this.completionStartTime;
    }

    @Override
    @JsonProperty(value="model")
    public Optional<String> getModel() {
        return this.model;
    }

    @Override
    @JsonProperty(value="modelParameters")
    public Optional<Map<String, MapValue>> getModelParameters() {
        return this.modelParameters;
    }

    @Override
    @JsonProperty(value="input")
    public Optional<Object> getInput() {
        return this.input;
    }

    @Override
    @JsonProperty(value="version")
    public Optional<String> getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="metadata")
    public Optional<Object> getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="output")
    public Optional<Object> getOutput() {
        return this.output;
    }

    @Override
    @JsonProperty(value="usage")
    public Optional<Usage> getUsage() {
        return this.usage;
    }

    @Override
    @JsonProperty(value="level")
    public ObservationLevel getLevel() {
        return this.level;
    }

    @Override
    @JsonProperty(value="statusMessage")
    public Optional<String> getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    @JsonProperty(value="parentObservationId")
    public Optional<String> getParentObservationId() {
        return this.parentObservationId;
    }

    @Override
    @JsonProperty(value="promptId")
    public Optional<String> getPromptId() {
        return this.promptId;
    }

    @Override
    @JsonProperty(value="usageDetails")
    public Optional<Map<String, Integer>> getUsageDetails() {
        return this.usageDetails;
    }

    @Override
    @JsonProperty(value="costDetails")
    public Optional<Map<String, Double>> getCostDetails() {
        return this.costDetails;
    }

    @Override
    @JsonProperty(value="environment")
    public Optional<String> getEnvironment() {
        return this.environment;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Observation && this.equalTo((Observation)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Observation other) {
        return this.id.equals(other.id) && this.traceId.equals(other.traceId) && this.type.equals(other.type) && this.name.equals(other.name) && this.startTime.equals(other.startTime) && this.endTime.equals(other.endTime) && this.completionStartTime.equals(other.completionStartTime) && this.model.equals(other.model) && this.modelParameters.equals(other.modelParameters) && this.input.equals(other.input) && this.version.equals(other.version) && this.metadata.equals(other.metadata) && this.output.equals(other.output) && this.usage.equals(other.usage) && this.level.equals((Object)other.level) && this.statusMessage.equals(other.statusMessage) && this.parentObservationId.equals(other.parentObservationId) && this.promptId.equals(other.promptId) && this.usageDetails.equals(other.usageDetails) && this.costDetails.equals(other.costDetails) && this.environment.equals(other.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.traceId, this.type, this.name, this.startTime, this.endTime, this.completionStartTime, this.model, this.modelParameters, this.input, this.version, this.metadata, this.output, this.usage, this.level, this.statusMessage, this.parentObservationId, this.promptId, this.usageDetails, this.costDetails, this.environment});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    TypeStage,
    StartTimeStage,
    LevelStage,
    _FinalStage {
        private String id;
        private String type;
        private OffsetDateTime startTime;
        private ObservationLevel level;
        private Optional<String> environment = Optional.empty();
        private Optional<Map<String, Double>> costDetails = Optional.empty();
        private Optional<Map<String, Integer>> usageDetails = Optional.empty();
        private Optional<String> promptId = Optional.empty();
        private Optional<String> parentObservationId = Optional.empty();
        private Optional<String> statusMessage = Optional.empty();
        private Optional<Usage> usage = Optional.empty();
        private Optional<Object> output = Optional.empty();
        private Optional<Object> metadata = Optional.empty();
        private Optional<String> version = Optional.empty();
        private Optional<Object> input = Optional.empty();
        private Optional<Map<String, MapValue>> modelParameters = Optional.empty();
        private Optional<String> model = Optional.empty();
        private Optional<OffsetDateTime> completionStartTime = Optional.empty();
        private Optional<OffsetDateTime> endTime = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> traceId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Observation other) {
            this.id(other.getId());
            this.traceId(other.getTraceId());
            this.type(other.getType());
            this.name(other.getName());
            this.startTime(other.getStartTime());
            this.endTime(other.getEndTime());
            this.completionStartTime(other.getCompletionStartTime());
            this.model(other.getModel());
            this.modelParameters(other.getModelParameters());
            this.input(other.getInput());
            this.version(other.getVersion());
            this.metadata(other.getMetadata());
            this.output(other.getOutput());
            this.usage(other.getUsage());
            this.level(other.getLevel());
            this.statusMessage(other.getStatusMessage());
            this.parentObservationId(other.getParentObservationId());
            this.promptId(other.getPromptId());
            this.usageDetails(other.getUsageDetails());
            this.costDetails(other.getCostDetails());
            this.environment(other.getEnvironment());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public TypeStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public StartTimeStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="startTime")
        public LevelStage startTime(@NotNull OffsetDateTime startTime) {
            this.startTime = Objects.requireNonNull(startTime, "startTime must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="level")
        public _FinalStage level(@NotNull ObservationLevel level) {
            this.level = Objects.requireNonNull(level, "level must not be null");
            return this;
        }

        @Override
        public _FinalStage environment(String environment) {
            this.environment = Optional.ofNullable(environment);
            return this;
        }

        @Override
        @JsonSetter(value="environment", nulls=Nulls.SKIP)
        public _FinalStage environment(Optional<String> environment) {
            this.environment = environment;
            return this;
        }

        @Override
        public _FinalStage costDetails(Map<String, Double> costDetails) {
            this.costDetails = Optional.ofNullable(costDetails);
            return this;
        }

        @Override
        @JsonSetter(value="costDetails", nulls=Nulls.SKIP)
        public _FinalStage costDetails(Optional<Map<String, Double>> costDetails) {
            this.costDetails = costDetails;
            return this;
        }

        @Override
        public _FinalStage usageDetails(Map<String, Integer> usageDetails) {
            this.usageDetails = Optional.ofNullable(usageDetails);
            return this;
        }

        @Override
        @JsonSetter(value="usageDetails", nulls=Nulls.SKIP)
        public _FinalStage usageDetails(Optional<Map<String, Integer>> usageDetails) {
            this.usageDetails = usageDetails;
            return this;
        }

        @Override
        public _FinalStage promptId(String promptId) {
            this.promptId = Optional.ofNullable(promptId);
            return this;
        }

        @Override
        @JsonSetter(value="promptId", nulls=Nulls.SKIP)
        public _FinalStage promptId(Optional<String> promptId) {
            this.promptId = promptId;
            return this;
        }

        @Override
        public _FinalStage parentObservationId(String parentObservationId) {
            this.parentObservationId = Optional.ofNullable(parentObservationId);
            return this;
        }

        @Override
        @JsonSetter(value="parentObservationId", nulls=Nulls.SKIP)
        public _FinalStage parentObservationId(Optional<String> parentObservationId) {
            this.parentObservationId = parentObservationId;
            return this;
        }

        @Override
        public _FinalStage statusMessage(String statusMessage) {
            this.statusMessage = Optional.ofNullable(statusMessage);
            return this;
        }

        @Override
        @JsonSetter(value="statusMessage", nulls=Nulls.SKIP)
        public _FinalStage statusMessage(Optional<String> statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public _FinalStage usage(Usage usage) {
            this.usage = Optional.ofNullable(usage);
            return this;
        }

        @Override
        @JsonSetter(value="usage", nulls=Nulls.SKIP)
        public _FinalStage usage(Optional<Usage> usage) {
            this.usage = usage;
            return this;
        }

        @Override
        public _FinalStage output(Object output) {
            this.output = Optional.ofNullable(output);
            return this;
        }

        @Override
        @JsonSetter(value="output", nulls=Nulls.SKIP)
        public _FinalStage output(Optional<Object> output) {
            this.output = output;
            return this;
        }

        @Override
        public _FinalStage metadata(Object metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @Override
        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public _FinalStage metadata(Optional<Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public _FinalStage version(String version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @Override
        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public _FinalStage version(Optional<String> version) {
            this.version = version;
            return this;
        }

        @Override
        public _FinalStage input(Object input) {
            this.input = Optional.ofNullable(input);
            return this;
        }

        @Override
        @JsonSetter(value="input", nulls=Nulls.SKIP)
        public _FinalStage input(Optional<Object> input) {
            this.input = input;
            return this;
        }

        @Override
        public _FinalStage modelParameters(Map<String, MapValue> modelParameters) {
            this.modelParameters = Optional.ofNullable(modelParameters);
            return this;
        }

        @Override
        @JsonSetter(value="modelParameters", nulls=Nulls.SKIP)
        public _FinalStage modelParameters(Optional<Map<String, MapValue>> modelParameters) {
            this.modelParameters = modelParameters;
            return this;
        }

        @Override
        public _FinalStage model(String model) {
            this.model = Optional.ofNullable(model);
            return this;
        }

        @Override
        @JsonSetter(value="model", nulls=Nulls.SKIP)
        public _FinalStage model(Optional<String> model) {
            this.model = model;
            return this;
        }

        @Override
        public _FinalStage completionStartTime(OffsetDateTime completionStartTime) {
            this.completionStartTime = Optional.ofNullable(completionStartTime);
            return this;
        }

        @Override
        @JsonSetter(value="completionStartTime", nulls=Nulls.SKIP)
        public _FinalStage completionStartTime(Optional<OffsetDateTime> completionStartTime) {
            this.completionStartTime = completionStartTime;
            return this;
        }

        @Override
        public _FinalStage endTime(OffsetDateTime endTime) {
            this.endTime = Optional.ofNullable(endTime);
            return this;
        }

        @Override
        @JsonSetter(value="endTime", nulls=Nulls.SKIP)
        public _FinalStage endTime(Optional<OffsetDateTime> endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public _FinalStage traceId(String traceId) {
            this.traceId = Optional.ofNullable(traceId);
            return this;
        }

        @Override
        @JsonSetter(value="traceId", nulls=Nulls.SKIP)
        public _FinalStage traceId(Optional<String> traceId) {
            this.traceId = traceId;
            return this;
        }

        @Override
        public Observation build() {
            return new Observation(this.id, this.traceId, this.type, this.name, this.startTime, this.endTime, this.completionStartTime, this.model, this.modelParameters, this.input, this.version, this.metadata, this.output, this.usage, this.level, this.statusMessage, this.parentObservationId, this.promptId, this.usageDetails, this.costDetails, this.environment, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Observation build();

        public _FinalStage traceId(Optional<String> var1);

        public _FinalStage traceId(String var1);

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage endTime(Optional<OffsetDateTime> var1);

        public _FinalStage endTime(OffsetDateTime var1);

        public _FinalStage completionStartTime(Optional<OffsetDateTime> var1);

        public _FinalStage completionStartTime(OffsetDateTime var1);

        public _FinalStage model(Optional<String> var1);

        public _FinalStage model(String var1);

        public _FinalStage modelParameters(Optional<Map<String, MapValue>> var1);

        public _FinalStage modelParameters(Map<String, MapValue> var1);

        public _FinalStage input(Optional<Object> var1);

        public _FinalStage input(Object var1);

        public _FinalStage version(Optional<String> var1);

        public _FinalStage version(String var1);

        public _FinalStage metadata(Optional<Object> var1);

        public _FinalStage metadata(Object var1);

        public _FinalStage output(Optional<Object> var1);

        public _FinalStage output(Object var1);

        public _FinalStage usage(Optional<Usage> var1);

        public _FinalStage usage(Usage var1);

        public _FinalStage statusMessage(Optional<String> var1);

        public _FinalStage statusMessage(String var1);

        public _FinalStage parentObservationId(Optional<String> var1);

        public _FinalStage parentObservationId(String var1);

        public _FinalStage promptId(Optional<String> var1);

        public _FinalStage promptId(String var1);

        public _FinalStage usageDetails(Optional<Map<String, Integer>> var1);

        public _FinalStage usageDetails(Map<String, Integer> var1);

        public _FinalStage costDetails(Optional<Map<String, Double>> var1);

        public _FinalStage costDetails(Map<String, Double> var1);

        public _FinalStage environment(Optional<String> var1);

        public _FinalStage environment(String var1);
    }

    public static interface LevelStage {
        public _FinalStage level(@NotNull ObservationLevel var1);
    }

    public static interface StartTimeStage {
        public LevelStage startTime(@NotNull OffsetDateTime var1);
    }

    public static interface TypeStage {
        public StartTimeStage type(@NotNull String var1);
    }

    public static interface IdStage {
        public TypeStage id(@NotNull String var1);

        public Builder from(Observation var1);
    }
}

