/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.commons.types.ConfigCategory;
import com.langfuse.client.resources.commons.types.ScoreDataType;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ScoreConfig {
    private final String id;
    private final String name;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    private final String projectId;
    private final ScoreDataType dataType;
    private final boolean isArchived;
    private final Optional<Double> minValue;
    private final Optional<Double> maxValue;
    private final Optional<List<ConfigCategory>> categories;
    private final Optional<String> description;
    private final Map<String, Object> additionalProperties;

    private ScoreConfig(String id, String name, OffsetDateTime createdAt, OffsetDateTime updatedAt, String projectId, ScoreDataType dataType, boolean isArchived, Optional<Double> minValue, Optional<Double> maxValue, Optional<List<ConfigCategory>> categories, Optional<String> description, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.projectId = projectId;
        this.dataType = dataType;
        this.isArchived = isArchived;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.categories = categories;
        this.description = description;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="createdAt")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updatedAt")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="projectId")
    public String getProjectId() {
        return this.projectId;
    }

    @JsonProperty(value="dataType")
    public ScoreDataType getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="isArchived")
    public boolean getIsArchived() {
        return this.isArchived;
    }

    @JsonProperty(value="minValue")
    public Optional<Double> getMinValue() {
        return this.minValue;
    }

    @JsonProperty(value="maxValue")
    public Optional<Double> getMaxValue() {
        return this.maxValue;
    }

    @JsonProperty(value="categories")
    public Optional<List<ConfigCategory>> getCategories() {
        return this.categories;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ScoreConfig && this.equalTo((ScoreConfig)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ScoreConfig other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.projectId.equals(other.projectId) && this.dataType.equals((Object)other.dataType) && this.isArchived == other.isArchived && this.minValue.equals(other.minValue) && this.maxValue.equals(other.maxValue) && this.categories.equals(other.categories) && this.description.equals(other.description);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.createdAt, this.updatedAt, this.projectId, this.dataType, this.isArchived, this.minValue, this.maxValue, this.categories, this.description});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    CreatedAtStage,
    UpdatedAtStage,
    ProjectIdStage,
    DataTypeStage,
    IsArchivedStage,
    _FinalStage {
        private String id;
        private String name;
        private OffsetDateTime createdAt;
        private OffsetDateTime updatedAt;
        private String projectId;
        private ScoreDataType dataType;
        private boolean isArchived;
        private Optional<String> description = Optional.empty();
        private Optional<List<ConfigCategory>> categories = Optional.empty();
        private Optional<Double> maxValue = Optional.empty();
        private Optional<Double> minValue = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ScoreConfig other) {
            this.id(other.getId());
            this.name(other.getName());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.projectId(other.getProjectId());
            this.dataType(other.getDataType());
            this.isArchived(other.getIsArchived());
            this.minValue(other.getMinValue());
            this.maxValue(other.getMaxValue());
            this.categories(other.getCategories());
            this.description(other.getDescription());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public CreatedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="createdAt")
        public UpdatedAtStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updatedAt")
        public ProjectIdStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="projectId")
        public DataTypeStage projectId(@NotNull String projectId) {
            this.projectId = Objects.requireNonNull(projectId, "projectId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="dataType")
        public IsArchivedStage dataType(@NotNull ScoreDataType dataType) {
            this.dataType = Objects.requireNonNull(dataType, "dataType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="isArchived")
        public _FinalStage isArchived(boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public _FinalStage categories(List<ConfigCategory> categories) {
            this.categories = Optional.ofNullable(categories);
            return this;
        }

        @Override
        @JsonSetter(value="categories", nulls=Nulls.SKIP)
        public _FinalStage categories(Optional<List<ConfigCategory>> categories) {
            this.categories = categories;
            return this;
        }

        @Override
        public _FinalStage maxValue(Double maxValue) {
            this.maxValue = Optional.ofNullable(maxValue);
            return this;
        }

        @Override
        @JsonSetter(value="maxValue", nulls=Nulls.SKIP)
        public _FinalStage maxValue(Optional<Double> maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        @Override
        public _FinalStage minValue(Double minValue) {
            this.minValue = Optional.ofNullable(minValue);
            return this;
        }

        @Override
        @JsonSetter(value="minValue", nulls=Nulls.SKIP)
        public _FinalStage minValue(Optional<Double> minValue) {
            this.minValue = minValue;
            return this;
        }

        @Override
        public ScoreConfig build() {
            return new ScoreConfig(this.id, this.name, this.createdAt, this.updatedAt, this.projectId, this.dataType, this.isArchived, this.minValue, this.maxValue, this.categories, this.description, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ScoreConfig build();

        public _FinalStage minValue(Optional<Double> var1);

        public _FinalStage minValue(Double var1);

        public _FinalStage maxValue(Optional<Double> var1);

        public _FinalStage maxValue(Double var1);

        public _FinalStage categories(Optional<List<ConfigCategory>> var1);

        public _FinalStage categories(List<ConfigCategory> var1);

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);
    }

    public static interface IsArchivedStage {
        public _FinalStage isArchived(boolean var1);
    }

    public static interface DataTypeStage {
        public IsArchivedStage dataType(@NotNull ScoreDataType var1);
    }

    public static interface ProjectIdStage {
        public DataTypeStage projectId(@NotNull String var1);
    }

    public static interface UpdatedAtStage {
        public ProjectIdStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface CreatedAtStage {
        public UpdatedAtStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface NameStage {
        public CreatedAtStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);

        public Builder from(ScoreConfig var1);
    }
}

