/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.commons.types.ISession;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Session
implements ISession {
    private final String id;
    private final OffsetDateTime createdAt;
    private final String projectId;
    private final Optional<String> environment;
    private final Map<String, Object> additionalProperties;

    private Session(String id, OffsetDateTime createdAt, String projectId, Optional<String> environment, Map<String, Object> additionalProperties) {
        this.id = id;
        this.createdAt = createdAt;
        this.projectId = projectId;
        this.environment = environment;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="createdAt")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="projectId")
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    @JsonProperty(value="environment")
    public Optional<String> getEnvironment() {
        return this.environment;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Session && this.equalTo((Session)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Session other) {
        return this.id.equals(other.id) && this.createdAt.equals(other.createdAt) && this.projectId.equals(other.projectId) && this.environment.equals(other.environment);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.projectId, this.environment);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    CreatedAtStage,
    ProjectIdStage,
    _FinalStage {
        private String id;
        private OffsetDateTime createdAt;
        private String projectId;
        private Optional<String> environment = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Session other) {
            this.id(other.getId());
            this.createdAt(other.getCreatedAt());
            this.projectId(other.getProjectId());
            this.environment(other.getEnvironment());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public CreatedAtStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="createdAt")
        public ProjectIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="projectId")
        public _FinalStage projectId(@NotNull String projectId) {
            this.projectId = Objects.requireNonNull(projectId, "projectId must not be null");
            return this;
        }

        @Override
        public _FinalStage environment(String environment) {
            this.environment = Optional.ofNullable(environment);
            return this;
        }

        @Override
        @JsonSetter(value="environment", nulls=Nulls.SKIP)
        public _FinalStage environment(Optional<String> environment) {
            this.environment = environment;
            return this;
        }

        @Override
        public Session build() {
            return new Session(this.id, this.createdAt, this.projectId, this.environment, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Session build();

        public _FinalStage environment(Optional<String> var1);

        public _FinalStage environment(String var1);
    }

    public static interface ProjectIdStage {
        public _FinalStage projectId(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public ProjectIdStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface IdStage {
        public CreatedAtStage id(@NotNull String var1);

        public Builder from(Session var1);
    }
}

