/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.datasetitems.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetDatasetItemsRequest {
    private final Optional<String> datasetName;
    private final Optional<String> sourceTraceId;
    private final Optional<String> sourceObservationId;
    private final Optional<Integer> page;
    private final Optional<Integer> limit;
    private final Map<String, Object> additionalProperties;

    private GetDatasetItemsRequest(Optional<String> datasetName, Optional<String> sourceTraceId, Optional<String> sourceObservationId, Optional<Integer> page, Optional<Integer> limit, Map<String, Object> additionalProperties) {
        this.datasetName = datasetName;
        this.sourceTraceId = sourceTraceId;
        this.sourceObservationId = sourceObservationId;
        this.page = page;
        this.limit = limit;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="datasetName")
    public Optional<String> getDatasetName() {
        return this.datasetName;
    }

    @JsonProperty(value="sourceTraceId")
    public Optional<String> getSourceTraceId() {
        return this.sourceTraceId;
    }

    @JsonProperty(value="sourceObservationId")
    public Optional<String> getSourceObservationId() {
        return this.sourceObservationId;
    }

    @JsonProperty(value="page")
    public Optional<Integer> getPage() {
        return this.page;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetDatasetItemsRequest && this.equalTo((GetDatasetItemsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetDatasetItemsRequest other) {
        return this.datasetName.equals(other.datasetName) && this.sourceTraceId.equals(other.sourceTraceId) && this.sourceObservationId.equals(other.sourceObservationId) && this.page.equals(other.page) && this.limit.equals(other.limit);
    }

    public int hashCode() {
        return Objects.hash(this.datasetName, this.sourceTraceId, this.sourceObservationId, this.page, this.limit);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> datasetName = Optional.empty();
        private Optional<String> sourceTraceId = Optional.empty();
        private Optional<String> sourceObservationId = Optional.empty();
        private Optional<Integer> page = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetDatasetItemsRequest other) {
            this.datasetName(other.getDatasetName());
            this.sourceTraceId(other.getSourceTraceId());
            this.sourceObservationId(other.getSourceObservationId());
            this.page(other.getPage());
            this.limit(other.getLimit());
            return this;
        }

        @JsonSetter(value="datasetName", nulls=Nulls.SKIP)
        public Builder datasetName(Optional<String> datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public Builder datasetName(String datasetName) {
            this.datasetName = Optional.ofNullable(datasetName);
            return this;
        }

        @JsonSetter(value="sourceTraceId", nulls=Nulls.SKIP)
        public Builder sourceTraceId(Optional<String> sourceTraceId) {
            this.sourceTraceId = sourceTraceId;
            return this;
        }

        public Builder sourceTraceId(String sourceTraceId) {
            this.sourceTraceId = Optional.ofNullable(sourceTraceId);
            return this;
        }

        @JsonSetter(value="sourceObservationId", nulls=Nulls.SKIP)
        public Builder sourceObservationId(Optional<String> sourceObservationId) {
            this.sourceObservationId = sourceObservationId;
            return this;
        }

        public Builder sourceObservationId(String sourceObservationId) {
            this.sourceObservationId = Optional.ofNullable(sourceObservationId);
            return this;
        }

        @JsonSetter(value="page", nulls=Nulls.SKIP)
        public Builder page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        public Builder page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public GetDatasetItemsRequest build() {
            return new GetDatasetItemsRequest(this.datasetName, this.sourceTraceId, this.sourceObservationId, this.page, this.limit, this.additionalProperties);
        }
    }
}

