/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.ingestion.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class IngestionError {
    private final String id;
    private final int status;
    private final Optional<String> message;
    private final Optional<Object> error;
    private final Map<String, Object> additionalProperties;

    private IngestionError(String id, int status, Optional<String> message, Optional<Object> error, Map<String, Object> additionalProperties) {
        this.id = id;
        this.status = status;
        this.message = message;
        this.error = error;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="status")
    public int getStatus() {
        return this.status;
    }

    @JsonProperty(value="message")
    public Optional<String> getMessage() {
        return this.message;
    }

    @JsonProperty(value="error")
    public Optional<Object> getError() {
        return this.error;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof IngestionError && this.equalTo((IngestionError)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(IngestionError other) {
        return this.id.equals(other.id) && this.status == other.status && this.message.equals(other.message) && this.error.equals(other.error);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.status, this.message, this.error);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    StatusStage,
    _FinalStage {
        private String id;
        private int status;
        private Optional<Object> error = Optional.empty();
        private Optional<String> message = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(IngestionError other) {
            this.id(other.getId());
            this.status(other.getStatus());
            this.message(other.getMessage());
            this.error(other.getError());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public StatusStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public _FinalStage status(int status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage error(Object error) {
            this.error = Optional.ofNullable(error);
            return this;
        }

        @Override
        @JsonSetter(value="error", nulls=Nulls.SKIP)
        public _FinalStage error(Optional<Object> error) {
            this.error = error;
            return this;
        }

        @Override
        public _FinalStage message(String message) {
            this.message = Optional.ofNullable(message);
            return this;
        }

        @Override
        @JsonSetter(value="message", nulls=Nulls.SKIP)
        public _FinalStage message(Optional<String> message) {
            this.message = message;
            return this;
        }

        @Override
        public IngestionError build() {
            return new IngestionError(this.id, this.status, this.message, this.error, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public IngestionError build();

        public _FinalStage message(Optional<String> var1);

        public _FinalStage message(String var1);

        public _FinalStage error(Optional<Object> var1);

        public _FinalStage error(Object var1);
    }

    public static interface StatusStage {
        public _FinalStage status(int var1);
    }

    public static interface IdStage {
        public StatusStage id(@NotNull String var1);

        public Builder from(IngestionError var1);
    }
}

