/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.ingestion.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class IngestionSuccess {
    private final String id;
    private final int status;
    private final Map<String, Object> additionalProperties;

    private IngestionSuccess(String id, int status, Map<String, Object> additionalProperties) {
        this.id = id;
        this.status = status;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="status")
    public int getStatus() {
        return this.status;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof IngestionSuccess && this.equalTo((IngestionSuccess)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(IngestionSuccess other) {
        return this.id.equals(other.id) && this.status == other.status;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.status);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    StatusStage,
    _FinalStage {
        private String id;
        private int status;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(IngestionSuccess other) {
            this.id(other.getId());
            this.status(other.getStatus());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public StatusStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public _FinalStage status(int status) {
            this.status = status;
            return this;
        }

        @Override
        public IngestionSuccess build() {
            return new IngestionSuccess(this.id, this.status, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public IngestionSuccess build();
    }

    public static interface StatusStage {
        public _FinalStage status(int var1);
    }

    public static interface IdStage {
        public StatusStage id(@NotNull String var1);

        public Builder from(IngestionSuccess var1);
    }
}

