/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.ingestion.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OpenAiUsage {
    private final Optional<Integer> promptTokens;
    private final Optional<Integer> completionTokens;
    private final Optional<Integer> totalTokens;
    private final Map<String, Object> additionalProperties;

    private OpenAiUsage(Optional<Integer> promptTokens, Optional<Integer> completionTokens, Optional<Integer> totalTokens, Map<String, Object> additionalProperties) {
        this.promptTokens = promptTokens;
        this.completionTokens = completionTokens;
        this.totalTokens = totalTokens;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="promptTokens")
    public Optional<Integer> getPromptTokens() {
        return this.promptTokens;
    }

    @JsonProperty(value="completionTokens")
    public Optional<Integer> getCompletionTokens() {
        return this.completionTokens;
    }

    @JsonProperty(value="totalTokens")
    public Optional<Integer> getTotalTokens() {
        return this.totalTokens;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OpenAiUsage && this.equalTo((OpenAiUsage)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OpenAiUsage other) {
        return this.promptTokens.equals(other.promptTokens) && this.completionTokens.equals(other.completionTokens) && this.totalTokens.equals(other.totalTokens);
    }

    public int hashCode() {
        return Objects.hash(this.promptTokens, this.completionTokens, this.totalTokens);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> promptTokens = Optional.empty();
        private Optional<Integer> completionTokens = Optional.empty();
        private Optional<Integer> totalTokens = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(OpenAiUsage other) {
            this.promptTokens(other.getPromptTokens());
            this.completionTokens(other.getCompletionTokens());
            this.totalTokens(other.getTotalTokens());
            return this;
        }

        @JsonSetter(value="promptTokens", nulls=Nulls.SKIP)
        public Builder promptTokens(Optional<Integer> promptTokens) {
            this.promptTokens = promptTokens;
            return this;
        }

        public Builder promptTokens(Integer promptTokens) {
            this.promptTokens = Optional.ofNullable(promptTokens);
            return this;
        }

        @JsonSetter(value="completionTokens", nulls=Nulls.SKIP)
        public Builder completionTokens(Optional<Integer> completionTokens) {
            this.completionTokens = completionTokens;
            return this;
        }

        public Builder completionTokens(Integer completionTokens) {
            this.completionTokens = Optional.ofNullable(completionTokens);
            return this;
        }

        @JsonSetter(value="totalTokens", nulls=Nulls.SKIP)
        public Builder totalTokens(Optional<Integer> totalTokens) {
            this.totalTokens = totalTokens;
            return this;
        }

        public Builder totalTokens(Integer totalTokens) {
            this.totalTokens = Optional.ofNullable(totalTokens);
            return this;
        }

        public OpenAiUsage build() {
            return new OpenAiUsage(this.promptTokens, this.completionTokens, this.totalTokens, this.additionalProperties);
        }
    }
}

