/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.ingestion.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.commons.types.CreateScoreValue;
import com.langfuse.client.resources.commons.types.ScoreDataType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ScoreBody {
    private final Optional<String> id;
    private final String traceId;
    private final String name;
    private final Optional<String> environment;
    private final CreateScoreValue value;
    private final Optional<String> observationId;
    private final Optional<String> comment;
    private final Optional<ScoreDataType> dataType;
    private final Optional<String> configId;
    private final Map<String, Object> additionalProperties;

    private ScoreBody(Optional<String> id, String traceId, String name, Optional<String> environment, CreateScoreValue value, Optional<String> observationId, Optional<String> comment, Optional<ScoreDataType> dataType, Optional<String> configId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.traceId = traceId;
        this.name = name;
        this.environment = environment;
        this.value = value;
        this.observationId = observationId;
        this.comment = comment;
        this.dataType = dataType;
        this.configId = configId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="traceId")
    public String getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="environment")
    public Optional<String> getEnvironment() {
        return this.environment;
    }

    @JsonProperty(value="value")
    public CreateScoreValue getValue() {
        return this.value;
    }

    @JsonProperty(value="observationId")
    public Optional<String> getObservationId() {
        return this.observationId;
    }

    @JsonProperty(value="comment")
    public Optional<String> getComment() {
        return this.comment;
    }

    @JsonProperty(value="dataType")
    public Optional<ScoreDataType> getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="configId")
    public Optional<String> getConfigId() {
        return this.configId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ScoreBody && this.equalTo((ScoreBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ScoreBody other) {
        return this.id.equals(other.id) && this.traceId.equals(other.traceId) && this.name.equals(other.name) && this.environment.equals(other.environment) && this.value.equals(other.value) && this.observationId.equals(other.observationId) && this.comment.equals(other.comment) && this.dataType.equals(other.dataType) && this.configId.equals(other.configId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.traceId, this.name, this.environment, this.value, this.observationId, this.comment, this.dataType, this.configId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TraceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TraceIdStage,
    NameStage,
    ValueStage,
    _FinalStage {
        private String traceId;
        private String name;
        private CreateScoreValue value;
        private Optional<String> configId = Optional.empty();
        private Optional<ScoreDataType> dataType = Optional.empty();
        private Optional<String> comment = Optional.empty();
        private Optional<String> observationId = Optional.empty();
        private Optional<String> environment = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ScoreBody other) {
            this.id(other.getId());
            this.traceId(other.getTraceId());
            this.name(other.getName());
            this.environment(other.getEnvironment());
            this.value(other.getValue());
            this.observationId(other.getObservationId());
            this.comment(other.getComment());
            this.dataType(other.getDataType());
            this.configId(other.getConfigId());
            return this;
        }

        @Override
        @JsonSetter(value="traceId")
        public NameStage traceId(@NotNull String traceId) {
            this.traceId = Objects.requireNonNull(traceId, "traceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public ValueStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="value")
        public _FinalStage value(@NotNull CreateScoreValue value) {
            this.value = Objects.requireNonNull(value, "value must not be null");
            return this;
        }

        @Override
        public _FinalStage configId(String configId) {
            this.configId = Optional.ofNullable(configId);
            return this;
        }

        @Override
        @JsonSetter(value="configId", nulls=Nulls.SKIP)
        public _FinalStage configId(Optional<String> configId) {
            this.configId = configId;
            return this;
        }

        @Override
        public _FinalStage dataType(ScoreDataType dataType) {
            this.dataType = Optional.ofNullable(dataType);
            return this;
        }

        @Override
        @JsonSetter(value="dataType", nulls=Nulls.SKIP)
        public _FinalStage dataType(Optional<ScoreDataType> dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public _FinalStage comment(String comment) {
            this.comment = Optional.ofNullable(comment);
            return this;
        }

        @Override
        @JsonSetter(value="comment", nulls=Nulls.SKIP)
        public _FinalStage comment(Optional<String> comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public _FinalStage observationId(String observationId) {
            this.observationId = Optional.ofNullable(observationId);
            return this;
        }

        @Override
        @JsonSetter(value="observationId", nulls=Nulls.SKIP)
        public _FinalStage observationId(Optional<String> observationId) {
            this.observationId = observationId;
            return this;
        }

        @Override
        public _FinalStage environment(String environment) {
            this.environment = Optional.ofNullable(environment);
            return this;
        }

        @Override
        @JsonSetter(value="environment", nulls=Nulls.SKIP)
        public _FinalStage environment(Optional<String> environment) {
            this.environment = environment;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public ScoreBody build() {
            return new ScoreBody(this.id, this.traceId, this.name, this.environment, this.value, this.observationId, this.comment, this.dataType, this.configId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ScoreBody build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage environment(Optional<String> var1);

        public _FinalStage environment(String var1);

        public _FinalStage observationId(Optional<String> var1);

        public _FinalStage observationId(String var1);

        public _FinalStage comment(Optional<String> var1);

        public _FinalStage comment(String var1);

        public _FinalStage dataType(Optional<ScoreDataType> var1);

        public _FinalStage dataType(ScoreDataType var1);

        public _FinalStage configId(Optional<String> var1);

        public _FinalStage configId(String var1);
    }

    public static interface ValueStage {
        public _FinalStage value(@NotNull CreateScoreValue var1);
    }

    public static interface NameStage {
        public ValueStage name(@NotNull String var1);
    }

    public static interface TraceIdStage {
        public NameStage traceId(@NotNull String var1);

        public Builder from(ScoreBody var1);
    }
}

