/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.ingestion.types;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.ingestion.types.OpenAiUsageSchema;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public final class UsageDetails {
    private final Object value;
    private final int type;

    private UsageDetails(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((Map)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((OpenAiUsageSchema)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UsageDetails && this.equalTo((UsageDetails)other);
    }

    private boolean equalTo(UsageDetails other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static UsageDetails of(Map<String, Integer> value) {
        return new UsageDetails(value, 0);
    }

    public static UsageDetails of(OpenAiUsageSchema value) {
        return new UsageDetails(value, 1);
    }

    public static interface Visitor<T> {
        public T visit(Map<String, Integer> var1);

        public T visit(OpenAiUsageSchema var1);
    }

    static final class Deserializer
    extends StdDeserializer<UsageDetails> {
        Deserializer() {
            super(UsageDetails.class);
        }

        public UsageDetails deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return UsageDetails.of((Map)ObjectMappers.JSON_MAPPER.convertValue(value, (TypeReference)new TypeReference<Map<String, Integer>>(){}));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return UsageDetails.of((OpenAiUsageSchema)ObjectMappers.JSON_MAPPER.convertValue(value, OpenAiUsageSchema.class));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    throw new JsonParseException(p, "Failed to deserialize");
                }
            }
        }
    }
}

