/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.media.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetMediaResponse {
    private final String mediaId;
    private final String contentType;
    private final int contentLength;
    private final OffsetDateTime uploadedAt;
    private final String url;
    private final String urlExpiry;
    private final Map<String, Object> additionalProperties;

    private GetMediaResponse(String mediaId, String contentType, int contentLength, OffsetDateTime uploadedAt, String url, String urlExpiry, Map<String, Object> additionalProperties) {
        this.mediaId = mediaId;
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.uploadedAt = uploadedAt;
        this.url = url;
        this.urlExpiry = urlExpiry;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="mediaId")
    public String getMediaId() {
        return this.mediaId;
    }

    @JsonProperty(value="contentType")
    public String getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="contentLength")
    public int getContentLength() {
        return this.contentLength;
    }

    @JsonProperty(value="uploadedAt")
    public OffsetDateTime getUploadedAt() {
        return this.uploadedAt;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="urlExpiry")
    public String getUrlExpiry() {
        return this.urlExpiry;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetMediaResponse && this.equalTo((GetMediaResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetMediaResponse other) {
        return this.mediaId.equals(other.mediaId) && this.contentType.equals(other.contentType) && this.contentLength == other.contentLength && this.uploadedAt.equals(other.uploadedAt) && this.url.equals(other.url) && this.urlExpiry.equals(other.urlExpiry);
    }

    public int hashCode() {
        return Objects.hash(this.mediaId, this.contentType, this.contentLength, this.uploadedAt, this.url, this.urlExpiry);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MediaIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements MediaIdStage,
    ContentTypeStage,
    ContentLengthStage,
    UploadedAtStage,
    UrlStage,
    UrlExpiryStage,
    _FinalStage {
        private String mediaId;
        private String contentType;
        private int contentLength;
        private OffsetDateTime uploadedAt;
        private String url;
        private String urlExpiry;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GetMediaResponse other) {
            this.mediaId(other.getMediaId());
            this.contentType(other.getContentType());
            this.contentLength(other.getContentLength());
            this.uploadedAt(other.getUploadedAt());
            this.url(other.getUrl());
            this.urlExpiry(other.getUrlExpiry());
            return this;
        }

        @Override
        @JsonSetter(value="mediaId")
        public ContentTypeStage mediaId(@NotNull String mediaId) {
            this.mediaId = Objects.requireNonNull(mediaId, "mediaId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="contentType")
        public ContentLengthStage contentType(@NotNull String contentType) {
            this.contentType = Objects.requireNonNull(contentType, "contentType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="contentLength")
        public UploadedAtStage contentLength(int contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        @Override
        @JsonSetter(value="uploadedAt")
        public UrlStage uploadedAt(@NotNull OffsetDateTime uploadedAt) {
            this.uploadedAt = Objects.requireNonNull(uploadedAt, "uploadedAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public UrlExpiryStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="urlExpiry")
        public _FinalStage urlExpiry(@NotNull String urlExpiry) {
            this.urlExpiry = Objects.requireNonNull(urlExpiry, "urlExpiry must not be null");
            return this;
        }

        @Override
        public GetMediaResponse build() {
            return new GetMediaResponse(this.mediaId, this.contentType, this.contentLength, this.uploadedAt, this.url, this.urlExpiry, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GetMediaResponse build();
    }

    public static interface UrlExpiryStage {
        public _FinalStage urlExpiry(@NotNull String var1);
    }

    public static interface UrlStage {
        public UrlExpiryStage url(@NotNull String var1);
    }

    public static interface UploadedAtStage {
        public UrlStage uploadedAt(@NotNull OffsetDateTime var1);
    }

    public static interface ContentLengthStage {
        public UploadedAtStage contentLength(int var1);
    }

    public static interface ContentTypeStage {
        public ContentLengthStage contentType(@NotNull String var1);
    }

    public static interface MediaIdStage {
        public ContentTypeStage mediaId(@NotNull String var1);

        public Builder from(GetMediaResponse var1);
    }
}

