/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.media.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetMediaUploadUrlResponse {
    private final Optional<String> uploadUrl;
    private final String mediaId;
    private final Map<String, Object> additionalProperties;

    private GetMediaUploadUrlResponse(Optional<String> uploadUrl, String mediaId, Map<String, Object> additionalProperties) {
        this.uploadUrl = uploadUrl;
        this.mediaId = mediaId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="uploadUrl")
    public Optional<String> getUploadUrl() {
        return this.uploadUrl;
    }

    @JsonProperty(value="mediaId")
    public String getMediaId() {
        return this.mediaId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetMediaUploadUrlResponse && this.equalTo((GetMediaUploadUrlResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetMediaUploadUrlResponse other) {
        return this.uploadUrl.equals(other.uploadUrl) && this.mediaId.equals(other.mediaId);
    }

    public int hashCode() {
        return Objects.hash(this.uploadUrl, this.mediaId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MediaIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements MediaIdStage,
    _FinalStage {
        private String mediaId;
        private Optional<String> uploadUrl = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GetMediaUploadUrlResponse other) {
            this.uploadUrl(other.getUploadUrl());
            this.mediaId(other.getMediaId());
            return this;
        }

        @Override
        @JsonSetter(value="mediaId")
        public _FinalStage mediaId(@NotNull String mediaId) {
            this.mediaId = Objects.requireNonNull(mediaId, "mediaId must not be null");
            return this;
        }

        @Override
        public _FinalStage uploadUrl(String uploadUrl) {
            this.uploadUrl = Optional.ofNullable(uploadUrl);
            return this;
        }

        @Override
        @JsonSetter(value="uploadUrl", nulls=Nulls.SKIP)
        public _FinalStage uploadUrl(Optional<String> uploadUrl) {
            this.uploadUrl = uploadUrl;
            return this;
        }

        @Override
        public GetMediaUploadUrlResponse build() {
            return new GetMediaUploadUrlResponse(this.uploadUrl, this.mediaId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GetMediaUploadUrlResponse build();

        public _FinalStage uploadUrl(Optional<String> var1);

        public _FinalStage uploadUrl(String var1);
    }

    public static interface MediaIdStage {
        public _FinalStage mediaId(@NotNull String var1);

        public Builder from(GetMediaUploadUrlResponse var1);
    }
}

