/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.metrics;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.langfuse.client.core.ClientOptions;
import com.langfuse.client.core.LangfuseClientApiException;
import com.langfuse.client.core.LangfuseClientException;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.core.QueryStringMapper;
import com.langfuse.client.core.RequestOptions;
import com.langfuse.client.resources.commons.errors.AccessDeniedError;
import com.langfuse.client.resources.commons.errors.Error;
import com.langfuse.client.resources.commons.errors.MethodNotAllowedError;
import com.langfuse.client.resources.commons.errors.NotFoundError;
import com.langfuse.client.resources.commons.errors.UnauthorizedError;
import com.langfuse.client.resources.metrics.requests.GetDailyMetricsRequest;
import com.langfuse.client.resources.metrics.types.DailyMetrics;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class MetricsClient {
    protected final ClientOptions clientOptions;

    public MetricsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public DailyMetrics daily() {
        return this.daily(GetDailyMetricsRequest.builder().build());
    }

    public DailyMetrics daily(GetDailyMetricsRequest request) {
        return this.daily(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DailyMetrics daily(GetDailyMetricsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/public").addPathSegments("metrics/daily");
        if (request.getPage().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "page", request.getPage().get().toString(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get().toString(), false);
        }
        if (request.getTraceName().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "traceName", request.getTraceName().get(), false);
        }
        if (request.getUserId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "userId", request.getUserId().get(), false);
        }
        if (request.getTags().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "tags", request.getTags().get(), false);
        }
        if (request.getEnvironment().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "environment", request.getEnvironment().get(), false);
        }
        if (request.getFromTimestamp().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "fromTimestamp", request.getFromTimestamp().get().toString(), false);
        }
        if (request.getToTimestamp().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "toTimestamp", request.getToTimestamp().get().toString(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                DailyMetrics dailyMetrics = (DailyMetrics)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DailyMetrics.class);
                return dailyMetrics;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new Error(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new UnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new AccessDeniedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 405: {
                        throw new MethodNotAllowedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new LangfuseClientApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new LangfuseClientApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new LangfuseClientException("Network error executing HTTP request", e);
        }
    }
}

