/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.metrics.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetDailyMetricsRequest {
    private final Optional<Integer> page;
    private final Optional<Integer> limit;
    private final Optional<String> traceName;
    private final Optional<String> userId;
    private final Optional<String> tags;
    private final Optional<String> environment;
    private final Optional<OffsetDateTime> fromTimestamp;
    private final Optional<OffsetDateTime> toTimestamp;
    private final Map<String, Object> additionalProperties;

    private GetDailyMetricsRequest(Optional<Integer> page, Optional<Integer> limit, Optional<String> traceName, Optional<String> userId, Optional<String> tags, Optional<String> environment, Optional<OffsetDateTime> fromTimestamp, Optional<OffsetDateTime> toTimestamp, Map<String, Object> additionalProperties) {
        this.page = page;
        this.limit = limit;
        this.traceName = traceName;
        this.userId = userId;
        this.tags = tags;
        this.environment = environment;
        this.fromTimestamp = fromTimestamp;
        this.toTimestamp = toTimestamp;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="page")
    public Optional<Integer> getPage() {
        return this.page;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="traceName")
    public Optional<String> getTraceName() {
        return this.traceName;
    }

    @JsonProperty(value="userId")
    public Optional<String> getUserId() {
        return this.userId;
    }

    @JsonProperty(value="tags")
    public Optional<String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="environment")
    public Optional<String> getEnvironment() {
        return this.environment;
    }

    @JsonProperty(value="fromTimestamp")
    public Optional<OffsetDateTime> getFromTimestamp() {
        return this.fromTimestamp;
    }

    @JsonProperty(value="toTimestamp")
    public Optional<OffsetDateTime> getToTimestamp() {
        return this.toTimestamp;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetDailyMetricsRequest && this.equalTo((GetDailyMetricsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetDailyMetricsRequest other) {
        return this.page.equals(other.page) && this.limit.equals(other.limit) && this.traceName.equals(other.traceName) && this.userId.equals(other.userId) && this.tags.equals(other.tags) && this.environment.equals(other.environment) && this.fromTimestamp.equals(other.fromTimestamp) && this.toTimestamp.equals(other.toTimestamp);
    }

    public int hashCode() {
        return Objects.hash(this.page, this.limit, this.traceName, this.userId, this.tags, this.environment, this.fromTimestamp, this.toTimestamp);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> page = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<String> traceName = Optional.empty();
        private Optional<String> userId = Optional.empty();
        private Optional<String> tags = Optional.empty();
        private Optional<String> environment = Optional.empty();
        private Optional<OffsetDateTime> fromTimestamp = Optional.empty();
        private Optional<OffsetDateTime> toTimestamp = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetDailyMetricsRequest other) {
            this.page(other.getPage());
            this.limit(other.getLimit());
            this.traceName(other.getTraceName());
            this.userId(other.getUserId());
            this.tags(other.getTags());
            this.environment(other.getEnvironment());
            this.fromTimestamp(other.getFromTimestamp());
            this.toTimestamp(other.getToTimestamp());
            return this;
        }

        @JsonSetter(value="page", nulls=Nulls.SKIP)
        public Builder page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        public Builder page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="traceName", nulls=Nulls.SKIP)
        public Builder traceName(Optional<String> traceName) {
            this.traceName = traceName;
            return this;
        }

        public Builder traceName(String traceName) {
            this.traceName = Optional.ofNullable(traceName);
            return this;
        }

        @JsonSetter(value="userId", nulls=Nulls.SKIP)
        public Builder userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        @JsonSetter(value="tags", nulls=Nulls.SKIP)
        public Builder tags(Optional<String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder tags(String tags) {
            this.tags = Optional.ofNullable(tags);
            return this;
        }

        @JsonSetter(value="environment", nulls=Nulls.SKIP)
        public Builder environment(Optional<String> environment) {
            this.environment = environment;
            return this;
        }

        public Builder environment(String environment) {
            this.environment = Optional.ofNullable(environment);
            return this;
        }

        @JsonSetter(value="fromTimestamp", nulls=Nulls.SKIP)
        public Builder fromTimestamp(Optional<OffsetDateTime> fromTimestamp) {
            this.fromTimestamp = fromTimestamp;
            return this;
        }

        public Builder fromTimestamp(OffsetDateTime fromTimestamp) {
            this.fromTimestamp = Optional.ofNullable(fromTimestamp);
            return this;
        }

        @JsonSetter(value="toTimestamp", nulls=Nulls.SKIP)
        public Builder toTimestamp(Optional<OffsetDateTime> toTimestamp) {
            this.toTimestamp = toTimestamp;
            return this;
        }

        public Builder toTimestamp(OffsetDateTime toTimestamp) {
            this.toTimestamp = Optional.ofNullable(toTimestamp);
            return this;
        }

        public GetDailyMetricsRequest build() {
            return new GetDailyMetricsRequest(this.page, this.limit, this.traceName, this.userId, this.tags, this.environment, this.fromTimestamp, this.toTimestamp, this.additionalProperties);
        }
    }
}

