/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.metrics.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.metrics.types.UsageByModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DailyMetricsDetails {
    private final String date;
    private final int countTraces;
    private final int countObservations;
    private final double totalCost;
    private final List<UsageByModel> usage;
    private final Map<String, Object> additionalProperties;

    private DailyMetricsDetails(String date, int countTraces, int countObservations, double totalCost, List<UsageByModel> usage, Map<String, Object> additionalProperties) {
        this.date = date;
        this.countTraces = countTraces;
        this.countObservations = countObservations;
        this.totalCost = totalCost;
        this.usage = usage;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="date")
    public String getDate() {
        return this.date;
    }

    @JsonProperty(value="countTraces")
    public int getCountTraces() {
        return this.countTraces;
    }

    @JsonProperty(value="countObservations")
    public int getCountObservations() {
        return this.countObservations;
    }

    @JsonProperty(value="totalCost")
    public double getTotalCost() {
        return this.totalCost;
    }

    @JsonProperty(value="usage")
    public List<UsageByModel> getUsage() {
        return this.usage;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DailyMetricsDetails && this.equalTo((DailyMetricsDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DailyMetricsDetails other) {
        return this.date.equals(other.date) && this.countTraces == other.countTraces && this.countObservations == other.countObservations && this.totalCost == other.totalCost && this.usage.equals(other.usage);
    }

    public int hashCode() {
        return Objects.hash(this.date, this.countTraces, this.countObservations, this.totalCost, this.usage);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DateStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DateStage,
    CountTracesStage,
    CountObservationsStage,
    TotalCostStage,
    _FinalStage {
        private String date;
        private int countTraces;
        private int countObservations;
        private double totalCost;
        private List<UsageByModel> usage = new ArrayList<UsageByModel>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DailyMetricsDetails other) {
            this.date(other.getDate());
            this.countTraces(other.getCountTraces());
            this.countObservations(other.getCountObservations());
            this.totalCost(other.getTotalCost());
            this.usage(other.getUsage());
            return this;
        }

        @Override
        @JsonSetter(value="date")
        public CountTracesStage date(@NotNull String date) {
            this.date = Objects.requireNonNull(date, "date must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="countTraces")
        public CountObservationsStage countTraces(int countTraces) {
            this.countTraces = countTraces;
            return this;
        }

        @Override
        @JsonSetter(value="countObservations")
        public TotalCostStage countObservations(int countObservations) {
            this.countObservations = countObservations;
            return this;
        }

        @Override
        @JsonSetter(value="totalCost")
        public _FinalStage totalCost(double totalCost) {
            this.totalCost = totalCost;
            return this;
        }

        @Override
        public _FinalStage addAllUsage(List<UsageByModel> usage) {
            this.usage.addAll(usage);
            return this;
        }

        @Override
        public _FinalStage addUsage(UsageByModel usage) {
            this.usage.add(usage);
            return this;
        }

        @Override
        @JsonSetter(value="usage", nulls=Nulls.SKIP)
        public _FinalStage usage(List<UsageByModel> usage) {
            this.usage.clear();
            this.usage.addAll(usage);
            return this;
        }

        @Override
        public DailyMetricsDetails build() {
            return new DailyMetricsDetails(this.date, this.countTraces, this.countObservations, this.totalCost, this.usage, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DailyMetricsDetails build();

        public _FinalStage usage(List<UsageByModel> var1);

        public _FinalStage addUsage(UsageByModel var1);

        public _FinalStage addAllUsage(List<UsageByModel> var1);
    }

    public static interface TotalCostStage {
        public _FinalStage totalCost(double var1);
    }

    public static interface CountObservationsStage {
        public TotalCostStage countObservations(int var1);
    }

    public static interface CountTracesStage {
        public CountObservationsStage countTraces(int var1);
    }

    public static interface DateStage {
        public CountTracesStage date(@NotNull String var1);

        public Builder from(DailyMetricsDetails var1);
    }
}

