/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.metrics.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UsageByModel {
    private final Optional<String> model;
    private final int inputUsage;
    private final int outputUsage;
    private final int totalUsage;
    private final int countTraces;
    private final int countObservations;
    private final double totalCost;
    private final Map<String, Object> additionalProperties;

    private UsageByModel(Optional<String> model, int inputUsage, int outputUsage, int totalUsage, int countTraces, int countObservations, double totalCost, Map<String, Object> additionalProperties) {
        this.model = model;
        this.inputUsage = inputUsage;
        this.outputUsage = outputUsage;
        this.totalUsage = totalUsage;
        this.countTraces = countTraces;
        this.countObservations = countObservations;
        this.totalCost = totalCost;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="model")
    public Optional<String> getModel() {
        return this.model;
    }

    @JsonProperty(value="inputUsage")
    public int getInputUsage() {
        return this.inputUsage;
    }

    @JsonProperty(value="outputUsage")
    public int getOutputUsage() {
        return this.outputUsage;
    }

    @JsonProperty(value="totalUsage")
    public int getTotalUsage() {
        return this.totalUsage;
    }

    @JsonProperty(value="countTraces")
    public int getCountTraces() {
        return this.countTraces;
    }

    @JsonProperty(value="countObservations")
    public int getCountObservations() {
        return this.countObservations;
    }

    @JsonProperty(value="totalCost")
    public double getTotalCost() {
        return this.totalCost;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UsageByModel && this.equalTo((UsageByModel)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UsageByModel other) {
        return this.model.equals(other.model) && this.inputUsage == other.inputUsage && this.outputUsage == other.outputUsage && this.totalUsage == other.totalUsage && this.countTraces == other.countTraces && this.countObservations == other.countObservations && this.totalCost == other.totalCost;
    }

    public int hashCode() {
        return Objects.hash(this.model, this.inputUsage, this.outputUsage, this.totalUsage, this.countTraces, this.countObservations, this.totalCost);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static InputUsageStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements InputUsageStage,
    OutputUsageStage,
    TotalUsageStage,
    CountTracesStage,
    CountObservationsStage,
    TotalCostStage,
    _FinalStage {
        private int inputUsage;
        private int outputUsage;
        private int totalUsage;
        private int countTraces;
        private int countObservations;
        private double totalCost;
        private Optional<String> model = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UsageByModel other) {
            this.model(other.getModel());
            this.inputUsage(other.getInputUsage());
            this.outputUsage(other.getOutputUsage());
            this.totalUsage(other.getTotalUsage());
            this.countTraces(other.getCountTraces());
            this.countObservations(other.getCountObservations());
            this.totalCost(other.getTotalCost());
            return this;
        }

        @Override
        @JsonSetter(value="inputUsage")
        public OutputUsageStage inputUsage(int inputUsage) {
            this.inputUsage = inputUsage;
            return this;
        }

        @Override
        @JsonSetter(value="outputUsage")
        public TotalUsageStage outputUsage(int outputUsage) {
            this.outputUsage = outputUsage;
            return this;
        }

        @Override
        @JsonSetter(value="totalUsage")
        public CountTracesStage totalUsage(int totalUsage) {
            this.totalUsage = totalUsage;
            return this;
        }

        @Override
        @JsonSetter(value="countTraces")
        public CountObservationsStage countTraces(int countTraces) {
            this.countTraces = countTraces;
            return this;
        }

        @Override
        @JsonSetter(value="countObservations")
        public TotalCostStage countObservations(int countObservations) {
            this.countObservations = countObservations;
            return this;
        }

        @Override
        @JsonSetter(value="totalCost")
        public _FinalStage totalCost(double totalCost) {
            this.totalCost = totalCost;
            return this;
        }

        @Override
        public _FinalStage model(String model) {
            this.model = Optional.ofNullable(model);
            return this;
        }

        @Override
        @JsonSetter(value="model", nulls=Nulls.SKIP)
        public _FinalStage model(Optional<String> model) {
            this.model = model;
            return this;
        }

        @Override
        public UsageByModel build() {
            return new UsageByModel(this.model, this.inputUsage, this.outputUsage, this.totalUsage, this.countTraces, this.countObservations, this.totalCost, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UsageByModel build();

        public _FinalStage model(Optional<String> var1);

        public _FinalStage model(String var1);
    }

    public static interface TotalCostStage {
        public _FinalStage totalCost(double var1);
    }

    public static interface CountObservationsStage {
        public TotalCostStage countObservations(int var1);
    }

    public static interface CountTracesStage {
        public CountObservationsStage countTraces(int var1);
    }

    public static interface TotalUsageStage {
        public CountTracesStage totalUsage(int var1);
    }

    public static interface OutputUsageStage {
        public TotalUsageStage outputUsage(int var1);
    }

    public static interface InputUsageStage {
        public OutputUsageStage inputUsage(int var1);

        public Builder from(UsageByModel var1);
    }
}

