/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.models.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.resources.commons.types.ModelUsageUnit;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateModelRequest {
    private final String modelName;
    private final String matchPattern;
    private final Optional<OffsetDateTime> startDate;
    private final Optional<ModelUsageUnit> unit;
    private final Optional<Double> inputPrice;
    private final Optional<Double> outputPrice;
    private final Optional<Double> totalPrice;
    private final Optional<String> tokenizerId;
    private final Optional<Object> tokenizerConfig;
    private final Map<String, Object> additionalProperties;

    private CreateModelRequest(String modelName, String matchPattern, Optional<OffsetDateTime> startDate, Optional<ModelUsageUnit> unit, Optional<Double> inputPrice, Optional<Double> outputPrice, Optional<Double> totalPrice, Optional<String> tokenizerId, Optional<Object> tokenizerConfig, Map<String, Object> additionalProperties) {
        this.modelName = modelName;
        this.matchPattern = matchPattern;
        this.startDate = startDate;
        this.unit = unit;
        this.inputPrice = inputPrice;
        this.outputPrice = outputPrice;
        this.totalPrice = totalPrice;
        this.tokenizerId = tokenizerId;
        this.tokenizerConfig = tokenizerConfig;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="modelName")
    public String getModelName() {
        return this.modelName;
    }

    @JsonProperty(value="matchPattern")
    public String getMatchPattern() {
        return this.matchPattern;
    }

    @JsonProperty(value="startDate")
    public Optional<OffsetDateTime> getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="unit")
    public Optional<ModelUsageUnit> getUnit() {
        return this.unit;
    }

    @JsonProperty(value="inputPrice")
    public Optional<Double> getInputPrice() {
        return this.inputPrice;
    }

    @JsonProperty(value="outputPrice")
    public Optional<Double> getOutputPrice() {
        return this.outputPrice;
    }

    @JsonProperty(value="totalPrice")
    public Optional<Double> getTotalPrice() {
        return this.totalPrice;
    }

    @JsonProperty(value="tokenizerId")
    public Optional<String> getTokenizerId() {
        return this.tokenizerId;
    }

    @JsonProperty(value="tokenizerConfig")
    public Optional<Object> getTokenizerConfig() {
        return this.tokenizerConfig;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateModelRequest && this.equalTo((CreateModelRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateModelRequest other) {
        return this.modelName.equals(other.modelName) && this.matchPattern.equals(other.matchPattern) && this.startDate.equals(other.startDate) && this.unit.equals(other.unit) && this.inputPrice.equals(other.inputPrice) && this.outputPrice.equals(other.outputPrice) && this.totalPrice.equals(other.totalPrice) && this.tokenizerId.equals(other.tokenizerId) && this.tokenizerConfig.equals(other.tokenizerConfig);
    }

    public int hashCode() {
        return Objects.hash(this.modelName, this.matchPattern, this.startDate, this.unit, this.inputPrice, this.outputPrice, this.totalPrice, this.tokenizerId, this.tokenizerConfig);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ModelNameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ModelNameStage,
    MatchPatternStage,
    _FinalStage {
        private String modelName;
        private String matchPattern;
        private Optional<Object> tokenizerConfig = Optional.empty();
        private Optional<String> tokenizerId = Optional.empty();
        private Optional<Double> totalPrice = Optional.empty();
        private Optional<Double> outputPrice = Optional.empty();
        private Optional<Double> inputPrice = Optional.empty();
        private Optional<ModelUsageUnit> unit = Optional.empty();
        private Optional<OffsetDateTime> startDate = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateModelRequest other) {
            this.modelName(other.getModelName());
            this.matchPattern(other.getMatchPattern());
            this.startDate(other.getStartDate());
            this.unit(other.getUnit());
            this.inputPrice(other.getInputPrice());
            this.outputPrice(other.getOutputPrice());
            this.totalPrice(other.getTotalPrice());
            this.tokenizerId(other.getTokenizerId());
            this.tokenizerConfig(other.getTokenizerConfig());
            return this;
        }

        @Override
        @JsonSetter(value="modelName")
        public MatchPatternStage modelName(@NotNull String modelName) {
            this.modelName = Objects.requireNonNull(modelName, "modelName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="matchPattern")
        public _FinalStage matchPattern(@NotNull String matchPattern) {
            this.matchPattern = Objects.requireNonNull(matchPattern, "matchPattern must not be null");
            return this;
        }

        @Override
        public _FinalStage tokenizerConfig(Object tokenizerConfig) {
            this.tokenizerConfig = Optional.ofNullable(tokenizerConfig);
            return this;
        }

        @Override
        @JsonSetter(value="tokenizerConfig", nulls=Nulls.SKIP)
        public _FinalStage tokenizerConfig(Optional<Object> tokenizerConfig) {
            this.tokenizerConfig = tokenizerConfig;
            return this;
        }

        @Override
        public _FinalStage tokenizerId(String tokenizerId) {
            this.tokenizerId = Optional.ofNullable(tokenizerId);
            return this;
        }

        @Override
        @JsonSetter(value="tokenizerId", nulls=Nulls.SKIP)
        public _FinalStage tokenizerId(Optional<String> tokenizerId) {
            this.tokenizerId = tokenizerId;
            return this;
        }

        @Override
        public _FinalStage totalPrice(Double totalPrice) {
            this.totalPrice = Optional.ofNullable(totalPrice);
            return this;
        }

        @Override
        @JsonSetter(value="totalPrice", nulls=Nulls.SKIP)
        public _FinalStage totalPrice(Optional<Double> totalPrice) {
            this.totalPrice = totalPrice;
            return this;
        }

        @Override
        public _FinalStage outputPrice(Double outputPrice) {
            this.outputPrice = Optional.ofNullable(outputPrice);
            return this;
        }

        @Override
        @JsonSetter(value="outputPrice", nulls=Nulls.SKIP)
        public _FinalStage outputPrice(Optional<Double> outputPrice) {
            this.outputPrice = outputPrice;
            return this;
        }

        @Override
        public _FinalStage inputPrice(Double inputPrice) {
            this.inputPrice = Optional.ofNullable(inputPrice);
            return this;
        }

        @Override
        @JsonSetter(value="inputPrice", nulls=Nulls.SKIP)
        public _FinalStage inputPrice(Optional<Double> inputPrice) {
            this.inputPrice = inputPrice;
            return this;
        }

        @Override
        public _FinalStage unit(ModelUsageUnit unit) {
            this.unit = Optional.ofNullable(unit);
            return this;
        }

        @Override
        @JsonSetter(value="unit", nulls=Nulls.SKIP)
        public _FinalStage unit(Optional<ModelUsageUnit> unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public _FinalStage startDate(OffsetDateTime startDate) {
            this.startDate = Optional.ofNullable(startDate);
            return this;
        }

        @Override
        @JsonSetter(value="startDate", nulls=Nulls.SKIP)
        public _FinalStage startDate(Optional<OffsetDateTime> startDate) {
            this.startDate = startDate;
            return this;
        }

        @Override
        public CreateModelRequest build() {
            return new CreateModelRequest(this.modelName, this.matchPattern, this.startDate, this.unit, this.inputPrice, this.outputPrice, this.totalPrice, this.tokenizerId, this.tokenizerConfig, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateModelRequest build();

        public _FinalStage startDate(Optional<OffsetDateTime> var1);

        public _FinalStage startDate(OffsetDateTime var1);

        public _FinalStage unit(Optional<ModelUsageUnit> var1);

        public _FinalStage unit(ModelUsageUnit var1);

        public _FinalStage inputPrice(Optional<Double> var1);

        public _FinalStage inputPrice(Double var1);

        public _FinalStage outputPrice(Optional<Double> var1);

        public _FinalStage outputPrice(Double var1);

        public _FinalStage totalPrice(Optional<Double> var1);

        public _FinalStage totalPrice(Double var1);

        public _FinalStage tokenizerId(Optional<String> var1);

        public _FinalStage tokenizerId(String var1);

        public _FinalStage tokenizerConfig(Optional<Object> var1);

        public _FinalStage tokenizerConfig(Object var1);
    }

    public static interface MatchPatternStage {
        public _FinalStage matchPattern(@NotNull String var1);
    }

    public static interface ModelNameStage {
        public MatchPatternStage modelName(@NotNull String var1);

        public Builder from(CreateModelRequest var1);
    }
}

