/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.observations;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.langfuse.client.core.ClientOptions;
import com.langfuse.client.core.LangfuseClientApiException;
import com.langfuse.client.core.LangfuseClientException;
import com.langfuse.client.core.ObjectMappers;
import com.langfuse.client.core.QueryStringMapper;
import com.langfuse.client.core.RequestOptions;
import com.langfuse.client.resources.commons.errors.AccessDeniedError;
import com.langfuse.client.resources.commons.errors.Error;
import com.langfuse.client.resources.commons.errors.MethodNotAllowedError;
import com.langfuse.client.resources.commons.errors.NotFoundError;
import com.langfuse.client.resources.commons.errors.UnauthorizedError;
import com.langfuse.client.resources.commons.types.ObservationsView;
import com.langfuse.client.resources.observations.requests.GetObservationsRequest;
import com.langfuse.client.resources.observations.types.ObservationsViews;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ObservationsClient {
    protected final ClientOptions clientOptions;

    public ObservationsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public ObservationsView get(String observationId) {
        return this.get(observationId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ObservationsView get(String observationId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/public").addPathSegments("observations").addPathSegment(observationId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ObservationsView observationsView = (ObservationsView)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ObservationsView.class);
                return observationsView;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new Error(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new UnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new AccessDeniedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 405: {
                        throw new MethodNotAllowedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new LangfuseClientApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new LangfuseClientApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new LangfuseClientException("Network error executing HTTP request", e);
        }
    }

    public ObservationsViews getMany() {
        return this.getMany(GetObservationsRequest.builder().build());
    }

    public ObservationsViews getMany(GetObservationsRequest request) {
        return this.getMany(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ObservationsViews getMany(GetObservationsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/public").addPathSegments("observations");
        if (request.getPage().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "page", request.getPage().get().toString(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get().toString(), false);
        }
        if (request.getName().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "name", request.getName().get(), false);
        }
        if (request.getUserId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "userId", request.getUserId().get(), false);
        }
        if (request.getType().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "type", request.getType().get(), false);
        }
        if (request.getTraceId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "traceId", request.getTraceId().get(), false);
        }
        if (request.getParentObservationId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "parentObservationId", request.getParentObservationId().get(), false);
        }
        if (request.getEnvironment().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "environment", request.getEnvironment().get(), false);
        }
        if (request.getFromStartTime().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "fromStartTime", request.getFromStartTime().get().toString(), false);
        }
        if (request.getToStartTime().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "toStartTime", request.getToStartTime().get().toString(), false);
        }
        if (request.getVersion().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "version", request.getVersion().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ObservationsViews observationsViews = (ObservationsViews)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ObservationsViews.class);
                return observationsViews;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new Error(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 401: {
                        throw new UnauthorizedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 403: {
                        throw new AccessDeniedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                    case 405: {
                        throw new MethodNotAllowedError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
                    }
                }
                throw new LangfuseClientApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new LangfuseClientApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new LangfuseClientException("Network error executing HTTP request", e);
        }
    }
}

