/*
 * Decompiled with CFR 0.152.
 */
package com.langfuse.client.resources.prompts.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PromptMeta {
    private final String name;
    private final List<Integer> versions;
    private final List<String> labels;
    private final List<String> tags;
    private final OffsetDateTime lastUpdatedAt;
    private final Object lastConfig;
    private final Map<String, Object> additionalProperties;

    private PromptMeta(String name, List<Integer> versions, List<String> labels, List<String> tags, OffsetDateTime lastUpdatedAt, Object lastConfig, Map<String, Object> additionalProperties) {
        this.name = name;
        this.versions = versions;
        this.labels = labels;
        this.tags = tags;
        this.lastUpdatedAt = lastUpdatedAt;
        this.lastConfig = lastConfig;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="versions")
    public List<Integer> getVersions() {
        return this.versions;
    }

    @JsonProperty(value="labels")
    public List<String> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="tags")
    public List<String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="lastUpdatedAt")
    public OffsetDateTime getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    @JsonProperty(value="lastConfig")
    public Object getLastConfig() {
        return this.lastConfig;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PromptMeta && this.equalTo((PromptMeta)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PromptMeta other) {
        return this.name.equals(other.name) && this.versions.equals(other.versions) && this.labels.equals(other.labels) && this.tags.equals(other.tags) && this.lastUpdatedAt.equals(other.lastUpdatedAt) && this.lastConfig.equals(other.lastConfig);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.versions, this.labels, this.tags, this.lastUpdatedAt, this.lastConfig);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    LastUpdatedAtStage,
    LastConfigStage,
    _FinalStage {
        private String name;
        private OffsetDateTime lastUpdatedAt;
        private Object lastConfig;
        private List<String> tags = new ArrayList<String>();
        private List<String> labels = new ArrayList<String>();
        private List<Integer> versions = new ArrayList<Integer>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PromptMeta other) {
            this.name(other.getName());
            this.versions(other.getVersions());
            this.labels(other.getLabels());
            this.tags(other.getTags());
            this.lastUpdatedAt(other.getLastUpdatedAt());
            this.lastConfig(other.getLastConfig());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public LastUpdatedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="lastUpdatedAt")
        public LastConfigStage lastUpdatedAt(@NotNull OffsetDateTime lastUpdatedAt) {
            this.lastUpdatedAt = Objects.requireNonNull(lastUpdatedAt, "lastUpdatedAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="lastConfig")
        public _FinalStage lastConfig(Object lastConfig) {
            this.lastConfig = lastConfig;
            return this;
        }

        @Override
        public _FinalStage addAllTags(List<String> tags) {
            this.tags.addAll(tags);
            return this;
        }

        @Override
        public _FinalStage addTags(String tags) {
            this.tags.add(tags);
            return this;
        }

        @Override
        @JsonSetter(value="tags", nulls=Nulls.SKIP)
        public _FinalStage tags(List<String> tags) {
            this.tags.clear();
            this.tags.addAll(tags);
            return this;
        }

        @Override
        public _FinalStage addAllLabels(List<String> labels) {
            this.labels.addAll(labels);
            return this;
        }

        @Override
        public _FinalStage addLabels(String labels) {
            this.labels.add(labels);
            return this;
        }

        @Override
        @JsonSetter(value="labels", nulls=Nulls.SKIP)
        public _FinalStage labels(List<String> labels) {
            this.labels.clear();
            this.labels.addAll(labels);
            return this;
        }

        @Override
        public _FinalStage addAllVersions(List<Integer> versions) {
            this.versions.addAll(versions);
            return this;
        }

        @Override
        public _FinalStage addVersions(Integer versions) {
            this.versions.add(versions);
            return this;
        }

        @Override
        @JsonSetter(value="versions", nulls=Nulls.SKIP)
        public _FinalStage versions(List<Integer> versions) {
            this.versions.clear();
            this.versions.addAll(versions);
            return this;
        }

        @Override
        public PromptMeta build() {
            return new PromptMeta(this.name, this.versions, this.labels, this.tags, this.lastUpdatedAt, this.lastConfig, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PromptMeta build();

        public _FinalStage versions(List<Integer> var1);

        public _FinalStage addVersions(Integer var1);

        public _FinalStage addAllVersions(List<Integer> var1);

        public _FinalStage labels(List<String> var1);

        public _FinalStage addLabels(String var1);

        public _FinalStage addAllLabels(List<String> var1);

        public _FinalStage tags(List<String> var1);

        public _FinalStage addTags(String var1);

        public _FinalStage addAllTags(List<String> var1);
    }

    public static interface LastConfigStage {
        public _FinalStage lastConfig(Object var1);
    }

    public static interface LastUpdatedAtStage {
        public LastConfigStage lastUpdatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface NameStage {
        public LastUpdatedAtStage name(@NotNull String var1);

        public Builder from(PromptMeta var1);
    }
}

