/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.annotationqueues.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = AnnotationQueueItem.Builder.class
)
public final class AnnotationQueueItem {
  private final String id;

  private final String queueId;

  private final String objectId;

  private final AnnotationQueueObjectType objectType;

  private final AnnotationQueueStatus status;

  private final Optional<OffsetDateTime> completedAt;

  private final OffsetDateTime createdAt;

  private final OffsetDateTime updatedAt;

  private final Map<String, Object> additionalProperties;

  private AnnotationQueueItem(String id, String queueId, String objectId,
      AnnotationQueueObjectType objectType, AnnotationQueueStatus status,
      Optional<OffsetDateTime> completedAt, OffsetDateTime createdAt, OffsetDateTime updatedAt,
      Map<String, Object> additionalProperties) {
    this.id = id;
    this.queueId = queueId;
    this.objectId = objectId;
    this.objectType = objectType;
    this.status = status;
    this.completedAt = completedAt;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("id")
  public String getId() {
    return id;
  }

  @JsonProperty("queueId")
  public String getQueueId() {
    return queueId;
  }

  @JsonProperty("objectId")
  public String getObjectId() {
    return objectId;
  }

  @JsonProperty("objectType")
  public AnnotationQueueObjectType getObjectType() {
    return objectType;
  }

  @JsonProperty("status")
  public AnnotationQueueStatus getStatus() {
    return status;
  }

  @JsonProperty("completedAt")
  public Optional<OffsetDateTime> getCompletedAt() {
    return completedAt;
  }

  @JsonProperty("createdAt")
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  @JsonProperty("updatedAt")
  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof AnnotationQueueItem && equalTo((AnnotationQueueItem) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(AnnotationQueueItem other) {
    return id.equals(other.id) && queueId.equals(other.queueId) && objectId.equals(other.objectId) && objectType.equals(other.objectType) && status.equals(other.status) && completedAt.equals(other.completedAt) && createdAt.equals(other.createdAt) && updatedAt.equals(other.updatedAt);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.queueId, this.objectId, this.objectType, this.status, this.completedAt, this.createdAt, this.updatedAt);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static IdStage builder() {
    return new Builder();
  }

  public interface IdStage {
    QueueIdStage id(@NotNull String id);

    Builder from(AnnotationQueueItem other);
  }

  public interface QueueIdStage {
    ObjectIdStage queueId(@NotNull String queueId);
  }

  public interface ObjectIdStage {
    ObjectTypeStage objectId(@NotNull String objectId);
  }

  public interface ObjectTypeStage {
    StatusStage objectType(@NotNull AnnotationQueueObjectType objectType);
  }

  public interface StatusStage {
    CreatedAtStage status(@NotNull AnnotationQueueStatus status);
  }

  public interface CreatedAtStage {
    UpdatedAtStage createdAt(@NotNull OffsetDateTime createdAt);
  }

  public interface UpdatedAtStage {
    _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
  }

  public interface _FinalStage {
    AnnotationQueueItem build();

    _FinalStage completedAt(Optional<OffsetDateTime> completedAt);

    _FinalStage completedAt(OffsetDateTime completedAt);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements IdStage, QueueIdStage, ObjectIdStage, ObjectTypeStage, StatusStage, CreatedAtStage, UpdatedAtStage, _FinalStage {
    private String id;

    private String queueId;

    private String objectId;

    private AnnotationQueueObjectType objectType;

    private AnnotationQueueStatus status;

    private OffsetDateTime createdAt;

    private OffsetDateTime updatedAt;

    private Optional<OffsetDateTime> completedAt = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(AnnotationQueueItem other) {
      id(other.getId());
      queueId(other.getQueueId());
      objectId(other.getObjectId());
      objectType(other.getObjectType());
      status(other.getStatus());
      completedAt(other.getCompletedAt());
      createdAt(other.getCreatedAt());
      updatedAt(other.getUpdatedAt());
      return this;
    }

    @java.lang.Override
    @JsonSetter("id")
    public QueueIdStage id(@NotNull String id) {
      this.id = Objects.requireNonNull(id, "id must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("queueId")
    public ObjectIdStage queueId(@NotNull String queueId) {
      this.queueId = Objects.requireNonNull(queueId, "queueId must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("objectId")
    public ObjectTypeStage objectId(@NotNull String objectId) {
      this.objectId = Objects.requireNonNull(objectId, "objectId must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("objectType")
    public StatusStage objectType(@NotNull AnnotationQueueObjectType objectType) {
      this.objectType = Objects.requireNonNull(objectType, "objectType must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("status")
    public CreatedAtStage status(@NotNull AnnotationQueueStatus status) {
      this.status = Objects.requireNonNull(status, "status must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("createdAt")
    public UpdatedAtStage createdAt(@NotNull OffsetDateTime createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("updatedAt")
    public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
      this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
      return this;
    }

    @java.lang.Override
    public _FinalStage completedAt(OffsetDateTime completedAt) {
      this.completedAt = Optional.ofNullable(completedAt);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "completedAt",
        nulls = Nulls.SKIP
    )
    public _FinalStage completedAt(Optional<OffsetDateTime> completedAt) {
      this.completedAt = completedAt;
      return this;
    }

    @java.lang.Override
    public AnnotationQueueItem build() {
      return new AnnotationQueueItem(id, queueId, objectId, objectType, status, completedAt, createdAt, updatedAt, additionalProperties);
    }
  }
}
