/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.commons.types;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.langfuse.client.core.ObjectMappers;
import java.io.IOException;
import java.lang.Boolean;
import java.lang.IllegalArgumentException;
import java.lang.IllegalStateException;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(
    using = MapValue.Deserializer.class
)
public final class MapValue {
  private final Object value;

  private final int type;

  private MapValue(Object value, int type) {
    this.value = value;
    this.type = type;
  }

  @JsonValue
  public Object get() {
    return this.value;
  }

  public <T> T visit(Visitor<T> visitor) {
    if(this.type == 0) {
      return visitor.visitOptionalString((Optional<String>) this.value);
    } else if(this.type == 1) {
      return visitor.visitOptionalInteger((Optional<Integer>) this.value);
    } else if(this.type == 2) {
      return visitor.visitOptionalBoolean((Optional<Boolean>) this.value);
    } else if(this.type == 3) {
      return visitor.visitOptionalListOfString((Optional<List<String>>) this.value);
    }
    throw new IllegalStateException("Failed to visit value. This should never happen.");
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof MapValue && equalTo((MapValue) other);
  }

  private boolean equalTo(MapValue other) {
    return value.equals(other.value);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.value);
  }

  @java.lang.Override
  public String toString() {
    return this.value.toString();
  }

  public static MapValue ofOptionalString(Optional<String> value) {
    return new MapValue(value, 0);
  }

  public static MapValue ofOptionalInteger(Optional<Integer> value) {
    return new MapValue(value, 1);
  }

  public static MapValue ofOptionalBoolean(Optional<Boolean> value) {
    return new MapValue(value, 2);
  }

  public static MapValue ofOptionalListOfString(Optional<List<String>> value) {
    return new MapValue(value, 3);
  }

  public interface Visitor<T> {
    T visitOptionalString(Optional<String> value);

    T visitOptionalInteger(Optional<Integer> value);

    T visitOptionalBoolean(Optional<Boolean> value);

    T visitOptionalListOfString(Optional<List<String>> value);
  }

  static final class Deserializer extends StdDeserializer<MapValue> {
    Deserializer() {
      super(MapValue.class);
    }

    @java.lang.Override
    public MapValue deserialize(JsonParser p, DeserializationContext context) throws IOException {
      Object value = p.readValueAs(Object.class);
      try {
        return ofOptionalString(ObjectMappers.JSON_MAPPER.convertValue(value, new TypeReference<Optional<String>>() {}));
      } catch(IllegalArgumentException e) {
      }
      try {
        return ofOptionalInteger(ObjectMappers.JSON_MAPPER.convertValue(value, new TypeReference<Optional<Integer>>() {}));
      } catch(IllegalArgumentException e) {
      }
      try {
        return ofOptionalBoolean(ObjectMappers.JSON_MAPPER.convertValue(value, new TypeReference<Optional<Boolean>>() {}));
      } catch(IllegalArgumentException e) {
      }
      try {
        return ofOptionalListOfString(ObjectMappers.JSON_MAPPER.convertValue(value, new TypeReference<Optional<List<String>>>() {}));
      } catch(IllegalArgumentException e) {
      }
      throw new JsonParseException(p, "Failed to deserialize");
    }
  }
}
