/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.ingestion.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = OpenAiUsage.Builder.class
)
public final class OpenAiUsage {
  private final Optional<Integer> promptTokens;

  private final Optional<Integer> completionTokens;

  private final Optional<Integer> totalTokens;

  private final Map<String, Object> additionalProperties;

  private OpenAiUsage(Optional<Integer> promptTokens, Optional<Integer> completionTokens,
      Optional<Integer> totalTokens, Map<String, Object> additionalProperties) {
    this.promptTokens = promptTokens;
    this.completionTokens = completionTokens;
    this.totalTokens = totalTokens;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("promptTokens")
  public Optional<Integer> getPromptTokens() {
    return promptTokens;
  }

  @JsonProperty("completionTokens")
  public Optional<Integer> getCompletionTokens() {
    return completionTokens;
  }

  @JsonProperty("totalTokens")
  public Optional<Integer> getTotalTokens() {
    return totalTokens;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof OpenAiUsage && equalTo((OpenAiUsage) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(OpenAiUsage other) {
    return promptTokens.equals(other.promptTokens) && completionTokens.equals(other.completionTokens) && totalTokens.equals(other.totalTokens);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.promptTokens, this.completionTokens, this.totalTokens);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<Integer> promptTokens = Optional.empty();

    private Optional<Integer> completionTokens = Optional.empty();

    private Optional<Integer> totalTokens = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(OpenAiUsage other) {
      promptTokens(other.getPromptTokens());
      completionTokens(other.getCompletionTokens());
      totalTokens(other.getTotalTokens());
      return this;
    }

    @JsonSetter(
        value = "promptTokens",
        nulls = Nulls.SKIP
    )
    public Builder promptTokens(Optional<Integer> promptTokens) {
      this.promptTokens = promptTokens;
      return this;
    }

    public Builder promptTokens(Integer promptTokens) {
      this.promptTokens = Optional.ofNullable(promptTokens);
      return this;
    }

    @JsonSetter(
        value = "completionTokens",
        nulls = Nulls.SKIP
    )
    public Builder completionTokens(Optional<Integer> completionTokens) {
      this.completionTokens = completionTokens;
      return this;
    }

    public Builder completionTokens(Integer completionTokens) {
      this.completionTokens = Optional.ofNullable(completionTokens);
      return this;
    }

    @JsonSetter(
        value = "totalTokens",
        nulls = Nulls.SKIP
    )
    public Builder totalTokens(Optional<Integer> totalTokens) {
      this.totalTokens = totalTokens;
      return this;
    }

    public Builder totalTokens(Integer totalTokens) {
      this.totalTokens = Optional.ofNullable(totalTokens);
      return this;
    }

    public OpenAiUsage build() {
      return new OpenAiUsage(promptTokens, completionTokens, totalTokens, additionalProperties);
    }
  }
}
