/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.media.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = GetMediaUploadUrlRequest.Builder.class
)
public final class GetMediaUploadUrlRequest {
  private final String traceId;

  private final Optional<String> observationId;

  private final MediaContentType contentType;

  private final int contentLength;

  private final String sha256Hash;

  private final String field;

  private final Map<String, Object> additionalProperties;

  private GetMediaUploadUrlRequest(String traceId, Optional<String> observationId,
      MediaContentType contentType, int contentLength, String sha256Hash, String field,
      Map<String, Object> additionalProperties) {
    this.traceId = traceId;
    this.observationId = observationId;
    this.contentType = contentType;
    this.contentLength = contentLength;
    this.sha256Hash = sha256Hash;
    this.field = field;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The trace ID associated with the media record
   */
  @JsonProperty("traceId")
  public String getTraceId() {
    return traceId;
  }

  /**
   * @return The observation ID associated with the media record. If the media record is associated directly with a trace, this will be null.
   */
  @JsonProperty("observationId")
  public Optional<String> getObservationId() {
    return observationId;
  }

  @JsonProperty("contentType")
  public MediaContentType getContentType() {
    return contentType;
  }

  /**
   * @return The size of the media record in bytes
   */
  @JsonProperty("contentLength")
  public int getContentLength() {
    return contentLength;
  }

  /**
   * @return The SHA-256 hash of the media record
   */
  @JsonProperty("sha256Hash")
  public String getSha256Hash() {
    return sha256Hash;
  }

  /**
   * @return The trace / observation field the media record is associated with. This can be one of <code>input</code>, <code>output</code>, <code>metadata</code>
   */
  @JsonProperty("field")
  public String getField() {
    return field;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof GetMediaUploadUrlRequest && equalTo((GetMediaUploadUrlRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(GetMediaUploadUrlRequest other) {
    return traceId.equals(other.traceId) && observationId.equals(other.observationId) && contentType.equals(other.contentType) && contentLength == other.contentLength && sha256Hash.equals(other.sha256Hash) && field.equals(other.field);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.traceId, this.observationId, this.contentType, this.contentLength, this.sha256Hash, this.field);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static TraceIdStage builder() {
    return new Builder();
  }

  public interface TraceIdStage {
    ContentTypeStage traceId(@NotNull String traceId);

    Builder from(GetMediaUploadUrlRequest other);
  }

  public interface ContentTypeStage {
    ContentLengthStage contentType(@NotNull MediaContentType contentType);
  }

  public interface ContentLengthStage {
    Sha256HashStage contentLength(int contentLength);
  }

  public interface Sha256HashStage {
    FieldStage sha256Hash(@NotNull String sha256Hash);
  }

  public interface FieldStage {
    _FinalStage field(@NotNull String field);
  }

  public interface _FinalStage {
    GetMediaUploadUrlRequest build();

    _FinalStage observationId(Optional<String> observationId);

    _FinalStage observationId(String observationId);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements TraceIdStage, ContentTypeStage, ContentLengthStage, Sha256HashStage, FieldStage, _FinalStage {
    private String traceId;

    private MediaContentType contentType;

    private int contentLength;

    private String sha256Hash;

    private String field;

    private Optional<String> observationId = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(GetMediaUploadUrlRequest other) {
      traceId(other.getTraceId());
      observationId(other.getObservationId());
      contentType(other.getContentType());
      contentLength(other.getContentLength());
      sha256Hash(other.getSha256Hash());
      field(other.getField());
      return this;
    }

    /**
     * <p>The trace ID associated with the media record</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("traceId")
    public ContentTypeStage traceId(@NotNull String traceId) {
      this.traceId = Objects.requireNonNull(traceId, "traceId must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("contentType")
    public ContentLengthStage contentType(@NotNull MediaContentType contentType) {
      this.contentType = Objects.requireNonNull(contentType, "contentType must not be null");
      return this;
    }

    /**
     * <p>The size of the media record in bytes</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("contentLength")
    public Sha256HashStage contentLength(int contentLength) {
      this.contentLength = contentLength;
      return this;
    }

    /**
     * <p>The SHA-256 hash of the media record</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("sha256Hash")
    public FieldStage sha256Hash(@NotNull String sha256Hash) {
      this.sha256Hash = Objects.requireNonNull(sha256Hash, "sha256Hash must not be null");
      return this;
    }

    /**
     * <p>The trace / observation field the media record is associated with. This can be one of <code>input</code>, <code>output</code>, <code>metadata</code></p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("field")
    public _FinalStage field(@NotNull String field) {
      this.field = Objects.requireNonNull(field, "field must not be null");
      return this;
    }

    /**
     * <p>The observation ID associated with the media record. If the media record is associated directly with a trace, this will be null.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage observationId(String observationId) {
      this.observationId = Optional.ofNullable(observationId);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "observationId",
        nulls = Nulls.SKIP
    )
    public _FinalStage observationId(Optional<String> observationId) {
      this.observationId = observationId;
      return this;
    }

    @java.lang.Override
    public GetMediaUploadUrlRequest build() {
      return new GetMediaUploadUrlRequest(traceId, observationId, contentType, contentLength, sha256Hash, field, additionalProperties);
    }
  }
}
