/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.media.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = GetMediaUploadUrlResponse.Builder.class
)
public final class GetMediaUploadUrlResponse {
  private final Optional<String> uploadUrl;

  private final String mediaId;

  private final Map<String, Object> additionalProperties;

  private GetMediaUploadUrlResponse(Optional<String> uploadUrl, String mediaId,
      Map<String, Object> additionalProperties) {
    this.uploadUrl = uploadUrl;
    this.mediaId = mediaId;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The presigned upload URL. If the asset is already uploaded, this will be null
   */
  @JsonProperty("uploadUrl")
  public Optional<String> getUploadUrl() {
    return uploadUrl;
  }

  /**
   * @return The unique langfuse identifier of a media record
   */
  @JsonProperty("mediaId")
  public String getMediaId() {
    return mediaId;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof GetMediaUploadUrlResponse && equalTo((GetMediaUploadUrlResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(GetMediaUploadUrlResponse other) {
    return uploadUrl.equals(other.uploadUrl) && mediaId.equals(other.mediaId);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.uploadUrl, this.mediaId);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static MediaIdStage builder() {
    return new Builder();
  }

  public interface MediaIdStage {
    _FinalStage mediaId(@NotNull String mediaId);

    Builder from(GetMediaUploadUrlResponse other);
  }

  public interface _FinalStage {
    GetMediaUploadUrlResponse build();

    _FinalStage uploadUrl(Optional<String> uploadUrl);

    _FinalStage uploadUrl(String uploadUrl);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements MediaIdStage, _FinalStage {
    private String mediaId;

    private Optional<String> uploadUrl = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(GetMediaUploadUrlResponse other) {
      uploadUrl(other.getUploadUrl());
      mediaId(other.getMediaId());
      return this;
    }

    /**
     * <p>The unique langfuse identifier of a media record</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("mediaId")
    public _FinalStage mediaId(@NotNull String mediaId) {
      this.mediaId = Objects.requireNonNull(mediaId, "mediaId must not be null");
      return this;
    }

    /**
     * <p>The presigned upload URL. If the asset is already uploaded, this will be null</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage uploadUrl(String uploadUrl) {
      this.uploadUrl = Optional.ofNullable(uploadUrl);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "uploadUrl",
        nulls = Nulls.SKIP
    )
    public _FinalStage uploadUrl(Optional<String> uploadUrl) {
      this.uploadUrl = uploadUrl;
      return this;
    }

    @java.lang.Override
    public GetMediaUploadUrlResponse build() {
      return new GetMediaUploadUrlResponse(uploadUrl, mediaId, additionalProperties);
    }
  }
}
