/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.organizations.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = MembershipResponse.Builder.class
)
public final class MembershipResponse {
  private final String userId;

  private final MembershipRole role;

  private final String email;

  private final String name;

  private final Map<String, Object> additionalProperties;

  private MembershipResponse(String userId, MembershipRole role, String email, String name,
      Map<String, Object> additionalProperties) {
    this.userId = userId;
    this.role = role;
    this.email = email;
    this.name = name;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("userId")
  public String getUserId() {
    return userId;
  }

  @JsonProperty("role")
  public MembershipRole getRole() {
    return role;
  }

  @JsonProperty("email")
  public String getEmail() {
    return email;
  }

  @JsonProperty("name")
  public String getName() {
    return name;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof MembershipResponse && equalTo((MembershipResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(MembershipResponse other) {
    return userId.equals(other.userId) && role.equals(other.role) && email.equals(other.email) && name.equals(other.name);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.userId, this.role, this.email, this.name);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static UserIdStage builder() {
    return new Builder();
  }

  public interface UserIdStage {
    RoleStage userId(@NotNull String userId);

    Builder from(MembershipResponse other);
  }

  public interface RoleStage {
    EmailStage role(@NotNull MembershipRole role);
  }

  public interface EmailStage {
    NameStage email(@NotNull String email);
  }

  public interface NameStage {
    _FinalStage name(@NotNull String name);
  }

  public interface _FinalStage {
    MembershipResponse build();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements UserIdStage, RoleStage, EmailStage, NameStage, _FinalStage {
    private String userId;

    private MembershipRole role;

    private String email;

    private String name;

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(MembershipResponse other) {
      userId(other.getUserId());
      role(other.getRole());
      email(other.getEmail());
      name(other.getName());
      return this;
    }

    @java.lang.Override
    @JsonSetter("userId")
    public RoleStage userId(@NotNull String userId) {
      this.userId = Objects.requireNonNull(userId, "userId must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("role")
    public EmailStage role(@NotNull MembershipRole role) {
      this.role = Objects.requireNonNull(role, "role must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("email")
    public NameStage email(@NotNull String email) {
      this.email = Objects.requireNonNull(email, "email must not be null");
      return this;
    }

    @java.lang.Override
    @JsonSetter("name")
    public _FinalStage name(@NotNull String name) {
      this.name = Objects.requireNonNull(name, "name must not be null");
      return this;
    }

    @java.lang.Override
    public MembershipResponse build() {
      return new MembershipResponse(userId, role, email, name, additionalProperties);
    }
  }
}
