/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.langfuse.client.resources.organizations.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.langfuse.client.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = OrganizationProjectsResponse.Builder.class
)
public final class OrganizationProjectsResponse {
  private final List<OrganizationProject> projects;

  private final Map<String, Object> additionalProperties;

  private OrganizationProjectsResponse(List<OrganizationProject> projects,
      Map<String, Object> additionalProperties) {
    this.projects = projects;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("projects")
  public List<OrganizationProject> getProjects() {
    return projects;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof OrganizationProjectsResponse && equalTo((OrganizationProjectsResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(OrganizationProjectsResponse other) {
    return projects.equals(other.projects);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.projects);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private List<OrganizationProject> projects = new ArrayList<>();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(OrganizationProjectsResponse other) {
      projects(other.getProjects());
      return this;
    }

    @JsonSetter(
        value = "projects",
        nulls = Nulls.SKIP
    )
    public Builder projects(List<OrganizationProject> projects) {
      this.projects.clear();
      this.projects.addAll(projects);
      return this;
    }

    public Builder addProjects(OrganizationProject projects) {
      this.projects.add(projects);
      return this;
    }

    public Builder addAllProjects(List<OrganizationProject> projects) {
      this.projects.addAll(projects);
      return this;
    }

    public OrganizationProjectsResponse build() {
      return new OrganizationProjectsResponse(projects, additionalProperties);
    }
  }
}
